/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util.upgrade;

import java.awt.Desktop;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.jackhuang.hellominecraft.launcher.core.MCUtils;
import org.jackhuang.hellominecraft.launcher.util.upgrade.AppDataUpgrader$$Lambda$1;
import org.jackhuang.hellominecraft.launcher.util.upgrade.AppDataUpgrader$$Lambda$2;
import org.jackhuang.hellominecraft.launcher.util.upgrade.IUpgrader;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.UpdateChecker;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.VersionNumber;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.OS;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public class AppDataUpgrader
extends IUpgrader {
    private boolean launchNewerVersion(String[] args, File jar) throws Exception {
        JarFile jarFile = new JarFile(jar);
        Throwable throwable = null;
        try {
            String mainClass = jarFile.getManifest().getMainAttributes().getValue("Main-Class");
            if (mainClass != null) {
                ArrayList<String> al = new ArrayList<String>(Arrays.asList(args));
                al.add("nofound");
                AccessController.doPrivileged(AppDataUpgrader$$Lambda$1.lambdaFactory$(jar, mainClass, al));
                boolean bl = true;
                return bl;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (jarFile != null) {
                if (throwable != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    jarFile.close();
                }
            }
        }
        return false;
    }

    @Override
    public boolean parseArguments(VersionNumber nowVersion, String[] args) {
        if (!ArrayUtils.contains(args, "nofound")) {
            try {
                File jar;
                String j;
                Map m;
                String s;
                File f = AppDataUpgraderTask.HMCL_VER_FILE;
                if (f.exists() && (s = (String)(m = C.GSON.fromJson(FileUtils.read(f), Map.class)).get("ver")) != null && VersionNumber.check(s).compareTo(nowVersion) > 0 && (j = (String)m.get("loc")) != null && (jar = new File(j)).exists()) {
                    return this.launchNewerVersion(args, jar);
                }
            }
            catch (Throwable t) {
                HMCLog.err("Failed to execute newer version application", t);
            }
        }
        return false;
    }

    @Override
    public boolean call(Object sender, VersionNumber number) {
        ((UpdateChecker)sender).requestDownloadLink().reg(AppDataUpgrader$$Lambda$2.lambdaFactory$(number)).execute();
        return true;
    }

    private static /* synthetic */ void lambda$call$57(VersionNumber number, Map map) {
        if (MessageBox.Show(C.i18n("update.newest_version", new Object[0]) + number.firstVer + "." + number.secondVer + "." + number.thirdVer + "\n" + C.i18n("update.should_open_link", new Object[0]), 10) == 0) {
            if (map != null && map.containsKey("pack")) {
                try {
                    String hash = null;
                    if (map.containsKey("packsha1")) {
                        hash = (String)map.get("packsha1");
                    }
                    if (TaskWindow.factory().append(new AppDataUpgraderTask((String)map.get("pack"), number.version, hash)).create()) {
                        new ProcessBuilder(IOUtils.getJavaDir(), "-jar", AppDataUpgraderTask.getSelf(number.version).getAbsolutePath()).directory(new File(".")).start();
                        System.exit(0);
                    }
                }
                catch (IOException ex) {
                    HMCLog.err("Failed to create upgrader", ex);
                }
            } else {
                String url = "http://www.mcbbs.net/thread-142335-1-1.html";
                if (map != null) {
                    if (map.containsKey(OS.os().checked_name)) {
                        url = (String)map.get(OS.os().checked_name);
                    } else if (map.containsKey(OS.UNKOWN.checked_name)) {
                        url = (String)map.get(OS.UNKOWN.checked_name);
                    }
                }
                if (url == null) {
                    url = "http://www.mcbbs.net/thread-142335-1-1.html";
                }
                try {
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (IOException | URISyntaxException e) {
                    HMCLog.warn("Failed to browse uri: " + url, e);
                    Utils.setClipborad(url);
                    MessageBox.Show(C.i18n("update.no_browser", new Object[0]));
                }
            }
        }
    }

    private static /* synthetic */ Void lambda$launchNewerVersion$56(File jar, String mainClass, ArrayList al) throws Exception {
        new URLClassLoader(new URL[]{jar.toURI().toURL()}, URLClassLoader.getSystemClassLoader().getParent()).loadClass(mainClass).getMethod("main", String[].class).invoke(null, new Object[]{al.toArray(new String[0])});
        return null;
    }

    static /* synthetic */ Void access$lambda$0(File file, String string, ArrayList arrayList) {
        return AppDataUpgrader.lambda$launchNewerVersion$56(file, string, arrayList);
    }

    static /* synthetic */ void access$lambda$1(VersionNumber versionNumber, Map map) {
        AppDataUpgrader.lambda$call$57(versionNumber, map);
    }

    public static class AppDataUpgraderTask
    extends Task {
        public static final File BASE_FOLDER = MCUtils.getWorkingDirectory("hmcl");
        public static final File HMCL_VER_FILE = new File(BASE_FOLDER, "hmclver.json");
        private final String downloadLink;
        private final String newestVersion;
        private final String expectedHash;
        File tempFile;

        public static File getSelf(String ver) {
            return new File(BASE_FOLDER, "HMCL-" + ver + ".jar");
        }

        public AppDataUpgraderTask(String downloadLink, String newestVersion, String hash) throws IOException {
            this.downloadLink = downloadLink;
            this.newestVersion = newestVersion;
            this.expectedHash = hash;
            this.tempFile = File.createTempFile("hmcl", ".pack.gz");
        }

        @Override
        public Collection<Task> getDependTasks() {
            return Arrays.asList(new FileDownloadTask(this.downloadLink, this.tempFile, this.expectedHash));
        }

        @Override
        public void executeTask() throws Exception {
            HashMap<String, String> json = new HashMap<String, String>();
            File f = AppDataUpgraderTask.getSelf(this.newestVersion);
            if (!f.getParentFile().exists() && !f.getParentFile().mkdirs()) {
                HMCLog.warn("Failed to make directories: " + f.getParent());
            }
            int i = 0;
            while (f.exists()) {
                f = new File(BASE_FOLDER, "HMCL-" + this.newestVersion + (i > 0 ? "-" + i : "") + ".jar");
                ++i;
            }
            if (!f.createNewFile()) {
                HMCLog.warn("Failed to create new file: " + f);
            }
            JarOutputStream jos = new JarOutputStream(new FileOutputStream(f));
            Throwable throwable = null;
            try {
                Pack200.newUnpacker().unpack((InputStream)new GZIPInputStream(new FileInputStream(this.tempFile)), jos);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (jos != null) {
                    if (throwable != null) {
                        try {
                            jos.close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        jos.close();
                    }
                }
            }
            json.put("ver", this.newestVersion);
            json.put("loc", f.getAbsolutePath());
            String result = C.GSON.toJson(json);
            FileUtils.write(HMCL_VER_FILE, result);
        }

        @Override
        public String getInfo() {
            return "Upgrade";
        }
    }
}

