/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.launcher.util.upgrade;

import java.io.File;
import java.io.IOException;
import org.jackhuang.hellominecraft.launcher.util.upgrade.IUpgrader;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.VersionNumber;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow;
import org.jackhuang.hellominecraft.util.tasks.download.FileDownloadTask;

public class NewFileUpgrader
extends IUpgrader {
    @Override
    public boolean parseArguments(VersionNumber nowVersion, String[] args) {
        File f;
        int i = ArrayUtils.indexOf(args, "--removeOldLauncher");
        if (i != -1 && i < args.length - 1 && (f = new File(args[i + 1])).exists()) {
            f.deleteOnExit();
        }
        return false;
    }

    @Override
    public boolean call(Object sender, VersionNumber number) {
        String str = this.requestDownloadLink();
        File newf = new File(FileUtils.getName(str));
        if (TaskWindow.factory().append(new FileDownloadTask(str, newf)).create()) {
            try {
                new ProcessBuilder(IOUtils.tryGetCanonicalFilePath(newf), "--removeOldLauncher", IOUtils.getRealPath()).directory(new File(".")).start();
            }
            catch (IOException ex) {
                HMCLog.err("Failed to start new app", ex);
            }
            System.exit(0);
        }
        return true;
    }

    private String requestDownloadLink() {
        return null;
    }
}

