/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.lookandfeel.painter;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthPainter;
import org.jackhuang.hellominecraft.util.ui.GraphicsUtils;

public class TextFieldPainter
extends SynthPainter {
    private boolean fill = true;
    private static final Color DISABLED = GraphicsUtils.getWebColor("F3F3F3");
    private static final Color NORMAL = GraphicsUtils.getWebColor("CCCCCC");
    private static final Color FOCUSED = GraphicsUtils.getWebColor("000000");
    private static final Color OVER = GraphicsUtils.getWebColor("7F7F7F");

    public TextFieldPainter() {
    }

    public TextFieldPainter(boolean fill) {
        this.fill = fill;
    }

    private void paintFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        --w;
        --h;
        if (this.fill) {
            g.setColor(Color.WHITE);
            g.fillRect(x, y, w, h);
        }
        Color color = (context.getComponentState() & 2) != 0 ? OVER : ((context.getComponentState() & 8) != 0 ? DISABLED : ((context.getComponentState() & 0x100) != 0 ? FOCUSED : NORMAL));
        g.setColor(color);
        g.drawLine(x, y, x + w, y);
        g.drawLine(x, y, x, y + w);
        g.drawLine(x + w, y, x + w, y + h);
        g.drawLine(x, y + h, x + w, y + h);
    }

    @Override
    public void paintPasswordFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintFieldBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintTextAreaBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintFieldBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintTextFieldBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintFieldBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintTextPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintFieldBackground(context, g, x, y, w, h);
    }

    @Override
    public void paintScrollPaneBackground(SynthContext context, Graphics g, int x, int y, int w, int h) {
        this.paintFieldBackground(context, g, x, y, w, h);
    }
}

