/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class ArrayUtils {
    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length <= 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> boolean contains(T[] array, T objectToFind) {
        return ArrayUtils.indexOf(array, objectToFind) != -1;
    }

    public static <T> int indexOf(T[] array, T valueToFind) {
        return ArrayUtils.indexOf(array, valueToFind, 0);
    }

    public static <T> int indexOf(T[] array, T valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            startIndex = 0;
        }
        for (int i = startIndex; i < array.length; ++i) {
            if (!valueToFind.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static <T> int lastIndexOf(T[] array, T valueToFind) {
        return ArrayUtils.lastIndexOf(array, valueToFind, Integer.MAX_VALUE);
    }

    public static <T> int lastIndexOf(T[] array, T valueToFind, int startIndex) {
        if (array == null) {
            return -1;
        }
        if (startIndex < 0) {
            return -1;
        }
        if (startIndex >= array.length) {
            startIndex = array.length - 1;
        }
        for (int i = startIndex; i >= 0; --i) {
            if (!valueToFind.equals(array[i])) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList merge(List a, List b) {
        ArrayList al = new ArrayList(a.size() + b.size());
        al.addAll(a);
        al.addAll(b);
        return al;
    }

    public static <K> K getEnd(K[] k) {
        if (k == null) {
            return null;
        }
        return k[k.length - 1];
    }

    public static List tryGetMapWithList(Map map, String key) {
        ArrayList l = (ArrayList)map.get(key);
        if (l == null) {
            l = new ArrayList();
            map.put(key, l);
        }
        return l;
    }

    public static <T> int matchArray(T[] a, T[] b) {
        for (int i = 0; i < a.length - b.length; ++i) {
            boolean j = true;
            for (int k = 0; k < b.length; ++k) {
                if (b[k].equals(a[i + k])) continue;
                j = false;
                break;
            }
            if (!j) continue;
            return i;
        }
        return -1;
    }

    public static <T> int matchArray(byte[] a, byte[] b) {
        for (int i = 0; i < a.length - b.length; ++i) {
            boolean j = true;
            for (int k = 0; k < b.length; ++k) {
                if (b[k] == a[i + k]) continue;
                j = false;
                break;
            }
            if (!j) continue;
            return i;
        }
        return -1;
    }

    public static <T> boolean equals(T[] a, T[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        Arrays.sort(a);
        Arrays.sort(b);
        for (int i = 0; i < a.length; ++i) {
            if (!(a[i] == null && b[i] != null || a[i] != null && b[i] == null) && a[i].equals(b[i])) continue;
            return false;
        }
        return true;
    }
}

