/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jackhuang.hellominecraft.util.ArrayUtils;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;

public class MinecraftVersionRequest
implements Serializable {
    public static final int UNKOWN = 0;
    public static final int INVALID = 1;
    public static final int INVALID_JAR = 2;
    public static final int MODIFIED = 3;
    public static final int OK = 4;
    public static final int NOT_FOUND = 5;
    public static final int UNREADABLE = 6;
    public static final int NOT_FILE = 7;
    public int type;
    public String version;

    public static String getResponse(MinecraftVersionRequest minecraftVersion) {
        String text = "";
        switch (minecraftVersion.type) {
            case 1: {
                text = C.i18n("minecraft.invalid", new Object[0]);
                break;
            }
            case 2: {
                text = C.i18n("minecraft.invalid_jar", new Object[0]);
                break;
            }
            case 7: {
                text = C.i18n("minecraft.not_a_file", new Object[0]);
                break;
            }
            case 5: {
                text = C.i18n("minecraft.not_found", new Object[0]);
                break;
            }
            case 6: {
                text = C.i18n("minecraft.not_readable", new Object[0]);
                break;
            }
            case 3: {
                text = C.i18n("minecraft.modified", new Object[0]) + " ";
            }
            case 4: {
                text = text + minecraftVersion.version;
                break;
            }
            default: {
                text = "???";
            }
        }
        return text;
    }

    private static int lessThan32(byte[] b, int x) {
        while (x < b.length) {
            if (b[x] < 32) {
                return x;
            }
            ++x;
        }
        return -1;
    }

    private static MinecraftVersionRequest getVersionOfOldMinecraft(ZipFile file, ZipEntry entry) throws IOException {
        String ver;
        byte[] bytes;
        MinecraftVersionRequest r = new MinecraftVersionRequest();
        byte[] tmp = NetUtils.getBytesFromStream(file.getInputStream(entry));
        int j = ArrayUtils.matchArray(tmp, bytes = "Minecraft Minecraft ".getBytes("ASCII"));
        if (j < 0) {
            r.type = 0;
            return r;
        }
        int i = j + bytes.length;
        if ((j = MinecraftVersionRequest.lessThan32(tmp, i)) < 0) {
            r.type = 0;
            return r;
        }
        r.version = ver = new String(tmp, i, j - i, "ASCII");
        r.type = file.getEntry("META-INF/MANIFEST.MF") == null ? 3 : 4;
        return r;
    }

    private static MinecraftVersionRequest getVersionOfNewMinecraft(ZipFile file, ZipEntry entry) throws IOException {
        byte[] str;
        MinecraftVersionRequest r = new MinecraftVersionRequest();
        byte[] tmp = NetUtils.getBytesFromStream(file.getInputStream(entry));
        int j = ArrayUtils.matchArray(tmp, str = "-server.txt".getBytes("ASCII"));
        if (j < 0) {
            r.type = 0;
            return r;
        }
        int i = j + str.length;
        j = MinecraftVersionRequest.lessThan32(tmp, i += 11);
        if (j < 0) {
            r.type = 0;
            return r;
        }
        r.version = new String(tmp, i, j - i, "ASCII");
        char ch = r.version.charAt(0);
        if (ch < '0' || ch > '9') {
            str = "Can't keep up! Did the system time change, or is the server overloaded?".getBytes("ASCII");
            j = ArrayUtils.matchArray(tmp, str);
            if (j < 0) {
                r.type = 0;
                return r;
            }
            i = -1;
            while (j > 0) {
                if (tmp[j] >= 48 && tmp[j] <= 57) {
                    i = j;
                    break;
                }
                --j;
            }
            if (i == -1) {
                r.type = 0;
                return r;
            }
            int k = i;
            if (tmp[i + 1] >= 97 && tmp[i + 1] <= 122) {
                ++i;
            }
            while (tmp[k] >= 48 && tmp[k] <= 57 || tmp[k] == 45 || tmp[k] == 46 || tmp[k] >= 97 && tmp[k] <= 122) {
                --k;
            }
            r.version = new String(tmp, ++k, i - k + 1);
        }
        r.type = file.getEntry("META-INF/MANIFEST.MF") == null ? 3 : 4;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MinecraftVersionRequest minecraftVersion(File file) {
        MinecraftVersionRequest r = new MinecraftVersionRequest();
        if (file == null || !file.exists()) {
            r.type = 5;
            return r;
        }
        if (!file.isFile()) {
            r.type = 7;
            return r;
        }
        if (!file.canRead()) {
            r.type = 6;
            return r;
        }
        ZipFile localZipFile = null;
        try {
            localZipFile = new ZipFile(file);
            ZipEntry minecraft = localZipFile.getEntry("net/minecraft/client/Minecraft.class");
            if (minecraft != null) {
                MinecraftVersionRequest minecraftVersionRequest = MinecraftVersionRequest.getVersionOfOldMinecraft(localZipFile, minecraft);
                return minecraftVersionRequest;
            }
            ZipEntry main = localZipFile.getEntry("net/minecraft/client/main/Main.class");
            ZipEntry minecraftserver = localZipFile.getEntry("net/minecraft/server/MinecraftServer.class");
            if (main != null && minecraftserver != null) {
                MinecraftVersionRequest minecraftVersionRequest = MinecraftVersionRequest.getVersionOfNewMinecraft(localZipFile, minecraftserver);
                return minecraftVersionRequest;
            }
            r.type = 1;
            MinecraftVersionRequest minecraftVersionRequest = r;
            return minecraftVersionRequest;
        }
        catch (IOException localException) {
            HMCLog.warn("Zip file is invalid", localException);
            r.type = 2;
            MinecraftVersionRequest minecraftVersionRequest = r;
            return minecraftVersionRequest;
        }
        finally {
            if (localZipFile != null) {
                try {
                    localZipFile.close();
                }
                catch (IOException ex) {
                    HMCLog.warn("Failed to close zip file", ex);
                }
            }
        }
    }
}

