/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.SwingWorker;
import org.jackhuang.hellominecraft.util.Utils;
import org.jackhuang.hellominecraft.util.func.Consumer;

public abstract class OverridableSwingWorker<T>
extends SwingWorker<Void, T> {
    List<Consumer<T>> processListeners = new ArrayList<Consumer<T>>();
    List<Runnable> doneListeners = new ArrayList<Runnable>();
    final List<T> lastChunks = new ArrayList<T>();

    protected abstract void work() throws Exception;

    @Override
    protected void done() {
        for (Runnable c : this.doneListeners) {
            c.run();
        }
    }

    @Override
    protected Void doInBackground() throws Exception {
        this.work();
        return null;
    }

    public OverridableSwingWorker reg(Consumer<T> c) {
        Utils.requireNonNull(c);
        this.processListeners.add(c);
        return this;
    }

    public OverridableSwingWorker regDone(Runnable c) {
        Utils.requireNonNull(c);
        this.doneListeners.add(c);
        return this;
    }

    @Override
    protected void process(List<T> chunks) {
        for (T t : chunks) {
            for (Consumer<T> c : this.processListeners) {
                c.accept(t);
            }
        }
    }

    protected void send(T ... t) {
        this.lastChunks.addAll(Arrays.asList(t));
        this.publish(t);
    }

    public List<T> justDo() throws Exception {
        this.work();
        return this.lastChunks;
    }
}

