/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import java.util.Map;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.IUpdateChecker;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.NetUtils;
import org.jackhuang.hellominecraft.util.OverridableSwingWorker;
import org.jackhuang.hellominecraft.util.VersionNumber;
import org.jackhuang.hellominecraft.util.logging.HMCLog;

public final class UpdateChecker
implements IUpdateChecker {
    public boolean OUT_DATED = false;
    public VersionNumber base;
    public String versionString;
    public String type;
    private Map<String, String> download_link = null;
    VersionNumber value;
    public final EventHandler<VersionNumber> outdated = new EventHandler(this);

    public UpdateChecker(VersionNumber base, String type) {
        this.base = base;
        this.type = type;
    }

    @Override
    public OverridableSwingWorker<VersionNumber> process(final boolean showMessage) {
        return new OverridableSwingWorker(){

            @Override
            protected void work() throws Exception {
                if (UpdateChecker.this.value == null) {
                    UpdateChecker.this.versionString = NetUtils.get("http://huangyuhui.duapp.com/info.php?type=" + UpdateChecker.this.type);
                    UpdateChecker.this.value = VersionNumber.check(UpdateChecker.this.versionString);
                }
                if (UpdateChecker.this.value == null) {
                    HMCLog.warn("Failed to check update...");
                    if (showMessage) {
                        MessageBox.Show(C.i18n("update.failed", new Object[0]));
                    }
                } else if (VersionNumber.isOlder(UpdateChecker.this.base, UpdateChecker.this.value)) {
                    UpdateChecker.this.OUT_DATED = true;
                }
                if (UpdateChecker.this.OUT_DATED) {
                    this.publish(UpdateChecker.this.value);
                }
            }
        };
    }

    @Override
    public VersionNumber getNewVersion() {
        return this.value;
    }

    @Override
    public synchronized OverridableSwingWorker<Map<String, String>> requestDownloadLink() {
        return new OverridableSwingWorker(){

            @Override
            protected void work() throws Exception {
                if (UpdateChecker.this.download_link == null) {
                    try {
                        UpdateChecker.this.download_link = C.GSON.fromJson(NetUtils.get("http://huangyuhui.duapp.com/update_link.php?type=" + UpdateChecker.this.type), Map.class);
                    }
                    catch (Exception e) {
                        HMCLog.warn("Failed to get update link.", e);
                    }
                }
                this.publish(UpdateChecker.this.download_link);
            }
        };
    }

    @Override
    public void checkOutdate() {
        if (this.OUT_DATED) {
            this.outdated.execute(this.getNewVersion());
        }
    }
}

