/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util;

import org.jackhuang.hellominecraft.util.logging.HMCLog;

public final class VersionNumber
implements Comparable<VersionNumber> {
    public final byte firstVer;
    public final byte secondVer;
    public final byte thirdVer;
    public final String version;

    public VersionNumber(byte a, byte b, byte c) {
        this(a, b, c, null);
    }

    public VersionNumber(byte a, byte b, byte c, String version) {
        this.firstVer = a;
        this.secondVer = b;
        this.thirdVer = c;
        this.version = version;
    }

    public String toString() {
        return "" + this.firstVer + '.' + this.secondVer + '.' + this.thirdVer;
    }

    public static VersionNumber check(String data) {
        while (!(data.isEmpty() || data.charAt(0) >= '0' && data.charAt(0) <= '9' || data.charAt(0) == '.')) {
            data = data.substring(1);
        }
        if (data.isEmpty()) {
            return null;
        }
        String[] ver = data.split("\\.");
        if (ver.length >= 3) {
            try {
                byte v1 = Byte.parseByte(ver[0]);
                byte v2 = Byte.parseByte(ver[1]);
                byte v3 = Byte.parseByte(ver[2]);
                VersionNumber ur = new VersionNumber(v1, v2, v3, data);
                return ur;
            }
            catch (Exception e) {
                HMCLog.warn("Failed to parse the version", e);
            }
        }
        return null;
    }

    public static boolean isOlder(VersionNumber a, VersionNumber b) {
        if (a.firstVer < b.firstVer) {
            return true;
        }
        if (a.firstVer == b.firstVer) {
            if (a.secondVer < b.secondVer) {
                return true;
            }
            if (a.secondVer == b.secondVer && a.thirdVer < b.thirdVer) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int compareTo(VersionNumber o) {
        if (VersionNumber.isOlder(this, o)) {
            return -1;
        }
        if (VersionNumber.isOlder(o, this)) {
            return 1;
        }
        return 0;
    }
}

