/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.code;

import java.io.UnsupportedEncodingException;

public class Base64 {
    private static final char[] ALPHABET;
    private static final byte[] CODES;

    public static char[] encode(byte[] data) {
        char[] out = new char[(data.length + 2) / 3 * 4];
        int i = 0;
        int index = 0;
        while (i < data.length) {
            boolean quad = false;
            boolean trip = false;
            int val = 0xFF & data[i];
            val <<= 8;
            if (i + 1 < data.length) {
                val |= 0xFF & data[i + 1];
                trip = true;
            }
            val <<= 8;
            if (i + 2 < data.length) {
                val |= 0xFF & data[i + 2];
                quad = true;
            }
            out[index + 3] = ALPHABET[quad ? val & 0x3F : 64];
            out[index + 2] = ALPHABET[trip ? (val >>= 6) & 0x3F : 64];
            out[index + 1] = ALPHABET[(val >>= 6) & 0x3F];
            out[index + 0] = ALPHABET[(val >>= 6) & 0x3F];
            i += 3;
            index += 4;
        }
        return out;
    }

    public static char[] encode(String s, String charset) throws UnsupportedEncodingException {
        return Base64.encode(s.getBytes(charset));
    }

    public static char[] encode(String s) {
        return Base64.encode(s.getBytes());
    }

    public static byte[] decode(char[] data) {
        int len = (data.length + 3) / 4 * 3;
        if (data.length > 0 && data[data.length - 1] == '=') {
            --len;
        }
        if (data.length > 1 && data[data.length - 2] == '=') {
            --len;
        }
        byte[] out = new byte[len];
        int shift = 0;
        int accum = 0;
        int index = 0;
        for (int ix = 0; ix < data.length; ++ix) {
            byte value = CODES[data[ix] & 0xFF];
            if (value < 0) continue;
            accum <<= 6;
            accum |= value;
            if ((shift += 6) < 8) continue;
            out[index++] = (byte)(accum >> (shift -= 8) & 0xFF);
        }
        if (index != out.length) {
            throw new Error("miscalculated data length!");
        }
        return out;
    }

    static {
        int i;
        ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        CODES = new byte[256];
        for (i = 0; i < 256; ++i) {
            Base64.CODES[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            Base64.CODES[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            Base64.CODES[i] = (byte)(26 + i - 97);
        }
        for (i = 48; i <= 57; ++i) {
            Base64.CODES[i] = (byte)(52 + i - 48);
        }
        Base64.CODES[43] = 62;
        Base64.CODES[47] = 63;
    }
}

