/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.lang;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;

public class Localization {
    private static final String ROOT_LOCATION = "/org/jackhuang/hellominecraft/lang/I18N%s.lang";
    private static final Map<Locale, Localization> INSTANCE = new HashMap<Locale, Localization>();
    private final Map<String, String> lang;

    private Localization(Locale locale) {
        InputStream is = Localization.class.getResourceAsStream(String.format(ROOT_LOCATION, "_" + locale.getLanguage() + "_" + locale.getCountry()));
        if (is == null) {
            is = Localization.class.getResourceAsStream(String.format(ROOT_LOCATION, "_" + locale.getLanguage()));
        }
        if (is == null) {
            is = Localization.class.getResourceAsStream(String.format(ROOT_LOCATION, ""));
        }
        if (is == null) {
            throw new RuntimeException("LANG FILE MISSING");
        }
        this.lang = new HashMap<String, String>();
        try {
            String[] strings;
            for (String s : strings = IOUtils.readFully(is).toString("UTF-8").split("\n")) {
                int i;
                if (s.isEmpty() || s.charAt(0) == '#' || (i = s.indexOf("=")) == -1) continue;
                this.lang.put(s.substring(0, i), s.substring(i + 1));
            }
        }
        catch (IOException ex) {
            HMCLog.err("LANG FILE MISSING", ex);
        }
    }

    public synchronized String localize(String key) {
        String s = this.lang.get(key);
        return s == null ? key : s;
    }

    public static Localization get(Locale l) {
        if (!INSTANCE.containsKey(l)) {
            INSTANCE.put(l, new Localization(l));
        }
        return INSTANCE.get(l);
    }
}

