/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.logging;

import org.jackhuang.hellominecraft.util.logging.Level;
import org.jackhuang.hellominecraft.util.logging.LogEvent;
import org.jackhuang.hellominecraft.util.logging.LoggingException;
import org.jackhuang.hellominecraft.util.logging.appender.IAppender;

public class AppenderControl {
    private final ThreadLocal<AppenderControl> recursive = new ThreadLocal();
    private final IAppender appender;
    private final Level level;
    private final int intLevel;

    public AppenderControl(IAppender appender, Level level) {
        this.appender = appender;
        this.level = level;
        this.intLevel = level == null ? Level.ALL.level : level.level;
    }

    public IAppender getAppender() {
        return this.appender;
    }

    public void callAppender(LogEvent event) {
        if (this.level != null && this.intLevel < event.level.level) {
            return;
        }
        if (this.recursive.get() != null) {
            System.err.println("Recursive call to appender " + this.appender.getName());
            return;
        }
        try {
            this.recursive.set(this);
            try {
                this.appender.append(event);
            }
            catch (RuntimeException ex) {
                System.err.println("An exception occurred processing Appender " + this.appender.getName());
                ex.printStackTrace();
                if (!this.appender.ignoreExceptions()) {
                    throw ex;
                }
            }
            catch (Exception ex) {
                System.err.println("An exception occurred processing Appender " + this.appender.getName());
                ex.printStackTrace();
                if (!this.appender.ignoreExceptions()) {
                    throw new LoggingException(ex);
                }
            }
        }
        finally {
            this.recursive.set(null);
        }
    }
}

