/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.logging;

import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum Level {
    OFF(0, Color.gray),
    FATAL(1, Color.red),
    ERROR(2, Color.red),
    WARN(3, Color.orange),
    INFO(4, Color.black),
    DEBUG(5, Color.blue),
    TRACE(6, Color.blue),
    ALL(Integer.MAX_VALUE, Color.black);

    public final int level;
    public final Color COLOR;
    public static final Pattern MINECRAFT_LOGGER;
    public static final String JAVA_SYMBOL = "([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*";

    private Level(int i, Color c) {
        this.level = i;
        this.COLOR = c;
    }

    public boolean lessOrEqual(Level level) {
        return this.level <= level.level;
    }

    public boolean lessOrEqual(int level) {
        return this.level <= level;
    }

    public static Level guessLevel(String line, Level level) {
        Matcher m = MINECRAFT_LOGGER.matcher(line);
        if (m.find()) {
            String levelStr = m.group("level");
            if (null != levelStr) {
                String string = levelStr;
                int n = -1;
                switch (string.hashCode()) {
                    case 2251950: {
                        if (!string.equals("INFO")) break;
                        n = 0;
                        break;
                    }
                    case 2656902: {
                        if (!string.equals("WARN")) break;
                        n = 1;
                        break;
                    }
                    case 66247144: {
                        if (!string.equals("ERROR")) break;
                        n = 2;
                        break;
                    }
                    case 66665700: {
                        if (!string.equals("FATAL")) break;
                        n = 3;
                        break;
                    }
                    case 80083237: {
                        if (!string.equals("TRACE")) break;
                        n = 4;
                        break;
                    }
                    case 64921139: {
                        if (!string.equals("DEBUG")) break;
                        n = 5;
                    }
                }
                switch (n) {
                    case 0: {
                        level = INFO;
                        break;
                    }
                    case 1: {
                        level = WARN;
                        break;
                    }
                    case 2: {
                        level = ERROR;
                        break;
                    }
                    case 3: {
                        level = FATAL;
                        break;
                    }
                    case 4: {
                        level = TRACE;
                        break;
                    }
                    case 5: {
                        level = DEBUG;
                        break;
                    }
                }
            }
        } else {
            if (line.contains("[INFO]") || line.contains("[CONFIG]") || line.contains("[FINE]") || line.contains("[FINER]") || line.contains("[FINEST]")) {
                level = INFO;
            }
            if (line.contains("[SEVERE]") || line.contains("[STDERR]")) {
                level = ERROR;
            }
            if (line.contains("[WARNING]")) {
                level = WARN;
            }
            if (line.contains("[DEBUG]")) {
                level = DEBUG;
            }
        }
        if (line.contains("overwriting existing")) {
            return FATAL;
        }
        if (line.contains("Exception in thread") || line.matches("\\s+at ([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*") || line.matches("Caused by: ([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$][a-zA-Z\\d_$]*") || line.matches("([a-zA-Z_$][a-zA-Z\\d_$]*\\.)+[a-zA-Z_$]?[a-zA-Z\\d_$]*(Exception|Error|Throwable)") || line.matches("... \\d+ more$")) {
            return ERROR;
        }
        return level;
    }

    static {
        MINECRAFT_LOGGER = Pattern.compile("\\[(?<timestamp>[0-9:]+)\\] \\[[^/]+/(?<level>[^\\]]+)\\]");
    }
}

