/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jackhuang.hellominecraft.util.func.BiFunction;
import org.jackhuang.hellominecraft.util.func.Predicate;

public class Compressor {
    public static void zip(String sourceDir, String zipFile) throws IOException {
        Compressor.zip(new File(sourceDir), new File(zipFile), null);
    }

    public static void zip(File sourceDir, File zipFile, BiFunction<String, Boolean, String> pathNameCallback) throws IOException {
        FileOutputStream os = new FileOutputStream(zipFile);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        ZipOutputStream zos = new ZipOutputStream(bos);
        Throwable throwable = null;
        try {
            String basePath = sourceDir.isDirectory() ? sourceDir.getPath() : sourceDir.getParent();
            Compressor.zipFile(sourceDir, basePath, zos, pathNameCallback);
            zos.closeEntry();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (zos != null) {
                if (throwable != null) {
                    try {
                        zos.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    zos.close();
                }
            }
        }
    }

    public static ZipOutputStream zipContinuing(File sourceDir, File zipFile, BiFunction<String, Boolean, String> pathNameCallback) throws IOException {
        FileOutputStream os = new FileOutputStream(zipFile);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        ZipOutputStream zos = new ZipOutputStream(bos);
        Throwable throwable = null;
        try {
            String basePath = sourceDir.isDirectory() ? sourceDir.getPath() : sourceDir.getParent();
            Compressor.zipFile(sourceDir, basePath, zos, pathNameCallback);
            ZipOutputStream zipOutputStream = zos;
            return zipOutputStream;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (zos != null) {
                if (throwable != null) {
                    try {
                        zos.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    zos.close();
                }
            }
        }
    }

    private static void zipFile(File source, String basePath, ZipOutputStream zos, BiFunction<String, Boolean, String> pathNameCallback) throws IOException {
        File[] files = source.isDirectory() ? source.listFiles() : new File[]{source};
        byte[] buf = new byte[1024];
        for (File file : files) {
            String pathName;
            if (file.isDirectory()) {
                pathName = file.getPath().substring(basePath.length() + 1) + "/";
                if (pathNameCallback != null) {
                    pathName = pathNameCallback.apply(pathName, true);
                }
                if (pathName == null) continue;
                zos.putNextEntry(new ZipEntry(pathName));
                Compressor.zipFile(file, basePath, zos, pathNameCallback);
                continue;
            }
            pathName = file.getPath().substring(basePath.length() + 1);
            if (pathNameCallback != null) {
                pathName = pathNameCallback.apply(pathName, true);
            }
            if (pathName == null) continue;
            FileInputStream is = new FileInputStream(file);
            Throwable throwable = null;
            try {
                int length;
                BufferedInputStream bis = new BufferedInputStream(is);
                zos.putNextEntry(new ZipEntry(pathName));
                while ((length = bis.read(buf)) > 0) {
                    zos.write(buf, 0, length);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is != null) {
                    if (throwable != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (Throwable throwable3) {
                        }
                    } else {
                        ((InputStream)is).close();
                    }
                }
            }
        }
    }

    public static void unzip(String zipFileName, String extPlace) throws IOException {
        Compressor.unzip(new File(zipFileName), new File(extPlace));
    }

    public static void unzip(File zipFileName, File extPlace) throws IOException {
        Compressor.unzip(zipFileName, extPlace, null, true);
    }

    public static void unzip(File zipFileName, File extPlace, Predicate<String> callback, boolean ignoreExistsFile) throws IOException {
        block36: {
            extPlace.mkdirs();
            ZipInputStream zipFile = new ZipInputStream(new FileInputStream(zipFileName));
            Throwable throwable = null;
            try {
                ZipEntry zipEnt;
                if (!zipFileName.exists()) break block36;
                String strPath = extPlace.getAbsolutePath();
                while ((zipEnt = zipFile.getNextEntry()) != null) {
                    String strtemp;
                    String gbkPath = zipEnt.getName();
                    if (callback != null && !callback.apply(gbkPath)) continue;
                    if (zipEnt.isDirectory()) {
                        strtemp = strPath + File.separator + gbkPath;
                        File dir = new File(strtemp);
                        dir.mkdirs();
                        continue;
                    }
                    gbkPath = zipEnt.getName();
                    strtemp = strPath + File.separator + gbkPath;
                    String strsubdir = gbkPath;
                    for (int i = 0; i < strsubdir.length(); ++i) {
                        String temp;
                        File subdir;
                        if (!strsubdir.substring(i, i + 1).equalsIgnoreCase("/") || (subdir = new File(temp = strPath + File.separator + strsubdir.substring(0, i))).exists()) continue;
                        subdir.mkdir();
                    }
                    if (ignoreExistsFile && new File(strtemp).exists()) continue;
                    FileOutputStream fos = new FileOutputStream(strtemp);
                    Throwable throwable2 = null;
                    try {
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        Throwable throwable3 = null;
                        try {
                            int c;
                            while ((c = zipFile.read()) != -1) {
                                bos.write((byte)c);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (bos == null) continue;
                            if (throwable3 != null) {
                                try {
                                    bos.close();
                                }
                                catch (Throwable throwable5) {
                                }
                                continue;
                            }
                            bos.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (fos == null) continue;
                        if (throwable2 != null) {
                            try {
                                fos.close();
                            }
                            catch (Throwable throwable7) {
                            }
                            continue;
                        }
                        fos.close();
                    }
                }
            }
            catch (Throwable throwable8) {
                throwable = throwable8;
                throw throwable8;
            }
            finally {
                if (zipFile != null) {
                    if (throwable != null) {
                        try {
                            zipFile.close();
                        }
                        catch (Throwable throwable9) {
                        }
                    } else {
                        zipFile.close();
                    }
                }
            }
        }
    }
}

