/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.FileUtils;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.system.Platform;

public final class JdkVersion
implements Cloneable {
    private String ver;
    private int platform;
    private String location;
    public static final int UNKOWN = 2;
    public static final int JAVA_16 = 3;
    public static final int JAVA_17 = 4;
    public static final int JAVA_18 = 5;
    public static final int JAVA_19 = 6;
    private static final String JAVA_VER = System.getProperty("java.version");
    private static final int MAJOR_JAVA_VER = JdkVersion.parseVersion(JAVA_VER);
    private static final Pattern p = Pattern.compile("java version \"[1-9]*\\.[1-9]*\\.[0-9]*(.*?)\"");

    public String getVersion() {
        return this.ver;
    }

    public Platform getPlatform() {
        return Platform.values()[this.platform];
    }

    public String getLocation() {
        return this.location;
    }

    public int getParsedVersion() {
        return JdkVersion.parseVersion(this.getVersion());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JdkVersion)) {
            return false;
        }
        JdkVersion b = (JdkVersion)obj;
        if (b.location == null || this.location == null) {
            return b.location == this.location;
        }
        return new File(b.location).equals(new File(this.location));
    }

    public int hashCode() {
        return this.location == null ? 0 : new File(this.location).hashCode();
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error(ex);
        }
    }

    public JdkVersion(String location) {
        File f = new File(location);
        if (f.exists() && f.isFile()) {
            f = f.getParentFile();
        }
        this.location = f.getAbsolutePath();
    }

    public JdkVersion(String location, String ver, Platform platform) {
        this(location);
        this.ver = ver;
        this.platform = platform.ordinal();
    }

    private static int parseVersion(String javaVersion) {
        if (StrUtils.isBlank(javaVersion)) {
            return 2;
        }
        int a = 2;
        if (javaVersion.contains("1.9.") || javaVersion.startsWith("9")) {
            a = 6;
        } else if (javaVersion.contains("1.8.")) {
            a = 5;
        } else if (javaVersion.contains("1.7.")) {
            a = 4;
        } else if (javaVersion.contains("1.6.")) {
            a = 3;
        }
        return a;
    }

    public static String getJavaVersion() {
        return JAVA_VER;
    }

    public static int getMajorJavaVersion() {
        return MAJOR_JAVA_VER;
    }

    public static boolean isJava64Bit() {
        String jdkBit = System.getProperty("sun.arch.data.model");
        return jdkBit.contains("64");
    }

    public static JdkVersion getJavaVersionFromExecutable(String file) throws IOException {
        String[] str = new String[]{file, "-version"};
        Platform platform = Platform.BIT_32;
        String ver = null;
        try {
            for (String line : IOUtils.readProcessByErrorStream(str)) {
                Matcher m = p.matcher(line);
                if (m.find()) {
                    ver = m.group();
                    ver = ver.substring("java version \"".length(), ver.length() - 1);
                }
                if (!line.contains("64-Bit")) continue;
                platform = Platform.BIT_64;
            }
        }
        catch (IOException | InterruptedException e) {
            HMCLog.warn("Failed to get java version", e);
        }
        return new JdkVersion(file, ver, platform);
    }

    public void write(File f) throws IOException {
        if (this.ver != null && this.getPlatform() != Platform.UNKNOWN) {
            FileUtils.write(f, this.ver + "\n" + this.platform);
        }
    }

    public boolean isEarlyAccess() {
        return this.getVersion() != null && this.getVersion().endsWith("-ea");
    }
}

