/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.system;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jackhuang.hellominecraft.util.func.BiFunction;

public class ZipEngine {
    byte[] buf = new byte[1024];
    ZipOutputStream zos;
    protected HashSet<String> names = new HashSet();

    public ZipEngine(File f) throws IOException {
        FileOutputStream os = new FileOutputStream(f);
        this.zos = new ZipOutputStream(new BufferedOutputStream(os));
    }

    public void closeFile() throws IOException {
        this.zos.closeEntry();
        this.zos.close();
    }

    public void putDirectory(String sourceDir) throws IOException {
        this.putDirectory(new File(sourceDir), null);
    }

    public void putDirectory(File sourceDir) throws IOException {
        this.putDirectory(sourceDir, null);
    }

    public void putDirectory(File sourceDir, BiFunction<String, Boolean, String> pathNameCallback) throws IOException {
        this.putDirectoryImpl(sourceDir, sourceDir.isDirectory() ? sourceDir.getPath() : sourceDir.getParent(), pathNameCallback);
    }

    private void putDirectoryImpl(File source, String basePath, BiFunction<String, Boolean, String> pathNameCallback) throws IOException {
        File[] files = source.isDirectory() ? source.listFiles() : new File[]{source};
        if (files == null) {
            return;
        }
        for (File file : files) {
            String pathName;
            if (file.isDirectory()) {
                pathName = file.getPath().substring(basePath.length() + 1) + "/";
                pathName = pathName.replace('\\', '/');
                if (pathNameCallback != null) {
                    pathName = pathNameCallback.apply(pathName, true);
                }
                if (pathName == null) continue;
                this.put(new ZipEntry(pathName));
                this.putDirectoryImpl(file, basePath, pathNameCallback);
                continue;
            }
            if (".DS_Store".equals(file.getName())) continue;
            pathName = file.getPath().substring(basePath.length() + 1);
            pathName = pathName.replace('\\', '/');
            if (pathNameCallback != null) {
                pathName = pathNameCallback.apply(pathName, false);
            }
            if (pathName == null) continue;
            this.putFile(file, pathName);
        }
    }

    public void putFile(File file, String pathName) throws IOException {
        this.putStream(new FileInputStream(file), pathName);
    }

    public void putStream(InputStream is, String pathName) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        Throwable throwable = null;
        try {
            int length;
            this.put(new ZipEntry(pathName));
            while ((length = bis.read(this.buf)) > 0) {
                this.zos.write(this.buf, 0, length);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (bis != null) {
                if (throwable != null) {
                    try {
                        bis.close();
                    }
                    catch (Throwable throwable3) {
                    }
                } else {
                    bis.close();
                }
            }
        }
    }

    public void putTextFile(String text, String pathName) throws IOException {
        this.putTextFile(text, "UTF-8", pathName);
    }

    public void putTextFile(String text, String encoding, String pathName) throws IOException {
        this.putStream(new ByteArrayInputStream(text.getBytes(encoding)), pathName);
    }

    public void put(ZipEntry entry) throws IOException {
        if (this.names.add(entry.getName())) {
            this.zos.putNextEntry(entry);
        }
    }
}

