/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.tasks;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.MessageBox;
import org.jackhuang.hellominecraft.util.StrUtils;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.tasks.DoingDoneListener;
import org.jackhuang.hellominecraft.util.tasks.NoShownTaskException;
import org.jackhuang.hellominecraft.util.tasks.ProgressProviderListener;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.TaskList;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$1;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$2;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$3;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$4;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$5;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$6;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$7;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$$Lambda$8;
import org.jackhuang.hellominecraft.util.tasks.TaskWindow$TaskWindowFactory$$Lambda$1;
import org.jackhuang.hellominecraft.util.ui.SwingUtils;

public class TaskWindow
extends JDialog
implements ProgressProviderListener,
Runnable,
DoingDoneListener<Task> {
    private static volatile TaskWindow INSTANCE = null;
    boolean suc = false;
    private TaskList taskList;
    private final ArrayList<String> failReasons = new ArrayList();
    private String stackTrace = null;
    private String lastStackTrace = null;
    public static String downloadSource = "";
    private JButton btnCancel;
    private JTable lstDownload;
    private JProgressBar pgsTotal;
    private JScrollPane srlDownload;
    final ArrayList<Task> tasks = new ArrayList();
    final ArrayList<Integer> progresses = new ArrayList();

    private static synchronized TaskWindow instance() {
        if (INSTANCE == null) {
            INSTANCE = new TaskWindow();
        }
        INSTANCE.clean();
        return INSTANCE;
    }

    public static TaskWindowFactory factory() {
        return new TaskWindowFactory();
    }

    private TaskWindow() {
        this.initComponents();
        this.setLocationRelativeTo(null);
        if (this.lstDownload.getColumnModel().getColumnCount() > 1) {
            int i = 35;
            this.lstDownload.getColumnModel().getColumn(1).setMinWidth(i);
            this.lstDownload.getColumnModel().getColumn(1).setMaxWidth(i);
            this.lstDownload.getColumnModel().getColumn(1).setPreferredWidth(i);
        }
        this.setModal(true);
    }

    public TaskWindow addTask(Task task) {
        this.taskList.addTask(task);
        return this;
    }

    public synchronized void clean() {
        if (this.isVisible()) {
            return;
        }
        this.taskList = new TaskList();
        this.taskList.addTaskListener(this);
        this.taskList.addAllDoneListener(this);
    }

    public boolean start() {
        if (this.isVisible() || this.taskList == null || this.taskList.isAlive()) {
            return false;
        }
        this.pgsTotal.setValue(0);
        this.suc = false;
        SwingUtils.clearDefaultTable(this.lstDownload);
        this.failReasons.clear();
        this.tasks.clear();
        try {
            this.taskList.start();
        }
        catch (Exception e) {
            HMCLog.err("Failed to start thread, maybe there're already a taskwindow here.", e);
            HMCLog.err("There's the stacktrace of the this invoking.");
            HMCLog.err(this.stackTrace);
            HMCLog.err("There's the stacktrace of the last invoking.");
            HMCLog.err(this.lastStackTrace);
            MessageBox.Show(C.i18n("taskwindow.no_more_instance", new Object[0]));
            return false;
        }
        this.setTitle(C.i18n("taskwindow.title", new Object[0]) + " - " + C.i18n("download.source", new Object[0]) + ": " + downloadSource);
        this.setVisible(true);
        return this.areTasksFinished();
    }

    private void initComponents() {
        this.btnCancel = new JButton();
        this.pgsTotal = new JProgressBar();
        this.srlDownload = new JScrollPane();
        this.lstDownload = new JTable();
        this.setDefaultCloseOperation(2);
        this.setTitle(C.i18n("taskwindow.title", new Object[0]));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                TaskWindow.this.formWindowClosed(evt);
            }
        });
        this.btnCancel.setText(C.i18n("taskwindow.cancel", new Object[0]));
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TaskWindow.this.btnCancelActionPerformed(evt);
            }
        });
        this.pgsTotal.setStringPainted(true);
        this.lstDownload.setModel(SwingUtils.makeDefaultTableModel(new String[]{C.i18n("taskwindow.file_name", new Object[0]), C.i18n("taskwindow.download_progress", new Object[0])}, new Class[]{String.class, String.class}, new boolean[]{false, false}));
        this.lstDownload.setRowSelectionAllowed(false);
        this.lstDownload.setSelectionMode(0);
        this.srlDownload.setViewportView(this.lstDownload);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.pgsTotal, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCancel).addContainerGap()).addComponent(this.srlDownload, -1, 517, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.srlDownload, -1, 290, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pgsTotal, -2, 22, -2).addComponent(this.btnCancel, -2, 22, -2)).addContainerGap()));
        this.pack();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        if (MessageBox.Show(C.i18n("operation.confirm_stop", new Object[0]), 10) == 0) {
            this.dispose();
        }
    }

    private void formWindowClosed(WindowEvent evt) {
        if (this.taskList == null) {
            return;
        }
        this.tasks.clear();
        if (!this.failReasons.isEmpty()) {
            String str = StrUtils.parseParams("", this.failReasons.toArray(), "\n");
            SwingUtilities.invokeLater(TaskWindow$$Lambda$1.lambdaFactory$(str));
            this.failReasons.clear();
        }
        if (!this.suc) {
            if (this.taskList != null) {
                TaskList taskList = this.taskList;
                taskList.getClass();
                SwingUtilities.invokeLater(TaskWindow$$Lambda$2.lambdaFactory$(taskList));
            }
            HMCLog.log("Tasks have been canceled by user.");
        }
        this.taskList = null;
    }

    @Override
    public void setProgress(Task task, int progress, int max) {
        SwingUtilities.invokeLater(TaskWindow$$Lambda$3.lambdaFactory$(this, task, progress, max));
    }

    @Override
    public void run() {
        SwingUtilities.invokeLater(TaskWindow$$Lambda$4.lambdaFactory$(this));
    }

    @Override
    public void onDoing(Task task, Collection<Task> taskCollection) {
        if (task == null) {
            return;
        }
        task.setProgressProviderListener(this);
        SwingUtilities.invokeLater(TaskWindow$$Lambda$5.lambdaFactory$(this, task));
    }

    public boolean areTasksFinished() {
        return this.suc;
    }

    @Override
    public void onDone(Task task, Collection<Task> taskCollection) {
        SwingUtilities.invokeLater(TaskWindow$$Lambda$6.lambdaFactory$(this, task));
    }

    @Override
    public void onFailed(Task task) {
        SwingUtilities.invokeLater(TaskWindow$$Lambda$7.lambdaFactory$(this, task));
    }

    @Override
    public void onProgressProviderDone(Task task) {
    }

    @Override
    public void setStatus(Task task, String sta) {
        SwingUtilities.invokeLater(TaskWindow$$Lambda$8.lambdaFactory$(this, task, sta));
    }

    public static boolean execute(Task ... ts) {
        TaskWindowFactory f = TaskWindow.factory();
        for (Task t : ts) {
            f.append(t);
        }
        return f.create();
    }

    private /* synthetic */ void lambda$setStatus$14(Task task, String sta) {
        if (this.taskList == null || task == null) {
            return;
        }
        int idx = this.tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        SwingUtils.setValueAt(this.lstDownload, task.getInfo() + ": " + sta, idx, 0);
    }

    private /* synthetic */ void lambda$onFailed$13(Task task) {
        if (this.taskList == null || task == null) {
            return;
        }
        String msg = null;
        if (task.getFailReason() != null && !(task.getFailReason() instanceof NoShownTaskException)) {
            msg = StrUtils.isBlank(task.getFailReason().getLocalizedMessage()) ? task.getFailReason().getClass().getSimpleName() : task.getFailReason().getLocalizedMessage();
        }
        if (msg != null) {
            this.failReasons.add(task.getInfo() + ": " + msg);
        }
        this.pgsTotal.setMaximum(this.taskList.taskCount());
        this.pgsTotal.setValue(this.pgsTotal.getValue() + 1);
        int idx = this.tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        SwingUtils.setValueAt(this.lstDownload, task.getFailReason(), idx, 0);
        SwingUtils.setValueAt(this.lstDownload, "0%", idx, 1);
        SwingUtils.moveEnd(this.srlDownload);
    }

    private /* synthetic */ void lambda$onDone$12(Task task) {
        if (this.taskList == null || task == null) {
            return;
        }
        this.pgsTotal.setMaximum(this.taskList.taskCount());
        this.pgsTotal.setValue(this.pgsTotal.getValue() + 1);
        int idx = this.tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        this.tasks.remove(idx);
        this.progresses.remove(idx);
        SwingUtils.removeRow(this.lstDownload, idx);
    }

    private /* synthetic */ void lambda$onDoing$11(Task task) {
        if (this.taskList == null) {
            return;
        }
        this.tasks.add(task);
        this.progresses.add(-1);
        SwingUtils.appendLast(this.lstDownload, task.getInfo(), "0%");
        SwingUtils.moveEnd(this.srlDownload);
    }

    private /* synthetic */ void lambda$run$10() {
        this.dispose();
        this.suc = true;
        HMCLog.log("Tasks are finished.");
    }

    private /* synthetic */ void lambda$setProgress$9(Task task, int progress, int max) {
        if (task == null) {
            return;
        }
        int idx = this.tasks.indexOf(task);
        if (idx == -1) {
            return;
        }
        int pgs = progress * 100 / max;
        if (this.progresses.size() > idx && this.progresses.get(idx) != pgs && this.lstDownload.getRowCount() > idx) {
            SwingUtils.setValueAt(this.lstDownload, pgs < 0 ? "???" : pgs + "%", idx, 1);
            this.progresses.set(idx, pgs);
        }
    }

    private static /* synthetic */ void lambda$formWindowClosed$8(String str) {
        MessageBox.Show(str, C.i18n("message.error", new Object[0]), 0);
    }

    static /* synthetic */ void access$lambda$0(String string) {
        TaskWindow.lambda$formWindowClosed$8(string);
    }

    static /* synthetic */ void access$lambda$1(TaskWindow taskWindow, Task task, int n, int n2) {
        taskWindow.lambda$setProgress$9(task, n, n2);
    }

    static /* synthetic */ void access$lambda$2(TaskWindow taskWindow) {
        taskWindow.lambda$run$10();
    }

    static /* synthetic */ void access$lambda$3(TaskWindow taskWindow, Task task) {
        taskWindow.lambda$onDoing$11(task);
    }

    static /* synthetic */ void access$lambda$4(TaskWindow taskWindow, Task task) {
        taskWindow.lambda$onDone$12(task);
    }

    static /* synthetic */ void access$lambda$5(TaskWindow taskWindow, Task task) {
        taskWindow.lambda$onFailed$13(task);
    }

    static /* synthetic */ void access$lambda$6(TaskWindow taskWindow, Task task, String string) {
        taskWindow.lambda$setStatus$14(task, string);
    }

    public static class TaskWindowFactory {
        LinkedList<Task> ll = new LinkedList();
        boolean flag;

        public TaskWindowFactory append(Task t) {
            if (t != null) {
                this.ll.add(t);
            }
            return this;
        }

        public boolean create() {
            String stacktrace = StrUtils.getStackTrace(new Throwable());
            return (Boolean)SwingUtils.invokeAndWait(TaskWindow$TaskWindowFactory$$Lambda$1.lambdaFactory$(this, stacktrace));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private /* synthetic */ Boolean lambda$create$15(String stacktrace) {
            TaskWindow tw;
            TaskWindow taskWindow = tw = TaskWindow.instance();
            synchronized (taskWindow) {
                if (tw.isVisible()) {
                    return false;
                }
                for (Task t : this.ll) {
                    tw.addTask(t);
                }
                tw.lastStackTrace = tw.stackTrace;
                tw.stackTrace = stacktrace;
                return tw.start();
            }
        }

        static /* synthetic */ Boolean access$lambda$0(TaskWindowFactory taskWindowFactory, String string) {
            return taskWindowFactory.lambda$create$15(string);
        }
    }
}

