/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.tasks.download;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.code.DigestUtils;
import org.jackhuang.hellominecraft.util.func.Function;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.system.IOUtils;
import org.jackhuang.hellominecraft.util.tasks.Task;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResult;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResultRegistrar;
import org.jackhuang.hellominecraft.util.tasks.download.DownloadListener;
import org.jackhuang.hellominecraft.util.tasks.download.NetException;

public class FileDownloadTask
extends Task
implements PreviousResult<File>,
PreviousResultRegistrar<String> {
    protected static final int MAX_BUFFER_SIZE = 2048;
    protected URL url;
    protected int downloaded = 0;
    protected File filePath;
    protected String expectedHash;
    protected Function<Integer, String> failedCallbackReturnsNewURL;
    RandomAccessFile file = null;
    InputStream stream = null;
    boolean shouldContinue = true;
    ArrayList<PreviousResult<String>> al = new ArrayList();

    public FileDownloadTask setFailedCallbackReturnsNewURL(Function<Integer, String> failedCallbackReturnsNewURL) {
        this.failedCallbackReturnsNewURL = failedCallbackReturnsNewURL;
        return this;
    }

    public FileDownloadTask() {
    }

    public FileDownloadTask(File filePath) {
        this((URL)null, filePath);
    }

    public FileDownloadTask(String url, File filePath) {
        this(IOUtils.parseURL(url), filePath);
    }

    public FileDownloadTask(URL url, File filePath) {
        this(url, filePath, null);
    }

    public FileDownloadTask(String url, File filePath, String hash) {
        this(IOUtils.parseURL(url), filePath, hash);
    }

    public FileDownloadTask(URL url, File file, String hash) {
        this.url = url;
        this.filePath = file;
        this.expectedHash = hash;
    }

    public String getUrl() {
        return this.url.toString();
    }

    private void closeFiles() {
        if (this.file != null) {
            try {
                this.file.close();
                this.file = null;
            }
            catch (IOException e) {
                HMCLog.warn("Failed to close file", e);
            }
        }
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (IOException e) {
                HMCLog.warn("Failed to close stream", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeTask() throws Throwable {
        for (PreviousResult<String> p : this.al) {
            this.url = IOUtils.parseURL(p.getResult());
        }
        for (int repeat = 0; repeat < 6; ++repeat) {
            URL tmp;
            if (repeat > 0 && this.failedCallbackReturnsNewURL != null && (tmp = IOUtils.parseURL(this.failedCallbackReturnsNewURL.apply(repeat))) != null) {
                this.url = tmp;
                HMCLog.warn("Switch to: " + this.url);
            }
            HMCLog.log("Downloading: " + this.url + ", to: " + this.filePath);
            if (!this.shouldContinue) break;
            try {
                if (this.ppl != null) {
                    this.ppl.setProgress(this, -1, 1);
                }
                HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
                connection.setConnectTimeout(5000);
                connection.setRequestProperty("User-Agent", "Hello Minecraft!");
                connection.connect();
                if (connection.getResponseCode() / 100 != 2) {
                    throw new NetException(C.i18n("download.not_200", new Object[0]) + " " + connection.getResponseCode());
                }
                int contentLength = connection.getContentLength();
                if (contentLength < 1) {
                    throw new NetException("The content length is invalid.");
                }
                this.filePath.getParentFile().mkdirs();
                File tempFile = new File(this.filePath.getAbsolutePath() + ".hmd");
                if (!tempFile.exists()) {
                    tempFile.createNewFile();
                } else if (!tempFile.renameTo(tempFile)) {
                    throw new RuntimeException("The temp file is locked, maybe there is an application using the file?");
                }
                this.file = new RandomAccessFile(tempFile, "rw");
                MessageDigest digest = DigestUtils.getSha1Digest();
                this.stream = connection.getInputStream();
                int lastDownloaded = 0;
                this.downloaded = 0;
                long lastTime = System.currentTimeMillis();
                while (true) {
                    if (!this.shouldContinue) {
                        this.closeFiles();
                        this.filePath.delete();
                        break;
                    }
                    byte[] buffer = new byte[2048];
                    int read = this.stream.read(buffer);
                    if (read == -1) break;
                    digest.update(buffer, 0, read);
                    this.file.write(buffer, 0, read);
                    this.downloaded += read;
                    long now = System.currentTimeMillis();
                    if (this.ppl == null || now - lastTime < 1000L) continue;
                    this.ppl.setProgress(this, this.downloaded, contentLength);
                    this.ppl.setStatus(this, (this.downloaded - lastDownloaded) / 1024 + "KB/s");
                    lastDownloaded = this.downloaded;
                    lastTime = now;
                }
                this.closeFiles();
                if (this.aborted) {
                    tempFile.delete();
                } else {
                    if (this.filePath.exists()) {
                        this.filePath.delete();
                    }
                    tempFile.renameTo(this.filePath);
                }
                if (this.shouldContinue) {
                    if (this.downloaded != contentLength) {
                        throw new IllegalStateException("Unexptected file size: " + this.downloaded + ", expected: " + contentLength);
                    }
                    String hashCode = String.format("%1$040x", new BigInteger(1, digest.digest()));
                    if (this.expectedHash != null && !this.expectedHash.equals(hashCode)) {
                        throw new IllegalStateException("Unexpected hash code: " + hashCode + ", expected: " + this.expectedHash);
                    }
                    if (this.ppl != null) {
                        this.ppl.onProgressProviderDone(this);
                    }
                    return;
                }
                break;
            }
            catch (Exception e) {
                this.setFailReason(new NetException(C.i18n("download.failed", new Object[0]) + " " + this.url, e));
                continue;
            }
            finally {
                this.closeFiles();
            }
        }
        if (this.failReason != null) {
            throw this.failReason;
        }
    }

    public static void download(String url, String file, DownloadListener dl) throws Throwable {
        FileDownloadTask.download(url, new File(file), dl);
    }

    public static void download(String url, File file, DownloadListener dl) throws Throwable {
        new FileDownloadTask(url, file).setProgressProviderListener(dl).executeTask();
    }

    @Override
    public boolean abort() {
        this.shouldContinue = false;
        this.aborted = true;
        return true;
    }

    @Override
    public String getInfo() {
        return C.i18n("download", new Object[0]) + ": " + this.url;
    }

    @Override
    public File getResult() {
        return this.filePath;
    }

    @Override
    public Task registerPreviousResult(PreviousResult<String> pr) {
        this.al.add(pr);
        return this;
    }
}

