/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.tasks.download;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.jackhuang.hellominecraft.util.EventHandler;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.tasks.TaskInfo;
import org.jackhuang.hellominecraft.util.tasks.communication.PreviousResult;
import org.jackhuang.hellominecraft.util.tasks.download.NetException;

public class HTTPGetTask
extends TaskInfo
implements PreviousResult<String> {
    String url;
    String encoding;
    String result;
    EventHandler<String> tdtsl = new EventHandler(this);
    boolean shouldContinue = true;

    public HTTPGetTask(String url) {
        this(null, url);
    }

    public HTTPGetTask(String info, String url) {
        this(info, url, "UTF-8");
    }

    public HTTPGetTask(String info, String url, String encoding) {
        super(info);
        this.url = url;
        this.encoding = encoding;
    }

    @Override
    public void executeTask() throws Exception {
        NetException t = null;
        for (int repeat = 0; repeat < 6; ++repeat) {
            if (repeat > 0) {
                HMCLog.warn("Failed to download, repeat: " + repeat);
            }
            try {
                int i;
                if (this.ppl != null) {
                    this.ppl.setProgress(this, -1, 1);
                }
                URLConnection conn = new URL(this.url).openConnection();
                InputStream is = conn.getInputStream();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int size = conn.getContentLength();
                int read = 0;
                long lastTime = System.currentTimeMillis();
                while ((i = is.read()) != -1) {
                    baos.write(i);
                    ++read;
                    long now = System.currentTimeMillis();
                    if (this.ppl != null && now - lastTime >= 1000L) {
                        this.ppl.setProgress(this, read, size);
                        lastTime = now;
                    }
                    if (this.shouldContinue) continue;
                    return;
                }
                this.result = baos.toString();
                this.tdtsl.execute(this.result);
                return;
            }
            catch (Exception ex) {
                t = new NetException("Failed to get " + this.url, ex);
                continue;
            }
        }
        if (t != null) {
            throw t;
        }
    }

    @Override
    public boolean abort() {
        this.shouldContinue = false;
        this.aborted = true;
        return true;
    }

    @Override
    public String getInfo() {
        return super.getInfo() != null ? super.getInfo() : "Get: " + this.url;
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

