/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui.wizard.api.displayer;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.NoSuchElementException;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.NavButtonManager$$Lambda$1;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.NavButtonManager$$Lambda$2;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.NavButtonManager$NavWizardObserver$$Lambda$1;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.WizardDisplayerImpl;
import org.jackhuang.hellominecraft.util.ui.wizard.modules.MergeMap;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.DeferredWizardResult;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.Summary;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.Wizard;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardException;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardObserver;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardPanel;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardPanelNavResult;

public class NavButtonManager
implements ActionListener {
    static final String NAME_NEXT = "next";
    static final String NAME_PREV = "prev";
    static final String NAME_FINISH = "finish";
    static final String NAME_CANCEL = "cancel";
    static final String NAME_CLOSE = "close";
    static final String DEFERRED_FAILED = "FAILED_";
    JButton next = null;
    JButton prev = null;
    JButton finish = null;
    JButton cancel = null;
    JButton help = null;
    JPanel buttons = null;
    private Window window;
    WizardDisplayerImpl parent;
    boolean suppressMessageDialog = false;
    String deferredStatus = null;

    NavButtonManager(WizardDisplayerImpl impl) {
        this.parent = impl;
    }

    protected void buildButtons(Action helpAction) {
        this.next = new JButton(C.i18n("wizard.next_>", new Object[0]));
        this.next.setName(NAME_NEXT);
        this.next.setMnemonic(C.i18n("wizard.next_mnemonic", new Object[0]).charAt(0));
        this.prev = new JButton(C.i18n("wizard.<_prev", new Object[0]));
        this.prev.setName(NAME_PREV);
        this.prev.setMnemonic(C.i18n("wizard.prev_mnemonic", new Object[0]).charAt(0));
        this.finish = new JButton(C.i18n("wizard.finish", new Object[0]));
        this.finish.setName(NAME_FINISH);
        this.finish.setMnemonic(C.i18n("wizard.finish_mnemonic", new Object[0]).charAt(0));
        this.cancel = new JButton(C.i18n("wizard.cancel", new Object[0]));
        this.cancel.setName(NAME_CANCEL);
        this.cancel.setMnemonic(C.i18n("wizard.cancel_mnemonic", new Object[0]).charAt(0));
        this.help = new JButton();
        if (helpAction != null) {
            this.help.setAction(helpAction);
        }
        if (helpAction == null || helpAction.getValue("Name") == null) {
            this.help.setText(C.i18n("wizard.help", new Object[0]));
            this.help.setMnemonic(C.i18n("wizard.help_mnemonic", new Object[0]).charAt(0));
        }
        this.next.setDefaultCapable(true);
        this.prev.setDefaultCapable(true);
        this.help.setVisible(helpAction != null);
        final boolean aqua = "Aqua".equals(UIManager.getLookAndFeel().getID());
        this.buttons = new JPanel(){

            @Override
            public void doLayout() {
                Insets ins = this.getInsets();
                JButton b = aqua ? NavButtonManager.this.finish : NavButtonManager.this.cancel;
                Dimension n = b.getPreferredSize();
                int y = (this.getHeight() - (ins.top + ins.bottom)) / 2 - n.height / 2;
                int gap = 5;
                int x = this.getWidth() - (12 + ins.right + n.width);
                b.setBounds(x, y, n.width, n.height);
                b = aqua ? NavButtonManager.this.next : NavButtonManager.this.finish;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap, y, n.width, n.height);
                b = aqua ? NavButtonManager.this.prev : NavButtonManager.this.next;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap, y, n.width, n.height);
                b = aqua ? NavButtonManager.this.cancel : NavButtonManager.this.prev;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap, y, n.width, n.height);
                b = NavButtonManager.this.help;
                n = b.getPreferredSize();
                b.setBounds(x -= n.width + gap * 2, y, n.width, n.height);
            }
        };
        this.buttons.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("textText")));
        this.buttons.add(this.prev);
        this.buttons.add(this.next);
        this.buttons.add(this.finish);
        this.buttons.add(this.cancel);
        this.buttons.add(this.help);
        this.next.addActionListener(this);
        this.prev.addActionListener(this);
        this.finish.addActionListener(this);
        this.cancel.addActionListener(this);
    }

    void connectListener() {
        NavWizardObserver l = new NavWizardObserver();
        Wizard wizard = this.parent.getWizard();
        l.stepsChanged(wizard);
        l.navigabilityChanged(wizard);
        l.selectionChanged(wizard);
        wizard.addWizardObserver(l);
    }

    private void configureNavigationButtons(Wizard wizard, JButton prev, JButton next, JButton finish) {
        String nextStep = wizard.getNextStep();
        int fwdNavMode = wizard.getForwardNavigationMode();
        WizardDisplayerImpl.checkLegalNavMode(fwdNavMode);
        String problem = wizard.getProblem();
        boolean isDeferredResult = this.deferredStatus != null;
        boolean canContinue = (fwdNavMode & 1) != 0 && !isDeferredResult;
        boolean canFinish = (fwdNavMode & 2) != 0 && !isDeferredResult;
        boolean enableFinish = canFinish && problem == null && !isDeferredResult;
        boolean enableNext = nextStep != null && canContinue && problem == null && !isDeferredResult;
        boolean enablePrevious = wizard.getPreviousStep() != null && !isDeferredResult;
        Runnable runnable = NavButtonManager$$Lambda$1.lambdaFactory$(next, enableNext, prev, enablePrevious, finish, enableFinish);
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        JButton button = (JButton)event.getSource();
        String name = button.getName();
        if (NAME_CANCEL.equals(name)) {
            this.processCancel(event, true);
            return;
        }
        if (this.deferredStatus != null) {
            this.deferredResultFinished(event);
            return;
        }
        if (null != name) {
            String string = name;
            int n = -1;
            switch (string.hashCode()) {
                case 3377907: {
                    if (!string.equals(NAME_NEXT)) break;
                    n = 0;
                    break;
                }
                case 3449395: {
                    if (!string.equals(NAME_PREV)) break;
                    n = 1;
                    break;
                }
                case -1274442605: {
                    if (!string.equals(NAME_FINISH)) break;
                    n = 2;
                    break;
                }
                case 94756344: {
                    if (!string.equals(NAME_CLOSE)) break;
                    n = 3;
                }
            }
            switch (n) {
                case 0: {
                    this.processNext();
                    break;
                }
                case 1: {
                    this.processPrev();
                    break;
                }
                case 2: {
                    this.processFinish(event);
                    break;
                }
                case 3: {
                    this.processClose(event);
                    break;
                }
            }
        }
        this.parent.updateProblem();
    }

    void deferredResultFailed(boolean canGoBack) {
        Runnable runnable = NavButtonManager$$Lambda$2.lambdaFactory$(this, canGoBack);
        if (EventQueue.isDispatchThread()) {
            runnable.run();
        } else {
            EventQueue.invokeLater(runnable);
        }
    }

    void deferredResultFinished(Object o) {
        String name = this.deferredStatus;
        this.deferredStatus = null;
        this.configureNavigationButtons(this.parent.getWizard(), this.prev, this.next, this.finish);
        if (name.startsWith(DEFERRED_FAILED)) {
            JButton button;
            if (o instanceof ActionEvent && NAME_CANCEL.equals(name = (button = (JButton)((ActionEvent)o).getSource()).getName())) {
                this.processCancel(o instanceof ActionEvent ? (ActionEvent)o : null, false);
                return;
            }
            String currentStep = this.parent.getCurrentStep();
            this.parent.navigateTo(currentStep);
            return;
        }
        String string = name;
        int n = -1;
        switch (string.hashCode()) {
            case 3377907: {
                if (!string.equals(NAME_NEXT)) break;
                n = 0;
                break;
            }
            case 3449395: {
                if (!string.equals(NAME_PREV)) break;
                n = 1;
                break;
            }
            case -1367724422: {
                if (!string.equals(NAME_CANCEL)) break;
                n = 2;
                break;
            }
            case -1274442605: {
                if (!string.equals(NAME_FINISH)) break;
                n = 3;
                break;
            }
            case 94756344: {
                if (!string.equals(NAME_CLOSE)) break;
                n = 4;
            }
        }
        switch (n) {
            case 0: {
                this.processNextProceed(o);
                break;
            }
            case 1: {
                this.processPrevProceed(o);
                break;
            }
            case 2: {
                this.processCancel(o instanceof ActionEvent ? (ActionEvent)o : null, false);
                break;
            }
            case 3: {
                this.processFinishProceed(o);
                break;
            }
            case 4: {
                Window dlg = this.getWindow();
                dlg.setVisible(false);
                dlg.dispose();
                break;
            }
        }
        this.parent.updateProblem();
    }

    protected void processNext() {
        String currentStep;
        WizardPanel panel = this.parent.getCurrentWizardPanel();
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        WizardPanelNavResult proceed = WizardPanelNavResult.PROCEED;
        if (panel != null && (proceed = panel.allowNext(currentStep = this.parent.getCurrentStep(), settings, wizard)).isDeferredComputation()) {
            this.deferredStatus = NAME_NEXT;
            this.configureNavigationButtons(wizard, this.prev, this.next, this.finish);
            this.parent.handleDeferredWizardResult(proceed, false);
            return;
        }
        this.processNextProceed(proceed);
    }

    protected void processNextProceed(Object result) {
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (WizardPanelNavResult.REMAIN_ON_PAGE.equals(result)) {
            return;
        }
        String nextId = wizard.getNextStep();
        settings.push(nextId);
        this.parent.navigateTo(nextId);
        this.parent.setInSummary(false);
    }

    protected void processPrev() {
        String currentStep;
        WizardPanel panel = this.parent.getCurrentWizardPanel();
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        WizardPanelNavResult proceed = WizardPanelNavResult.PROCEED;
        if (panel != null && (proceed = panel.allowBack(currentStep = this.parent.getCurrentStep(), settings, wizard)).isDeferredComputation()) {
            this.deferredStatus = NAME_PREV;
            this.parent.handleDeferredWizardResult(proceed, false);
            return;
        }
        this.processPrevProceed(proceed);
    }

    protected void processPrevProceed(Object result) {
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (WizardPanelNavResult.REMAIN_ON_PAGE.equals(result)) {
            return;
        }
        String prevId = wizard.getPreviousStep();
        settings.popAndCalve();
        this.parent.setDeferredResult(null);
        this.parent.navigateTo(prevId);
        this.parent.setInSummary(false);
    }

    protected void processFinish(ActionEvent event) {
        String currentStep;
        WizardPanel panel = this.parent.getCurrentWizardPanel();
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        WizardPanelNavResult proceed = WizardPanelNavResult.PROCEED;
        if (panel != null && (proceed = panel.allowFinish(currentStep = this.parent.getCurrentStep(), settings, wizard)).isDeferredComputation()) {
            this.deferredStatus = NAME_FINISH;
            this.parent.handleDeferredWizardResult(proceed, false);
            return;
        }
        this.processFinishProceed(proceed);
    }

    protected void processFinishProceed(Object result) {
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (WizardPanelNavResult.REMAIN_ON_PAGE.equals(result)) {
            return;
        }
        try {
            Object o = wizard.finish(settings);
            boolean closeWindow = true;
            if (o instanceof DeferredWizardResult) {
                DeferredWizardResult r = (DeferredWizardResult)o;
                this.finish.setEnabled(false);
                this.cancel.setEnabled(r.canAbort());
                this.prev.setEnabled(false);
                this.next.setEnabled(false);
                this.deferredStatus = NAME_CANCEL;
                this.parent.handleDeferredWizardResult(r, true);
                closeWindow = false;
            } else if (o instanceof Summary) {
                this.parent.handleSummary((Summary)o);
                this.parent.setWizardResult(((Summary)o).getResult());
                closeWindow = false;
            } else {
                this.parent.setWizardResult(o);
            }
            if (closeWindow) {
                this.processCancel(null, false);
            }
        }
        catch (WizardException we) {
            if (!this.suppressMessageDialog) {
                JOptionPane.showMessageDialog(this.next, we.getLocalizedMessage());
            }
            String id = we.getStepToReturnTo();
            String curr = settings.currID();
            try {
                while (id != null && !id.equals(curr)) {
                    curr = settings.popAndCalve();
                }
                settings.push(id);
                this.parent.navigateTo(id);
            }
            catch (NoSuchElementException ex) {
                IllegalStateException e = new IllegalStateException("Exception said to return to " + id + " but no such " + "step found", ex);
                throw e;
            }
        }
    }

    protected void processCancel(ActionEvent event, boolean reallyCancel) {
        boolean closeWindow;
        DeferredWizardResult deferredResult = this.parent.getDeferredResult();
        if (deferredResult != null && deferredResult.canAbort()) {
            deferredResult.abort();
        }
        Wizard wizard = this.parent.getWizard();
        MergeMap settings = this.parent.getSettings();
        if (reallyCancel && this.parent.cancel()) {
            wizard.cancel(settings);
            return;
        }
        boolean bl = reallyCancel ? wizard.cancel(settings) : (closeWindow = this.parent.receiver == null);
        if (closeWindow) {
            Window win = event != null ? (Window)((JComponent)event.getSource()).getTopLevelAncestor() : this.getWindow();
            win.setVisible(false);
            win.dispose();
        }
    }

    protected void processClose(ActionEvent event) {
        Window win = (Window)((JComponent)event.getSource()).getTopLevelAncestor();
        win.setVisible(false);
        win.dispose();
    }

    void updateButtons() {
        Wizard wizard = this.parent.getWizard();
        if (!wizard.isBusy()) {
            this.configureNavigationButtons(wizard, this.prev, this.next, this.finish);
        }
    }

    void setSummaryShowingMode() {
        this.next.setEnabled(false);
        this.prev.setEnabled(false);
        this.cancel.setEnabled(true);
        this.finish.setEnabled(false);
        if (this.window != null && this.parent.receiver == null && this.window instanceof JDialog) {
            ((JDialog)this.window).getRootPane().setDefaultButton(this.cancel);
        }
        this.cancel.setText(this.getCloseString());
        this.cancel.setMnemonic(C.i18n("wizard.close_mnemonic", new Object[0]).charAt(0));
        this.cancel.setName(NAME_CLOSE);
        this.deferredStatus = null;
    }

    void setWindow(Window dlg) {
        this.window = dlg;
    }

    public JPanel getButtons() {
        return this.buttons;
    }

    public JButton getCancel() {
        return this.cancel;
    }

    public String getCloseString() {
        return C.i18n("wizard.close", new Object[0]);
    }

    public Window getWindow() {
        return this.window;
    }

    public JButton getFinish() {
        return this.finish;
    }

    public JButton getHelp() {
        return this.help;
    }

    public JButton getNext() {
        return this.next;
    }

    public WizardDisplayerImpl getParent() {
        return this.parent;
    }

    public JButton getPrev() {
        return this.prev;
    }

    public void initializeNavigation() {
        Wizard wizard = this.parent.getWizard();
        this.prev.setEnabled(false);
        this.next.setEnabled(wizard.getNextStep() != null);
        int fwdNavMode = wizard.getForwardNavigationMode();
        WizardDisplayerImpl.checkLegalNavMode(fwdNavMode);
        this.finish.setEnabled((fwdNavMode & 2) != 0);
        this.connectListener();
    }

    private /* synthetic */ void lambda$deferredResultFailed$22(boolean canGoBack) {
        if (!canGoBack) {
            this.getCancel().setText(this.getCloseString());
        }
        this.getPrev().setEnabled(true);
        this.getNext().setEnabled(false);
        this.getCancel().setEnabled(true);
        this.getFinish().setEnabled(false);
        if (!NAME_CLOSE.equals(this.deferredStatus)) {
            this.deferredStatus = DEFERRED_FAILED + this.deferredStatus;
        }
    }

    private static /* synthetic */ void lambda$configureNavigationButtons$21(JButton next, boolean enableNext, JButton prev, boolean enablePrevious, JButton finish, boolean enableFinish) {
        next.setEnabled(enableNext);
        prev.setEnabled(enablePrevious);
        finish.setEnabled(enableFinish);
        JRootPane root = next.getRootPane();
        if (root != null) {
            if (next.isEnabled()) {
                root.setDefaultButton(next);
            } else if (finish.isEnabled()) {
                root.setDefaultButton(finish);
            } else if (prev.isEnabled()) {
                root.setDefaultButton(prev);
            } else {
                root.setDefaultButton(null);
            }
        }
    }

    static /* synthetic */ void access$lambda$0(JButton jButton, boolean bl, JButton jButton2, boolean bl2, JButton jButton3, boolean bl3) {
        NavButtonManager.lambda$configureNavigationButtons$21(jButton, bl, jButton2, bl2, jButton3, bl3);
    }

    static /* synthetic */ void access$lambda$1(NavButtonManager navButtonManager, boolean bl) {
        navButtonManager.lambda$deferredResultFailed$22(bl);
    }

    class NavWizardObserver
    implements WizardObserver {
        boolean wasBusy = false;

        NavWizardObserver() {
        }

        @Override
        public void stepsChanged(Wizard wizard) {
        }

        @Override
        public void navigabilityChanged(Wizard wizard) {
            Runnable runnable = NavButtonManager$NavWizardObserver$$Lambda$1.lambdaFactory$(this, wizard);
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeLater(runnable);
            }
        }

        @Override
        public void selectionChanged(Wizard wizard) {
        }

        private /* synthetic */ void lambda$navigabilityChanged$23(Wizard wizard) {
            if (wizard.isBusy()) {
                NavButtonManager.this.next.setEnabled(false);
                NavButtonManager.this.prev.setEnabled(false);
                NavButtonManager.this.finish.setEnabled(false);
                NavButtonManager.this.cancel.setEnabled(false);
                NavButtonManager.this.parent.getOuterPanel().setCursor(Cursor.getPredefinedCursor(3));
                this.wasBusy = true;
                return;
            }
            if (this.wasBusy) {
                NavButtonManager.this.cancel.setEnabled(true);
                NavButtonManager.this.parent.getOuterPanel().setCursor(Cursor.getPredefinedCursor(0));
            }
            NavButtonManager.this.configureNavigationButtons(wizard, NavButtonManager.this.prev, NavButtonManager.this.next, NavButtonManager.this.finish);
            NavButtonManager.this.parent.updateProblem();
        }

        static /* synthetic */ void access$lambda$0(NavWizardObserver navWizardObserver, Wizard wizard) {
            navWizardObserver.lambda$navigabilityChanged$23(wizard);
        }
    }
}

