/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui.wizard.api.displayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import org.jackhuang.hellominecraft.util.C;
import org.jackhuang.hellominecraft.util.logging.HMCLog;
import org.jackhuang.hellominecraft.util.ui.wizard.api.WizardDisplayer;
import org.jackhuang.hellominecraft.util.ui.wizard.api.WizardResultReceiver;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.InstructionsPanel;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.NavButtonManager;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.NavProgress;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.WizardDisplayerImpl$$Lambda$1;
import org.jackhuang.hellominecraft.util.ui.wizard.api.displayer.WizardDisplayerImpl$4$$Lambda$1;
import org.jackhuang.hellominecraft.util.ui.wizard.modules.InstructionsPanelImpl;
import org.jackhuang.hellominecraft.util.ui.wizard.modules.MergeMap;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.DeferredWizardResult;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.ResultProgressHandle;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.Summary;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.Wizard;
import org.jackhuang.hellominecraft.util.ui.wizard.spi.WizardPanel;

public class WizardDisplayerImpl
extends WizardDisplayer {
    ResultProgressHandle progress = null;
    JLabel ttlLabel = null;
    JPanel ttlPanel = null;
    Wizard wizard = null;
    JPanel outerPanel = null;
    NavButtonManager buttonManager = null;
    InstructionsPanel instructions = null;
    MergeMap settings = null;
    JPanel inner = null;
    JLabel problem = null;
    Object wizardResult = null;
    WizardResultReceiver receiver = null;
    JComponent wizardPanel = null;
    boolean inSummary = false;
    DeferredWizardResult deferredResult = null;
    private static boolean warned;

    protected void buildStepTitle() {
        this.ttlLabel = new JLabel(this.wizard.getStepDescription(this.wizard.getAllSteps()[0]));
        this.ttlLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 12, 5), BorderFactory.createMatteBorder(0, 0, 1, 0, UIManager.getColor("textText"))));
        this.ttlPanel = new JPanel(){

            @Override
            public void doLayout() {
                Dimension d = WizardDisplayerImpl.this.ttlLabel.getPreferredSize();
                if (WizardDisplayerImpl.this.ttlLabel.getComponentOrientation() == ComponentOrientation.RIGHT_TO_LEFT) {
                    WizardDisplayerImpl.this.ttlLabel.setBounds(this.getWidth() - d.width, 0, this.getWidth(), d.height);
                } else {
                    WizardDisplayerImpl.this.ttlLabel.setBounds(0, 0, this.getWidth(), d.height);
                }
            }

            @Override
            public Dimension getPreferredSize() {
                return WizardDisplayerImpl.this.ttlLabel.getPreferredSize();
            }
        };
        this.ttlPanel.add(this.ttlLabel);
        Font f = this.ttlLabel.getFont();
        if (f == null) {
            f = UIManager.getFont("controlFont");
        }
        if (f != null) {
            f = f.deriveFont(1);
            this.ttlLabel.setFont(f);
        }
    }

    private JPanel createOuterPanel(Wizard awizard, Rectangle bounds, Action helpAction, Map initialProperties) {
        this.wizard = awizard;
        this.outerPanel = new JPanel();
        if (this.wizard.getAllSteps().length == 0) {
            throw new IllegalArgumentException("Wizard has no steps");
        }
        this.buildStepTitle();
        this.buttonManager = new NavButtonManager(this);
        this.outerPanel.setLayout(new BorderLayout());
        AbstractAction kbdCancel = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = WizardDisplayerImpl.this.buttonManager.getCancel();
                if (b.isEnabled()) {
                    b.doClick();
                }
            }
        };
        this.outerPanel.getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
        this.outerPanel.getActionMap().put("cancel", kbdCancel);
        this.instructions = this.createInstructionsPanel();
        this.buttonManager.buildButtons(helpAction);
        this.inner = new JPanel();
        this.inner.setLayout(new BorderLayout());
        this.inner.add((Component)this.ttlPanel, "North");
        this.problem = new JLabel("  ");
        Color fg = UIManager.getColor("nb.errorColor");
        this.problem.setForeground(fg == null ? Color.BLUE : fg);
        this.inner.add((Component)this.problem, "South");
        this.problem.setPreferredSize(new Dimension(20, 20));
        this.outerPanel.add((Component)this.instructions.getComponent(), "West");
        this.outerPanel.add((Component)this.buttonManager.getButtons(), "South");
        this.outerPanel.add((Component)this.inner, "Center");
        String first = this.wizard.getAllSteps()[0];
        this.settings = new MergeMap(first);
        if (initialProperties != null) {
            this.settings.putAll(initialProperties);
        }
        this.wizardPanel = this.wizard.navigatingTo(first, this.settings);
        String desc = this.wizard.getLongDescription(first);
        if (desc != null) {
            this.ttlLabel.setText(desc);
        }
        this.inner.add((Component)this.wizardPanel, "Center");
        this.buttonManager.initializeNavigation();
        return this.outerPanel;
    }

    protected InstructionsPanel createInstructionsPanel() {
        return new InstructionsPanelImpl(this.wizard);
    }

    @Override
    public void install(Container c, Object layoutConstraint, Wizard awizard, Action helpAction, Map initialProperties, WizardResultReceiver receiver) {
        JPanel pnl = this.createOuterPanel(awizard, new Rectangle(), helpAction, initialProperties);
        if (layoutConstraint != null) {
            if (c instanceof RootPaneContainer) {
                ((RootPaneContainer)((Object)c)).getContentPane().add((Component)pnl, layoutConstraint);
            } else {
                c.add((Component)pnl, layoutConstraint);
            }
        } else if (c instanceof RootPaneContainer) {
            ((RootPaneContainer)((Object)c)).getContentPane().add(pnl);
        } else {
            c.add(pnl);
        }
        this.receiver = receiver;
    }

    @Override
    public Object show(Wizard awizard, Rectangle bounds, Action helpAction, Map initialProperties) {
        if (!EventQueue.isDispatchThread() && !warned) {
            HMCLog.warn("WizardDisplayerImpl: show() should be called from the AWT Event Thread. This call may deadlock - c.f. http://java.net/jira/browse/WIZARD-33", new Throwable());
            warned = true;
        }
        this.createOuterPanel(awizard, bounds, helpAction, initialProperties);
        Object result = this.showInDialog(bounds);
        return result;
    }

    protected JDialog createDialog() {
        Window o = this.findLikelyOwnerWindow();
        JDialog dlg = o instanceof Frame ? new JDialog((Frame)o) : (o instanceof Dialog ? new JDialog((Dialog)o) : new JDialog());
        return dlg;
    }

    protected Object showInDialog(Rectangle bounds) {
        JDialog dlg = this.createDialog();
        this.buttonManager.setWindow(dlg);
        dlg.setTitle(this.wizard.getTitle());
        dlg.getContentPane().setLayout(new BorderLayout());
        dlg.getContentPane().add((Component)this.outerPanel, "Center");
        if (bounds != null) {
            dlg.setBounds(bounds);
        } else {
            dlg.pack();
        }
        dlg.setDefaultCloseOperation(0);
        dlg.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosing(WindowEvent e) {
                if (!(e.getWindow() instanceof JDialog)) {
                    return;
                }
                JDialog dlg = (JDialog)e.getWindow();
                boolean dontClose = false;
                if (!WizardDisplayerImpl.this.wizard.isBusy()) {
                    DeferredWizardResult defResult;
                    WizardDisplayerImpl wizardDisplayerImpl = WizardDisplayerImpl.this;
                    synchronized (wizardDisplayerImpl) {
                        defResult = WizardDisplayerImpl.this.deferredResult;
                    }
                    try {
                        if (defResult != null && defResult.canAbort()) {
                            defResult.abort();
                        } else if (defResult != null && !defResult.canAbort()) {
                            dontClose = true;
                        }
                    }
                    finally {
                        if (!dontClose && WizardDisplayerImpl.this.wizard.cancel(WizardDisplayerImpl.this.settings)) {
                            dlg.setVisible(false);
                            dlg.dispose();
                        }
                    }
                }
            }
        });
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        if (bounds == null) {
            int x = (d.width - dlg.getWidth()) / 2;
            int y = (d.height - dlg.getHeight()) / 2;
            dlg.setLocation(x, y);
        }
        dlg.setModal(true);
        dlg.getRootPane().setDefaultButton(this.buttonManager.getNext());
        dlg.setVisible(true);
        return this.wizardResult;
    }

    private Window findLikelyOwnerWindow() {
        return KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
    }

    public WizardPanel getCurrentWizardPanel() {
        JComponent comp = this.wizardPanel;
        if (comp instanceof WizardPanel) {
            return (WizardPanel)((Object)comp);
        }
        return null;
    }

    public String getCurrentStep() {
        return this.settings.currID();
    }

    static void checkLegalNavMode(int i) {
        switch (i) {
            case 1: 
            case 2: 
            case 3: {
                return;
            }
        }
        throw new IllegalArgumentException("Illegal forward navigation mode: " + i);
    }

    public void setCurrentWizardPanel(JComponent comp) {
        this.inner.add((Component)comp, "Center");
        this.inner.remove(this.wizardPanel);
        this.wizardPanel = comp;
        this.inner.invalidate();
        this.inner.revalidate();
        this.inner.repaint();
        comp.requestFocus();
        if (!this.inSummary) {
            this.buttonManager.updateButtons();
        }
    }

    void handleSummary(Summary summary) {
        this.inSummary = true;
        this.instructions.setInSummaryPage(true);
        JComponent summaryComp = (JComponent)summary.getSummaryComponent();
        if (summaryComp.getBorder() != null) {
            CompoundBorder b = new CompoundBorder(new EmptyBorder(5, 5, 5, 5), summaryComp.getBorder());
            summaryComp.setBorder(b);
        }
        this.setCurrentWizardPanel(summaryComp);
        this.ttlLabel.setText(C.i18n("wizard.summary", new Object[0]));
        this.getButtonManager().setSummaryShowingMode();
        summaryComp.requestFocus();
    }

    protected ResultProgressHandle createProgressDisplay() {
        return new NavProgress(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDeferredWizardResult(final DeferredWizardResult r, boolean inSummary) {
        WizardDisplayerImpl wizardDisplayerImpl = this;
        synchronized (wizardDisplayerImpl) {
            this.deferredResult = r;
        }
        this.wizardPanel.setEnabled(false);
        this.progress = this.createProgressDisplay();
        Container inst = this.instructions.getComponent();
        this.progress.addProgressComponents(inst);
        inst.invalidate();
        if (inst instanceof JComponent) {
            ((JComponent)inst).revalidate();
        }
        inst.repaint();
        Runnable run = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                if (!EventQueue.isDispatchThread()) {
                    try {
                        EventQueue.invokeLater(WizardDisplayerImpl$4$$Lambda$1.lambdaFactory$(this));
                        r.start(WizardDisplayerImpl.this.settings, WizardDisplayerImpl.this.progress);
                        if (!WizardDisplayerImpl.this.progress.isRunning()) return;
                        WizardDisplayerImpl.this.progress.failed("Start method did not inidicate failure or finished in " + r, false);
                        return;
                    }
                    finally {
                        try {
                            EventQueue.invokeAndWait(this);
                        }
                        catch (InterruptedException | InvocationTargetException ex) {
                            HMCLog.err("Failed to invoke and wait", ex);
                            return;
                        }
                        finally {
                            WizardDisplayerImpl.this.buttonManager.getWindow().setCursor(Cursor.getDefaultCursor());
                        }
                    }
                }
                WizardDisplayerImpl ex = WizardDisplayerImpl.this;
                synchronized (ex) {
                    WizardDisplayerImpl.this.deferredResult = null;
                }
                WizardDisplayerImpl.this.buttonManager.getCancel().setEnabled(true);
                Container inst = WizardDisplayerImpl.this.instructions.getComponent();
                inst.removeAll();
                inst.invalidate();
                if (inst instanceof JComponent) {
                    ((JComponent)((Object)WizardDisplayerImpl.this.instructions)).revalidate();
                }
                inst.repaint();
            }

            private /* synthetic */ void lambda$run$24() {
                WizardDisplayerImpl.this.buttonManager.getWindow().setCursor(Cursor.getPredefinedCursor(3));
            }

            static /* synthetic */ void access$lambda$0(4 var0) {
                var0.lambda$run$24();
            }
        };
        Thread runner = new Thread(run, "Wizard Background Result Thread " + r);
        runner.setDaemon(true);
        runner.start();
    }

    public void navigateTo(String id) {
        JComponent comp = this.wizard.navigatingTo(id, this.getSettings());
        String description = this.wizard.getLongDescription(id);
        if (description == null) {
            description = this.wizard.getStepDescription(id);
        }
        this.getTtlLabel().setText(description);
        this.setCurrentWizardPanel(comp);
    }

    public NavButtonManager getButtonManager() {
        return this.buttonManager;
    }

    public synchronized DeferredWizardResult getDeferredResult() {
        return this.deferredResult;
    }

    public InstructionsPanel getInstructions() {
        return this.instructions;
    }

    public boolean isInSummary() {
        return this.inSummary;
    }

    public void setInSummary(boolean state) {
        this.inSummary = state;
        Runnable r = WizardDisplayerImpl$$Lambda$1.lambdaFactory$(this, state);
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            EventQueue.invokeLater(r);
        }
    }

    public JPanel getOuterPanel() {
        return this.outerPanel;
    }

    public MergeMap getSettings() {
        return this.settings;
    }

    public JLabel getTtlLabel() {
        return this.ttlLabel;
    }

    public JPanel getTtlPanel() {
        return this.ttlPanel;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public JComponent getWizardPanel() {
        return this.wizardPanel;
    }

    public Object getWizardResult() {
        return this.wizardResult;
    }

    public void setWizardResult(Object wizardResult) {
        this.wizardResult = wizardResult;
        if (this.receiver != null) {
            this.receiver.finished(wizardResult);
        }
    }

    public synchronized void setDeferredResult(DeferredWizardResult deferredResult) {
        this.deferredResult = deferredResult;
    }

    boolean cancel() {
        boolean result;
        boolean bl = result = this.receiver != null;
        if (result) {
            this.receiver.cancelled(this.settings);
        }
        return result;
    }

    void updateProblem() {
        String prob = this.wizard.getProblem();
        this.problem.setText(prob == null ? " " : prob);
        if (prob != null && prob.trim().length() == 0) {
            prob = null;
        }
        Border b = prob == null ? BorderFactory.createEmptyBorder(1, 0, 0, 0) : BorderFactory.createMatteBorder(1, 0, 0, 0, this.problem.getForeground());
        CompoundBorder b1 = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 12, 0, 12), b);
        this.problem.setBorder(b1);
    }

    private /* synthetic */ void lambda$setInSummary$25(boolean state) {
        this.instructions.setInSummaryPage(state);
    }

    static /* synthetic */ void access$lambda$0(WizardDisplayerImpl wizardDisplayerImpl, boolean bl) {
        wizardDisplayerImpl.lambda$setInSummary$25(bl);
    }
}

