/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hellominecraft.util.ui.wizard.spi;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Summary {
    private final Component comp;
    private Object result;

    public Summary(String text, Object result) {
        if (text == null) {
            throw new NullPointerException("Text is null");
        }
        if (text.trim().length() == 0) {
            throw new IllegalArgumentException("Text is empty or all whitespace");
        }
        this.result = result;
        JTextArea jta = new JTextArea();
        jta.setText(text);
        jta.setWrapStyleWord(true);
        jta.setLineWrap(true);
        jta.getCaret().setBlinkRate(0);
        jta.setEditable(false);
        jta.getCaret().setVisible(true);
        Font f = UIManager.getFont("Label.font");
        if (f != null) {
            jta.setFont(f);
        }
        this.comp = new JScrollPane(jta);
    }

    public Summary(String[] items, Object result) {
        if (items == null) {
            throw new NullPointerException("Items array null");
        }
        if (items.length == 0) {
            throw new IllegalArgumentException("Items array empty");
        }
        this.result = result;
        JList<String> list = new JList<String>(items);
        this.comp = new JScrollPane(list);
    }

    public Summary(Component comp, Object result) {
        this.result = result;
        this.comp = comp;
        if (comp == null) {
            throw new NullPointerException("Null component");
        }
    }

    public Component getSummaryComponent() {
        return this.comp;
    }

    public Object getResult() {
        return this.result;
    }
}

