#!/usr/bin/env python3

# Code built to use streamdeck to interface with Kubifaktorium. (experimental)
#
# Using example code from Python Stream Deck Library Released under the MIT license
#   dean [at] fourwalledcubicle [dot] com
#         www.fourwalledcubicle.com


import os
import threading
import random
import time
from PIL import Image, ImageDraw, ImageFont
from StreamDeck.DeviceManager import DeviceManager
from StreamDeck.ImageHelpers import PILHelper

global lines

commandfile = "/home/mseithe/.config/unity3d/MirkoStudio/Kubifaktorium/streamdeck.info.in"

datafile = "/home/mseithe/.config/unity3d/MirkoStudio/Kubifaktorium/streamdeck.info.out"

icondirectory = "/home/mseithe/.config/unity3d/MirkoStudio/Kubifaktorium/IconCache/"

# Generates a custom tile with run-time generated text and custom image via the
# PIL module.
def render_key_image(deck, icon_filename, font_filename, label_text):
    # Create new key image of the correct dimensions, black background
    image = PILHelper.create_image(deck)
    draw = ImageDraw.Draw(image)

    # Add image overlay, rescaling the image asset if it is too large to fit
    # the requested dimensions via a high quality Lanczos scaling algorithm
    if icon_filename != "":
        icon = Image.open(icon_filename).convert("RGBA")
        icon.thumbnail((image.width, image.height - 20), Image.LANCZOS)
        icon_pos = ((image.width - icon.width) // 2, 0)
        image.paste(icon, icon_pos, icon)

    # Load a custom TrueType font and use it to overlay the key index, draw key
    # label onto the image
    font = ImageFont.truetype(font_filename, 14)
    label_w, label_h = draw.textsize(label_text, font=font)
    label_pos = ((image.width - label_w) // 2, image.height - 20)
    draw.text(label_pos, text=label_text, font=font, fill="white")

    return PILHelper.to_native_format(deck, image)


# Returns styling information for a key based on its position and state.
def get_key_style(deck, key, state, lines):
    # Last button in the example application is the exit button
    exit_key_index = deck.key_count() - 1


    if key < len(lines):
        line = lines[key].strip()
        name = line
        icon = line
        font = "Roboto-Regular.ttf"
        label = "" #line.split(',')[2]+" / "+line.split(',')[3]
    else:
        name = "emoji"
        icon = ""
        font = "Roboto-Regular.ttf"
        label = ""

    
    filename = os.path.join(icondirectory, icon+"_0.png")
 
    return {
        "name": name,
        "icon": filename if icon != "" else "",
        #"icon": os.path.join(os.path.dirname(__file__), "Assets", icon),
        "font": os.path.join(os.path.dirname(__file__), "Assets", font),
        "label": label
    }


# Creates a new key image based on the key index, style and current key state
# and updates the image on the StreamDeck.
def update_key_image(deck, key, state, lines):
    # Determine what icon and label to use on the generated key
    key_style = get_key_style(deck, key, state, lines)

    # Generate the custom key with the requested image and label
    image = render_key_image(deck, key_style["icon"], key_style["font"], key_style["label"])

    # Update requested key with the generated image
    deck.set_key_image(key, image)


# Prints key state change information, updates rhe key image and performs any
# associated actions when a key is pressed.
def key_change_callback(deck, key, state):
    # Print new key state
    print("Deck {} Key {} = {}".format(deck.id(), key, state), flush=True)

    # Update the key image based on the new key state
    update_key_image(deck, key, state, lines)


    # Check if the key is changing to the pressed state
    if state:
        key_style = get_key_style(deck, key, state, lines)

        if key < len(lines):
            file = open(commandfile,"w") 
            file.write(lines[key].strip()) 
            file.close() 

        # When an exit button is pressed, close the application
        if key_style["name"] == "exit":
            # Reset deck, clearing all button images
            deck.reset()

            # Close deck handle, terminating internal worker threads
            deck.close()


def read_data_file():
    return [f for f in open(datafile, "r")]

if __name__ == "__main__":
    streamdecks = DeviceManager().enumerate()

    print("Found {} Stream Deck(s).\n".format(len(streamdecks)))

    for index, deck in enumerate(streamdecks):
        deck.open()
        deck.reset()

        deck.set_brightness(75)

        # Set initial key images

        # Register callback function for when a key state changes
        deck.set_key_callback(key_change_callback)

        while True:
            lines = read_data_file()
            for key in range(deck.key_count()):
                update_key_image(deck, key, False, lines)
            time.sleep(1)


            
#"Bonfire,OutpostBonfire,ZeppelinStation,Depot5x5,Inserter
#Torch,House,Barn,Table,StatueSettler
#Well,Bakery,BasicWorkplace,Kiln,OilPump
