
// SamplePg_VC++Dlg.cpp : implementation file
//

#include "stdafx.h"
#include "SamplePg_VC++.h"
#include "SamplePg_VC++Dlg.h"


// Link bixolon library
#include ".\\Inc\\BXLPDcApi.h"

#ifdef TARGET_64BIT
#pragma comment(lib, ".\\Lib\\BXLPDC_x64.lib")
#else
#pragma comment(lib, ".\\Lib\\BXLPDC.lib")
#endif



//	Cash Draw Speed
#define	 SPEED_50MS				0
#define	 SPEED_100MS			1
#define	 SPEED_150MS			2
#define	 SPEED_200MS			3
#define	 SPEED_250MS			4

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CSamplePg_VCDlg dialog


CSamplePg_VCDlg::CSamplePg_VCDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSamplePg_VCDlg::IDD, pParent)
	, m_strPrinterName(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSamplePg_VCDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_COMBO_DEVICEFONT, m_cmbDeviceFont);
	DDX_Text(pDX, IDC_EDIT_PRINTERNAME, m_strPrinterName);
	DDX_Control(pDX, IDC_COMBO_CASHDRAWER_SPEED, m_cmbCashdrawer_Speed);
}

BEGIN_MESSAGE_MAP(CSamplePg_VCDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_CONNECT, &CSamplePg_VCDlg::OnBnClickedConnect)
	ON_BN_CLICKED(IDC_DISCONNECT, &CSamplePg_VCDlg::OnBnClickedDisconnect)
	ON_BN_CLICKED(IDC_PRINT_DEVICEFONT, &CSamplePg_VCDlg::OnBnClickedPrintDevicefont)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_PARTIALCUT, &CSamplePg_VCDlg::OnBnClickedPartialcut)
	ON_BN_CLICKED(IDC_PARTIALCUT_NOFEED, &CSamplePg_VCDlg::OnBnClickedPartialcutNofeed)
	ON_BN_CLICKED(IDC_PRINT_RECEIPT, &CSamplePg_VCDlg::OnBnClickedPrintReceipt)
	ON_BN_CLICKED(IDCANCEL, &CSamplePg_VCDlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDC_CASHDRAWER_OPEN, &CSamplePg_VCDlg::OnBnClickedCashdrawerOpen)
END_MESSAGE_MAP()


// CSamplePg_VCDlg message handlers

BOOL CSamplePg_VCDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	// FontA
	m_cmbDeviceFont.AddString("FontA1x1");	
	m_cmbDeviceFont.AddString("FontA1x1[255]");	
	m_cmbDeviceFont.AddString("FontA1x1[Ext.]");	
	m_cmbDeviceFont.AddString("FontA1x2");	
	m_cmbDeviceFont.AddString("FontA1x2[255]");	
	m_cmbDeviceFont.AddString("FontA1x2[Ext.]");	
	m_cmbDeviceFont.AddString("FontA2x1");	
	m_cmbDeviceFont.AddString("FontA2x1[255]");	
	m_cmbDeviceFont.AddString("FontA2x1[Ext.]");		
	m_cmbDeviceFont.AddString("FontA2x2");	
	m_cmbDeviceFont.AddString("FontA2x2[255]");	
	m_cmbDeviceFont.AddString("FontA2x2[Ext.]");		

	// FontB
	m_cmbDeviceFont.AddString("FontB1x1");	
	m_cmbDeviceFont.AddString("FontB1x1[255]");	
	m_cmbDeviceFont.AddString("FontB1x1[Ext.]");	
	m_cmbDeviceFont.AddString("FontB1x2");	
	m_cmbDeviceFont.AddString("FontB1x2[255]");	
	m_cmbDeviceFont.AddString("FontB1x2[Ext.]");	
	m_cmbDeviceFont.AddString("FontB2x1");	
	m_cmbDeviceFont.AddString("FontB2x1[255]");	
	m_cmbDeviceFont.AddString("FontB2x1[Ext.]");		
	m_cmbDeviceFont.AddString("FontB2x2");	
	m_cmbDeviceFont.AddString("FontB2x2[255]");	
	m_cmbDeviceFont.AddString("FontB2x2[Ext.]");

	// FontC
	/*
	m_cmbDeviceFont.AddString("FontC1x1");	
	m_cmbDeviceFont.AddString("FontC1x1[255]");	
	m_cmbDeviceFont.AddString("FontC1x1[Ext.]");	
	m_cmbDeviceFont.AddString("FontC1x2");	
	m_cmbDeviceFont.AddString("FontC1x2[255]");	
	m_cmbDeviceFont.AddString("FontC1x2[Ext.]");	
	m_cmbDeviceFont.AddString("FontC2x1");	
	m_cmbDeviceFont.AddString("FontC2x1[255]");	
	m_cmbDeviceFont.AddString("FontC2x1[Ext.]");		
	m_cmbDeviceFont.AddString("FontC2x2");	
	m_cmbDeviceFont.AddString("FontC2x2[255]");	
	m_cmbDeviceFont.AddString("FontC2x2[Ext.]");
	*/

	m_cmbDeviceFont.SetCurSel(0);

	//	Initialize Cash Draw Speed
	m_cmbCashdrawer_Speed.AddString("50ms");
	m_cmbCashdrawer_Speed.AddString("100ms");
	m_cmbCashdrawer_Speed.AddString("150ms");
	m_cmbCashdrawer_Speed.AddString("200ms");
	m_cmbCashdrawer_Speed.AddString("250ms");

	m_cmbCashdrawer_Speed.SetCurSel(0);

	//	Initialize Cash Draw Number
	((CButton*)GetDlgItem(IDC_RADIO_CASHDRAWER_1))->SetCheck(TRUE);

	// Initialize Printer Name
	m_strPrinterName = "BIXOLON SRP-270";

	UpdateData(FALSE);

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSamplePg_VCDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSamplePg_VCDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CSamplePg_VCDlg::EnableCtrls(BOOL bConnect)
{
	GetDlgItem(IDC_CONNECT)->EnableWindow(!bConnect);
	GetDlgItem(IDC_EDIT_PRINTERNAME)->EnableWindow(!bConnect);

	GetDlgItem(IDC_DISCONNECT)->EnableWindow(bConnect);

	m_cmbDeviceFont.EnableWindow(bConnect);
	GetDlgItem(IDC_PRINT_DEVICEFONT)->EnableWindow(bConnect);

	m_cmbCashdrawer_Speed.EnableWindow(bConnect);
	GetDlgItem(IDC_RADIO_CASHDRAWER_1)->EnableWindow(bConnect);
	GetDlgItem(IDC_RADIO_CASHDRAWER_2)->EnableWindow(bConnect);
	GetDlgItem(IDC_CASHDRAWER_OPEN)->EnableWindow(bConnect);

	GetDlgItem(IDC_PARTIALCUT)->EnableWindow(bConnect);
	GetDlgItem(IDC_PARTIALCUT_NOFEED)->EnableWindow(bConnect);
	GetDlgItem(IDC_PRINT_RECEIPT)->EnableWindow(bConnect);

	UpdateData(FALSE);
}

void CSamplePg_VCDlg::OnBnClickedConnect()
{
	UpdateData(TRUE);
	
	if( ConnectPrinter(m_strPrinterName) == FALSE ) return;

	EnableCtrls(TRUE);
}

void CSamplePg_VCDlg::OnBnClickedDisconnect()
{
	DisconnectPrinter();

	EnableCtrls(FALSE);
}

void CSamplePg_VCDlg::OnBnClickedPrintDevicefont()
{
	CHAR	szFontName[32]	= {NULL, }; 
	CString	strBuffer		= _T("");
	INT		nFontSize		= 0;
	INT		nPositionY		= 0;

	UpdateData(TRUE);

	// Start Document
	if( Start_Doc("Print Device Font") == FALSE ) 
		return;
	// Start Page
	Start_Page();

	//	Get selected font device name
	m_cmbDeviceFont.GetLBText(m_cmbDeviceFont.GetCurSel(), szFontName);

	//	Load Font
	nFontSize = 10;
	if(strstr(szFontName,"x2"))
	{
		if(strstr(szFontName,"FontA"))
			nFontSize = 19;
		else
			nFontSize = 9;
	}

	nPositionY += PrintDeviceFont(0, nPositionY, szFontName, nFontSize, "*****-----");

	strBuffer.Format("FontName: %s", szFontName);
	nPositionY += PrintDeviceFont(0, nPositionY, szFontName, nFontSize, strBuffer);
	strBuffer.Format("Device Font Test");
	nPositionY += PrintDeviceFont(0, nPositionY, szFontName, nFontSize, strBuffer);

	nPositionY += PrintDeviceFont(0, nPositionY, szFontName, nFontSize, "-----*****");

	End_Page();	// End Page
	End_Doc();	// End Document
}

void CSamplePg_VCDlg::OnDestroy()
{
	CDialog::OnDestroy();

	DisconnectPrinter();
}

void CSamplePg_VCDlg::OnBnClickedPartialcut()
{
	int			nPositionX	= 0;	
	int			nPositionY	= 0;
	int			nTextHeight	= 0;
	CString		strBuffer	= _T("");

	UpdateData(TRUE);

	// Start Document
	if( Start_Doc("Partial Cut") == FALSE ) 
		return;
	// Start Page
	Start_Page();

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontControl", 0, "P");


	End_Page();	// End Page
	End_Doc();	// End Document
}

void CSamplePg_VCDlg::OnBnClickedPartialcutNofeed()
{
	int			nPositionX	= 0;	
	int			nPositionY	= 0;
	int			nTextHeight	= 0;
	CString		strBuffer	= _T("");

	UpdateData(TRUE);

	// Start Document
	if( Start_Doc("Partial Cut without Feeding") == FALSE ) 
		return;
	// Start Page
	Start_Page();

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontControl", 0, "g");


	End_Page();	// End Page
	End_Doc();	// End Document
}

void CSamplePg_VCDlg::OnBnClickedPrintReceipt()
{
	int			nPositionX	= 0;	
	int			nPositionY	= 0;
	int			nTextHeight	= 0;
	CString		strBuffer	= _T("");

	UpdateData(TRUE);

	// Start Document
	if( Start_Doc("Print Receipt") == FALSE ) 
		return;
	// Start Page
	Start_Page();

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontControl", 0, "x");		// ALIGNS TEXT TO THE CENTER

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA2x2", 0, "* BIXOLON CAFE *");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Bundang-gu, Seongam-si");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Sampyeong-dong, 685");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Tel) 858-519-3698 Fax) 3852");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontControl", 0, "w");	// ALIGNS TEXT TO THE LEFT

	nPositionY += nTextHeight*2;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "------------------------------");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "ORANGE                  $3,500");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "BUFALO WING             $3,000");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "POTATO                  $1,200");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "------------------------------");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Total                   $7,700");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Tax 6%                    $470");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Member Discount           $900");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Money received         $10,000");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Change                  $2,730");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "------------------------------");

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontControl", 0, "x");	// ALIGNS TEXT TO THE CENTER

	nPositionX  = 25;
	nPositionY += nTextHeight/2;
	//nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Member Number : 452331949");
	nTextHeight = PrintTrueFont(nPositionX, nPositionY, "Arial", 10, "Member Number : 452331949", FALSE, 0, TRUE);

	nPositionY += nTextHeight;
	//nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "HAVE A NICE DAY!");
	nTextHeight = PrintTrueFont(nPositionX, nPositionY, "Arial", 10, "HAVE A NICE DAY!", FALSE, 0, TRUE);

	nPositionY += nTextHeight;
	//nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Sale Date: 07/01/03");
	nTextHeight = PrintTrueFont(nPositionX, nPositionY, "Arial", 10, "Sale Date: 07/01/03", FALSE, 0, TRUE);

	nPositionY += nTextHeight;
	//nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontA1x1", 0, "Time: 12:30:45");
	nTextHeight = PrintTrueFont(nPositionX, nPositionY, "Arial", 10, "Time: 12:30:45", FALSE, 0, TRUE);

	End_Page();	// End Page
	End_Doc();	// End Document
}

void CSamplePg_VCDlg::OnBnClickedCashdrawerOpen()
{
	int			nPositionX	= 0;	
	int			nPositionY	= 0;
	int			nTextHeight	= 0;
	CString		strBuffer	= _T("");

	UpdateData(TRUE);

	// Start Document
	if( Start_Doc("Open Cash Draw") == FALSE ) 
		return;
	// Start Page
	Start_Page();

	switch(m_cmbCashdrawer_Speed.GetCurSel()) 
	{
	case SPEED_50MS:
		strBuffer.Format("a");
		break;
	case SPEED_100MS:
		strBuffer.Format("b");	
		break;
	case SPEED_150MS:
		strBuffer.Format("c");
		break;
	case SPEED_200MS:
		strBuffer.Format("d");
		break;
	case SPEED_250MS:
		strBuffer.Format("e");
		break;
	}

	// Cash Drawer 1
	if( ((CButton*)GetDlgItem(IDC_RADIO_CASHDRAWER_1))->GetCheck() )
	{
		strBuffer.MakeUpper();
	}
	// Cash Drawer 2
	else if( ((CButton*)GetDlgItem(IDC_RADIO_CASHDRAWER_2))->GetCheck() )
	{
		strBuffer.MakeLower();
	}

	nPositionY += nTextHeight;
	nTextHeight = PrintDeviceFont(nPositionX, nPositionY, "FontControl", 0, strBuffer);


	End_Page();	// End Page
	End_Doc();	// End Document
}

void CSamplePg_VCDlg::OnBnClickedCancel()
{
	OnCancel();
}
