# /stachybotrys

A dark theme and matching iconset for [AlephNote](https://mikescher.github.io/AlephNote/), an extensible, lightweight desktop note client for multiple backends. Part of the bundled AlephNote themes. For usage notes and additional theme options, see the [AlephNote manual](https://github.com/Mikescher/AlephNote/wiki/Themeing).


## Approach

Built for the wonderfully customizable AlephNote, this theme and the following suggested configuration is focused towards a keyboard-first approach, continuing the tradition of the opinionated [Notational Velocity](http://notational.net/) application.


## Screenshot configuration

To achieve the color blending between the titlebar and the app as in the following screenshots, set the Windows 10 accent color to the darkest gray possible (#3C3C3F), via `Personalisation → Colors → Custom color`.

### View → General

- [x] Hide tag search button
- [x] Use vertical layout
- [x] Auto hide menubar (Press <kbd>Alt</kbd> to toggle visibility)

### Theme → Modifiers

- [x] Hide scrollbars

### Text Editor

- Highlighting →
	+ Hyperlinks: Clickable (single click)
	+ Markdown: Always
	+ Todo lists: Always


## Suggested Fonts

- Advanced → UI Font: Inter BETA＊
- Text Editor →
	+ Note: Anonymous Pro, 9pt
	+ List: Inter BETA, 10pt
	+ Title: Inter BETA, 11pt

＊ Windows 10 hinting seems improved over plain Inter.

The font in the following screenshots is *Redacted-Script*.


## Screenshots

![Screenshot of Alephnote with the Stachybotrys theme](./screenshots/stachybotrys_screenshot_01.png)

Vertical layout

![Screenshot of Alephnote with the Stachybotrys theme](./screenshots/stachybotrys_screenshot_02.png)

Horizontal layout (default)


## Etymology

[Stachybotrys (Wikipedia)](https://en.wikipedia.org/wiki/Stachybotrys): “The name comes from the Greek words *στάχυς* [stakhus] (ear of grain, stalk, stick; metaphorically, progeny) and *βότρυς* [botrus] (cluster or bunch as in grapes, trusses). Stachybotrys, also known as black mold or toxic black mold, is a variety of microfungus.”

---

© 2019-2020 [Heracles Papatheodorou](http://heracl.es) a.k.a [@Arty2](https://www.twitter.com/Arty2), [MIT Licence](LICENCE.txt)