-- The name field should be aligned with the 3D object it references

-- Deteremine what the default initial is ("D", or "C")
DorC = "C"
if (fox.app.GetAppName() == "Dogz") then
    DorC = "D"
end

function RemoveAllPetAccessories()
    SetPetAccessory('collar', '')
    SetPetAccessory('hat', '')
    for i = 1, 4, 1 do
        SetPetAccessory('bootie'..i, '')
    end
    SetPetAccessory('tailpom', '')
end

inventory = {
    Food = {
        BookOfTricks = { filename = "But_x"..DorC.."bookoftricks_01T.tga", order = 0, command = function() DoBookOfTricks('COMMON/BookOfTricksBasic.ini') PetAI.DoHelpDialog(73) end },
        BookOfTricksAdvanced = { filename = "But_x"..DorC.."bookoftricks_02T.tga", order = 1, command = function() DoBookOfTricks('COMMON/BookOfTricksAdvanced.ini') PetAI.DoHelpDialog(73) end },
        BookOfTricksExpert = { filename = "But_x"..DorC.."bookoftricks_03T.tga", order = 2, command = function() DoBookOfTricks('COMMON/BookOfTricksExpert.ini') PetAI.DoHelpDialog(73) end },
        BookOfTricksSecret = { filename = "But_x"..DorC.."bookoftricks_04T.tga", order = 3, command = function() DoBookOfTricks('COMMON/BookOfTricksSecret.ini') PetAI.DoHelpDialog(73) end },

        treats_03 = { filename = "But_xCDtreats_03T.tga", order = 10, command = function() OneLessTreat('treats_03') CreateAndGrabToy('Objects/obj_treat.lua') ToggleInventory() end, },
        treats_01 = { filename = "But_xCDtreats_01T.tga", order = 11, command = function() OneLessTreat('treats_01') CreateAndGrabToy('Objects/obj_treat.lua') ToggleInventory() end, },
        treats_02 = { filename = "But_xCDtreats_02T.tga", order = 12, command = function() OneLessTreat('treats_02') CreateAndGrabToy('Objects/obj_treat.lua') ToggleInventory() end, },

        foodcan_01 = { filename = "But_x"..DorC.."foodcan_01T.tga", order = 20, command = function() PetAI.tThinkFunc.FeedPet('foodcan_01','tFoodCanLuxury') ToggleInventory() end, },
        foodcan_02 = { filename = "But_x"..DorC.."foodcan_02T.tga", order = 21, command = function() PetAI.tThinkFunc.FeedPet('foodcan_02','tFoodCanOrganic') ToggleInventory() end, },
        foodcan_03 = { filename = "But_x"..DorC.."foodcan_03T.tga", order = 22, command = function() PetAI.tThinkFunc.FeedPet('foodcan_03','tFoodCanBrandName') ToggleInventory() end, },
        foodcan_04 = { filename = "But_x"..DorC.."foodcan_04T.tga", order = 23, command = function() PetAI.tThinkFunc.FeedPet('foodcan_04','tFoodCanGeneric') ToggleInventory() end, },

        foodbag_01 = { filename = "But_x"..DorC.."foodbag_01T.tga", order = 30, command = function() PetAI.tThinkFunc.FeedPet('foodbag_01','tFoodBagLuxury') ToggleInventory() end, },
        foodbag_02 = { filename = "But_x"..DorC.."foodbag_02T.tga", order = 31, command = function() PetAI.tThinkFunc.FeedPet('foodbag_02','tFoodBagOrganic') ToggleInventory() end, },
        foodbag_03 = { filename = "But_x"..DorC.."foodbag_03T.tga", order = 32, command = function() PetAI.tThinkFunc.FeedPet('foodbag_03','tFoodBagBrandName') ToggleInventory() end, },
        foodbag_04 = { filename = "But_x"..DorC.."foodbag_04T.tga", order = 33, command = function() PetAI.tThinkFunc.FeedPet('foodbag_04','tFoodBagGeneric') ToggleInventory() end, },

        waterbottle_01 = { filename = "But_xCDwaterbottle_01T.tga", order = 40, command = function() PetAI.tThinkFunc.WaterPet('waterbottle_01','tWaterBottleGeneric') ToggleInventory() end, },
        waterbottle_02 = { filename = "But_xCDwaterbottle_02T.tga", order = 41, command = function() PetAI.tThinkFunc.WaterPet('waterbottle_02','tWaterBottleLuxury') ToggleInventory() end, },
        waterbottle_03 = { filename = "But_xCDwaterbottle_03T.tga", order = 42, command = function() PetAI.tThinkFunc.WaterPet('waterbottle_03','tWaterBottlePremium') ToggleInventory() end, },
        waterbottle_04 = { filename = "But_xCDwaterbottle_04T.tga", order = 43, command = function() PetAI.tThinkFunc.WaterPet('waterbottle_04','tWaterBottleBrandName') ToggleInventory() end, },

        shampoo_01 = { filename = "But_xCDshampoo_01T.tga", order = 50, command = function() PetAI.tThinkFunc.ShampooPet('shampoo_01','tShampooLuxury') ToggleInventory() end, },
        shampoo_02 = { filename = "But_xCDshampoo_02T.tga", order = 51, command = function() PetAI.tThinkFunc.ShampooPet('shampoo_02','tShampooOrganic') ToggleInventory() end, },
        shampoo_03 = { filename = "But_xCDshampoo_03T.tga", order = 52, command = function() PetAI.tThinkFunc.ShampooPet('shampoo_03','tShampooGeneric') ToggleInventory() end, },

        brush_01 = { filename = "But_xCDbrush_01T.tga", order = 60, command = function() PetAI.tThinkFunc.BrushPet(1,PetAI.tItems.tGroomingBrushWood) ToggleInventory() end, },
        brush_02 = { filename = "But_xCDbrush_02T.tga", order = 61, command = function() PetAI.tThinkFunc.BrushPet(2,PetAI.tItems.tGroomingBrushPlastic) ToggleInventory() end, },
        brush_03 = { filename = "But_xCDbrush_03T.tga", order = 62, command = function() PetAI.tThinkFunc.BrushPet(3,PetAI.tItems.tGroomingBrushSilver) ToggleInventory() end, },
        brush_04 = { filename = "But_xCDbrush_04T.tga", order = 63, command = function() PetAI.tThinkFunc.BrushPet(4,PetAI.tItems.tGroomingBrushGold) ToggleInventory() end, },
    },

    Clothing = {
        remove_clothes = { filename = "But_xCDremoveclothes_01T.tga", order = 0, command = function() RemoveAllPetAccessories() end, },

        collar_01 = { filename = "But_xCDcollar_01T.tga", order = 10, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 1) end, },
        collar_02 = { filename = "But_xCDcollar_02T.tga", order = 11, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 2) end, },
        collar_03 = { filename = "But_xCDcollar_03T.tga", order = 12, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 3) end, },
        collar_04 = { filename = "But_xCDcollar_04T.tga", order = 13, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 4) end, },
        collar_05 = { filename = "But_xCDcollar_05T.tga", order = 14, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 5) end, },
        collar_06 = { filename = "But_xCDcollar_06T.tga", order = 15, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 6) end, },
        collar_07 = { filename = "But_xCDcollar_07T.tga", order = 16, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 7) end, },
        collar_08 = { filename = "But_xCDcollar_08T.tga", order = 17, command = function() SetPetAccessory('collar', 'Objects/acc_collar.lua', '-tag collar01', 8) end, },

        floralcollar_01 = { filename = "But_xCDfloralcollar_01T.tga", order = 18, command = function() SetPetAccessory('collar', 'Objects/acc_floralcollar.lua', '-tag collar01', 1) end, },
        floralcollar_02 = { filename = "But_xCDfloralcollar_02T.tga", order = 19, command = function() SetPetAccessory('collar', 'Objects/acc_floralcollar.lua', '-tag collar01', 2) end, },
        floralcollar_03 = { filename = "But_xCDfloralcollar_03T.tga", order = 20, command = function() SetPetAccessory('collar', 'Objects/acc_floralcollar.lua', '-tag collar01', 3) end, },

        chaincollar_01 = { filename = "But_xCDchaincollar_01T.tga", order = 21, command = function() SetPetAccessory('collar', 'Objects/acc_chaincollar.lua', '-tag collar01', 1) end, },
        chaincollar_02 = { filename = "But_xCDchaincollar_02T.tga", order = 22,  command = function() SetPetAccessory('collar', 'Objects/acc_chaincollar.lua', '-tag collar01', 2) end, },
        chaincollar_03 = { filename = "But_xCDchaincollar_03T.tga", order = 23, command = function() SetPetAccessory('collar', 'Objects/acc_chaincollar.lua', '-tag collar01',  3) end, },

        gmcollar_01 = { filename = "But_xCDgmcollar_01T.tga", order = 24, command = function() SetPetAccessory('collar', 'Objects/acc_gmcollar.lua', '-tag collar01', 1) end, },
        bandanacollar_01 = { filename = "But_xCDbandanacollar_01T.tga", order = 25, command = function() SetPetAccessory('collar', 'Objects/acc_bandanacollar.lua', '-tag collar01', 1) end, },

        booties_01 = { filename = "But_x"..DorC.."booties_01T.tga", order = 30, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_bootie_01.lua', '-tag bootie0'..i, 1) end end, },
        booties_02 = { filename = "But_x"..DorC.."booties_02T.tga", order = 31, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_bootie_01.lua', '-tag bootie0'..i, 2) end end, },
        booties_03 = { filename = "But_x"..DorC.."booties_03T.tga", order = 32, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_bootie_01.lua', '-tag bootie0'..i, 3) end end, },

		tailpom_01 = { filename = "But_xCDtailpom_01T.tga", order = 40, command = function() SetPetAccessory('tailpom', 'Objects/acc_tailpom_01.lua', '-tag tailpom01', 1) end, },
		tailpom_02 = { filename = "But_xCDtailpom_02T.tga", order = 41, command = function() SetPetAccessory('tailpom', 'Objects/acc_tailpom_01.lua', '-tag tailpom01', 2) end, },
		tailpom_03 = { filename = "But_xCDtailpom_03T.tga", order = 42, command = function() SetPetAccessory('tailpom', 'Objects/acc_tailpom_01.lua', '-tag tailpom01', 3) end, },
		tailpom_04 = { filename = "But_xCDtailpom_04T.tga", order = 43, command = function() SetPetAccessory('tailpom', 'Objects/acc_tailpom_01.lua', '-tag tailpom01', 4) end, },
		tailpom_06 = { filename = "But_xCDtailpom_05T.tga", order = 45, command = function() SetPetAccessory('tailpom', 'Objects/acc_tailpom_01.lua', '-tag tailpom01', 6) end, },

        sombrerohat_01 = { filename = "But_xCDsombrerohat_01T.tga", order = 50, command = function() SetPetAccessory('hat', 'Objects/acc_sombrerohat_01.lua', '-tag hat01', 1) end, },
        baseballhat_01 = { filename = "But_xCDbaseballhat_01T.tga", order = 51, command = function() SetPetAccessory('hat', 'Objects/acc_baseballhat_01.lua', '-tag hat01', 1) end, },
        beeniehat_01 = { filename = "But_xCDbeeniehat_01T.tga", order = 52, command = function() SetPetAccessory('hat', 'Objects/acc_propbeenie_01.lua', '-tag hat01', 1) end, },
        cowboyhat_01 = { filename = "But_xCDcowboyhat_01T.tga", order = 53, command = function() SetPetAccessory('hat', 'Objects/acc_cowboyhat_01.lua', '-tag hat01', 1) end, },
        jesterhat_01 = { filename = "But_xCDjesterhat_01T.tga", order = 54, command = function() SetPetAccessory('hat', 'Objects/acc_jesterhat_01.lua', '-tag hat01', 1) end, },
        piratehat_01 = { filename = "But_xCDpiratehat_01T.tga", order = 55, command = function() SetPetAccessory('hat', 'Objects/acc_piratehat_01.lua', '-tag hat01', 1) end, },
        vikinghat_01 = { filename = "But_xCDvikinghat_01T.tga", order = 56, command = function() SetPetAccessory('hat', 'Objects/acc_vikinghat_01.lua', '-tag hat01', 1) end, },
        mohawkhat_01 = { filename = "But_xCDmohawk_01T.tga", order = 57, command = function() SetPetAccessory('hat', 'Objects/acc_mohawk_01.lua', '-tag hat01', 1) end, },
        princesshat_01 = { filename = "But_xCDprincesshat_01T.tga", order = 58, command = function() SetPetAccessory('hat', 'Objects/acc_princesshat_01.lua', '-tag hat01', 1) end, },
        wizardhat_01 = { filename = "But_xCDwizardhat_01T.tga", order = 59, command = function() SetPetAccessory('hat', 'Objects/acc_wizardhat_01.lua', '-tag hat01', 1) end, },
        tiarahat_01 = { filename = "But_xCDtiarahat_01T.tga", order = 60, command = function() SetPetAccessory('hat', 'Objects/acc_tiara_01.lua', '-tag hat01', 1) end, },

-- Dogz fur textures
        fur_01 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_01T.tga", order = 70, command = function() SetPetFur(1) end, },
        fur_02 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_02T.tga", order = 71, command = function() SetPetFur(2) end, },
        fur_03 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_03T.tga", order = 72, command = function() SetPetFur(3) end, },
        fur_04 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_04T.tga", order = 73, command = function() SetPetFur(4) end, },
        fur_05 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_05T.tga", order = 74, command = function() SetPetFur(5) end, },
        fur_06 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_06T.tga", order = 75, command = function() SetPetFur(6) end, },

-- Cat fur textures must be broken out by breed
        abyssinian_fur_04 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_04T.tga", order = 73, command = function() SetPetFur(4) end, tip_name= "Catz_fur_04",},
        abyssinian_fur_05 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_05T.tga", order = 74, command = function() SetPetFur(5) end, tip_name= "Catz_fur_05", },
        abyssinian_fur_06 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_06T.tga", order = 75, command = function() SetPetFur(6) end, tip_name= "Catz_fur_06", },
        abyssinian_fur_07 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_07T.tga", order = 76, command = function() SetPetFur(7) end, tip_name= "Catz_fur_07", },
        abyssinian_fur_08 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_08T.tga", order = 77, command = function() SetPetFur(8) end, tip_name= "Catz_fur_08", },
        abyssinian_fur_09 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_09T.tga", order = 78, command = function() SetPetFur(9) end, tip_name= "Catz_fur_09", },
        abyssinian_fur_10 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_10T.tga", order = 79, command = function() SetPetFur(10) end, tip_name= "Catz_fur_10", },
        abyssinian_fur_11 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_11T.tga", order = 80, command = function() SetPetFur(11) end, tip_name= "Catz_fur_11", },

		bengal_fur_04 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_04T.tga", order = 73, command = function() SetPetFur(4) end, tip_name= "Catz_fur_04", },
        bengal_fur_05 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_05T.tga", order = 74, command = function() SetPetFur(5) end, tip_name= "Catz_fur_05", },
        bengal_fur_06 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_06T.tga", order = 75, command = function() SetPetFur(6) end, tip_name= "Catz_fur_06", },
        bengal_fur_07 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_07T.tga", order = 76, command = function() SetPetFur(7) end, tip_name= "Catz_fur_07", },
        bengal_fur_08 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_08T.tga", order = 77, command = function() SetPetFur(8) end, tip_name= "Catz_fur_08", },
        bengal_fur_09 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_09T.tga", order = 78, command = function() SetPetFur(9) end, tip_name= "Catz_fur_09", },
        bengal_fur_10 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_10T.tga", order = 79, command = function() SetPetFur(10) end, tip_name= "Catz_fur_11", },

		burmese_fur_04 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_04T.tga", order = 73, command = function() SetPetFur(4) end, tip_name= "Catz_fur_12", },
        burmese_fur_05 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_05T.tga", order = 74, command = function() SetPetFur(5) end, tip_name= "Catz_fur_13", },
        burmese_fur_07 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_07T.tga", order = 76, command = function() SetPetFur(7) end, tip_name= "Catz_fur_10", },
        burmese_fur_08 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_08T.tga", order = 77, command = function() SetPetFur(8) end, tip_name= "Catz_fur_11", },

		maincoon_fur_04 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_04T.tga", order = 73, command = function() SetPetFur(4) end, tip_name= "Catz_fur_09", },
        maincoon_fur_05 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_05T.tga", order = 74, command = function() SetPetFur(5) end, tip_name= "Catz_fur_10", },
        maincoon_fur_06 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_06T.tga", order = 75, command = function() SetPetFur(6) end, tip_name= "Catz_fur_11", },

		siamese_fur_04 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_04T.tga", order = 73, command = function() SetPetFur(4) end, tip_name= "Catz_fur_13", },
        siamese_fur_05 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_05T.tga", order = 74, command = function() SetPetFur(5) end, tip_name= "Catz_fur_10", },
        siamese_fur_06 = { filename = "But_x"..DorC..""..PetAI.tBreed.szName.."fur_06T.tga", order = 75, command = function() SetPetFur(6) end, tip_name= "Catz_fur_11", },
    },

    Decor = {
        arearug_01 = { filename = "But_xCDarearug_01T.tga", order = 20, command = function() SetHouseAccessory('AreaRug', 1) end, },
        arearug_02 = { filename = "But_xCDarearug_02T.tga", order = 21, command = function() SetHouseAccessory('AreaRug', 2) end, },
        arearug_03 = { filename = "But_xCDarearug_03T.tga", order = 22, command = function() SetHouseAccessory('AreaRug', 3) end, },
        arearug_04 = { filename = "But_xCDarearug_04T.tga", order = 23, command = function() SetHouseAccessory('AreaRug', 4) end, },

        Bathroom_01 = { filename = "But_xCDBathroom_01T.tga", order = 30, command = function() SetHouseAccessory('BathRoom', 2) end, },
        Bathroom_02 = { filename = "But_xCDBathroom_02T.tga", order = 31, command = function() SetHouseAccessory('BathRoom', 1) end, },
        Bathroom_03 = { filename = "But_xCDBathroom_03T.tga", order = 32, command = function() SetHouseAccessory('BathRoom', 4) end, },
        Bathroom_04 = { filename = "But_xCDBathroom_04T.tga", order = 33, command = function() SetHouseAccessory('BathRoom', 3) end, },

        coffeetable_01 = { filename = "But_xCDcoffeetable_03T.tga", order = 40, command = function() SetHouseAccessory('CoffeeTable', 3) end, },
        coffeetable_02 = { filename = "But_xCDcoffeetable_02T.tga", order = 41, command = function() SetHouseAccessory('CoffeeTable', 2) end, },
        coffeetable_03 = { filename = "But_xCDcoffeetable_01T.tga", order = 42, command = function() SetHouseAccessory('CoffeeTable', 1) end, },

        Kitchen_01 = { filename = "But_xCDKitchen_01T.tga", order = 50, command = function() SetHouseAccessory('Kitchen', 1) end, },
        Kitchen_02 = { filename = "But_xCDKitchen_02T.tga", order = 51, command = function() SetHouseAccessory('Kitchen', 2) end, },
        Kitchen_03 = { filename = "But_xCDKitchen_03T.tga", order = 52, command = function() SetHouseAccessory('Kitchen', 3) end, },
        Kitchen_04 = { filename = "But_xCDKitchen_04T.tga", order = 53, command = function() SetHouseAccessory('Kitchen', 4) end, },

        kitchenchair_01 = { filename = "But_xCDkitchenchair_01T.tga", order = 60, command = function() SetHouseAccessory('KitchenChair01', 1) SetHouseAccessory('KitchenChair02', 1) end, },
        kitchenchair_02 = { filename = "But_xCDkitchenchair_02T.tga", order = 61, command = function() SetHouseAccessory('KitchenChair01', 2) SetHouseAccessory('KitchenChair02', 2) end, },
        kitchenchair_03 = { filename = "But_xCDkitchenchair_03T.tga", order = 62, command = function() SetHouseAccessory('KitchenChair01', 3) SetHouseAccessory('KitchenChair02', 3) end, },

        kitchentable_01 = { filename = "But_xCDkitchentable_01T.tga", order = 70, command = function() SetHouseAccessory('KitchenTable', 1) end, },
        kitchentable_02 = { filename = "But_xCDkitchentable_02T.tga", order = 71, command = function() SetHouseAccessory('KitchenTable', 2) end, },
        kitchentable_03 = { filename = "But_xCDkitchentable_03T.tga", order = 72, command = function() SetHouseAccessory('KitchenTable', 3) end, },
        kitchentable_04 = { filename = "But_xCDkitchentable_04T.tga", order = 73, command = function() SetHouseAccessory('KitchenTable', 4) end, },

		fridge_01 = { filename = "But_xCDfridge_01T.tga", order = 80, command = function() SetHouseAccessory('Refrigerator', 2) end, },
		fridge_02 = { filename = "But_xCDfridge_02T.tga", order = 81, command = function() SetHouseAccessory('Refrigerator', 3) end, },
		fridge_03 = { filename = "But_xCDfridge_03T.tga", order = 82, command = function() SetHouseAccessory('Refrigerator', 1) end, },
		fridge_04 = { filename = "But_xCDfridge_04T.tga", order = 83, command = function() SetHouseAccessory('Refrigerator', 4) end, },

        livingroom_01 = { filename = "But_xCDlivingroom_01T.tga", order = 90, command = function() SetHouseAccessory('LivingRoom', 4) end, },
        livingroom_02 = { filename = "But_xCDlivingroom_02T.tga", order = 91, command = function() SetHouseAccessory('LivingRoom', 3) end, },
        livingroom_03 = { filename = "But_xCDlivingroom_03T.tga", order = 92, command = function() SetHouseAccessory('LivingRoom', 2) end, },
        livingroom_04 = { filename = "But_xCDlivingroom_04T.tga", order = 93, command = function() SetHouseAccessory('LivingRoom', 1) end, },

        petbed_01 = { filename = "But_xCDpetbed_01T.tga", order = 100, command = function() SetHouseAccessory('PetBed', 1) end, },
        petbed_02 = { filename = "But_xCDpetbed_02T.tga", order = 101, command = function() SetHouseAccessory('PetBed', 2) end, },
        petbed_03 = { filename = "But_xCDpetbed_03T.tga", order = 102, command = function() SetHouseAccessory('PetBed', 3) end, },
        petbed_04 = { filename = "But_xCDpetbed_04T.tga", order = 103, command = function() SetHouseAccessory('PetBed', 4) end, },

        sofa_01 = { filename = "But_xCDsofa_01T.tga", order = 110, command = function() SetHouseAccessory('Sofa', 1) end, },
        sofa_02 = { filename = "But_xCDsofa_02T.tga", order = 111, command = function() SetHouseAccessory('Sofa', 2) end, },
        sofa_03 = { filename = "But_xCDsofa_03T.tga", order = 112, command = function() SetHouseAccessory('Sofa', 3) end, },
        sofa_04 = { filename = "But_xCDsofa_04T.tga", order = 113, command = function() SetHouseAccessory('Sofa', 4) end, },

        toilet_01 = { filename = "But_xCDtoilet_01T.tga", order = 120, command = function() SetHouseAccessory('Toilet', 4) end, },
        toilet_02 = { filename = "But_xCDtoilet_02T.tga", order = 121, command = function() SetHouseAccessory('Toilet', 3) end, },
        toilet_03 = { filename = "But_xCDtoilet_03T.tga", order = 122, command = function() SetHouseAccessory('Toilet', 1) end, },
        toilet_04 = { filename = "But_xCDtoilet_04T.tga", order = 123, command = function() SetHouseAccessory('Toilet', 2) end, },

        tub_01 = { filename = "But_xCDtub_01T.tga", order = 130, command = function() SetHouseAccessory('Tub', 2) end, tip_name="tub_02"},
        tub_02 = { filename = "But_xCDtub_02T.tga", order = 131, command = function() SetHouseAccessory('Tub', 4) end, tip_name="tub_03"},
        tub_03 = { filename = "But_xCDtub_03T.tga", order = 132, command = function() SetHouseAccessory('Tub', 3) end, tip_name="tub_01"},
        tub_04 = { filename = "But_xCDtub_04T.tga", order = 133, command = function() SetHouseAccessory('Tub', 1) end, tip_name="tub_04"},

        doghouse_01 = { filename = "But_xCDdoghouse_01T.tga", order = 140, command = function() SetHouseAccessory('DogHouse', 1) end, },
        doghouse_02 = { filename = "But_xCDdoghouse_02T.tga", order = 141, command = function() SetHouseAccessory('DogHouse', 2) end, },
        doghouse_03 = { filename = "But_xCDdoghouse_03T.tga", order = 142, command = function() SetHouseAccessory('DogHouse', 3) end, },
        doghouse_04 = { filename = "But_xCDdoghouse_04T.tga", order = 143, command = function() SetHouseAccessory('DogHouse', 4) end, },
    },

    Toys = {
        ball_01 = { filename = "But_xCDball_01T.tga", order = 10, command = function() KillToy() ToggleToy('Objects/toy_ball.lua', 1, 'But_xCDinvball_01T.tga', 'ball_01') end, },
        ball_02 = { filename = "But_xCDball_02T.tga", order = 11, command = function() KillToy() ToggleToy('Objects/toy_ball.lua', 2, 'But_xCDinvball_02T.tga', 'ball_02') end, },
        ball_03 = { filename = "But_xCDball_03T.tga", order = 12, command = function() KillToy() ToggleToy('Objects/toy_ball.lua', 3, 'But_xCDinvball_03T.tga', 'ball_03') end, },
        ball_04 = { filename = "But_xCDball_04T.tga", order = 13, command = function() KillToy() ToggleToy('Objects/toy_ball.lua', 4, 'But_xCDinvball_04T.tga', 'ball_04') end, },
        ball_05 = { filename = "But_xCDball_05T.tga", order = 14, command = function() KillToy() ToggleToy('Objects/toy_ball.lua', 5, 'But_xCDinvball_05T.tga', 'ball_05') end, },
        ball_06 = { filename = "But_xCDball_06T.tga", order = 15, command = function() KillToy() ToggleToy('Objects/toy_ball.lua', 6, 'But_xCDinvball_06T.tga', 'ball_06') end, },
    },
}


-- Insert Dogz Specific items
--
if (fox.app.GetAppName() == "Dogz") then

    inventory.Toys.flyingdisc_01 = { filename = "But_xDflyingdisc_01T.tga", order = 20, command = function() KillToy() ToggleToy('Objects/toy_frisbee.lua', 1, 'But_xDinvflyingdisc_01T.tga', 'flyingdisc_01') end, }
    inventory.Toys.flyingdisc_02 = { filename = "But_xDflyingdisc_02T.tga", order = 21, command = function() KillToy() ToggleToy('Objects/toy_frisbee.lua', 2, 'But_xDinvflyingdisc_02T.tga', 'flyingdisc_02') end, }
    inventory.Toys.flyingdisc_03 = { filename = "But_xDflyingdisc_03T.tga", order = 22, command = function() KillToy() ToggleToy('Objects/toy_frisbee.lua', 3, 'But_xDinvflyingdisc_03T.tga', 'flyingdisc_03') end, }
    inventory.Toys.flyingdisc_04 = { filename = "But_xDflyingdisc_04T.tga", order = 23, command = function() KillToy() ToggleToy('Objects/toy_frisbee.lua', 4, 'But_xDinvflyingdisc_04T.tga', 'flyingdisc_04') end, }

    inventory.Toys.stick_01 = { filename = "But_xDstick_01T.tga", order = 30, command = function() KillToy() ToggleToy('Objects/toy_stick_01.lua', 1, 'But_xDinvstick_01T.tga') end, }
    inventory.Toys.newspaper_01 = { filename = "But_xDnewspaper_01T.tga", order = 40, command = function() KillToy() ToggleToy('Objects/toy_newspaper.lua', 1, 'But_xDinvnewspaper_01T.tga') end, }
    inventory.Toys.mocassin_01 = { filename = "But_xDmocassin_01T.tga", order = 50, command = function() KillToy() ToggleToy('Objects/toy_mocassin.lua', 1, 'But_xDinvmocassin_01T.tga') end, }
    inventory.Toys.squeekybone_01 = { filename = "But_xDsqueekybone_01T.tga", order = 60, command = function() PlaySound('bone.wav') KillToy() ToggleToy('Objects/toy_squeekybone.lua', 1, 'But_xDinvsqueekybone_01T.tga') end, }
    inventory.Toys.teddy_01 = { filename = "But_xDteddy_01T.tga", order = 70, command = function() KillToy() ToggleToy('Objects/toy_teddybear.lua', 1, 'But_xDinvteddy_01T.tga') end, }
    inventory.Toys.squeekyduck_01 = { filename = "But_xDsqueekyduck_01T.tga", order = 80, command = function() PlaySound('ducky.wav') KillToy() ToggleToy('Objects/toy_squeekyduck.lua', 1, 'But_xDinvsqueekyduck_01T.tga') end, }

	inventory.Clothing.pombooties_01 = { filename = "But_x"..DorC.."pombooties_01T.tga", order = 33, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_pombootie_01.lua', '-tag bootie0'..i, 1) end end, }
	inventory.Clothing.pombooties_02 = { filename = "But_x"..DorC.."pombooties_02T.tga", order = 34, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_pombootie_01.lua', '-tag bootie0'..i, 2) end end, }
	inventory.Clothing.pombooties_03 = { filename = "But_x"..DorC.."pombooties_03T.tga", order = 35, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_pombootie_01.lua', '-tag bootie0'..i, 3) end end, }

    inventory.Decor.foodbowl_01 = { filename = "But_xDfoodbowl_01T.tga", order = 10, command = function() SetHouseAccessory('FoodBowl', 1) end }
    inventory.Decor.foodbowl_02 = { filename = "But_xDfoodbowl_02T.tga", order = 11, command = function() SetHouseAccessory('FoodBowl', 2) end }
    inventory.Decor.foodbowl_03 = { filename = "But_xDfoodbowl_03T.tga", order = 12, command = function() SetHouseAccessory('FoodBowl', 3) end }
    inventory.Decor.foodbowl_04 = { filename = "But_xDfoodbowl_04T.tga", order = 13, command = function() SetHouseAccessory('FoodBowl', 4) end }

else
    -- Catz Specific items
    inventory.Toys.toymouse_01 = { filename = "But_xCmouse_01T.tga", order = 20, command = function() KillToy() ToggleToy('Objects/toy_mouse.lua', 1, 'But_xCinvmouse_01T.tga') end, }

    inventory.Toys.jingleball_01 = { filename = "But_xCjingleball_01T.tga", order = 30, command = function() PlaySound('jingle.wav') KillToy() ToggleToy('Objects/toy_jingleball.lua', 1, 'But_xCinvjingleball_01T.tga') end, }
    inventory.Toys.jingleball_02 = { filename = "But_xCjingleball_02T.tga", order = 31, command = function() PlaySound('jingle.wav') KillToy() ToggleToy('Objects/toy_jingleball.lua', 2, 'But_xCinvjingleball_02T.tga') end, }
    inventory.Toys.jingleball_03 = { filename = "But_xCjingleball_03T.tga", order = 32, command = function() PlaySound('jingle.wav') KillToy() ToggleToy('Objects/toy_jingleball.lua', 3, 'But_xCinvjingleball_03T.tga') end, }
    --inventory.Toys.jingleball_04 = { filename = "But_xCjingleball_04T.tga", order = 33, command = function() PlaySound('jingle.wav') KillToy() ToggleToy('Objects/toy_ball.lua', 1, 'But_xCinvjingleball_04T.tga') end, }

    inventory.Decor.foodbowl_01 = { filename = "But_xCfoodbowl_01T.tga", order = 10, command = function() SetHouseAccessory('FoodBowl', 1) end }
    inventory.Decor.foodbowl_02 = { filename = "But_xCfoodbowl_02T.tga", order = 11, command = function() SetHouseAccessory('FoodBowl', 2) end }
    inventory.Decor.foodbowl_03 = { filename = "But_xCfoodbowl_03T.tga", order = 12, command = function() SetHouseAccessory('FoodBowl', 3) end }

    inventory.Decor.litterbox_01 = { filename = "But_xClitterbox_01T.tga", order = 150, command = function() SetHouseAccessory('LitterBox', 2) end }
    inventory.Decor.litterbox_02 = { filename = "But_xClitterbox_02T.tga", order = 151, command = function() SetHouseAccessory('LitterBox', 1) end }
    inventory.Decor.litterbox_03 = { filename = "But_xClitterbox_03T.tga", order = 152, command = function() SetHouseAccessory('LitterBox', 4) end }
    inventory.Decor.litterbox_04 = { filename = "But_xClitterbox_04T.tga", order = 153, command = function() SetHouseAccessory('LitterBox', 3) end }

    inventory.Decor.scratchingpost_01 = { filename = "But_xCscratchingpost_01T.tga", order = 160, command = function() SetHouseAccessory('ScratchingPost', 2) end }
    inventory.Decor.scratchingpost_02 = { filename = "But_xCscratchingpost_02T.tga", order = 161, command = function() SetHouseAccessory('ScratchingPost', 1) end }

    inventory.Decor.perch_01 = { filename = "But_xCperch_01T.tga",  order = 170, command = function() SetHouseAccessory('CatPerch', 1) end}
    inventory.Decor.perch_02 = { filename = "But_xCperch_02T.tga",  order = 171, command = function() SetHouseAccessory('CatPerch', 2) end}

	inventory.Clothing.pombooties_01 = { filename = "But_x"..DorC.."pombooties_01T.tga", order = 33, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_pombootie_01.lua', '-tag bootie0'..i, 1) end end, }
	inventory.Clothing.pombooties_02 = { filename = "But_x"..DorC.."pombooties_02T.tga", order = 34, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_pombootie_01.lua', '-tag bootie0'..i, 2) end end, tip_name= "pombooties_03"}
	inventory.Clothing.pombooties_03 = { filename = "But_x"..DorC.."pombooties_03T.tga", order = 35, command = function() for i = 1, 4, 1 do SetPetAccessory('bootie'..i, 'Objects/acc_pombootie_01.lua', '-tag bootie0'..i, 3) end end, tip_name= "pombooties_02"}

end

function ToggleToy(object, texture, button, name)
    if (toy == nil) and PetAI.tThinkFunc.JumpToBackyard() then

        name = name or ''

        PetAI.DoHelpDialog(58)
        CreateAndGrabToy(object, texture, name)

        HideInventory()
        Room.SetInvIcon(button, "ToggleToy('"..object.."', "..texture..", '"..button.."', '"..name.."')")

        if (Room.m_cInvIcon_btn != nil) then
            Room.m_cInvIcon_btn:SetEffects(BLT_EFFECTS.BLT_INVISIBLE)
        end

    else

        if (Room.m_cInvIcon_btn != nil and Room.m_cInvIcon_btn:GetEffects() == BLT_EFFECTS.BLT_EFFECT_NONE) then
            MyGrabToy(toy)

            Room.m_cInvIcon_btn:SetEffects(BLT_EFFECTS.BLT_INVISIBLE)

        else

            if (Room.m_cInvIcon_btn != nil) then
                Room.m_cInvIcon_btn:SetEffects(BLT_EFFECTS.BLT_EFFECT_NONE)
            end

            KillToy()
        end
    end

    return(toy != nil)
end
