dofile("radio.lua")

function standard_angle(angle)
    local t = angle

    while t > 360 do
        t = t - 360
    end

    while t < -360 do
        t = t + 360
    end

    if t > 180 then
        return t - 360
    elseif t < -180 then
        return t + 360
    else
        return t
    end
end

Room.BACKYARD = 1
Room.LIVINGROOM = 2
Room.KITCHEN = 3
Room.BATHROOM = 4
Room.TALENTSHOW = 5

Room.m_nNumRooms = 4
Room.m_fRoomOffset = 230
Room.m_nCurRoom = Room.BACKYARD -- this will be set by the SaveRestore system

Room.rooms = {
    { HomeEye = {-230, 116, 203}, HomeLookAt = {-230, 5, -70}, Name = "Backyard", },
    { HomeEye = {0, 116, 203}, HomeLookAt = {0, 5, -70}, Name = "LivingRoom",},
    { HomeEye = {250, 116, 203}, HomeLookAt = {250, 5, -70}, Name = "Kitchen",},
    { HomeEye = {490, 116, 203}, HomeLookAt = {490, 5, -70}, Name = "Bathroom",},
    { HomeEye = {752, 116, 203}, HomeLookAt = {752, 5, -70}, Name = "TalentShow",},
}

Room.m_tDogzAttnModeCam = {
	EyeOffset = {
        0  + pet.data.attention_camera_eye_offset[1],
        27 + pet.data.attention_camera_eye_offset[2],
        50 + pet.data.attention_camera_eye_offset[3],
    },

    LookAtOffset = {
        0  + pet.data.attention_camera_lookat_offset[1],
        15 + pet.data.attention_camera_lookat_offset[2],
        0  + pet.data.attention_camera_lookat_offset[3],
    }
}

Room.m_tCatzAttnModeCam = {
  EyeOffset = {
      0  + pet.data.attention_camera_eye_offset[1],
      32 + pet.data.attention_camera_eye_offset[2],
      45 + pet.data.attention_camera_eye_offset[3],
  },

  LookAtOffset = {
      0  + pet.data.attention_camera_lookat_offset[1],
      7  + pet.data.attention_camera_lookat_offset[2],
      0  + pet.data.attention_camera_lookat_offset[3],
  }
}

Room.SetRoom = function(nRoomID)
    Room.m_nCurRoom = nRoomID

    if (not Room.m_bShuttingDown) then

        Room.SetNavButtonsForRoom(nRoomID)
        Room.SetHomeCamera()

        if (nRoomID == Room.BACKYARD) then
            Room.m_cBathRoom:SetVisible(FALSE)
            Room.m_cKitchen:SetVisible(FALSE)
            Room.m_cLivingRoom:SetVisible(TRUE)
            Room.m_cBackyard:SetVisible(TRUE)

        elseif (nRoomID == Room.LIVINGROOM) then
            Room.m_cBathRoom:SetVisible(FALSE)
            Room.m_cKitchen:SetVisible(TRUE)
            Room.m_cLivingRoom:SetVisible(TRUE)
            Room.m_cBackyard:SetVisible(TRUE)

        elseif (nRoomID == Room.KITCHEN) then
            Room.m_cBathRoom:SetVisible(TRUE)
            Room.m_cKitchen:SetVisible(TRUE)
            Room.m_cLivingRoom:SetVisible(TRUE)
            Room.m_cBackyard:SetVisible(FALSE)

        elseif (nRoomID == Room.BATHROOM) then
            Room.m_cBathRoom:SetVisible(TRUE)
            Room.m_cKitchen:SetVisible(TRUE)
            Room.m_cLivingRoom:SetVisible(TRUE)
            Room.m_cBackyard:SetVisible(FALSE)

         elseif (nRoomID == Room.TALENTSHOW) then
            Room.m_cBathRoom:SetVisible(FALSE)
            Room.m_cKitchen:SetVisible(FALSE)
            Room.m_cLivingRoom:SetVisible(FALSE)
            Room.m_cBackyard:SetVisible(FALSE)
            if (Room.yardsound != nil) then
                Room.yardsound:SetVol(0)
            end
            if (Room.indoorsound != nil) then
                Room.indoorsound:SetVol(0)
            end

        else
            assert(FALSE)
        end

        if toy != nil then
            if Room.m_nCurRoom == Room.BACKYARD then
                --backyard
                toy:EnableCollisions()
            else
                toy:DisableCollisions()
            end
        end

        --if (nRoomID < 5) then dofile("Collision.lua") end
    end
end

Room.SetHomeCamera = function()
    FlushChannel(Room.m_nCameraTrackChannel);
    SetCameraPosition(Room.rooms[Room.m_nCurRoom].HomeEye[1], Room.rooms[Room.m_nCurRoom].HomeEye[2], Room.rooms[Room.m_nCurRoom].HomeEye[3])
    SetCameraLookAt(Room.rooms[Room.m_nCurRoom].HomeLookAt[1], Room.rooms[Room.m_nCurRoom].HomeLookAt[2], Room.rooms[Room.m_nCurRoom].HomeLookAt[3])
end

Room.TiltLeft = function()
    if (IsChannelEmpty(Room.m_nCameraChannel)) then
        FlushChannel(Room.m_nCameraTrackChannel);
        DoEvent("Room.TrackCamera(20, 50, ".. Room.rooms[Room.m_nCurRoom].HomeLookAt[1] + 40 ..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[2]..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[3]..")", Room.m_nCameraTrackChannel);
    end
end

Room.TiltRight = function()
    if (IsChannelEmpty(Room.m_nCameraChannel)) then
        FlushChannel(Room.m_nCameraTrackChannel);
        DoEvent("Room.TrackCamera(20, 50, ".. Room.rooms[Room.m_nCurRoom].HomeLookAt[1] - 40 ..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[2]..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[3]..")", Room.m_nCameraTrackChannel);
    end
end

Room.TiltUp = function()
    if (IsChannelEmpty(Room.m_nCameraChannel)) then
        FlushChannel(Room.m_nCameraTrackChannel);
        DoEvent("Room.TrackCamera(20, 50, ".. Room.rooms[Room.m_nCurRoom].HomeLookAt[1] ..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[2]..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[3] - 40 ..")", Room.m_nCameraTrackChannel);
    end
end

Room.TiltDown = function()
    if (IsChannelEmpty(Room.m_nCameraChannel)) then
        FlushChannel(Room.m_nCameraTrackChannel);
        DoEvent("Room.TrackCamera(20, 50, ".. Room.rooms[Room.m_nCurRoom].HomeLookAt[1] ..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[2]..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[3] + 40 ..")", Room.m_nCameraTrackChannel);
    end
end

Room.TiltHome = function()
    if (IsChannelEmpty(Room.m_nCameraChannel)) then
        FlushChannel(Room.m_nCameraTrackChannel);
        DoEvent("Room.TrackCamera(20, 50, ".. Room.rooms[Room.m_nCurRoom].HomeLookAt[1] ..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[2]..", "..Room.rooms[Room.m_nCurRoom].HomeLookAt[3] ..")", Room.m_nCameraTrackChannel);
    end
end

function Room.OnStartRoom()

    Room.m_bShuttingDown = false

    g_bSubmitPhoto = false

    pet:StopAll()

    -- Load the rooms
    --
    Room.m_cKitchen = Room.AddObjectToScene("kitchen.lua", 256, 0, 0)
    Room.m_cBathRoom = Room.AddObjectToScene("bathroom.lua", 501.5, 0, 0)
    Room.m_cLivingRoom = Room.AddObjectToScene("livingroom.lua", 0, 0, 0)
    Room.m_cBackyard = Room.AddObjectToScene("backyard.lua", -247, 0, 0)
    Room.m_cTalentShow = Room.AddObjectToScene("talentshow.lua", 752, 0, 0)

    Room.m_cCurtain = Room.LoadAndAttach("Objects/envobj_curtain.lua", Room.m_cTalentShow,"-tag Curtain")
    Room.m_cSpotlight = Room.LoadAndAttach("Objects/envobj_spotlight.lua", Room.m_cTalentShow,"-tag spotlight")

    Room.m_cAreaRug = Room.LoadAndAttach("Objects/envobj_arearug.lua", Room.m_cLivingRoom,"-tag Area Rug")
    Room.m_cCoffeeTable = Room.LoadAndAttach("Objects/envobj_coffeetable.lua", Room.m_cLivingRoom,"-tag Coffee Table")
    Room.m_cFireplace = Room.LoadAndAttach("Objects/envobj_fireplace.lua",Room.m_cLivingRoom,"-tag Fireplace")
    Room.m_cSofa = Room.LoadAndAttach("Objects/envobj_sofa.lua", Room.m_cLivingRoom,"-tag Sofa")
    Room.m_cPetBed = Room.LoadAndAttach("Objects/envobj_petbed.lua", Room.m_cLivingRoom,"-tag Pet Bed")
    Room.m_cLivingRoomCeiling = Room.LoadAndAttach("Objects/envobj_livingroomceiling.lua", Room.m_cLivingRoom,"-tag Ceiling")

    Room.m_cFireplace:RotateXZ(3.1415927)
    Room.m_cCoffeeTable:RotateXZ(1.5707964)

    Room.m_cFire = Room.LoadAndAttach("Objects/envobj_fire.lua", Room.m_cFireplace, "-tag Flames")
    Room.m_cFire:RotateXZ(3.1415927)
    Room.m_cFire:SetVisible(FALSE)

    -- Preload the fireplace
    Room.m_cFire:PreLoadAllTextures()

    Room.m_cRefrigerator = Room.LoadAndAttach("Objects/envobj_refrigerator.lua",Room.m_cKitchen,"-tag Refridgerator")
    Room.m_cKitchenChair01 = Room.LoadAndAttach("Objects/envobj_kitchenchair.lua",Room.m_cKitchen,"-tag kitchen Chair 01")
    Room.m_cKitchenChair02 = Room.LoadAndAttach("Objects/envobj_kitchenchair.lua",Room.m_cKitchen,"-tag kitchen Chair 02")
    Room.m_cKitchenTable = Room.LoadAndAttach("Objects/envobj_kitchentable.lua",Room.m_cKitchen,"-tag Kitchen Table")
    Room.m_cFoodBowl = Room.LoadAndAttach("Objects/envobj_foodbowl.lua",Room.m_cKitchen,"-tag Food Bowl")
    Room.m_cWaterBowl = Room.LoadAndAttach("Objects/envobj_waterbowl.lua",Room.m_cKitchen,"-tag Water Bowl")
    Room.m_cKitchenCeiling = Room.LoadAndAttach("Objects/envobj_kitchenceiling.lua",Room.m_cKitchen,"-tag Ceiling")
    Room.m_cKitchenFaucet = Room.LoadAndAttach("Objects/envobj_kitchenfaucet.lua",Room.m_cKitchen,"-tag Kitchen Faucet 01")
    Room.m_cKitchenFaucetWater = Room.LoadAndAttach("Objects/envobj_faucetwater.lua",Room.m_cKitchenFaucet,"-tag Water Faucet 01")
    Room.m_cBoomBox = Room.LoadAndAttach("Objects/envobj_boombox_01.lua", Room.m_cKitchen,"-tag Radio01")

    --Room.m_cOnPoint = Room.LoadAndAttach("Objects/dbg_mapnode.lua",Room.m_cSofa,"-Tag Cat On Sofa")
    --Room.m_cOffPoint = Room.LoadAndAttach("Objects/dbg_mapnode.lua",Room.m_cSofa,"-Tag Pets Jump To Sofa")

    Room.m_cKibble = Room.LoadAndAttach("Objects/envobj_kibble.lua",Room.m_cFoodBowl,"-Tag Kibble")
    Room.m_cBowlWater = Room.LoadAndAttach("Objects/envobj_bowlwater.lua",Room.m_cWaterBowl,"-tag Waterlevel")

    Room.m_cKibble:SetVisible(0)
    Room.m_cBowlWater:SetVisible(0)

    Room.m_cKitchenFaucetWater:SetVisible(0)
    Room.m_cKitchenFaucetWater:SetOffset(0, 15, 0)

    Room.m_cKitchenChair01:RotateXZ(3.1415927)
    Room.m_cKitchenChair02:RotateXZ(1.5707964)
    Room.m_cFoodBowl:SetOffset(-10,0,10)
    Room.m_cWaterBowl:SetOffset(-10,0,10)

    Room.m_cTub = Room.LoadAndAttach("Objects/envobj_tub.lua",Room.m_cBathRoom,"-tag Bathtub")
    Room.m_cToilet = Room.LoadAndAttach("Objects/envobj_toilet.lua",Room.m_cBathRoom,"-tag Toilet")
    Room.m_cBathroomCeiling = Room.LoadAndAttach("Objects/envobj_bathroomceiling.lua",Room.m_cBathRoom,"-tag Ceiling")
    Room.m_cTubWater = Room.LoadAndAttach("Objects/envobj_tubwater.lua",Room.m_cTub,"-tag Water Level")
    Room.m_cBathroomFaucet = Room.LoadAndAttach("Objects/envobj_bathroomfaucet.lua",Room.m_cBathRoom,"-tag Faucet")
    Room.m_cBathroomFaucetWater = Room.LoadAndAttach("Objects/envobj_faucetwater.lua",Room.m_cBathroomFaucet,"-tag Water Faucet 01")
    Room.m_cTubFaucetWater = Room.LoadAndAttach("Objects/envobj_faucetwater.lua",Room.m_cTub,"-tag Faucet Water 01")
    if CATZ then
      Room.m_cScratchingPost = Room.LoadAndAttach("Objects/envobj_scratchingpost.lua", Room.m_cLivingRoom,"-tag Scratchingpost")
      Room.m_cLitterBox = Room.LoadAndAttach("Objects/envobj_litterbox.lua",Room.m_cBathRoom,"-tag Litterbox")
      Room.m_cCatPerch = Room.LoadAndAttach("Objects/envobj_perch.lua",Room.m_cBathRoom,"-tag Perch")
    end

    Room.m_cBathroomFaucetWater:SetVisible(0)
    Room.m_cBathroomFaucetWater:SetOffset(0, 15, 0)

    Room.m_cTubFaucetWater:SetVisible(0)
    Room.m_cTubFaucetWater:SetOffset(0, 15, 0)

	--Room.m_cTubWater = Room.AddObjectToScene("Objects/envobj_tubwater.lua", 0, 100, 0)

    Room.m_cTree01 = Room.LoadAndAttach("Objects/envobj_smalltree.lua",Room.m_cBackyard,"-tag tree_01")
    Room.m_cTree02 = Room.LoadAndAttach("Objects/envobj_smalltree.lua",Room.m_cBackyard,"-tag tree_03")
    Room.m_cTree03 = Room.LoadAndAttach("Objects/envobj_largetree.lua",Room.m_cBackyard,"-tag tree_02")
    Room.m_cTree04 = Room.LoadAndAttach("Objects/envobj_largetree.lua",Room.m_cBackyard,"-tag tree_04")
    Room.m_cDogHouse = Room.LoadAndAttach("Objects/envobj_doghouse.lua",Room.m_cBackyard,"-tag doghouse")
    Room.m_cBushes = Room.LoadAndAttach("Objects/envobj_bushes.lua",Room.m_cBackyard,"-tag bushes")

    Room.m_cDogHouse:RotateXZ(3.1415927)

    --------------------------------------
    -- Create 2 event channels for camera work
    --------------------------------------
    Room.m_nCameraChannel = CreateChannel()
    Room.m_nCameraTrackChannel = CreateChannel()

    if (FoxFileExists("cheat_keys.lua")) then
        dofile("cheat_keys.lua")
    end

    --------------------------------------

    Room.m_cMainLight = CxLight()

    Room.m_cMainLight:SetType(LIGHT_POINT)
    Room.m_cMainLight:SetDiffuse(255, 255, 255, 255)
    Room.m_cMainLight:SetAttenuation0(0.1)
    Room.m_cMainLight:SetPosition(0, 300, 0)
    Room.m_cMainLight:SetDirection(0.0, -1.0, 0.0)
    Room.m_cMainLight:SetRange(900.0)

    -- Attach to Scene
    Room.m_cSceneManager:AddLight(Room.m_cMainLight)

    --Room.SetRoom(player.m_nCurRoom)

    -- Stats Dialog
    Room.stats_dialog = dofile("stats_dialog.lua")

    -- needs tab highlight
    Room.stats_dialog.tab1.m_pHighlight = NewHighlight("Efx_xCDstatustabhighlight_01T.tga", Room.stats_dialog.tab1, 1, 21)
    Room.stats_dialog.tab1:SetClip(TRUE)
    Room.stats_dialog.tab1.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end

    -- stats tab highlight
    Room.stats_dialog.tab2.m_pHighlight = NewHighlight("Efx_xCDstatustabhighlight_01T.tga", Room.stats_dialog.tab2, 1, 81)
    Room.stats_dialog.tab2:SetClip(TRUE)
    Room.stats_dialog.tab2.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end

    -- trick of the day tab highlight
    Room.stats_dialog.tab3.m_pHighlight = NewHighlight("Efx_xCDstatustabhighlight_01T.tga", Room.stats_dialog.tab3, 1, 141)
    Room.stats_dialog.tab3:SetClip(TRUE)
    Room.stats_dialog.tab3.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end

    -- close stats/needs dialog by default
    Room.stats_dialog:Erase()

    Room.trick_button = CLuaButton()
    Room.trick_button:SetName("Tricks")
    if (fox.app.GetAppName() == "Dogz") then
		Room.trick_button:LoadSurface("But_xDtricks_01T.tga")
	else
		Room.trick_button:LoadSurface("But_xCtricks_01T.tga")
	end
    Room.trick_button:Link(Room.this)
    Room.trick_button:Paint(8, Room.this:GetHeight() - 8, EPOS.BOTTOMLEFT)
    Room.trick_button:SetOnClicked("Room.ToggleTricks() PetAI.DoHelpDialog(11)")
    Room.trick_button:SetOnMouseEnter("DoToolTipForButton(Room.trick_button)")
    Room.trick_button:SetOnMouseExit("HideToolTip()")

    --Room.trick_button.m_pHighlight = NewHighlight("Efx_xCDstatusbuttonhighlight_01T.tga", Room.trick_button)
    --Room.trick_button.Flash = function(bOnOff) if (bOnOff) then Room.trick_button.m_pHighlight:Play() else Room.trick_button.m_pHighlight:Stop() Room.trick_button.m_pHighlight.sprite:Erase() end end


    -- The Trick Frame contains all the "learned" trick buttons
    --
    Room.trick_frame = dofile("trick_frame.lua")
    Room.trick_frame:Link(Room.this)
    Room.trick_frame:Paint(Room.trick_button:GetWidth() + 10, Room.this:GetHeight() - 8, EPOS.BOTTOMLEFT)
    Room.trick_frame:Erase()

    --Room.trick_frame:ActivateButton("Sit", Room.this, Room.this:GetWidth() / 2, Room.this:GetHeight() / 2)

    Room.hud_left = Room.LoadSprite("UI_xCDIngamehud_01T.tga", -1, 0, EPOS.TOPLEFT, ZORDER.HINDMOST)
    Room.hud_right = Room.LoadSprite("UI_xCDIngamehud_02T.tga", Room.this:GetWidth() - 1, 0, EPOS.TOPRIGHT, ZORDER.HINDMOST)

    local x, y = Room.hud_right:GetPosition(EPOS.TOPLEFT)

    Room.hud_inv = Room.LoadSprite("UI_xCDactiveitem_01T.tga", x + 20, y, EPOS.TOPCENTER, ZORDER.HINDMOST + 1)
    Room.hud_inv:Erase()

    Room.m_cLeftNavButton = CLuaButton()
    Room.m_cLeftNavButton:LoadSurface("But_xCD_Nav_Left_01T.tga")
    Room.m_cLeftNavButton:Link(Room.this)
    x, y = Room.hud_left:GetPosition(EPOS.BOTTOMLEFT)
    Room.m_cLeftNavButton:Paint(x, y, EPOS.TOPLEFT)
    Room.m_cLeftNavButton:SetOnClicked("HideToolTip() HideInventory() Room.RemoveToy() Room.NavLeftClicked()")
    Room.m_cLeftNavButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cLeftNavButton, Room.rooms[Room.m_nCurRoom + 1].Name)")
    Room.m_cLeftNavButton:SetOnMouseExit("HideToolTip()")

    Room.m_cRightNavButton = CLuaButton()
    Room.m_cRightNavButton:LoadSurface("But_xCD_Nav_Right_01T.tga")
    Room.m_cRightNavButton:Link(Room.this)
    x, y = Room.hud_right:GetPosition(EPOS.BOTTOMRIGHT)
    Room.m_cRightNavButton:Paint(x, y, EPOS.TOPRIGHT)
    Room.m_cRightNavButton:SetOnClicked("HideToolTip() HideInventory() Room.RemoveToy() Room.NavRightClicked()")
    Room.m_cRightNavButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cRightNavButton, Room.rooms[Room.m_nCurRoom - 1].Name)")
    Room.m_cRightNavButton:SetOnMouseExit("HideToolTip()")

    --  Inventory Button
    --
    Room.m_cInvButton = CLuaButton()
    Room.m_cInvButton:SetName("Inventory")
    Room.m_cInvButton:LoadSurface("But_xCDinventory_01T.tga")
    Room.m_cInvButton:Link(Room.hud_right);
    Room.m_cInvButton:SetOnClicked("HideToolTip() ShowInventory() Room.RemoveToy() PetAI.DoHelpDialog(8)")
    Room.m_cInvButton:Paint(138, 10)
    Room.m_cInvButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cInvButton)")
    Room.m_cInvButton:SetOnMouseExit("HideToolTip()")

    -- Store Button
    --
    Room.m_cStoreButton = CLuaButton()
    Room.m_cStoreButton:SetName("Store")
    Room.m_cStoreButton:LoadSurface("But_xCDstore_01T.tga")
    Room.m_cStoreButton:Link(Room.hud_right);
    Room.m_cStoreButton:SetOnClicked("HideToolTip() PetAI.DoHelpDialog(7) DoStoreDialog()")
    Room.m_cStoreButton:Paint(66, 10)
    Room.m_cStoreButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cStoreButton)")
    Room.m_cStoreButton:SetOnMouseExit("HideToolTip()")

    -- Reward/Treat Button
    --
    Room.m_cRewardButton = CLuaButton()
    Room.m_cRewardButton:SetName("Treat")
	Room.m_cRewardButton:LoadSurface("But_xCDlove_01T.tga")
    Room.m_cRewardButton:Link(Room.this);
    Room.m_cRewardButton:SetOnClicked("Room.RemoveToy() HideToolTip() HideInventory() PetAI.DoHelpDialog(67) if (OneLessTreat() != nil) then CreateAndGrabToy('Objects/obj_treat.lua') else PetAI.tThinkFunc.Reward() end")
    Room.m_cRewardButton:Paint(8, Room.this:GetHeight() - 215)
    Room.m_cRewardButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cRewardButton)")
    Room.m_cRewardButton:SetOnMouseExit("HideToolTip()")

    Room.m_cRewardButton.m_pHighlight = NewHighlight("Efx_xCDstatusbuttonhighlight_01T.tga", Room.m_cRewardButton)
    Room.m_cRewardButton.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end

    -- Temp Reward/Treat Button (goes in middle of screen under trick button)
    --
    Room.m_cTempRewardButton = CLuaButton()
    Room.m_cTempRewardButton:SetName("Treat")
	Room.m_cTempRewardButton:LoadSurface("But_xCDlove_01T.tga")
    Room.m_cTempRewardButton:Link(Room.this);
    Room.m_cTempRewardButton:SetOnClicked("Room.RemoveToy() if (g_cTipDialog != nil) then g_cTipDialog:EndModal() g_cTipDialog = nil end HideToolTip() HideInventory() PetAI.DoHelpDialog(67) if (OneLessTreat() != nil) then CreateAndGrabToy('Objects/obj_treat.lua') else PetAI.tThinkFunc.Reward() end Room.m_cTempRewardButton:Erase()")
    Room.m_cTempRewardButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cTempRewardButton)")
    Room.m_cTempRewardButton:SetOnMouseExit("HideToolTip()")

    Room.m_cTempRewardButton.m_pHighlight = NewHighlight("Efx_xCDstatusbuttonhighlight_01T.tga", Room.m_cTempRewardButton)
    Room.m_cTempRewardButton.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end

    -- Scold/BadDog Button
    --
    Room.m_cScoldButton = CLuaButton()
    Room.m_cScoldButton:SetName("Scold")
    Room.m_cScoldButton:LoadSurface("But_xCDsquirtbottle_01T.tga")
    Room.m_cScoldButton:Link(Room.this);
    Room.m_cScoldButton:SetOnClicked("HideToolTip() HideInventory() Room.ToggleScolding() PetAI.DoHelpDialog(68)")
    Room.m_cScoldButton:Paint(8, Room.this:GetHeight() - 146)
    Room.m_cScoldButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cScoldButton)")
    Room.m_cScoldButton:SetOnMouseExit("HideToolTip()")

    Room.m_cExitZoomMode = CLuaButton()
    Room.m_cExitZoomMode:SetName("Bathroom")
  	Room.m_cExitZoomMode:LoadSurface("But_xCDreturnhome_01T.tga")
    Room.m_cExitZoomMode:Link(Room.this);
    Room.m_cExitZoomMode:SetOnClicked("HideToolTip() Room.ExitZoomModeClicked()")
    Room.m_cExitZoomMode:Paint(8, Room.this:GetHeight() / 2)
    Room.m_cExitZoomMode:Erase()
    Room.m_cExitZoomMode:Disable()
    Room.m_cExitZoomMode:SetOnMouseEnter("DoToolTipForButton(Room.m_cExitZoomMode)")
    Room.m_cExitZoomMode:SetOnMouseExit("HideToolTip()")

    -- Stats Button
    --
    Room.m_cStatsButton = CLuaButton()
    Room.m_cStatsButton:SetName("Stats")
    if (fox.app.GetAppName() == "Dogz") then
		Room.m_cStatsButton:LoadSurface("But_xDstatus_01T.tga")
	else
		Room.m_cStatsButton:LoadSurface("But_xCstatus_01T.tga")
	end
    Room.m_cStatsButton:Link(Room.this);
    Room.m_cStatsButton:SetOnClicked("HideToolTip() Room.ToggleStats() PetAI.DoHelpDialog(12)")
    Room.m_cStatsButton:Paint(Room.this:GetWidth() - 10, Room.this:GetHeight() - 11, EPOS.BOTTOMRIGHT)
    Room.m_cStatsButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cStatsButton)")
    Room.m_cStatsButton:SetOnMouseExit("HideToolTip()")

    Room.m_cStatsButton.m_pHighlight = NewHighlight("Efx_xCDstatusbuttonhighlight_01T.tga", Room.m_cStatsButton)
    Room.m_cStatsButton.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end


    -- Options Button
    --
    Room.m_cOptionsButton = CLuaButton()
    Room.m_cOptionsButton:SetName("Options")
    Room.m_cOptionsButton:LoadSurface("But_xCDoptions_01T.tga")
    Room.m_cOptionsButton:Link(Room.hud_left);
    Room.m_cOptionsButton:SetOnClicked("HideToolTip() DoMenuDialog()")
    Room.m_cOptionsButton:Paint(15, 10)
    Room.m_cOptionsButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cOptionsButton)")
    Room.m_cOptionsButton:SetOnMouseExit("HideToolTip()")

    -- Camera Button
    --
    Room.m_cCameraButton = CLuaButton()
    Room.m_cCameraButton:SetName("Camera")
    Room.m_cCameraButton:LoadSurface("But_xCDcamera_01T.tga")
    Room.m_cCameraButton:Link(Room.hud_left);
    Room.m_cCameraButton:SetOnClicked('HideToolTip() PlaySound("camera.wav") TakePhoto("<AppData>photo_"..FoxGetTickCount()..".tga")')
    Room.m_cCameraButton:Paint(100, 10)
    Room.m_cCameraButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cCameraButton)")
    Room.m_cCameraButton:SetOnMouseExit("HideToolTip()")

    -- Shows Button
    --
    Room.m_cTalentMenuButton = CLuaButton()
    Room.m_cTalentMenuButton:SetName("Shows")
    Room.m_cTalentMenuButton:LoadSurface("But_xCDtalentshow_01T.tga")
    Room.m_cTalentMenuButton:Link(Room.hud_left);
    Room.m_cTalentMenuButton:SetOnClicked("HideToolTip() Room.LoadTalentMenu()")
    Room.m_cTalentMenuButton:Paint(180, 10)
    Room.m_cTalentMenuButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cTalentMenuButton)")
    Room.m_cTalentMenuButton:SetOnMouseExit("HideToolTip()")

    -- Return to House Button
    Room.m_cReturnToHouseButton = CLuaButton()
    Room.m_cReturnToHouseButton:SetName("ReturnToHouse")
    Room.m_cReturnToHouseButton:LoadSurface("But_xCDhouse_01T.tga")
    Room.m_cReturnToHouseButton:Link(Room.hud_left);
    Room.m_cReturnToHouseButton:SetOnClicked("HideToolTip() PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE)")
    Room.m_cReturnToHouseButton:Paint(180, 10)
    Room.m_cReturnToHouseButton:Erase()
    Room.m_cReturnToHouseButton:Disable()
    Room.m_cReturnToHouseButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cReturnToHouseButton)")
    Room.m_cReturnToHouseButton:SetOnMouseExit("HideToolTip()")

    -- Rising Text Elements
    Room.RisingTextQueue = {}
    Room.m_nTempRiser = nil

    -- House SFX
    Room.m_tHouseSFX = {}

    Room.m_tHouseSFX.wavSink = CxWave()
    Room.m_tHouseSFX.wavSink:Load("sink.wav")

    Room.m_tHouseSFX.wavToilet = CxWave()
    Room.m_tHouseSFX.wavToilet:Load("toilet.wav")

    Room.m_tHouseSFX.wavFridgeOpen = CxWave()
    Room.m_tHouseSFX.wavFridgeOpen:Load("fridgeopen.wav")

    Room.m_tHouseSFX.wavFridgeClose = CxWave()
    Room.m_tHouseSFX.wavFridgeClose:Load("fridgeclose.wav")

    Room.m_tHouseSFX.wavTub = CxWave()
    Room.m_tHouseSFX.wavTub:Load("tub.wav")

    Room.m_tHouseSFX.wavShowerStart = CxWave()
    Room.m_tHouseSFX.wavShowerStart:Load("showerstart.wav")

    Room.m_tHouseSFX.wavShowerLoop = CxWave()
    Room.m_tHouseSFX.wavShowerLoop:Load("showerloop.wav")
    Room.m_tHouseSFX.wavShowerLoop:SetNumLoops(9999999)

    Room.m_tHouseSFX.wavShowerStop = CxWave()
    Room.m_tHouseSFX.wavShowerStop:Load("showerstop.wav")

    Room.m_tHouseSFX.wavSinkFaucet = CxWave()
    Room.m_tHouseSFX.wavSinkFaucet:Load("sink.wav")

    Room.m_tHouseSFX.wavMoneyIncrease = CxWave()
    Room.m_tHouseSFX.wavMoneyIncrease:Load("cashbell.wav")

    Room.m_tHouseSFX.wavStatIncrease = CxWave()
    Room.m_tHouseSFX.wavStatIncrease:Load("statbell.wav")

    Room.m_tHouseSFX.wavNeedAlert = CxWave()
    Room.m_tHouseSFX.wavNeedAlert:Load("alert.wav")
    Room.m_tHouseSFX.wavNeedAlert:SetNumLoops(4)

    Room.m_bIsFridgeOpen = false
    Room.m_bIsFireplaceOn = false

    Room.UpdateRewardButton()

    --
    -- preload toy sfx to avoid pauses
    --
    if DOGZ then
        PreLoadSound("throw-ducky.wav")
        PreLoadSound("land-ducky.wav")
    elseif CATZ then
        PreLoadSound("land-jingle.wav")
        PreLoadSound("throw-jingle.wav")
    end
    PreLoadSound("land-toy.wav")

    if (pet != nil) then
        if (pet:GetName() == "Pug") then
            NewFileSystem("<PugSounds>", "PUG/SOUND")
        end
    end

    Room.yardsound = CreateSound { filename = "yardloop.wav", loops = 999999, volume = 0, position = {-230, 116, 203}, falloff_distance = 400,}
    Room.yardsound:Play()
    Room.indoorsound = CreateSound { filename = "roomtone.wav", loops = 999999, volume = 0, position = {250, 116, 203}, falloff_distance = 400, }
    Room.indoorsound:Play()
end

function Room.UpdateAmbientSounds()

    if (Room.m_nCurRoom == Room.TALENTSHOW) then
        if (Room.yardsound != nil) then
            Room.yardsound:SetVol(0)
        end

        if (Room.indoorsound != nil) then
            Room.indoorsound:SetVol(0)
        end

        if (Room.firesound != nil) then
            Room.firesound:SetVol(0)
        end
    else
        local x, y, z = GetCameraPosition()

        if (Room.yardsound != nil) then
            Room.yardsound:SetDistanceVol(x, y, z)
        end

        if (Room.indoorsound != nil) then
            Room.indoorsound:SetDistanceVol(x, y, z)
        end

        if (Room.firesound != nil) then
            Room.firesound:SetDistanceVol(x, y, z)
        end
    end
end


function Room.OnStopRoom()

    RemoveFileSystem("<PugSounds>")

    if (Room.yardsound != nil) then
        Room.yardsound:Release()
        Room.yardsound = nil
    end

    if (Room.indoorsound != nil) then
        Room.indoorsound:Release()
        Room.indoorsound = nil
    end

    if (Room.firesound != nil) then
        Room.firesound:Release()
        Room.firesound = nil
    end

    radio.ShutDown()

    Room.m_bShuttingDown = true

	HideToolTip()

	EventChannelManager.DestroyAll()

	if (Room.m_nFireChannel != nil) then
        DestroyChannel(Room.m_nFireChannel)
        Room.m_nFireChannel = nil
    end

    -- Unload any registered cheat keys
    --
    if (cheat_keys != nil) then
        for k, v in pairs(cheat_keys) do
            UnBindKey(k)
        end
        cheat_keys = nil
    end

    KillToy()

    pet:UnLink()

    Room.stats_dialog:Kill()
    Room.stats_dialog = nil

    Room.m_cSceneManager:RemoveLight(Room.m_cMainLight)
    Room.m_cMainLight = nil

    if (Room.m_nCameraTrackChannel != nil) then
        DestroyChannel(Room.m_nCameraTrackChannel)
        Room.m_nCameraTrackChannel = nil
    end

    if (Room.m_nCameraChannel != nil) then
        DestroyChannel(Room.m_nCameraChannel)
        Room.m_nCameraChannel = nil
    end

    -- Kill the 2D stuff
    Room.hud_left:Kill()
    Room.hud_right:Kill()
    Room.hud_inv:Kill()

    Room.trick_frame:Kill()
    Room.trick_button:Kill()

    Room.m_cInvButton:Kill()
    Room.m_cStoreButton:Kill()

    Room.m_cLeftNavButton:Kill()
    Room.m_cRightNavButton:Kill()

    Room.m_cTempRewardButton:Kill()
    Room.m_cRewardButton:Kill()

    Room.m_cScoldButton:Kill()

    Room.m_cStatsButton:Kill()
    Room.m_cCameraButton:Kill()

    Room.m_cTalentMenuButton:Kill()
    Room.m_cOptionsButton:Kill()

    Room.m_cReturnToHouseButton:Kill()

    Room.m_cExitZoomMode:Kill()

    if (Room.m_pPetIndicator != nil) then
        Room.m_pPetIndicator:Kill()
        Room.m_pPetIndicator = nil
    end

    -- Kill the 3D stuff
    Room.RemoveObject(Room.m_cFire)

    Room.RemoveObject(Room.m_cAreaRug)
    Room.RemoveObject(Room.m_cCoffeeTable)
    Room.RemoveObject(Room.m_cFireplace)
    Room.RemoveObject(Room.m_cSofa)
    Room.RemoveObject(Room.m_cPetBed)
    Room.RemoveObject(Room.m_cLivingRoomCeiling)

    Room.RemoveObject(Room.m_cBathroomFaucet)
    Room.RemoveObject(Room.m_cTubFaucetWater)

    Room.RemoveObject(Room.m_cKitchenChair01)
    Room.RemoveObject(Room.m_cKitchenChair02)
    Room.RemoveObject(Room.m_cKitchenTable)
    Room.RemoveObject(Room.m_cKitchenFaucet)
    Room.RemoveObject(Room.m_cRefrigerator)
    Room.RemoveObject(Room.m_cFoodBowl)
    Room.RemoveObject(Room.m_cWaterBowl)

    Room.RemoveObject(Room.m_cTree01)
    Room.RemoveObject(Room.m_cTree02)
    Room.RemoveObject(Room.m_cTree03)
    Room.RemoveObject(Room.m_cTree04)

    Room.RemoveObject(Room.m_cDogHouse)

    Room.RemoveObject(Room.m_cCurtain)
    Room.RemoveObject(Room.m_cSpotlight)

    Room.RemoveObject(Room.m_cBackyard)
    Room.RemoveObject(Room.m_cLivingRoom)
    Room.RemoveObject(Room.m_cKitchen)
    Room.RemoveObject(Room.m_cBathRoom)
    Room.RemoveObject(Room.m_cTalentShow)

    for k,v in pairs(Room.m_tHouseSFX) do v:Release() end

	PetAI.tThinkFunc.Shutdown()

	StopMusic()

	-- flush toy sfx
    FlushSoundCache()
end

function Room.OnPause()
    --
    -- TODO: Pause all Event channels, animations, etc...
    --
    if (Room.m_nCameraTrackChannel != nil) then
        PauseChannel(Room.m_nCameraTrackChannel)
    end

    if (Room.m_nCameraChannel != nil) then
        PauseChannel(Room.m_nCameraChannel)
    end

    if (Room.m_nFireChannel != nil) then
        PauseChannel(Room.m_nFireChannel)
    end

    EventChannelManager.Pause()

    if (ActivePetChannel != nil) then
        PauseChannel(ActivePetChannel)
    end

    Room.DimScene()

    if toy then
        toy:Pause()
    end

    radio.Pause()
end

function Room.OnResume()
    --
    -- TODO: Restore all paused stuff
    --
    if (Room.m_nCameraChannel != nil) then
        ResumeChannel(Room.m_nCameraChannel)
    end

    if (Room.m_nCameraTrackChannel != nil) then
        ResumeChannel(Room.m_nCameraTrackChannel)
    end

    if (Room.m_nFireChannel != nil) then
        ResumeChannel(Room.m_nFireChannel)
    end

    EventChannelManager.Resume()

    if (ActivePetChannel != nil) then
        ResumeChannel(ActivePetChannel)
    end

    Room.UnDimScene()

    if toy then
        toy:Resume()
    end

    radio.Resume()
end

Room.bNeedsFlashing = false
Room.bReplayNeedsAlert = false

function Room.FlashNeeds(bOn)

  if (bOn and not Room.bNeedsFlashing) then
    Room.stats_dialog.tab1.Flash(Room.stats_dialog.tab1,true)
    Room.m_cStatsButton.Flash(Room.m_cStatsButton,true)
    if (Room.m_tHouseSFX.wavNeedAlert:IsPlaying() != 1) then Room.m_tHouseSFX.wavNeedAlert:Play() end
    Room.bNeedsFlashing = true
  elseif (bOn and Room.bReplayNeedsAlert) then
    if (Room.m_tHouseSFX.wavNeedAlert:IsPlaying() != 1) then Room.m_tHouseSFX.wavNeedAlert:Play() end
    Room.bReplayNeedsAlert = false
  elseif (not bOn and Room.bNeedsFlashing) then
    Room.stats_dialog.tab1.Flash(Room.stats_dialog.tab1,false)
    Room.m_cStatsButton.Flash(Room.m_cStatsButton,false)
    Room.m_tHouseSFX.wavNeedAlert:Stop()
    Room.bNeedsFlashing = false
  end
end

function Room.FindTrickButton(name)
	return(Room.trick_frame.buttons[name])
end

function Room.Save()

    player.m_tTricks = {}
    for k, v in pairs(PetAI.tVoiceCommands) do
		if (v.bActive) then
			table.insert(player.m_tTricks, k)
		end
    end

    player.m_nCurRoom = Room.m_nCurRoom

    Room.m_cRefrigerator.texture = Room.m_cRefrigerator.texture or 2
    Room.m_cKitchen.texture = Room.m_cKitchen.texture or 1
    Room.m_cBathRoom.texture = Room.m_cBathRoom.texture or 2
    Room.m_cLivingRoom.texture = Room.m_cLivingRoom.texture or 4
    Room.m_cAreaRug.texture = Room.m_cAreaRug.texture or 1
    Room.m_cCoffeeTable.texture = Room.m_cCoffeeTable.texture or 3
    Room.m_cSofa.texture = Room.m_cSofa.texture or 1
    Room.m_cPetBed.texture = Room.m_cPetBed.texture or 1
    Room.m_cKitchenChair01.texture = Room.m_cKitchenChair01.texture or 1
    Room.m_cKitchenChair02.texture = Room.m_cKitchenChair02.texture or 1
    Room.m_cKitchenTable.texture = Room.m_cKitchenTable.texture or 1
    Room.m_cWaterBowl.texture = Room.m_cWaterBowl.texture or 1
    Room.m_cTub.texture = Room.m_cTub.texture or 2
    Room.m_cToilet.texture = Room.m_cToilet.texture or 4
    Room.m_cDogHouse.texture = Room.m_cDogHouse.texture or 1
    if CATZ then
        Room.m_cScratchingPost.texture = Room.m_cScratchingPost.texture or 2
        Room.m_cLitterBox.texture = Room.m_cLitterBox.texture or 2
        Room.m_cCatPerch.texture = Room.m_cCatPerch.texture or 2
    end


    LogInfo("m_cKitchen.texture".. Room.m_cKitchen.texture)

    SaveGame.m_cUserData:SetInt("Decor", "Refrigerator", Room.m_cRefrigerator.texture)
    SaveGame.m_cUserData:SetInt("Decor", "Kitchen", Room.m_cKitchen.texture)
    SaveGame.m_cUserData:SetInt("Decor", "BathRoom", Room.m_cBathRoom.texture)
    SaveGame.m_cUserData:SetInt("Decor", "LivingRoom", Room.m_cLivingRoom.texture)
    SaveGame.m_cUserData:SetInt("Decor", "AreaRug", Room.m_cAreaRug.texture)
    SaveGame.m_cUserData:SetInt("Decor", "CoffeeTable", Room.m_cCoffeeTable.texture)
    SaveGame.m_cUserData:SetInt("Decor", "Sofa", Room.m_cSofa.texture)
    SaveGame.m_cUserData:SetInt("Decor", "PetBed", Room.m_cPetBed.texture)
    SaveGame.m_cUserData:SetInt("Decor", "KitchenChair01", Room.m_cKitchenChair01.texture)
    SaveGame.m_cUserData:SetInt("Decor", "KitchenChair02", Room.m_cKitchenChair01.texture)
    SaveGame.m_cUserData:SetInt("Decor", "KitchenTable", Room.m_cKitchenTable.texture)
    SaveGame.m_cUserData:SetInt("Decor", "WaterBowl", Room.m_cWaterBowl.texture)
    SaveGame.m_cUserData:SetInt("Decor", "Tub", Room.m_cTub.texture)
    SaveGame.m_cUserData:SetInt("Decor", "Toilet", Room.m_cToilet.texture)
    SaveGame.m_cUserData:SetInt("Decor", "DogHouse", Room.m_cDogHouse.texture)
    if CATZ then
        SaveGame.m_cUserData:SetInt("Decor", "ScratchingPost", Room.m_cScratchingPost.texture)
        SaveGame.m_cUserData:SetInt("Decor", "LitterBox", Room.m_cLitterBox.texture)
        SaveGame.m_cUserData:SetInt("Decor", "CatPerch", Room.m_cCatPerch.texture)
    end

    SaveGame.Save()
end

function Room.Restore()
    Room.SetRoom(player.m_nCurRoom)
    PetAI.szLocation = Room.rooms[Room.m_nCurRoom].Name

    local t = PetAI.tPathFunc.tRooms[PetAI.szLocation].GetHomePosition()

    pet:Link(Room.m_cSceneManager)
    pet:SetPosition(t[1], t[2], t[3])
    pet:SetVisible(TRUE)

    -- Set known trick buttons
    --
    for i, v in ipairs(player.m_tTricks) do
        Room.trick_frame:SaveButton(v, true)
        PetAI.tVoiceCommands[v].bActive = true
    end

    local t = player.m_tInventory

    player.m_tInventory = {}

    -- Populate the inventory
    --
    for item, count in pairs(t) do

        for tab_name in pairs(inventory) do
            if (inventory[tab_name][item] != nil) then
                for i = 1, count, 1 do
                    AddItemToInventory(tab_name, item)
                end
                break
            end
        end
    end

    SetHouseAccessory("Refrigerator", SaveGame.m_cUserData:GetInt("Decor", "Refrigerator", 2))
    SetHouseAccessory("Kitchen", SaveGame.m_cUserData:GetInt("Decor", "Kitchen", 1))
    SetHouseAccessory("BathRoom", SaveGame.m_cUserData:GetInt("Decor", "BathRoom", 2))
    SetHouseAccessory("LivingRoom", SaveGame.m_cUserData:GetInt("Decor", "LivingRoom", 4))
    SetHouseAccessory("AreaRug", SaveGame.m_cUserData:GetInt("Decor", "AreaRug",  1))
    SetHouseAccessory("CoffeeTable", SaveGame.m_cUserData:GetInt("Decor", "CoffeeTable", 3))
    SetHouseAccessory("Sofa", SaveGame.m_cUserData:GetInt("Decor", "Sofa", 1))
    SetHouseAccessory("PetBed", SaveGame.m_cUserData:GetInt("Decor", "PetBed", 1))
    SetHouseAccessory("KitchenChair01", SaveGame.m_cUserData:GetInt("Decor", "KitchenChair01", 1))
    SetHouseAccessory("KitchenChair02", SaveGame.m_cUserData:GetInt("Decor", "KitchenChair02", 1))
    SetHouseAccessory("KitchenTable", SaveGame.m_cUserData:GetInt("Decor", "KitchenTable", 1))
    SetHouseAccessory("WaterBowl", SaveGame.m_cUserData:GetInt("Decor", "WaterBowl", 1))
    SetHouseAccessory("Tub", SaveGame.m_cUserData:GetInt("Decor", "Tub", 2))
    SetHouseAccessory("Toilet", SaveGame.m_cUserData:GetInt("Decor", "Toilet", 4))
    SetHouseAccessory("DogHouse", SaveGame.m_cUserData:GetInt("Decor", "DogHouse", 1))
    if CATZ then
        SetHouseAccessory("ScratchingPost", SaveGame.m_cUserData:GetInt("Decor", "ScratchingPost", 2))
        SetHouseAccessory("LitterBox", SaveGame.m_cUserData:GetInt("Decor", "LitterBox", 2))
        SetHouseAccessory("CatPerch", SaveGame.m_cUserData:GetInt("Decor", "CatPerch", 2))
    end
end

function Room.OnAfterStart()
    Room.Restore()
    PetAI.Enable()
    PetAI.RestoreNeedsFromPrevSession()
end

function Room.OnBeforeStop()
    PetAI.tThinkFunc.Shutdown()

    PetAI.m_bKenneled = false

    -- Record time of last save
    PetAI.m_nKennelTime = FoxGetTimeSeconds()

    Room.Save()
end

function Room.ExitZoomModeClicked()
	if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
	  PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE,false)
	else PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE) end
end

function Room.NavRightClicked()
	if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
	    PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE,false)
	elseif (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE)) then
	    PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE)
	else dofile("MoveRight.lua") end
end

function Room.NavLeftClicked()
	if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
	    PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE,false)
	elseif (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE)) then
	    PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE)
	else dofile("MoveLeft.lua") end
end

function Room.NavUpClicked()
	if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE) or PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE)) then
	    PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE)
	end
end


function Room.LoadTalentMenu()

    local bBusy = false

    -- We can't go to the talent show if the trick buttons are still busy
    --
    for k, v in pairs(Room.trick_frame.m_bFlyingTrickButton) do
        if (v) then
            bBusy = true
            break;
        end
    end

    if (not bBusy) then

        -- retrieve highest talent show difficulty level available
        local iDiffLevel = PetAI.TalentShow.GetHighestTalentShowLevel()

        -- load a help dialog if the next difficulty level is currently disabled
        if (iDiffLevel == 0) then
            DoTalentMenu(GetLanguageString("Tip_59"))
        elseif (iDiffLevel == 1) then
            DoTalentMenu(GetLanguageString("Tip_60"))
        elseif (iDiffLevel == 2) then
            DoTalentMenu(GetLanguageString("Tip_61"))
        else
            DoTalentMenu("")
        end
    end
end

function Room.SetNavButtonsForAttnMode()
	if not (Room.m_cLeftNavButton:IsEnabled() == 1) then
		Room.m_cLeftNavButton:Enable()
		Room.m_cLeftNavButton:Paint()
	end

	if not (Room.m_cRightNavButton:IsEnabled() == 1) then
		Room.m_cRightNavButton:Enable()
		Room.m_cRightNavButton:Paint()
	end

	Room.m_cLeftNavButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cLeftNavButton, 'LeaveAttentionMode')")
	Room.m_cRightNavButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cRightNavButton, 'LeaveAttentionMode')")
	Room.m_cExitZoomMode:SetOnMouseEnter("DoToolTipForButton(Room.m_cExitZoomMode, 'LeaveAttentionMode')")
	Room.m_cExitZoomMode:Enable();
	Room.m_cExitZoomMode:Paint();

end

function Room.DisableNavButtons(iRoom)
 	Room.m_cLeftNavButton:Disable()
	Room.m_cRightNavButton:Disable()
end

function Room.SetNavButtonsForRoom(iRoom)
    if not (Room.m_cLeftNavButton:IsEnabled() == 1) then
		Room.m_cLeftNavButton:Enable()
		Room.m_cLeftNavButton:Paint()
	end

	if not (Room.m_cRightNavButton:IsEnabled() == 1) then
		Room.m_cRightNavButton:Enable()
		Room.m_cRightNavButton:Paint()
	end

	if (iRoom == 1) then

		Room.m_cRightNavButton:Erase()
	 	Room.m_cRightNavButton:Disable()

	elseif (iRoom == 4) then
		Room.m_cLeftNavButton:Erase()
		Room.m_cLeftNavButton:Disable()
	end

    Room.m_cLeftNavButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cLeftNavButton, Room.rooms[Room.m_nCurRoom + 1].Name)")
    Room.m_cRightNavButton:SetOnMouseEnter("DoToolTipForButton(Room.m_cRightNavButton, Room.rooms[Room.m_nCurRoom - 1].Name)")

    Room.m_cExitZoomMode:SetOnMouseEnter("DoToolTipForButton(Room.m_cExitZoomMode)")
    Room.m_cExitZoomMode:Erase();

    HideToolTip()
end

function Room.ToggleTricks()
    if (Room.trick_frame:IsVisible() == FALSE) then
        Room.trick_frame:Paint()
    else
        Room.trick_frame:Erase()
    end
end

function Room.OnTick(elapsed)
	PetAI.tThinkFunc.Update(elapsed)

	Room.UpdateAmbientSounds()

	if (Room.m_bScolding and Room.m_nStartSquirtBottle != nil and (Room.m_nStartSquirtBottle + 5000 < FoxGetTickCount())) then
	    Room.ToggleScolding()
	end

    if Room.m_bAttentionMode then
        local angle = standard_angle(PetAI.fCurOrientation)
        if angle == 0 then
            Room.tPetLookAtWhilePetting.on = false
            Room.tPetLookAtWhilePetting.angle = 0
        elseif angle < 91 and angle > 0 then
            Room.tPetLookAtWhilePetting.on = true
            Room.tPetLookAtWhilePetting.angle = -(angle + 10)
        elseif angle > -89 and angle < 0 then
            Room.tPetLookAtWhilePetting.on = true
            Room.tPetLookAtWhilePetting.angle = -(angle - 10)
        else
            Room.tPetLookAtWhilePetting.on = false
            Room.tPetLookAtWhilePetting.angle = 0
        end
    end
	-- update needs meters
	Room.stats_dialog.m_kHungerMeter:SetValue(PetAI.tNeeds.tHunger.iCurValue)
	Room.stats_dialog.m_kThirstMeter:SetValue(PetAI.tNeeds.tThirst.iCurValue)
	Room.stats_dialog.m_kLoveMeter:SetValue(PetAI.tNeeds.tLove.iCurValue)
	Room.stats_dialog.m_kAlertnessMeter:SetValue(PetAI.tNeeds.tAlertness.iCurValue)
	Room.stats_dialog.m_kGroomingMeter:SetValue(PetAI.tNeeds.tGrooming.iCurValue)

	-- update stats meters (current values)
	Room.stats_dialog.m_kIntelligenceMeter:SetValue(PetAI.tStats.tIntelligence.iCurValue)
	Room.stats_dialog.m_kStaminaMeter:SetValue(PetAI.tStats.tStamina.iCurValue)
	Room.stats_dialog.m_kAgilityMeter:SetValue(PetAI.tStats.tAgility.iCurValue)
	Room.stats_dialog.m_kObedienceMeter:SetValue(PetAI.tStats.tObedience.iCurValue)

  -- update stats meters (max values)
	Room.stats_dialog.m_kIntelligenceMeter:SetMidValue(PetAI.tStats.tIntelligence.iMaxValue)
	Room.stats_dialog.m_kStaminaMeter:SetMidValue(PetAI.tStats.tStamina.iMaxValue)
	Room.stats_dialog.m_kAgilityMeter:SetMidValue(PetAI.tStats.tAgility.iMaxValue)
	Room.stats_dialog.m_kObedienceMeter:SetMidValue(PetAI.tStats.tObedience.iMaxValue)

	-- update stat labels
	PetAI.tThinkFunc.UpdateNeedLabels()
	Room.stats_dialog.m_kIntelligenceLabel:SetString(string.format("%s (%2.0f/%2.0f)",GetLanguageString("StatIntelligence"), PetAI.tStats.tIntelligence.iCurValue,PetAI.tStats.tIntelligence.iMaxValue))
	Room.stats_dialog.m_kStaminaLabel:SetString(string.format("%s (%2.0f/%2.0f)",GetLanguageString("StatStamina"), PetAI.tStats.tStamina.iCurValue,PetAI.tStats.tStamina.iMaxValue))
	Room.stats_dialog.m_kAgilityLabel:SetString(string.format("%s (%2.0f/%2.0f)",GetLanguageString("StatAgility"), PetAI.tStats.tAgility.iCurValue,PetAI.tStats.tAgility.iMaxValue))
	Room.stats_dialog.m_kObedienceLabel:SetString(string.format("%s (%2.0f/%2.0f)",GetLanguageString("StatObedience"), PetAI.tStats.tObedience.iCurValue,PetAI.tStats.tObedience.iMaxValue))

    -- update queued rising text objects
    Room.UpdateRisingText()

	if (Room.m_pPetIndicator != nil) then

		if (FoxGetTickCount() >= Room.m_pPetIndicator.m_nExpireTime) then
			Room.m_pPetIndicator:Kill()
			Room.m_pPetIndicator = nil
		else
		    local x, y = Room.GetPetIndicatorPosition()
			Room.m_pPetIndicator:Paint(x, y, EPOS.BOTTOMCENTER)
		end
	end

	if (pet != nil and pet.shadow != nil) then
	    pet.shadow:SetVisible(1)
	    if (PetAI.tJumpDownInfo != nil) then
	        local x, y, z = pet:GetPosition()
	        if (y > 0) then
	            pet.shadow:SetVisible(0)
	        end
	    end
    end
end

function Room.LoadSprite(name, x, y, pos_type, z)
    local p = CxSprite()
    p:LoadSurface(name)
    p:SetZOrder(z)
    p:Link(Room.this)
    p:Paint(x, y, pos_type);

    return p
end

function Room.ToggleStats()
    if (Room.stats_dialog:IsVisible() != FALSE) then
        Room.stats_dialog:Erase()
    else
        Room.stats_dialog:Paint()
    end
end


function Room.DoHouseTextureSwitch(iTextureNum)
	Room.m_cKitchen:SetTexture("Env_xCDkitchen_0"..iTextureNum.."T.dds")
	Room.m_cBathRoom:SetTexture("Env_xCDbathroom_0"..iTextureNum.."T.dds")
	Room.m_cLivingRoom:SetTexture("Env_xCDlivingroom_0"..iTextureNum.."T.dds")
end

function Room.AddObjectToScene(filename, x, y, z)
    local o = Load3DObject(filename)
    o:SetPosition(x, y, z)
    o:SetVisible(1)
    o:Link(Room.m_cSceneManager)

    return o
end

function Room.RemoveObject(o)
    o:UnLink()
	o:UnLoad()
end


function Room.LoadAndAttach(filename, parent, bone)
    local o = Load3DObject(filename)
    o:SetVisible(1)
    o:Link(parent)
    o:SetAttachmentBoneIndex(parent:GetBoneIndex(bone))

    return o
end

function Room.OnLButtonDown(x, y)
    if (Room.m_bScolding) then

        PlaySound("spray.wav")

        Room.m_nStartSquirtBottle = FoxGetTickCount()

    elseif (not Room.m_bTransition) then
        if (GetCursor() == CURSOR_ARROW) then
            PetAI.tThinkFunc.GetAttention()
        end
    end
end

function Room.NormalizedMouse(x, y)
    local w = Room.this:GetWidth()
    local h = Room.this:GetHeight()

    -- centered screen coordinates
    local u_x = (x - w/2)
    local u_y = (y - h/2)
    local u_length = math.sqrt(u_x*u_x + u_y*u_y)

    -- centered, normalized coordinates
    u_x = u_x/u_length
    u_y = u_y/u_length
    u_length = u_length/(0.5*math.sqrt(w*w + h*h))

    return u_x, u_y, u_length
end

function Room.OnMouseMove(x, y)

    --HideToolTip()

    local treat_on_cursor =
        (Room.m_bAttentionMode
         and
         toy
         and
         PetAI.fCurOrientation == 0)

    local tweaking_bone =
        (PetAI.bIsBeingPet
         and
         PetAI.tPettingFunc.tLastBlendPattern
         and
         PetAI.tPettingFunc.tLastBlendPattern.fnTweakBone)

    if treat_on_cursor or tweaking_bone then
        local u_x, u_y, u_length = Room.NormalizedMouse(x, y)

        if treat_on_cursor then
            PetAI.tPettingFunc.TrackCursor(
                u_x,
                u_y,
                u_length,
                Room.tTweakBone)
        elseif tweaking_bone then
            PetAI.tPettingFunc.tLastBlendPattern.fnTweakBone(
                u_x,
                u_y,
                u_length,
                Room.tTweakBone)
        end
    else
        Room.tTweakBone.on = false
    end

    --
    -- treat control -- obsolete
    --
    --elseif Room.m_bAttentionMode and Room.m_bToyGrabbed then
    --    assert(toy != nil)
    --    if toy != nil then
    --        Room.PetLookAtObject(toy)
    --    end
    --    --local u_x, u_y, u_length = Room.NormalizedMouse(x, y)
    --    --PetAI.tPettingFunc.TrackCursor(u_x, u_y, Room.tTweakBone)
    --    --Room.tTweakBone.angle = u_length*Room.tTweakBone.angle_factor
    --end
    --

    -- if the camera is not already busy
    if (not Room.m_bTransition and not Room.m_bAttentionMode) then

        Room.m_nCurTilt = Room.m_nCurTilt or 0

        local left = 10
        local top = 10
        local right = Room.this:GetWidth() - 11
        local bottom = Room.this:GetHeight() - 11

        if not (x >= left and x <= right and y >= top and y <= bottom) then

            if (x < left and Room.m_nCurTilt != 1) then

                SetCursor(CURSOR_LEFT)
                g_bAllowDefaultCursor = false

                if (not Room.m_bAttentionMode) then
                    Room.m_nCurTilt = 1;
                    Room.TiltLeft()
                end

            elseif (x > right and Room.m_nCurTilt != 2) then

                SetCursor(CURSOR_RIGHT)
                g_bAllowDefaultCursor = false

                if (not Room.m_bAttentionMode) then
                    Room.m_nCurTilt = 2
                    Room.TiltRight()
                end

            elseif (y < top and Room.m_nCurTilt != 3) then

                SetCursor(CURSOR_UP)
                g_bAllowDefaultCursor = false

                if (not Room.m_bAttentionMode) then
                    Room.m_nCurTilt = 3
                    Room.TiltUp()
                end

            elseif (y > bottom and Room.m_nCurTilt != 4) then

                if (not Room.m_bAttentionMode) then
                    Room.m_nCurTilt = 4
                    Room.TiltDown()
                end
            end

        else
            if not PetAI.bIsBeingPet then
                RevertToDefaultCursor()
                g_bAllowDefaultCursor = true
            end

            if (not Room.m_bAttentionMode) then

                if (Room.m_nCurTilt != 0) then
                    Room.TiltHome()
                    Room.m_nCurTilt = 0
                end
            end
        end
    end
end

Room.OnPokePet = function(szZone)
	return(PetAI.tPettingFunc.OnPokePet(szZone))
end

Room.OnStartPetting = function(szZone, bChangeZone)
	return(PetAI.tPettingFunc.OnStartPetting(szZone, bChangeZone))
end

Room.OnEndPetting = function(szZone,iTime, bChangeZone)
	return(PetAI.tPettingFunc.OnEndPetting(szZone,iTime, bChangeZone))
end

Room.OnPushPet = function(szZone,iDirection)
	return(PetAI.tPettingFunc.OnPushPet(szZone,iDirection))
end

function ActivateTrickButton(name)
    Room.trick_frame:ActivateButton(name, Room.this, Room.this:GetWidth() / 2, Room.this:GetHeight() / 2)
end

function ShowTempRewardButton(name)
    Room.trick_frame:StopFlashingButton(name)
    Room.trick_frame:HideButton(name)

    local x, y = Room.this:GetWidth() / 2, Room.this:GetHeight() / 2
    local my_parent = Room.this
    local d

    if (not PetAI.tHelpDialogInfo[29]) then
        PetAI.tHelpDialogInfo[29] = true

        d = Room.trick_frame:CreateTipDialog(string.format(GetLanguageString("Tip_29"), GetLanguageString("TrickName_"..name)))

        my_parent = d

        d:Paint(x, y, EPOS.BOTTOMCENTER)

        x, y = d:GetWidth() / 2, d:GetHeight()
    end

    Room.m_cRewardButton:Flash(true)
    Room.m_cTempRewardButton:Link(my_parent)
    Room.m_cTempRewardButton:Paint(x, y, EPOS.TOPCENTER)
    Room.m_cTempRewardButton:Flash(true)

    if (d != nil) then
        g_cTipDialog = d
        Room.Pause()
        d:DoModal()
        Room.Resume()
        d.text:Kill()
        d:Kill()
        g_cTipDialog = nil
    end

    --DoToolTipForButton(Room.m_cTempRewardButton)
    HideToolTip()
end

function DeActivateTrickButton(name)
    Room.trick_frame:DeActivateButton(name)
    Room.m_cRewardButton:Flash(false)
    Room.m_cTempRewardButton:Erase()
    HideToolTip()
end

function SaveTrickButton(name)
    Room.trick_frame:Paint()
    Room.trick_frame:FlyButton(name)
end

function Room.DumpAllRisingText()
  if (Room.m_nTempRiser != nil) then
    Room.m_nTempRiser:Destroy()
    Room.m_nTempRiser = nil
  end
  while (table.getn(Room.RisingTextQueue) != 0) do table.remove(Room.RisingTextQueue) end
end

function Room.UpdateRisingText()

  -- if the current riser is nil or finished, and the queue is not empty...
  if ((Room.m_nTempRiser == nil) or (Room.m_nTempRiser:IsDestroyed() == 1)) and (table.getn(Room.RisingTextQueue) > 0) then

    -- grab next riser from the front of the queue
    local tNextRiser = Room.RisingTextQueue[1]

    local x,y

    if (Room.stats_dialog:IsVisible() != 0) then
      x,y = Room.stats_dialog:GetPosition(EPOS.TOPLEFT)
      y = y-25
    else
      x,y = Room.m_cStatsButton:GetPosition(EPOS.TOPLEFT)
      y = y - 15
    end

    -- launch new rising text element and play sfx
    Room.m_nTempRiser = RisingText()
    Room.m_tHouseSFX[tNextRiser.soundfile]:Play()
    Room.m_nTempRiser:Make(tNextRiser.text,GetAppWidth()-8,y, Room.this, g_nFontArial, 255, 0, 255, 0, 18, 100, -1, EPOS.TOPRIGHT)

    -- remove the launched riser from the queue
    table.remove(Room.RisingTextQueue,1)
  end
end

function Room.EarnStat(szStat)

  local szText = "+"..GetLanguageString("Stat"..szStat)

  -- if the active rising text object matches the new string to be added, return immediately
  if (Room.m_nTempRiser != nil) and (Room.m_nTempRiser:IsDestroyed() != 1) and (Room.m_nTempRiser:GetText() == szText) then return end

  -- check queue for duplicates, return immediately if found
  for i,v in ipairs(Room.RisingTextQueue) do if (v.text == szText) then return end end

  -- load the new stat message into the queue
  table.insert(Room.RisingTextQueue,{text = szText, soundfile = "wavStatIncrease"})
end

function Room.EarnMoney(nMoney)
  SetPlayerMoney(GetPlayerMoney() + nMoney)

  -- check queue for any waiting money messages
  for i,v in ipairs(Room.RisingTextQueue) do

    -- if a money message is found...
    if (string.find(v.text,"+$") != nil) then

      -- splice out numeric amount, add current message's value, and reset message string
      strint.gsub(v.text,"+$","")
      v.text = v.text + nMoney
      v.text = "+$"..nMoney

      -- return immediately, having modified the queue message
      return
    end
  end

  -- if no money message is found, insert a new message into the queue
  table.insert(Room.RisingTextQueue,{text = "+$"..nMoney, soundfile = "wavMoneyIncrease"})
end

function Room.DoSnooz()

    if (gLanguage == "English") then

        local x, y = Room.GetPetIndicatorPosition()

        local o = RisingText()
        o:Make("Zzzz", x, y, Room.this, g_nFontArial, 255, 0, 255, 255, 18, 100, -1, EPOS.TOPCENTER)

        Room.m_pSnoozText = o
    end
end


function Room.GetPetIndicatorPosition()

	-- Get offset from head bone
	local xx, yy, zz = pet:GetBonePosition(pet:GetBoneIndex("-tag Hat01"))

	yy = yy + 5

 	local x, y = GetScreenPosition(xx, yy, zz)

 	return x, y
end

function Room.KillPetIndicator()

    if (Room.m_pPetIndicator != nil) then
        Room.m_pPetIndicator:Kill()
        Room.m_pPetIndicator = nil
    end
end


function Room.DoPetIndicator(name, expire_time)

    Room.KillPetIndicator()

    if (expire_time == nil) then
    	expire_time = 4000
   	end

    local x, y = Room.GetPetIndicatorPosition()

    Room.m_pPetIndicator = Room.LoadSprite(name, x, y, EPOS.BOTTOMCENTER, ZORDER.HINDMOST)
    Room.m_pPetIndicator.m_nExpireTime = FoxGetTickCount() + expire_time
end

function Room.DoLightBulb()
	Room.DoPetIndicator("Efx_xCDlightbulb_01T.tga", 4000)
end

function Room.DoQuestionMark()
	Room.DoPetIndicator("Efx_xCDquestionmark_01T.tga", 4000)
end

function Room.DoFrownIcon()
	Room.DoPetIndicator("Efx_xCDfrownface_01T.tga", 4000)
end

function Room.HighlightFoodBowl()
	local x, y = GetScreenPosition(Room.m_cFoodBowl:GetPosition())

	for i = 1, 10, 1 do
		DoGlitter("sparkles", x + math.random(20) - 45, y + math.random(20) - 45, FALSE, -1, 1)
	end

	-- TODO: Show food in the food bowl?

	PlaySound("bowl.wav")
end

function Room.HighlightWaterBowl()
	local x, y = GetScreenPosition(Room.m_cWaterBowl:GetPosition())

	for i = 1, 10, 1 do
		DoGlitter("sparkles", x + math.random(20) - 45, y + math.random(20) - 47, FALSE, -1, 1)
	end

	-- TODO: Show water in the water bowl?

	PlaySound("bowl.wav")
end

function Room.ToggleHouse()

    Room.m_bEnvironHidden = not Room.m_bEnvironHidden

    if (Room.m_bEnvironHidden) then
        Room.m_cKitchen:SetVisible(FALSE)
        Room.m_cBathRoom:SetVisible(FALSE)
        Room.m_cLivingRoom:SetVisible(FALSE)
        Room.m_cBackyard:SetVisible(FALSE)
    else
        Room.m_cKitchen:SetVisible(TRUE)
        Room.m_cBathRoom:SetVisible(TRUE)
        Room.m_cLivingRoom:SetVisible(TRUE)
        Room.m_cBackyard:SetVisible(TRUE)
    end
end


function CreateAndGrabToy(filename, texture, name)

    PetAI.tThinkFunc.KillHandheld()
    UnGrabToy()
    RemoveToyFromPhysics()

    if (toy != nil) then
        toy:UnLoad()
        toy = nil
    end

    toy = C3DPhysicsObject()
    toy = Load3DObject(filename, toy)

    if (name != nil and name != '') then
        toy:SetName(name)
    end

    if Room.m_nCurRoom == 1 then
        --backyard
        toy:EnableCollisions()
    else
        toy:DisableCollisions()
    end

    if (texture != nil) then
        toy:SetTexture(toy.data.available_textures[texture])

        if string.find(string.lower(toy:GetName()), "jingle") then
            toy:SetHasAlpha(TRUE)
        end
    end

    MyGrabToy(toy)
end

function ToyIsFetchable(toy)
  return(
    (string.find(toy:GetName(),"ball") != nil) or
    (string.find(toy:GetName(),"flyingdisc") != nil) or
    (string.find(toy:GetName(),"Ball") != nil) or
    (string.find(toy:GetName(),"Frisbee") != nil))
end

function MyGrabToy(t)

  -- play toy-specific grab sfx
	if (t:GetName() == "SqueekyDuck") then PetAI.tSoundFX.wavSqueakyDuck:Play()
	elseif (t:GetName() == "JingleBall") then PetAI.tSoundFX.wavJingleBall:Play() end

  if (ToyIsFetchable(t)) then
		PetAI.tThinkFunc.LoadToyFetchTrick()

		if (Room.m_cInvIcon_btn != nil) then
            Room.m_cInvIcon_btn:SetEffects(BLT_EFFECTS.BLT_INVISIBLE)
        end

	elseif (toy:GetName() != "Treat") then
    LogInfo("Loading Play With Toy Trick for "..toy:GetName())
	  PetAI.tThinkFunc.LoadToyPlayTrick()
	end

    GrabToy(t)
end

function KillToy(bEatTreat)
    --LogInfo("KillToy()")

    if (PetAI.tActiveInformalTrick != nil) then
        if (not (PetAI.tActiveInformalTrick.OnTerminate == nil)) then PetAI.tActiveInformalTrick.OnTerminate() end
        PetAI.tActiveInformalTrick = nil
    end

    UnRegisterToy()

    if (toy != nil) then

        -- Need to put treat back (unless they actually ate it)
        --
        if (not bEatTreat and toy:GetName() == "Treat") then
            gLastTreatTaken = gLastTreatTaken or "treat_01"
            AddItemToInventory("Food", gLastTreatTaken)
            AddOneTreat(gLastTreatTaken)
            Room.UpdateRewardButton()
        end
        toy:UnLoad()
        toy = nil
    end
end


function NewHighlight(filename, button, x, y)

    local p = CxSprite()

    button:SetClip(FALSE)

    p:LoadSurface(filename, 5)
    p:Link(button)

    if (x == nil or y == nil) then
      p:Center()
    else
      p:Paint(x,y)
    end

    p:Erase()

    local a = CxAnimation()
    a:SetSprite(p)
    a.sprite = p

    local action = {
        flags = 0,
        framerate = 10,
        loops = 99999,
    }

    a:AddPathToTail(action)

    return(a)
end

--
-- This is a table read directly by the C++ pre-rendering step.
--
Room.tTweakBone = {
    --if false, ignore this functionality completely
    on = false,

    --label for the bone (use Granny Viewer)
    name = "Bip01 Head",

    --freakish bone stretch
    position = {
	x = 0,
	y = 0,
	z = 0,
    },

    --rotation axis
    axis = {
	x = 1,
	y = 0,
	z = 0,
    },

    -- quaternion angular velocity factor
    qav_factor = 1,
    qav_factor_min = 1,
    qav_factor_max = 1,

    --rotation angle, in degrees
    angle = 0,
}

Room.tPetLookAtWhilePetting = {
    on = false,
    bone = "Bip01 Head",
    axis = {
        x = 1,
        y = 0,
        z = 0,
    },

    angle = 0,
}

Room.tPetLookAt = {
    -- enable/disable
    on = false,

    -- where to look
    target = {
        x = 0,
        y = 0,
        z = 0,
    },

    -- bone connector
    bone = "Bip01 Head",

    -- local pose tweak
    tweak = {
        axis = {
            x = 0,
            y = 1,
            z = 0,
        },

        angle = 45,
    },

    -- inverse kinematics
    link_count = 1,
    iteration_count = 3,
}

function Room.PetLookAtPoint(x, y, z)
    Room.tPetLookAt.on = true
    Room.tPetLookAt.target.x = x
    Room.tPetLookAt.target.y = y
    Room.tPetLookAt.target.z = z
end

function Room.PetLookAtObject(object3d)
    local x, y, z = object3d:GetPosition()
    Room.PetLookAtPoint(x, y, z)
end

function Room.PetLookAtTag(parent, tag)
    local x, y, z = parent:GetBonePosition(parent:GetBoneIndex(tag))
    Room.PetLookAtPoint(x, y, z)
end

function Room.PetLookAtStop()
    Room.tPetLookAt.on = false
end

function Room.NextFireFrame()

    if (Room.m_cFire != nil) then

        Room.m_cFire.texture = Room.m_cFire.texture or 1

        Room.m_cFire.texture = math.mod(Room.m_cFire.texture, table.getn(Room.m_cFire.data.available_textures)) + 1

        Room.m_cFire:SetTexture(Room.m_cFire.data.available_textures[Room.m_cFire.texture])
    end
end

function Room.OnClickedObject(name, bIsPet)
    LogInfo("Clicked on "..name)

    if (bIsPet) then

        if (Room.m_bScolding) then PetAI.tThinkFunc.Scold() end

    elseif (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.IDLE_MODE) or
           PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.EATING_MODE) or
           PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.DRINKING_MODE) or
           PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.INFORMAL_TRICK)) then


        if (toy != nil and name == toy:GetName()) then
            ToggleToy()

        elseif (Room.m_nCurRoom == Room.BACKYARD) then

            if (name == "Dog House") then
                Room.RemoveToy()
                PetAI.tThinkFunc.ProcessClickableObject(name)
            end

        elseif (Room.m_nCurRoom == Room.LIVINGROOM) then

            if (name == "Fireplace") then
                if (Room.m_bIsFireplaceOn) then
                    if (Room.firesound != nil) then
                        Room.firesound:Release()
                        Room.firesound = nil
                    end

                    Room.m_bIsFireplaceOn = false

                    if (Room.m_nFireChannel != nil) then
                        DestroyChannel(Room.m_nFireChannel)
                        Room.m_nFireChannel = nil
                    end
                    Room.m_cFire:SetVisible(FALSE)
                else
                    Room.firesound = Room.firesound or CreateSound{filename = "fireloop.wav", loops = 999999, volume = 127, position = {0, 116, 203}, falloff_distance = 400, }

                    Room.firesound:Play()

                    Room.m_bIsFireplaceOn = true
                    Room.m_cFire:SetVisible(TRUE)
                    Room.m_nFireChannel = CreateChannel()
                    DoLuaTimerEvent(99999000, 50, "Room.NextFireFrame()", Room.m_nFireChannel)
                end

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Scratching Post") then

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Pet Bed") then

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Sofa") then

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Coffee Table") then

                PetAI.tThinkFunc.ProcessClickableObject(name)

            end

        elseif (Room.m_nCurRoom == Room.KITCHEN) then

            if (name == "BoomBox") then
                radio.NextStation()

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Refrigerator") then

                local fDistance = PetAI.tPathFunc.DistanceBetweenTwoPoints({pet:GetPosition()},{Room.m_cRefrigerator:GetPosition()})

                if (fDistance > 100.0) then
                  if (Room.m_bIsFridgeOpen) then
                   local fTime = 1
                   Room.m_cRefrigerator:BlendOut("Open",.25,1,1)
                   Room.m_tHouseSFX.wavFridgeClose:Play()
                   Room.m_bIsFridgeOpen = false
                 else
                   local fTime = 1
                   Room.m_cRefrigerator:BlendIn("Open",.25,1,0)
                   Room.m_tHouseSFX.wavFridgeOpen:Play()
                   Room.m_bIsFridgeOpen = true
                 end
                end

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Kitchen Faucet") then

                Room.KitchenFaucetChannel = Room.KitchenFaucetChannel or EventChannelManager.CreateChannel()

                if (IsChannelEmpty(Room.KitchenFaucetChannel)) then
                    DoLuaEvent("Room.m_cKitchenFaucetWater:SetVisible(1)", Room.KitchenFaucetChannel)
                    DoLuaEvent("Room.m_cKitchenFaucetWater:BlendIn('PourOut',0.25,-1,1)", Room.KitchenFaucetChannel)
                    DoEvent("System.PlaySound(-1, sink.wav)", Room.KitchenFaucetChannel)
                    DoLuaEvent("Room.m_cKitchenFaucetWater:SetVisible(0)", Room.KitchenFaucetChannel)
                    DoLuaEvent("DoLuaEvent('EventChannelManager.DestroyChannel("..Room.KitchenFaucetChannel..") Room.KitchenFaucetChannel = nil', GetSystemChannel())", Room.KitchenFaucetChannel)
                end

                PetAI.tThinkFunc.ProcessClickableObject(name)
            end

        elseif (Room.m_nCurRoom == Room.BATHROOM) then

            if (name == "Cat Perch") then

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Bathroom Faucet") then

                Room.BathroomFaucetChannel = Room.BathroomFaucetChannel or EventChannelManager.CreateChannel()

                if (IsChannelEmpty(Room.BathroomFaucetChannel)) then

                    DoLuaEvent("Room.m_cBathroomFaucetWater:SetVisible(1)", Room.BathroomFaucetChannel)
                    DoLuaEvent("Room.m_cBathroomFaucetWater:BlendIn('PourOut',0.25,-1,1)", Room.BathroomFaucetChannel)
                    DoEvent("System.PlaySound(-1, sink.wav)", Room.BathroomFaucetChannel)
                    DoLuaEvent("Room.m_cBathroomFaucetWater:SetVisible(0)", Room.BathroomFaucetChannel)
                    DoLuaEvent("DoLuaEvent('EventChannelManager.DestroyChannel("..Room.BathroomFaucetChannel..") Room.BathroomFaucetChannel = nil', GetSystemChannel())", Room.BathroomFaucetChannel)
                end

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Toilet") then
                Room.m_tHouseSFX.wavToilet:Play()

                PetAI.tThinkFunc.ProcessClickableObject(name)

            elseif (name == "Tub") and (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE)) then

                Room.TubFaucetChannel = Room.TubFaucetChannel or EventChannelManager.CreateChannel()

                if (IsChannelEmpty(Room.TubFaucetChannel)) then

                    DoLuaEvent("Room.m_cTubFaucetWater:SetVisible(1)", Room.TubFaucetChannel)
                    DoLuaEvent("Room.m_cTubFaucetWater:BlendIn('PourOut',0.25,-1,1)", Room.TubFaucetChannel)
                    DoEvent("System.PlaySound(-1, tub.wav)", Room.TubFaucetChannel)
                    DoLuaEvent("Room.m_cTubFaucetWater:SetVisible(0)", Room.TubFaucetChannel)
                    DoLuaEvent("DoLuaEvent('EventChannelManager.DestroyChannel("..Room.TubFaucetChannel..") Room.TubFaucetChannel = nil', GetSystemChannel())", Room.TubFaucetChannel)
                end

                PetAI.tThinkFunc.ProcessClickableObject(name)
            end
        end

        -- Anywhere
        --
        if (name == "Poop") then
            cPoo:UnLoad()
            cPoo = nil
        elseif (name == "Pee Stain") then
            cPeeStain:UnLoad()
            cPeeStain = nil
        end
    end
end


function Room.SetInvIcon(filename, onclick)
    if (Room.m_cInvIcon_btn != nil) then
        Room.m_cInvIcon_btn:Kill()
    end

    Room.hud_inv:Erase()

    if (filename != nil) then
        Room.m_cInvIcon_btn = NewLuaButton({name = "InvIcon", file = filename, position = {0, 0}, parent = Room.hud_inv, OnClick = onclick, })
        Room.m_cInvIcon_btn:Center()

        Room.hud_inv:Paint()
    else
        if (Room.m_bScolding) then
            Room.m_bScolding = false

            PetAI.tThinkFunc.KillHandheld()
        end
    end
end

function Room.EndScolding()
    Room.m_bScolding = false

    PetAI.tThinkFunc.KillHandheld()

    Room.SetInvIcon(nil)
end


function Room.ToggleScolding()
    Room.m_bScolding = not Room.m_bScolding

    Room.SetInvIcon("But_xCDinvsquirtbottle_01T.tga", "Room.ToggleScolding()")

    if (Room.m_bScolding) then
        local o = PetAI.tThinkFunc.CreateHandheld('Objects/obj_squirtbottle_01.lua')

        --if o != nil then
        --    o:SetOffset(0, -10, -5)
        --end

        --SetCursorEx(CURSOR_SPRAY)
        Room.m_nStartSquirtBottle = FoxGetTickCount()

        if (Room.m_cInvIcon_btn != nil) then
            Room.m_cInvIcon_btn:SetEffects(BLT_EFFECTS.BLT_INVISIBLE)
        end

    else

        PetAI.tThinkFunc.KillHandheld()
        --SetCursorEx(CURSOR_ARROW)

        if (Room.m_cInvIcon_btn != nil) then
            Room.m_cInvIcon_btn:SetEffects(BLT_EFFECTS.BLT_EFFECT_NONE)
        end
    end
end

function Room.RemoveToy()
    KillToy()
    Room.SetInvIcon(nil)
end

function Room.IconizeToy()

    if (toy != nil) then
        ToggleToy()

    elseif (Room.m_bScolding) then
        Room.ToggleScolding()
    end
end

function Room.OnGrabToy()
    if Room.m_bAttentionMode then
        assert(toy != nil)
        if toy != nil then
            Room.PetLookAtObject(toy)
            Room.m_bToyGrabbed = true
        end
    end
end

function Room.OnUnGrabToy()
    Room.PetLookAtStop()
    Room.m_bToyGrabbed = false
end


function Room.OnPurchase(tab, item)
    AddItemToInventory(tab, item)

    if (item == "treats_01" or item == "treats_02" or item == "treats_03") then
        AddOneTreat(item)
        Room.UpdateRewardButton()
    end
end

function Room.UpdateRewardButton()
	-- Change to Treat button when there are treats, or a Heart Button when no more treats
	local nTotal = 0
	for k, v in pairs(player.m_cTreats) do
	    nTotal = nTotal + v
	end
	if (nTotal == 0) then
	    Room.m_cRewardButton:LoadSurface("But_xCDlove_01T.tga")
	    Room.m_cTempRewardButton:LoadSurface("But_xCDlove_01T.tga")
    else
        local DorC = "C"
        if (fox.app.GetAppName() == "Dogz") then
            DorC = "D"
        end

        Room.m_cRewardButton:LoadSurface("But_x"..DorC.."treat_01T.tga")
        Room.m_cTempRewardButton:LoadSurface("But_x"..DorC.."treat_01T.tga")
    end
end


function Room.DisableUI()
    Room.trick_button:Disable()
    Room.trick_frame:Disable()
    Room.m_cInvButton:Disable()
    Room.m_cStoreButton:Disable()
    Room.m_cRewardButton:Disable()
    Room.m_cTempRewardButton:Disable()
    Room.m_cScoldButton:Disable()
    Room.m_cExitZoomMode:Disable()
    Room.m_cStatsButton:Disable()
    --Room.m_cOptionsButton:Disable()
    Room.m_cCameraButton:Disable()
    Room.m_cTalentMenuButton:Disable()
    Room.m_cReturnToHouseButton:Disable()

    if (Room.m_cInvIcon_btn != nil) then
        Room.m_cInvIcon_btn:Disable()
    end
end

function Room.EnableUI()
    Room.trick_button:Enable()
    Room.trick_frame:Enable()
    Room.m_cInvButton:Enable()
    Room.m_cStoreButton:Enable()
    Room.m_cRewardButton:Enable()
    Room.m_cTempRewardButton:Enable()
    Room.m_cScoldButton:Enable()
    Room.m_cExitZoomMode:Enable()
    Room.m_cStatsButton:Enable()
    --Room.m_cOptionsButton:Enable()
    Room.m_cCameraButton:Enable()
    Room.m_cTalentMenuButton:Enable()
    Room.m_cReturnToHouseButton:Enable()

    if (Room.m_cInvIcon_btn != nil) then
        Room.m_cInvIcon_btn:Enable()
    end
end

function Room.TreatPet()
    KillToy(true)

    -- TODO: If pet is idle then blend in the Pet eat animation, otherwise, sound only
    PetAI.tThinkFunc.Reward(true)

    --PlaySound("eating.wav")

    -- TODO: Pet's Love goes up?

    Room.UpdateRewardButton()
end

function Room.PutTreatBack()
    KillToy()
end

function Room.DimScene()
    SetGlobalAmbientLight(127, 127, 127, 127)
    Room.m_cMainLight:SetAmbient(0, 0, 0, 0)
    Room.m_cMainLight:SetDiffuse(0, 0, 0, 0)
end

function Room.UnDimScene()
    SetGlobalAmbientLight(255, 255, 255, 255)
    Room.m_cMainLight:SetAmbient(0, 0, 0, 0)
    Room.m_cMainLight:SetDiffuse(255, 255, 255, 255)
end
