radio = {}

radio.MAX_STATIONS = 4

function radio.NextStation()
    radio.m_nCurStation = radio.m_nCurStation or 0

    radio.m_nEventChannel = radio.m_nEventChannel or CreateChannel()

    radio.m_nCurStation = math.mod(radio.m_nCurStation + 1, radio.MAX_STATIONS + 1)

    FlushChannel(radio.m_nEventChannel)

    PlaySound("click.wav")

    if (radio.m_nCurStation == 0) then
        radio.song_list = nil
        Room.m_cBoomBox:SetTextureIndex(1)
    else
        radio.song_list = FoxBuildFileList("<InstallPath>MUSIC/STATION"..radio.m_nCurStation.."/*.mp3", 0, false)
        radio.NextSong()
        Room.m_cBoomBox:SetTextureIndex(2)
    end
end

function radio.NextSong()
    if (radio.song_list != nil and table.getn(radio.song_list) > 0) then

        if (radio.m_nCurSong == nil) then
            radio.m_nCurSong = math.random(table.getn(radio.song_list))
        else

            radio.m_nCurSong = radio.m_nCurSong + 1
            if (radio.m_nCurSong > table.getn(radio.song_list)) then
                radio.m_nCurSong = 1
            end
        end

        if (string.find(radio.song_list[radio.m_nCurSong], "%)") == nil and string.find(radio.song_list[radio.m_nCurSong], ",") == nil and string.find(radio.song_list[radio.m_nCurSong], "%%") == nil) then
            DoEvent("System.PlaySound(-1, "..radio.song_list[radio.m_nCurSong]..")", radio.m_nEventChannel)
        end
        DoLuaEvent("radio.NextSong()", radio.m_nEventChannel)
    end
end

function radio.ShutDown()
    if (radio.m_nEventChannel != nil) then
        DestroyChannel(radio.m_nEventChannel)
        radio.m_nEventChannel = nil
    end

    radio.m_nCurStation = nil
    radio.song_list = nil
    radio.m_nCurSong = nil

    Room.m_cBoomBox:SetTextureIndex(1)
end

function radio.Pause()
    if (radio.m_nEventChannel != nil) then
        PauseChannel(radio.m_nEventChannel)
    end
end

function radio.Resume()
    if (radio.m_nEventChannel != nil) then
        ResumeChannel(radio.m_nEventChannel)
    end
end