local function GetBounds(t)
    local left = 9999
    local top = 9999
    local right = 0
    local bottom = 0

    for i, v in ipairs(t) do
        local x, y = v:GetPosition()

        left = math.min(left, x)
        top = math.min(top, y)

        local cx, cy = v:GetSize()

        right = math.max(right, x + cx - 1)
        bottom = math.max(bottom, y + cy - 1)
    end

    return left, top, right - left + 1, bottom - top + 1
end

local function MakeToolTipHelper(name, t1, t2, parent, kind)
    local o = CToolTipHelper()

    o:Create(GetBounds{t1, t2})
    o:Link(parent)
    o:SetOnMouseEnter("local x, y = Room.stats_dialog.tooltip['"..name.."']:GetGlobalPosition(EPOS.TOPCENTER) ShowToolTip(x, y, GetStatTip('"..name.."', '"..kind.."'))")
    o:SetOnMouseExit("HideToolTip()")
    o:Paint()

    return(o)
end

function GetStatTip(name, kind)

    local n = PetAI["t"..kind.."s"]["t"..name].iCurValue
    local postfix = "Green"

    if (kind == "Stat") then
        postfix = "Tip"
    else

        if (n <= 10) then
            postfix  = "Red"

        elseif (n <= 40) then
            postfix  = "Yellow"
        end
    end

    return(GetLanguageString(""..kind..""..name..""..postfix))
end

local SPR_METER_WHITE	=	"COMMON/PAD_meter_max.tga"
local SPR_METER_YELLOW = "COMMON/PAD_meter_yellow.tga"
local SPR_METER_RED	=	"COMMON/PAD_meter_red.tga"
local SPR_METER_GREEN	=	"COMMON/PAD_meter_green.tga"
local SPR_METER_BLUE = "COMMON/PAD_meter_blue.tga"
local SPR_METER_ORANGE = "COMMON/PAD_meter_orange.tga"
local STAT_MAX = 100

local d = CStatsDialog()
d:Create(0, 0, 220, 229)
d:SetZOrder(ZORDER.BACKGROUND)
d:Link(Room.this)
d:Paint(Room.this:GetWidth() - 1, Room.this:GetHeight() - 20, EPOS.BOTTOMRIGHT)

d.tab1 = CStatusTab()
d.tab1:LoadSurface("But_xCDstatustabneeds_01T.tga")
d.tab1:SetZOrder(ZORDER.HINDMOST)
d.tab1:Link(d)
d.tab1:Paint(0, 0)

d.tab2 = CStatusTab()
d.tab2:LoadSurface("But_xCDstatustabstatus_01T.tga")
d.tab2:SetZOrder(ZORDER.HINDMOST)
d.tab2:Link(d)
d.tab2:Paint(0, 0)

d.tab3 = CStatusTab()
d.tab3:LoadSurface("But_xCDstatustabtrick_01T.tga")
d.tab3:SetZOrder(ZORDER.HINDMOST)
d.tab3:Link(d)
d.tab3:Paint(0, 0)

d.tooltip = {}

d.title1 = Text{ text = GetLanguageString("NeedsTitle"), pointsize = 16, position = { 40, 10 }, size = { 160, 30 }, parent = d.tab1, color = 0x00000000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER, }
d.title2 = Text{ text = GetLanguageString("StatsTitle"), pointsize = 16, position = { 40, 10 }, size = { 160, 30 }, parent = d.tab2, color = 0x00000000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER, }

local kMaxMeter = CxSprite()

-- load meter asset to check sizing specifications
kMaxMeter:LoadSurface(SPR_METER_WHITE)

local x, y = 50, 55
local dx, dy = kMaxMeter:GetWidth(), kMaxMeter:GetHeight()

-- setup hunger meter
d.m_kHungerMeter = CMeter()
d.m_kHungerMeter:Create(x, y, dx, dy)
d.m_kHungerMeter:SetValueBar(SPR_METER_BLUE)
d.m_kHungerMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kHungerMeter:SetMaxValue(PetAI.tNeeds.tHunger.iMaxValue)
d.m_kHungerMeter:SetValue(PetAI.tNeeds.tHunger.iCurValue)
d.m_kHungerMeter:Link(d.tab1)
d.m_kHungerMeter:Paint()

d.m_kHungerLabel = CxDrawText()
d.m_kHungerLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kHungerLabel:SetFont(g_nFontArial)
d.m_kHungerLabel:SetBkColor(0)
d.m_kHungerLabel:SetString(GetLanguageString("NeedHunger"))
d.m_kHungerLabel:SetDefaultDepth(32)
d.m_kHungerLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kHungerLabel:Link(d.tab1)
d.m_kHungerLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Hunger"] = MakeToolTipHelper("Hunger", d.m_kHungerLabel, d.m_kHungerMeter, d.tab1, "Need")

-- setup intelligence meter
d.m_kIntelligenceMeter = CMeter()
d.m_kIntelligenceMeter:Create(x, y, dx, dy)
d.m_kIntelligenceMeter:SetValueBar(SPR_METER_BLUE)
d.m_kIntelligenceMeter:SetMidValueBar(SPR_METER_RED)
d.m_kIntelligenceMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kIntelligenceMeter:SetMaxValue(STAT_MAX)
d.m_kIntelligenceMeter:SetMidValue(PetAI.tStats.tIntelligence.iMaxValue)
d.m_kIntelligenceMeter:SetValue(PetAI.tStats.tIntelligence.iCurValue)
d.m_kIntelligenceMeter:Link(d.tab2)
d.m_kIntelligenceMeter:Paint()

d.m_kIntelligenceLabel = CxDrawText()
d.m_kIntelligenceLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kIntelligenceLabel:SetFont(g_nFontArial)
d.m_kIntelligenceLabel:SetBkColor(0)
d.m_kIntelligenceLabel:SetString(GetLanguageString("StatIntelligence"))
d.m_kIntelligenceLabel:SetDefaultDepth(32)
d.m_kIntelligenceLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kIntelligenceLabel:Link(d.tab2)
d.m_kIntelligenceLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Intelligence"] = MakeToolTipHelper("Intelligence", d.m_kIntelligenceLabel, d.m_kIntelligenceMeter, d.tab2, "Stat")

-- update y position for next meter
y = y + dy + 20;

-- setup thirst meter
d.m_kThirstMeter = CMeter()
d.m_kThirstMeter:Create(x, y, dx, dy)
d.m_kThirstMeter:SetValueBar(SPR_METER_BLUE)
d.m_kThirstMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kThirstMeter:SetMaxValue(PetAI.tNeeds.tThirst.iMaxValue)
d.m_kThirstMeter:SetValue(PetAI.tNeeds.tThirst.iCurValue)
d.m_kThirstMeter:Link(d.tab1)
d.m_kThirstMeter:Paint()

d.m_kThirstLabel = CxDrawText()
d.m_kThirstLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kThirstLabel:SetFont(g_nFontArial)
d.m_kThirstLabel:SetBkColor(0)
d.m_kThirstLabel:SetString(GetLanguageString("NeedThirst"))
d.m_kThirstLabel:SetDefaultDepth(32)
d.m_kThirstLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kThirstLabel:Link(d.tab1)
d.m_kThirstLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Thirst"] = MakeToolTipHelper("Thirst", d.m_kThirstLabel, d.m_kThirstMeter, d.tab1, "Need")

-- setup stamina meter
d.m_kStaminaMeter = CMeter()
d.m_kStaminaMeter:Create(x, y, dx, dy)
d.m_kStaminaMeter:SetValueBar(SPR_METER_BLUE)
d.m_kStaminaMeter:SetMidValueBar(SPR_METER_RED)
d.m_kStaminaMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kStaminaMeter:SetMaxValue(STAT_MAX)
d.m_kStaminaMeter:SetMidValue(PetAI.tStats.tStamina.iMaxValue)
d.m_kStaminaMeter:SetValue(PetAI.tStats.tStamina.iCurValue)
d.m_kStaminaMeter:Link(d.tab2)
d.m_kStaminaMeter:Paint()

d.m_kStaminaLabel = CxDrawText()
d.m_kStaminaLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kStaminaLabel:SetFont(g_nFontArial)
d.m_kStaminaLabel:SetBkColor(0)
d.m_kStaminaLabel:SetString(GetLanguageString("StatStamina"))
d.m_kStaminaLabel:SetDefaultDepth(32)
d.m_kStaminaLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kStaminaLabel:Link(d.tab2)
d.m_kStaminaLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Stamina"] = MakeToolTipHelper("Stamina", d.m_kStaminaLabel, d.m_kStaminaMeter, d.tab2, "Stat")

y = y + dy + 20;

-- setup love meter
d.m_kLoveMeter = CMeter()
d.m_kLoveMeter:Create(x, y, dx, dy)
d.m_kLoveMeter:SetValueBar(SPR_METER_BLUE)
d.m_kLoveMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kLoveMeter:SetMaxValue(PetAI.tNeeds.tLove.iMaxValue)
d.m_kLoveMeter:SetValue(PetAI.tNeeds.tLove.iCurValue)
d.m_kLoveMeter:Link(d.tab1)
d.m_kLoveMeter:Paint()

d.m_kLoveLabel = CxDrawText()
d.m_kLoveLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kLoveLabel:SetFont(g_nFontArial)
d.m_kLoveLabel:SetBkColor(0)
d.m_kLoveLabel:SetString(GetLanguageString("NeedLove"))
d.m_kLoveLabel:SetDefaultDepth(32)
d.m_kLoveLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kLoveLabel:Link(d.tab1)
d.m_kLoveLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Love"] = MakeToolTipHelper("Love", d.m_kLoveLabel, d.m_kLoveMeter, d.tab1, "Need")

-- setup agility meter
d.m_kAgilityMeter = CMeter()
d.m_kAgilityMeter:Create(x, y, dx, dy)
d.m_kAgilityMeter:SetValueBar(SPR_METER_BLUE)
d.m_kAgilityMeter:SetMidValueBar(SPR_METER_RED)
d.m_kAgilityMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kAgilityMeter:SetMaxValue(STAT_MAX)
d.m_kAgilityMeter:SetMidValue(PetAI.tStats.tAgility.iMaxValue)
d.m_kAgilityMeter:SetValue(PetAI.tStats.tAgility.iCurValue)
d.m_kAgilityMeter:Link(d.tab2)
d.m_kAgilityMeter:Paint()

d.m_kAgilityLabel = CxDrawText()
d.m_kAgilityLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kAgilityLabel:SetFont(g_nFontArial)
d.m_kAgilityLabel:SetBkColor(0)
d.m_kAgilityLabel:SetString(GetLanguageString("StatAgility"))
d.m_kAgilityLabel:SetDefaultDepth(32)
d.m_kAgilityLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kAgilityLabel:Link(d.tab2)
d.m_kAgilityLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Agility"] = MakeToolTipHelper("Agility", d.m_kAgilityLabel, d.m_kAgilityMeter, d.tab2, "Stat")

-- update y position for next meter
y = y + dy + 20;

-- setup alertness meter
d.m_kAlertnessMeter = CMeter()
d.m_kAlertnessMeter:Create(x, y, dx, dy)
d.m_kAlertnessMeter:SetValueBar(SPR_METER_BLUE)
d.m_kAlertnessMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kAlertnessMeter:SetMaxValue(PetAI.tNeeds.tAlertness.iMaxValue)
d.m_kAlertnessMeter:SetValue(PetAI.tNeeds.tAlertness.iCurValue)
d.m_kAlertnessMeter:Link(d.tab1)
d.m_kAlertnessMeter:Paint()

d.m_kAlertnessLabel = CxDrawText()
d.m_kAlertnessLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kAlertnessLabel:SetFont(g_nFontArial)
d.m_kAlertnessLabel:SetBkColor(0)
d.m_kAlertnessLabel:SetString(GetLanguageString("NeedAlertness"))
d.m_kAlertnessLabel:SetDefaultDepth(32)
d.m_kAlertnessLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kAlertnessLabel:Link(d.tab1)
d.m_kAlertnessLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Alertness"] = MakeToolTipHelper("Alertness", d.m_kAlertnessLabel, d.m_kAlertnessMeter, d.tab1, "Need")

-- setup obedience meter
d.m_kObedienceMeter = CMeter()
d.m_kObedienceMeter:Create(x, y, dx, dy)
d.m_kObedienceMeter:SetValueBar(SPR_METER_BLUE)
d.m_kObedienceMeter:SetMidValueBar(SPR_METER_RED)
d.m_kObedienceMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kObedienceMeter:SetMaxValue(STAT_MAX)
d.m_kObedienceMeter:SetMidValue(PetAI.tStats.tObedience.iMaxValue)
d.m_kObedienceMeter:SetValue(PetAI.tStats.tObedience.iCurValue)
d.m_kObedienceMeter:Link(d.tab2)
d.m_kObedienceMeter:Paint()

d.m_kObedienceLabel = CxDrawText()
d.m_kObedienceLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kObedienceLabel:SetFont(g_nFontArial)
d.m_kObedienceLabel:SetBkColor(0)
d.m_kObedienceLabel:SetString(GetLanguageString("StatObedience"))
d.m_kObedienceLabel:SetDefaultDepth(32)
d.m_kObedienceLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kObedienceLabel:Link(d.tab2)
d.m_kObedienceLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Obedience"] = MakeToolTipHelper("Obedience", d.m_kObedienceLabel, d.m_kObedienceMeter, d.tab2, "Stat")

-- update y position for next meter
y = y + dy + 20;

-- setup grooming meter
d.m_kGroomingMeter = CMeter()
d.m_kGroomingMeter:Create(x, y, dx, dy)
d.m_kGroomingMeter:SetValueBar(SPR_METER_BLUE)
d.m_kGroomingMeter:SetMaxBar(SPR_METER_WHITE)
d.m_kGroomingMeter:SetMaxValue(PetAI.tNeeds.tGrooming.iMaxValue)
d.m_kGroomingMeter:SetValue(PetAI.tNeeds.tGrooming.iCurValue)
d.m_kGroomingMeter:Link(d.tab1)
d.m_kGroomingMeter:Paint()

d.m_kGroomingLabel = CxDrawText()
d.m_kGroomingLabel:Create(0,0,kMaxMeter:GetWidth(),20)
d.m_kGroomingLabel:SetFont(g_nFontArial)
d.m_kGroomingLabel:SetBkColor(0)
d.m_kGroomingLabel:SetString(GetLanguageString("NeedGrooming"))
d.m_kGroomingLabel:SetDefaultDepth(32)
d.m_kGroomingLabel:SetFlags(TEXT_CENTER_LEFT+TEXT_PRESERVE_ALPHA)
d.m_kGroomingLabel:Link(d.tab1)
d.m_kGroomingLabel:Paint(x, y, EPOS.BOTTOMLEFT)

d.tooltip["Grooming"] = MakeToolTipHelper("Grooming", d.m_kGroomingLabel, d.m_kGroomingMeter, d.tab1, "Need")

-- destroy helper meter sprite
kMaxMeter:ReleaseSurface()

d.m_cTrickOfTheDayHead = CxDrawText()
d.m_cTrickOfTheDayHead:Create(40, 10, 212, 24)
d.m_cTrickOfTheDayHead:Link(d.tab3)
d.m_cTrickOfTheDayHead:SetFont(g_nFontArial)
d.m_cTrickOfTheDayHead:SetBkColor(0)
d.m_cTrickOfTheDayHead:SetString(GetLanguageString("TOD_Heading"))
d.m_cTrickOfTheDayHead:SetPointSize(14)
d.m_cTrickOfTheDayHead:SetDefaultDepth(32)
d.m_cTrickOfTheDayHead:SetFlags(TEXT_TOP_LEFT + TEXT_PRESERVE_ALPHA)
d.m_cTrickOfTheDayHead:Paint()

d.m_cTrickOfTheDayBody = CxDrawText()
d.m_cTrickOfTheDayBody:Create(40, 32, 172, 172)
d.m_cTrickOfTheDayBody:Link(d.tab3)
d.m_cTrickOfTheDayBody:SetFont(g_nFontArial)
d.m_cTrickOfTheDayBody:SetBkColor(0)
d.m_cTrickOfTheDayBody:SetString(GetTrickOfTheDay())
d.m_cTrickOfTheDayBody:SetDefaultDepth(32)
d.m_cTrickOfTheDayBody:SetFlags(TEXT_TOP_LEFT + TEXT_PRESERVE_ALPHA + TEXT_WORD_WRAP)
d.m_cTrickOfTheDayBody:Paint()

return d

