
local f = CxDisplayObject()

f.m_bEnabled = 1

f:Create(0, 0, 680, 70)
f:SetZOrder(ZORDER.HINDMOST)

f.m_bFlyingTrickButton = {}

function f:ClickTrick(name)

    if (g_cTipDialog != nil) then
        g_cTipDialog:EndModal()
        g_cTipDialog = nil
    end

    if (not self.m_bFlyingTrickButton[name]) then
        PetAI.tThinkFunc.GiveVoiceCommand(name)
    end
end

local trick_buttons

if (fox.app.GetAppName() == "Dogz") then

    trick_buttons = {
        { name = "Promenade", filename = "But_xDtrickpromenade_01T.tga", command = "Room.trick_frame:ClickTrick('Promenade')", },
        { name = "Sit", filename = "But_xDtricksit_01T.tga", command = "Room.trick_frame:ClickTrick('Sit')", },
        { name = "LieDown", filename = "But_xDtricklay_01T.tga", command = "Room.trick_frame:ClickTrick('LieDown')", },
        { name = "Beg", filename = "But_xDtrickbeg_01T.tga", command = "Room.trick_frame:ClickTrick('Beg')", },
        { name = "GivePaw", filename = "But_xDtrickgivepaw_01T.tga", command = "Room.trick_frame:ClickTrick('GivePaw')", },

        { name = "Speak", filename = "But_xDtrickspeak_01T.tga", command = "Room.trick_frame:ClickTrick('Speak')", },
        { name = "RollOver", filename = "But_xDtrickrollover_01T.tga", command = "Room.trick_frame:ClickTrick('RollOver')", },
        { name = "Hide", filename = "But_xDtrickhide_01T.tga", command = "Room.trick_frame:ClickTrick('Hide')", },
        { name = "NodHead", filename = "But_xDtricknod_01T.tga", command = "Room.trick_frame:ClickTrick('NodHead')", },
        { name = "ShakeHead", filename = "But_xDtrickshake_01T.tga", command = "Room.trick_frame:ClickTrick('ShakeHead')", },

        { name = "Jump", filename = "But_xDtrickjump_01T.tga", command = "Room.trick_frame:ClickTrick('Jump')", },
     	{ name = "StandOnHindLegs", filename = "But_xDtrickwalkonlegs_01T.tga", command = "Room.trick_frame:ClickTrick('StandOnHindLegs')", },
        --{ name = "Temp", filename = "But_xDtricktemp_01T.tga", command = "Room.trick_frame:ClickTrick('Temp')", },
    }

else -- Catz

    trick_buttons = {
        { name = "Promenade", filename = "But_xCtrickpromenade_01T.tga", command = "Room.trick_frame:ClickTrick('Promenade')", },
        { name = "Sit", filename = "But_xCtricksit_01T.tga", command = "Room.trick_frame:ClickTrick('Sit')", },
        { name = "LieDown", filename = "But_xCtricklay_01T.tga", command = "Room.trick_frame:ClickTrick('LieDown')", },
        { name = "Beg", filename = "But_xCtrickbeg_01T.tga", command = "Room.trick_frame:ClickTrick('Beg')", },
        { name = "GivePaw", filename = "But_xCtrickwavepaw_01T.tga", command = "Room.trick_frame:ClickTrick('GivePaw')", },

        { name = "Speak", filename = "But_xCtrickspeak_01T.tga", command = "Room.trick_frame:ClickTrick('Speak')", },
        { name = "RollOver", filename = "But_xCtrickrollover_01T.tga", command = "Room.trick_frame:ClickTrick('RollOver')", },
        { name = "Hide", filename = "But_xCtrickhide_01T.tga", command = "Room.trick_frame:ClickTrick('Hide')", },
        { name = "NodHead", filename = "But_xCtricknod_01T.tga", command = "Room.trick_frame:ClickTrick('NodHead')", },
        { name = "ShakeHead", filename = "But_xCtrickshake_01T.tga", command = "Room.trick_frame:ClickTrick('ShakeHead')", },

        { name = "Jump", filename = "But_xCtrickjump_01T.tga", command = "Room.trick_frame:ClickTrick('Jump')", },
     	{ name = "StandOnHindLegs", filename = "But_xCtrickwalkonlegs_01T.tga", command = "Room.trick_frame:ClickTrick('StandOnHindLegs')", },
        --{ name = "Temp", filename = "But_xCtricktemp_01T.tga", command = "Room.trick_frame:ClickTrick('Temp')", },
    }
end

f.buttons = {}
f.activebuttons = {}

-- create all trick buttons
for k, v in pairs(trick_buttons) do
    local b = CLuaButton()
    b:LoadSurface(v.filename)
    b:SetName(v.name)
    b:Link(f)
    b:SetOnClicked("HideToolTip() "..v.command)

    b:SetOnMouseEnter("if (not Room.trick_frame.m_bFlyingTrickButton['"..v.name.."']) then DoToolTipForButton(Room.FindTrickButton('"..v.name.."')) end")
    b:SetOnMouseExit("HideToolTip()")

    b.m_pHighlight = NewHighlight("Efx_xCDtrickbuttonhighlight_01T.tga", b)
    b.Flash = function(self, bOnOff) if (bOnOff) then self.m_pHighlight:Play() else self.m_pHighlight:Stop() self.m_pHighlight.sprite:Erase() end end

    f.buttons[v.name] = b
end

function RemoveObjectFromTable(t, o)
    for k, v in pairs(t) do
        if (v == o) then
            t[k] = nil
            break
        end
    end
end

function AddToTableOnce(t, o)
    local bFound = false

    for k, v in pairs(t) do
        if (v == o) then
            bFound = true
            t[k] = nil
            break
        end
    end
    if (not bFound) then
        table.insert(t, o)
    end
end

function TableContains(t, o)
    local bFound = false

    for k, v in pairs(t) do
        if (v == o) then
            bFound = true
            break
        end
    end

    return bFound
end

function f:StopFlashingButton(name)
    local b = self.buttons[name]

    if (b != nil) then
        b:Flash(false)
    end
end

function f:CreateTipDialog(caption)
    local d = CxDialogBox()

    d:LoadSurface("UI_xCDthindialogbox1024_01T.tga")
    d:SetZOrder(ZORDER.TOPMOST)
    d:LinkRoot()
    d:SetClip(0)

    d.text = Text{ text = caption, pointsize = 18, position = { d:GetWidth() * 0.1, d:GetHeight() * 0.1 }, size = { d:GetWidth() - (d:GetWidth() * 0.2), d:GetHeight() - (d:GetHeight() * 0.2)}, parent = d, color = 0x00000000, bkcolor = 0x00000000, flags = TEXT_WORD_WRAP + TEXT_CENTER_CENTER, }
    --d.text = Text{ text = caption, pointsize = 18, position = { 4, 4}, size = {d:GetWidth() - 5, d:GetHeight() - 5 }, parent = d, color = 0x00000000, bkcolor = 0x00000000, flags = TEXT_WORD_WRAP + TEXT_CENTER_CENTER, }

    return(d)
end

function f:ActivateButton(name, parent, x, y)
    --LogInfo("ActivateButton "..name)
    local b = self.buttons[name]

    if (b != nil) then
        local my_parent = parent
        local d

        x = parent:GetWidth() / 2
        y = parent:GetHeight() / 2

        -- If this is the first time activating a button...
        if (not PetAI.tHelpDialogInfo[29]) then
            local t = {
                Promenade = "Tip_15",
                Sit = "Tip_16",
                LieDown = "Tip_17",
                Speak = "Tip_18",
                GivePaw = "Tip_19",
                Beg = "Tip_20",
                RollOver = "Tip_21",
                Hide = "Tip_22",
                NodHead = "Tip_23",
                ShakeHead = "Tip_24",
                Jump = "Tip_25",
                StandOnHindLegs = "Tip_26",
            }

            d = self:CreateTipDialog(GetLanguageString(t[name]))

            my_parent = d

            d:Paint(x, y, EPOS.BOTTOMCENTER)

            x, y = d:GetWidth() / 2, d:GetHeight()

            for i = 15, 26 do
                PetAI.tHelpDialogInfo[i] = true
            end
        end


        b:Link(my_parent)
        b:Paint(x, y, EPOS.TOPCENTER)
        b:Flash(true)

        PlaySound("newbutton.wav")

        if (b.text == nil) then
            local trick_text = GetLanguageString("TrickName_"..name)

            local cx, cy = GetTextSize(trick_text, g_nFontArial, 12, 200, 20)

            b.text = Text{size = {cx + 9, cy + 1}, text = trick_text, font = g_nFontArial, pointsize = 12, color = 0x00000000, bkcolor = 0xFF00FF00}
            b.text:SetZOrder(b:GetZOrder())
            b.text:Link(my_parent)

            x, y = b:GetPosition(EPOS.BOTTOMCENTER)

            b.text:Paint(x, y, EPOS.TOPCENTER)
        end

        if (d != nil) then
            g_cTipDialog = d
            Room.Pause()
            d:DoModal()
            Room.Resume()
            d.text:Kill()
            d:Kill()
            g_cTipDialog = nil

            b:Paint(parent:GetWidth() / 2, parent:GetHeight() / 2, EPOS.TOPCENTER)
            b:Erase()
        end
    end
end

function f:HideButton(name)
    local b = self.buttons[name]

    HideToolTip()

    if (b != nil) then

        if (b.text != nil) then
            b.text:Kill()
            b.text = nil
        end

        b:Erase()
    end
end

function f:DeActivateButton(name)
    --LogInfo("DeActivateButton "..name)

    local b = self.buttons[name]

    if (b != nil) then

        if (b.text != nil) then
            b.text:Kill()
            b.text = nil

            HideToolTip()
        end

        if (not TableContains(self.activebuttons, b)) then
            RemoveObjectFromTable(self.activebuttons, b)

            if (not self.m_bFlyingTrickButton[name]) then
                b:Erase()
                b:UnLink()
            end
        end

        self:Update()
    end
end


function f:GetTrickButton(name)
    return(self.buttons[name])
end


function f:FlyButton(name)

    local b = self.buttons[name]

    if (b != nil) then
        b:Link(Room.this)
        b:Flash(false)
        b:Paint()

        self.m_bFlyingTrickButton[name] = true

        HideToolTip()

        local nFlyChannel = EventChannelManager.CreateChannel()

        local x, y = self:GetNextIconPosition()

        local xx, yy = self:GetPosition()

        -- Bring into parent coords
        x = x + xx
        y = y + yy

        local xDog, yDog = GetScreenPosition(pet:GetBonePosition(pet:GetBoneIndex("-tag Hat01")))

        DoLuaEvent("Room.trick_frame:Paint()", nFlyChannel)
        DoLuaEvent("DoGlitter('sparkles',"..xDog..", "..yDog..", FALSE, -1, 2)", nFlyChannel)
        DoEvent("System.Sleep(2000)", nFlyChannel)
        DoEvent("System.MoveSprite("..b:GetAddress()..", 30, 400, 30, 400, "..x..", "..y..")", nFlyChannel)
        DoLuaEvent("Room.trick_frame:SaveButton('"..name.."')", nFlyChannel)
        DoLuaEvent("Room.trick_frame.m_bFlyingTrickButton['"..name.."'] = false", nFlyChannel)
        DoLuaEvent("PlaySound('newbutton.wav')", nFlyChannel)
        DoLuaEvent("Room.trick_frame:GetTrickButton('"..name.."'):Flash(true)", nFlyChannel)
        DoEvent("System.Sleep(2000)", nFlyChannel)
        DoLuaEvent("Room.trick_frame:GetTrickButton('"..name.."'):Flash(false)", nFlyChannel)
        DoLuaEvent("DoLuaEvent('EventChannelManager.DestroyChannel("..nFlyChannel..")', GetSystemChannel())", nFlyChannel)
    end
end

function f:GetNextIconPosition()

    local x, y = 0, 10
    for k, v in pairs(self.activebuttons) do
        x = x + v:GetWidth() + 1
    end

    return x, y
end


function f:SaveButton(name)

    local b = self.buttons[name]

    if (b != nil) then

        if (b.text != nil) then
            b.text:Kill()
            b.text = nil

            HideToolTip()
        end

        b:Erase()
        b:Link(self)

        AddToTableOnce(self.activebuttons, b)

        self:Update()
    end
end

function f:UnSaveButton(name)
    --LogInfo("UnSave "..name)

    local b = self.buttons[name]

    if (b != nil) then

        if (b.text != nil) then
            b.text:Kill()
            b.text = nil

            HideToolTip()
        end

        RemoveObjectFromTable(self.activebuttons, b)

        b:Erase()
        b:UnLink()

        self:Update()
    end
end

function f:Update()
    local x, y = 0, 10
    for k, v in pairs(self.activebuttons) do
        if (self.m_bEnabled == 0) then
            v:Disable()
        end
        v:Paint(x, y)
        x = x + v:GetWidth() + 1
    end
end

function f:Disable()
    self.m_bEnabled = 0
    for k, v in pairs(self.activebuttons) do
        v:Disable()
    end
end

function f:Enable()
    self.m_bEnabled = 1
    for k, v in pairs(self.activebuttons) do
        v:Enable()
    end
end

function f:IsEnabled()
    return(self.m_bEnabled)
end

function f:Kill()
    self:Erase()
    self:UnLink()

    for k, v in pairs(self.buttons) do
        v:Kill()
    end
end

return f