
function Room.OnStartRoom()

    if (fox.app.GetAppName() == "Dogz") then
        StartMusic("dogkennel.mp3")
    else
        StartMusic("catkennel.mp3")
    end

    Room.this:LoadSurface("UI_xCDadoptbackground_01T.tga")
    Room.this:LinkRoot()
    Room.this:Paint()

    Room.group = CxRadioGroup()
    Room.group:SetZOrder(ZORDER.HINDMOST)
    Room.group:Create(0, 0, Room.this:GetWidth(), Room.this:GetHeight())
    Room.group:Link(Room.this)
    Room.group:Paint()

--  local psize = 64
--  if (gLanguage != "English") then
--       psize = 40
--  end

	Room.header = Text { position = {0, 70}, size = {1024, 80}, pointsize = 60, text = GetLanguageString("SelectBreed"), font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}
    Room.header:Link(Room.this)
    Room.header:Paint()

--    Room.title = Text { position = {302, 78}, size = {400, 60}, pointsize = 52, text = GetLanguageString("KennelTitle"), font = g_nFont3, color = 0xFF285020, bkcolor = 0x00000000, flags = TEXT_TOP_LEFT}
--    Room.title:Link(Room.this)
--    Room.title:Paint()

    Room.back_btn = NewLuaButton({name = "Back", file = "But_xCDBack_01T.tga", position = {374, 611}, parent = Room.this, OnClick = "UnLoadPet() StopMusic() PopRoom()"})
    Room.next_btn = NewLuaButton({name = "Next", file = "But_xCDcustomizepet_01T.tga", position = {666, 611}, parent = Room.this, OnClick = "PushRoom('Kennel2')"})

    psize = 16
 --   if (gLanguage != "English") then
 --       psize = 16
 --   end

    Room.text = Text { position = {80, 480}, size = {864, 120}, pointsize = 36, text = GetLanguageString("NoBreedSelected"), font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_CENTER_CENTER + TEXT_WORD_WRAP}
    Room.text:SetZOrder(ZORDER.HINDMOST)
    Room.text:Link(Room.this)
    Room.text:Paint()

    if (fox.app.GetAppName() == "Dogz") then
        Room.pet1_btn = NewLuaButton({name = "GermanShepard", file = "But_xDadoptgermanshepard_01T.tga", position = {260, 180}, parent = Room.group, OnChecked = "Room.LoadBreed('GermanShepard')"})
        Room.pet1_btn:SetStyle(RADIO_BUTTON)
        Room.pet1_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet1_breed = Text { text = GetLanguageString("GermanShepard"), parent = Room.this, position = { Room.pet1_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet2_btn = NewLuaButton({name = "GoldenRetriever", file = "But_xDadoptgoldenretriever_01T.tga", position = {340, 330}, parent = Room.group, OnChecked = "Room.LoadBreed('GoldenRetriever')"})
        Room.pet2_btn:SetStyle(RADIO_BUTTON)
        Room.pet2_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet2_breed = Text { text = GetLanguageString("GoldenRetriever"), parent = Room.this, position = { Room.pet2_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet3_btn = NewLuaButton({name = "BorderCollie", file = "But_xDadoptbordercollie_01T.tga", position = {180, 330}, parent = Room.group, OnChecked = "Room.LoadBreed('BorderCollie')"})
        Room.pet3_btn:SetStyle(RADIO_BUTTON)
        Room.pet3_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet3_breed = Text { text = GetLanguageString("BorderCollie"), parent = Room.this, position = { Room.pet3_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet4_btn = NewLuaButton({name = "Beagle", file = "But_xDadoptbeagle_01T.tga", position = {100, 180}, parent = Room.group, OnChecked = "Room.LoadBreed('Beagle')"})
        Room.pet4_btn:SetStyle(RADIO_BUTTON)
        Room.pet4_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet4_breed = Text { text = GetLanguageString("Beagle"), parent = Room.this, position = { Room.pet4_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet5_btn = NewLuaButton({name = "Pug", file = "But_xDadoptpug_01T.tga", position = {420, 180}, parent = Room.group, OnChecked = "Room.LoadBreed('Pug')"})
        Room.pet5_btn:SetStyle(RADIO_BUTTON)
        Room.pet5_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet5_breed = Text { text = GetLanguageString("Pug"), parent = Room.this, position = { Room.pet5_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        gszBreedShort = gszBreedShort or "Beagle"

    else
        Room.pet1_btn = NewLuaButton({name = "Abyssinian", file = "But_xCadoptabyssinian_01T.tga", position = {100, 180}, parent = Room.group, OnChecked = "Room.LoadBreed('Abyssinian')"})
        Room.pet1_btn:SetStyle(RADIO_BUTTON)
        Room.pet1_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet1_breed = Text { text = GetLanguageString("Abyssinian"), parent = Room.this, position = { Room.pet1_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet2_btn = NewLuaButton({name = "Bengal", file = "But_xCadoptbengal_01T.tga", position = {180, 330}, parent = Room.group, OnChecked = "Room.LoadBreed('Bengal')"})
        Room.pet2_btn:SetStyle(RADIO_BUTTON)
        Room.pet2_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet2_breed = Text { text = GetLanguageString("Bengal"), parent = Room.this, position = { Room.pet2_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet3_btn = NewLuaButton({name = "Siamese", file = "But_xCadoptsiamese_01T.tga", position = {260, 180}, parent = Room.group, OnChecked = "Room.LoadBreed('Siamese')"})
        Room.pet3_btn:SetStyle(RADIO_BUTTON)
        Room.pet3_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet3_breed = Text { text = GetLanguageString("Siamese"), parent = Room.this, position = { Room.pet3_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet4_btn = NewLuaButton({name = "Burmese", file = "But_xCadoptburmese_01T.tga", position = {340, 330}, parent = Room.group, OnChecked = "Room.LoadBreed('Burmese')"})
        Room.pet4_btn:SetStyle(RADIO_BUTTON)
        Room.pet4_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet4_breed = Text { text = GetLanguageString("Burmese"), parent = Room.this, position = { Room.pet4_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        Room.pet5_btn = NewLuaButton({name = "MaineCoon", file = "But_xCadoptmainecoon_01T.tga", position = {420, 180}, parent = Room.group, OnChecked = "Room.LoadBreed('MaineCoon')"})
        Room.pet5_btn:SetStyle(RADIO_BUTTON)
        Room.pet5_btn:SetStateMap({0, 3, 2, 3, 4})
        Room.pet5_breed = Text { text = GetLanguageString("MaineCoon"), parent = Room.this, position = { Room.pet5_btn:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {188, 30}, pointsize = psize, font = g_nFont3, color = 0xFF489000, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}

        gszBreedShort = gszBreedShort or "Abyssinian"
    end

    if (Room.pet1_btn:GetName() == gszBreedShort) then
        Room.pet1_btn:SetCheck(1)

    elseif (Room.pet2_btn:GetName() == gszBreedShort) then
        Room.pet2_btn:SetCheck(1)

    elseif (Room.pet3_btn:GetName() == gszBreedShort) then
        Room.pet3_btn:SetCheck(1)

    elseif (Room.pet4_btn:GetName() == gszBreedShort) then
        Room.pet4_btn:SetCheck(1)

    elseif (Room.pet5_btn:GetName() == gszBreedShort) then
        Room.pet5_btn:SetCheck(1)
    end


--    Room.text = NewDrawText(106, 450, 800, 200, "No Pet selected", g_nFontArial, 0xFF000000, 0x00000000)
--    Room.text:SetZOrder(ZORDER.HINDMOST)
--    Room.text:Link(Room.this)
--    Room.text:SetFlags(TEXT_CENTER_LEFT + TEXT_WORD_WRAP + TEXT_PRESERVE_ALPHA)
--    Room.text:SetPointSize(28)
--    Room.text:Paint()

    if (pet == nil) then
        Room.next_btn:Disable()
    end
end

function Room.OnStopRoom()
    Room.back_btn:Kill()
    Room.next_btn:Kill()

    Room.pet1_btn:Kill()
    Room.pet2_btn:Kill()
    Room.pet3_btn:Kill()
    Room.pet4_btn:Kill()
    Room.pet5_btn:Kill()
    Room.text:Kill()

    Room.group:Kill()

    Room.pet1_breed:Kill()
    Room.pet2_breed:Kill()
    Room.pet3_breed:Kill()
    Room.pet4_breed:Kill()
    Room.pet5_breed:Kill()

    if (Room.title != nil) then Room.title:Kill() end
end

local breed_description = {
    GermanShepard = "DogDesc_Shepherd",
    Beagle="DogDesc_Beagle",
    BorderCollie="DogDesc_Collie",
    GoldenRetriever="DogDesc_Retriever",
    Pug="DogDesc_Pug",

    Abyssinian = "CatDesc_Abyssinian",
    Bengal = "CatDesc_Bengal",
    Burmese = "CatDesc_Burmese",
    MaineCoon = "CatDesc_MaineCoon",
    Siamese = "CatDesc_Siamese",
}

function Room.LoadBreed(breed)

    SetCursor(CURSOR_BUSY)

    gszBreedShort = breed

    if (fox.app.GetAppName() == "Dogz") then
		gszBreed="PETS/dog_"..breed..".lua"
    else
		gszBreed="PETS/cat_"..breed..".lua"
	end

    LoadPet(gszBreed)

    if (pet != nil) then
        pet:StopAll()
        pet:SetOrientation({-1, 0, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1})
        pet:PlayInfinite("SitIdle", 1.0)
    end

    local psize = 20
--    if (gLanguage != "English") then
--       psize = 18
--   end

    Room.text:SetPointSize(psize)
    Room.text:SetString(GetLanguageString(breed_description[breed]))

    Room.next_btn:Enable()

    SetCursor(CURSOR_ARROW)
end