function Room.SetFur(n)

    -- Set default texture based on fur choice
    pet.texture = n

    pet:SetTexture(pet.data.available_textures[pet.texture])
end

function Room.SetCollar(n)

    -- TODO: Set default collar based on choice
    -- Load Collar

    SetPetAccessory("collar", "Objects/acc_collar.lua", "-tag collar01", n)
end


function Room.SetGender(gender)

    -- TODO: Set gender based on choice
    PetAI.szGender = gender

end

DorC = "C"
if (fox.app.GetAppName() == "Dogz") then
    DorC = "D"
end


function Room.OnStartRoom()

    Room.this:LoadSurface("UI_xCDadoptbackground_01T.tga")
    Room.this:LinkRoot()
    Room.this:Paint()

--  local psize = 56
--   if (gLanguage != "English") then
--      psize = 40
--  end

    Room.header = Text { position = {0, 70}, size = {1024, 80}, pointsize = 60, text = GetLanguageString("CustomizeYourPet"), font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}
    Room.header:Link(Room.this)
    Room.header:Paint()

    Room.back_btn = NewLuaButton({name = "Back", file = "But_xCDBack_01T.tga", position = {374, 611}, parent = Room.this, OnClick = "UnLoadPet() PopRoom()"})
    Room.next_btn = NewLuaButton({name = "Next", file = "But_xCDNamepet_01T.tga", position = {666, 611}, parent = Room.this, OnClick = "PushRoom('Kennel3')"})

    -- Fur selection radio buttons
    Room.fur_group = CxRadioGroup()
    Room.fur_group:SetZOrder(ZORDER.HINDMOST)
    Room.fur_group:Create(130, 180, 360, 200)
    Room.fur_group:Link(Room.this)
    Room.fur_group:Paint()

    Room.fur1 = CLuaButton()
    Room.fur1:SetStyle(RADIO_BUTTON)
    Room.fur1:LoadSurface("But_x"..DorC.."adopt"..gszBreedShort.."fur_01T.tga")
    Room.fur1:SetStateMap({0, 3, 2, 3, 4})
    Room.fur1:Link(Room.fur_group)
    Room.fur1:Paint(0, 0)
    Room.fur1:SetOnChecked("Room.SetFur(1)")

    Room.fur2 = CLuaButton()
    Room.fur2:SetStyle(RADIO_BUTTON)
    Room.fur2:LoadSurface("But_x"..DorC.."adopt"..gszBreedShort.."fur_02T.tga")
    Room.fur2:SetStateMap({0, 3, 2, 3, 4})
    Room.fur2:Link(Room.fur_group)
    Room.fur2:Paint(120, 0)
    Room.fur2:SetOnChecked("Room.SetFur(2)")

    Room.fur3 = CLuaButton()
    Room.fur3:SetStyle(RADIO_BUTTON)
    Room.fur3:LoadSurface("But_x"..DorC.."adopt"..gszBreedShort.."fur_03T.tga")
    Room.fur3:SetStateMap({0, 3, 2, 3, 4})
    Room.fur3:Link(Room.fur_group)
    Room.fur3:Paint(240, 0)
    Room.fur3:SetOnChecked("Room.SetFur(3)")

    psize = 24
--    if (gLanguage != "English") then
--       psize = 24
--   end

    Room.fur1:SetCheck(TRUE)
    Room.fur_text = Text { text = GetLanguageString("SelectFur"), parent = Room.fur_group, position = { Room.fur2:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {300, 40}, pointsize = psize, font = g_nFont3, color = 0xFF4A9400, flags = TEXT_TOP_CENTER}

    -- Collar selection Radio buttons
    Room.collar_group = CxRadioGroup()
    Room.collar_group:SetZOrder(ZORDER.HINDMOST)
    Room.collar_group:Create(130, 350, 360, 200)
    Room.collar_group:Link(Room.this)
    Room.collar_group:Paint()

    Room.collar1 = CLuaButton()
    Room.collar1:SetStyle(RADIO_BUTTON)
    Room.collar1:LoadSurface("But_xCDadoptcollar_02T.tga")
    Room.collar1:SetStateMap({0, 3, 2, 3, 4})
    Room.collar1:Link(Room.collar_group)
    Room.collar1:Paint(0, 0)
    Room.collar1:SetOnChecked("Room.SetCollar(1)")

    Room.collar2 = CLuaButton()
    Room.collar2:SetStyle(RADIO_BUTTON)
    Room.collar2:LoadSurface("But_xCDadoptcollar_01T.tga")
    Room.collar2:SetStateMap({0, 3, 2, 3, 4})
    Room.collar2:Link(Room.collar_group)
    Room.collar2:Paint(120, 0)
    Room.collar2:SetOnChecked("Room.SetCollar(2)")

    Room.collar3 = CLuaButton()
    Room.collar3:SetStyle(RADIO_BUTTON)
    Room.collar3:LoadSurface("But_xCDadoptcollar_03T.tga")
    Room.collar3:SetStateMap({0, 3, 2, 3, 4})
    Room.collar3:Link(Room.collar_group)
    Room.collar3:Paint(240, 0)
    Room.collar3:SetOnChecked("Room.SetCollar(3)")

    Room.collar_text = Text { text = GetLanguageString("SelectCollar"), parent = Room.collar_group, position = { Room.collar2:GetPosition(EPOS.BOTTOMCENTER) }, epos = EPOS.TOPCENTER, size = {300, 40}, pointsize = psize, font = g_nFont3, color = 0xFF4A9400, flags = TEXT_TOP_CENTER}

    Room.collar1:SetCheck(TRUE)

    -- Boy vs Girl Radio buttons

    Room.gender_group = CxRadioGroup()
    Room.gender_group:Create(680, 500, 880, 600)
    Room.gender_group:SetZOrder(ZORDER.HINDMOST)
    Room.gender_group:Link(Room.this)
    Room.gender_group:Paint()

    Room.gender1 = CLuaButton()
    Room.gender1:SetStyle(RADIO_BUTTON)
    Room.gender1:LoadSurface("UI_xCDradialbuttons_01T.tga", 3)
    Room.gender1:SetStateMap({0, 1, 0, 1, 2})
    Room.gender1:Link(Room.gender_group)
    Room.gender1:Paint(0, 0)
    Room.gender1:SetOnChecked("Room.SetGender('Boy')")

    Room.gender2 = CLuaButton()
    Room.gender2:SetStyle(RADIO_BUTTON)
    Room.gender2:LoadSurface("UI_xCDradialbuttons_01T.tga", 3)
    Room.gender2:SetStateMap({0, 1, 0, 1, 2})
    Room.gender2:Link(Room.gender_group)
    Room.gender2:Paint(100, 0)
    Room.gender2:SetOnChecked("Room.SetGender('Girl')")

    Room.gender2:SetCheck(TRUE)

    Room.label_boy = Text { position = {652, 550}, size = {100, 40}, pointsize = 24, text = GetLanguageString("Boy"), font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}
    Room.label_boy:Link(Room.this)
    Room.label_boy:Paint()

    Room.label_girl = Text { position = {752, 550}, size = {100, 40}, pointsize = 24, text = GetLanguageString("Girl"), font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}
    Room.label_girl:Link(Room.this)
    Room.label_girl:Paint()

end

function Room.OnStopRoom()
    Room.back_btn:Kill()
    Room.next_btn:Kill()
    Room.fur_group:Kill()
    Room.fur1:Kill()
    Room.fur2:Kill()
    Room.fur3:Kill()
    Room.collar_group:Kill()
    Room.collar1:Kill()
    Room.collar3:Kill()
    Room.gender_group:Kill()
    Room.gender1:Kill()
    Room.gender2:Kill()
    Room.label_boy:Kill()
    Room.label_girl:Kill()

    Room.fur_text:Kill()
    Room.collar_text:Kill()

    if (Room.title != nil) then Room.title:Kill() end
end