Room.MY_TIMER_ID = 101

function GenBirthday()
    local d = date()

    -- few months ago
    local month = (math.mod(d.month + 9, 12) + 1)

    -- random day in that month
    local day = math.random(1, 28)

    -- TODO: This, or last year
    local year = d.year
    if (d.month <= 2) then
        year = year - 1
    end

    local s = ""..month.."/"..day.."/"..year

    return s
end

DorC = "C"
if (fox.app.GetAppName() == "Dogz") then
    DorC = "D"
end

function Room.HideUI()
    Room.back_btn:Erase()
    Room.next_btn:Erase()
    Room.print_btn:Erase()
    Room.header:Erase()
    Room.name:SetEditState(0)
end

function Room.ShowUI()
    Room.back_btn:Paint()
    Room.next_btn:Paint()
    Room.print_btn:Paint()
    Room.header:Paint()
    Room.name:SetEditState(1)
end


function Room.OnStartRoom()

    if (fox.app.GetAppName() == "Dogz") then
        Room.this:LoadSurface("UI_xDadoptpuppybackground_02T.tga")
    else
        Room.this:LoadSurface("UI_xCadoptkittybackground_02T.tga")
    end

    Room.this:LinkRoot()
    Room.this:Paint()

    local psize = 40
    if (gLanguage != "English") then
        if (gLanguage == "German") then
            psize = 32
        else
            psize = 36
        end
    end

    Room.header = Text { position = {0, 70}, size = {1024, 60}, pointsize = psize, text = GetLanguageString("NameYourPet"), font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}
    Room.header:Link(Room.this)
    Room.header:Paint()

    Room.title = Text { position = {174, 200}, size = {676, 60}, pointsize = 40, text = GetLanguageString("AdoptCertificate"), font = g_nFont3, color = 0xFF006B94, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER}
    Room.title:Link(Room.this)
    Room.title:Paint()

    Room.back_btn = CLuaButton()
    Room.back_btn:LoadSurface("But_xCDBack_01T.tga")
    Room.back_btn:SetName("Back")
    Room.back_btn:Link(Room.this)
    Room.back_btn:Paint(374, 611)
    Room.back_btn:SetOnClicked("PopRoom()")

    Room.next_btn = CLuaButton()
    Room.next_btn:LoadSurface("But_xCDAdoptpet_01T.tga")
    Room.next_btn:SetName("Next")
    Room.next_btn:Link(Room.this)
    Room.next_btn:Paint(666, 611)
    Room.next_btn:SetOnClicked("Room.TryLogin()")
    Room.next_btn:Disable()

    Room.print_btn = CLuaButton()
    Room.print_btn:LoadSurface("But_xCDPrint_01T.tga")
    Room.print_btn:SetName("Print")
    Room.print_btn:Link(Room.this)
    Room.print_btn:Paint(80, 80)
    Room.print_btn:SetOnClicked("Room.HideUI() PrintScreen() Room.ShowUI()")

    -- TODO: Print certificate
    --Room.print_btn:SetOnClicked("")

    Room.picture = CxSprite()
    Room.picture:LoadSurface("But_x"..DorC.."adopt"..gszBreedShort.."_01T.tga", 5)
    Room.picture:Link(Room.this)
    Room.picture:Paint(250, 305)

    psize = 24
--   if (gLanguage != "English") then
 --     psize = 24
 --  end

    Room.breed = NewDrawText(400, 280, 400, 40, GetLanguageString("StatBreed")..": "..GetLanguageString(gszBreedShort), g_nFont3, 0xFF000000, 0x00000000)
    Room.breed:Link(Room.this)
    Room.breed:SetPointSize(psize)
    Room.breed:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.breed:Paint()

    PetAI.sBirthday = GenBirthday()
    PetAI.szName = ""   -- default name

    Room.birthday = NewDrawText(400, 320, 400, 40, GetLanguageString("StatBirthday")..": "..PetAI.sBirthday, g_nFont3, 0xFF000000, 0x00000000)
    Room.birthday:Link(Room.this)
    Room.birthday:SetPointSize(psize)
    Room.birthday:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.birthday:Paint()

    Room.obedience = NewDrawText(400, 360, 180, 40, GetLanguageString("StatObedience")..": "..PetAI.tStats.tObedience.iCurValue, g_nFont3, 0xFF000000, 0x00000000)
    Room.obedience:Link(Room.this)
    Room.obedience:SetPointSize(psize)
    Room.obedience:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.obedience:Paint()

    Room.intelligence = NewDrawText(600, 360, 180, 40, GetLanguageString("StatIntelligence")..": "..PetAI.tStats.tIntelligence.iCurValue, g_nFont3, 0xFF000000, 0x00000000)
    Room.intelligence:Link(Room.this)
    Room.intelligence:SetPointSize(psize)
    Room.intelligence:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.intelligence:Paint()

    Room.agility = NewDrawText(400, 400, 180, 40, GetLanguageString("StatAgility")..": "..PetAI.tStats.tAgility.iCurValue, g_nFont3, 0xFF000000, 0x00000000)
    Room.agility:Link(Room.this)
    Room.agility:SetPointSize(psize)
    Room.agility:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.agility:Paint()

    Room.stamina = NewDrawText(600, 400, 180, 40, GetLanguageString("StatStamina")..": "..PetAI.tStats.tStamina.iCurValue, g_nFont3, 0xFF000000, 0x00000000)
    Room.stamina:Link(Room.this)
    Room.stamina:SetPointSize(psize)
    Room.stamina:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.stamina:Paint()

    Room.name = CxEditText()
    Room.name:SetDefaultDepth(32)
    Room.name:SetCaretOffset(4, 20) -- 4, 10
    Room.name:MakeCaret(48, 0)
    Room.name:Create(300, 456, 450, 60) -- 462
    Room.name:SetString(PetAI.szName)
    Room.name:SetFont(g_nFontArial)
    Room.name:SetColor(0xFF006B94)
    Room.name:SetBkColor(0x00000000)
    Room.name:Link(Room.this)
    Room.name:SetPointSize(48)
    Room.name:SetFlags(TEXT_PRESERVE_ALPHA)
    Room.name:SetCharRestriction("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")
    Room.name:SetUpper(TRUE)
    Room.name:SetPixelLimit(420)
    Room.name:Paint()

    Room.SetTimer(Room.MY_TIMER_ID, 100, 0)

    Room.name:SetActive()
end

function Room.OnActivate()
    Room.name:SetActive()
end

function Room.OnStopRoom()

    Room.KillTimer(Room.MY_TIMER_ID)

    PetAI.szName = Room.name:GetString()

    Room.picture:Kill()
    Room.breed:Kill()
    Room.birthday:Kill()
    Room.obedience:Kill()
    Room.intelligence:Kill()
    Room.agility:Kill()
    Room.stamina:Kill()
    Room.name:Kill()

    Room.back_btn:Kill()
    Room.next_btn:Kill()
    Room.print_btn:Kill()

    if (Room.title != nil) then Room.title:Kill() end
end

function Room.OnTimer(nID)
    if (Room.name:GetString() != '' and Room.next_btn:IsEnabled() == FALSE) then
        Room.next_btn:Enable()

    elseif (Room.name:GetString() == '' and Room.next_btn:IsEnabled() != FALSE) then
        Room.next_btn:Disable()
    end
end

function Room.OnKeyHit(nKey)
    if (nKey == Keys.ENTER) then
        Room.TryLogin()
    end
end

function Room.TryLogin()

    if (Room.name:GetString() != '' and (not FoxFileExists('<AppData>pet_'..Room.name:GetString()..'.sav') or DoYesNoDialog(GetLanguageString('ConfirmOverwrite')) == TRUE)) then
        SaveGame.Init('<AppData>pet_'..Room.name:GetString()..'.sav', Room.name:GetString())
        Room.HideUI()
        ScreenCaptureWithUI('<AppData>photo_'..FoxGetTimeSeconds()..'.tga')
        Room.ShowUI()
        StopMusic()
        PopRoom()
        PopRoom()
        GotoRoom('House')
    end
end