
function Room.OnStartRoom()

    if (not IsMusicPlaying()) then
        StartMusic("MUSIC/default.mp3")
    end

    if (fox.app.GetAppName() == "Dogz") then
        Room.this:LoadSurface("UI_xDMainmenubackground_01T.tga")
    else
        Room.this:LoadSurface("UI_xCMainmenubackground_01T.tga")
    end

    Room.this:LinkRoot()
    Room.this:Paint()

    if (fox.app.GetAppName() == "Dogz") then
        Room.new_btn = NewLuaButton({name = "New", file = "But_xDNewPuppy_01T.tga", position = {172, 246}, parent = Room.this, OnClick = "UnLoadPet() StopMusic() gszBreedShort = nil PushRoom('Kennel1')"})
        Room.load_btn = NewLuaButton({name = "Load", file = "But_xDLoadPuppy_01T.tga", position = {172, 337}, parent = Room.this, OnClick = "UnLoadPet() StopMusic() PushRoom('LoadMenu')"})
    else
        Room.new_btn = NewLuaButton({name = "New", file = "But_xCNewKitty_01T.tga", position = {172, 246}, parent = Room.this, OnClick = "UnLoadPet() StopMusic() gszBreedShort = nil PushRoom('Kennel1')"})
        Room.load_btn = NewLuaButton({name = "Load", file = "But_xCLoadKitty_01T.tga", position = {172, 337}, parent = Room.this, OnClick = "UnLoadPet() StopMusic() PushRoom('LoadMenu')"})
    end

    Room.quit_btn = NewLuaButton({name = "Quit", file = "But_xCDQuit_01T.tga", position = {87, 620}, parent = Room.this, OnClick = "Quit()"})
    Room.options_btn = NewLuaButton({name = "Settings", file = "But_xCDSettings_01T.tga", position = {226, 620}, parent = Room.this, OnClick = "PushRoom('OptionsMenu')"})
    Room.play_btn = NewLuaButton({name = "Play", file = "But_xCDPlay_01T.tga", position = {666, 610}, parent = Room.this, OnClick = "StopMusic() PushRoom('House')"})

    if (pet == nil) then
        -- Load the Most Recently Used pet
        --
        local last_pet = fox.options:GetString("Petz", "LastPet", "better_not_exist.omg")

        if (FoxFileExists(last_pet)) then
            SaveGame.Restore(last_pet)

        else
            Room.play_btn:Disable()

            local list = FoxBuildFileList("<AppData>pet_*.sav", 0, false)

            if (table.getn(list) == 0) then
                Room.load_btn:Disable()
            end
        end
    end

    if (pet != nil) then
        pet:StopAll()
        pet:SetOrientation({-1, 0, 0, 0, 0, 1, 0, 0, 0, 0, -1, 0, 0, 0, 0, 1})
        pet:PlayInfinite("SitIdle", 1.0)

        Room.pet_name = Text { position = {590, 454}, size = {334, 42}, pointsize = 32, text = PetAI.szName, font = g_nFont3, color = 0xFFF0F0F0, bkcolor = 0x00000000, flags = TEXT_CENTER_CENTER, parent = Room.this }
    end

    local s = GetLanguageString("MainMenuText")
    if (pet == nil) then
        s = GetLanguageString("MainMenuTextNoPet")
    end

    Room.description = Text { position = {86, 450}, size = {466, 150}, pointsize = 32, text = s, font = g_nFont3, color = 0xFF4A9400, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER + TEXT_WORD_WRAP}
    Room.description:SetZOrder(ZORDER.HINDMOST)
    Room.description:Link(Room.this)
    Room.description:Paint()
end

function Room.OnStopRoom()
    Room.new_btn:Kill()
    Room.load_btn:Kill()
    Room.quit_btn:Kill()
    Room.options_btn:Kill()
    Room.play_btn:Kill()

    Room.description:Kill()

    if (Room.pet_name != nil) then Room.pet_name:Kill() end
end