//-----------------------------------------------------------------
// Actions
//-----------------------------------------------------------------

local tActions = {}

-- generalized obedience thresholds
tActions.ObedienceThresholds = {
	iNone = 0,
	iEasy = 30,
	iHard = 50,
	iExpert = 70
}

-- generalized grooming effects
tActions.GroomingEffects = {
	iNone = -0.00,
	iMin = -0.03,
	iMed = -0.2,
	iMax = -1.0
}

//-----------------------------------------------------------------
// Idle Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tAmbleAround 
-- ****************************************************************
tActions.AmbleAround = {

	-- name
	szName = "AmbleAround",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
		PetAI.tThinkFunc.DoIdle()
		PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToRandomPathNode("Walk1","BodyIdle")
		DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
		if (bMakeAvailable) then if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- WalkAimlessly 
-- ****************************************************************
tActions.WalkAimlessly = {

	-- name
	szName = "WalkAimlessly",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
		PetAI.tThinkFunc.DoIdle()
		PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToRandomPathNode("Walk1","BodyIdle")
		if (bMakeAvailable) then if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tSniffRandomObject 
-- ****************************************************************
tActions.SniffRandomObject = {

	-- name
	szName = "SniffRandomObject",

	-- precondition checking function
	CheckPrecondition = function() if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then return(PetAI.tThinkFunc.IsStanding()) else return(true) end end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("SniffGround","wavSniffGround",pet:GetAnimDuration("SniffGround")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tGrowl 
-- ****************************************************************
tActions.Growl = {

	-- name
	szName = "Growl",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("Growl","wavDogLowGrowl",pet:GetAnimDuration("Growl")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tChaseTail 
-- ****************************************************************
tActions.ChaseTail = {

	-- name
	szName = "ChaseTail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("ChaseTail",nil,pet:GetAnimDuration("ChaseTail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tTurnAndBark 
-- ****************************************************************
tActions.TurnAndBark = {

	-- name
	szName = "TurnAndBark",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("TurnAndBark",nil,pet:GetAnimDuration("TurnAndBark")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- BeSprayed 
-- ****************************************************************
tActions.BeSprayed = {

	-- name
	szName = "BeSprayed",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.01,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = -8,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

  	-- play water spraying animation depending on current pose
  	if (PetAI.tThinkFunc.IsStanding()) then
  	  PetAI.tThinkFunc.LoadNewAnim("StandSprayedWithWater",1)
  	  DoLuaEvent("PetAI.tSoundFX[\"wavStandSprayed\"]:Play()",ActivePetChannel)
      DoEvent("System.Sleep("..(pet:GetAnimDuration("StandSprayedWithWater")*1000)..")",ActivePetChannel)
  	elseif (PetAI.tThinkFunc.IsSitting()) then
  	  PetAI.tThinkFunc.LoadNewAnim("SitSprayedWithWater",1)
  	  DoLuaEvent("PetAI.tSoundFX[\"wavSitSprayed\"]:Play()",ActivePetChannel)
      DoEvent("System.Sleep("..(pet:GetAnimDuration("SitSprayedWithWater")*1000)..")",ActivePetChannel)
  	elseif (PetAI.tThinkFunc.IsLyingDown()) then
  	  PetAI.tThinkFunc.LoadNewAnim("LaySprayedWithWater",1)
  	  DoLuaEvent("PetAI.tSoundFX[\"wavLaySprayed\"]:Play()",ActivePetChannel)
      DoEvent("System.Sleep("..(pet:GetAnimDuration("LaySprayedWithWater")*1000)..")",ActivePetChannel)
    end 

    -- jump down from an elevated surface immediately (if necessary)
    local x,y,z = pet:GetPosition()
    if (PetAI.tJumpDownInfo != nil and (y > 0)) then PetAI.tThinkFunc.JumpDownFromObject() end

    if (PetAI.iScoldsInARow >= 2) and (PetAI.tJumpDownInfo == nil) then
      if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then DoLuaEvent("PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE,false)",ActivePetChannel) end
      PetAI.tThinkFunc.LoadNewAnim({szBody="Run"},0.5)
  	  PetAI.tPathFunc.WalkToPathNode(PetAI.tPathFunc.tRooms[PetAI.szLocation].GetRunAwayNode(),"Run","BodyIdle",120)      
    end

		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tStretch 
-- ****************************************************************
tActions.Stretch = {

	-- name
	szName = "Stretch",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoLieDownAndSingleAnim("LayStretch",nil,pet:GetAnimDuration("LayStretch")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tYawn 
-- ****************************************************************
tActions.Yawn = {

	-- name
	szName = "Yawn",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoSitAndSingleAnim({szBody="BodySitIdle", szHead="HeadYawn", szTail="TailIdle"},"wavPetYawn",pet:GetAnimDuration("HeadYawn")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- Stand 
-- ****************************************************************
tActions.Stand = {

	-- name
	szName = "Stand",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
		PetAI.tThinkFunc.DoStand()
		if (bMakeAvailable) then if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- CleanInAttn 
-- ****************************************************************
tActions.CleanInAttn = {

	-- name
	szName = "CleanInAttn",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE) and (not PetAI.tThinkFunc.IsLyingDown())) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
    if (PetAI.tThinkFunc.IsSitting()) then PetAI.tThinkFunc.DoSitAndSingleAnim("SitClean",nil,pet:GetAnimDuration("SitClean")*1000)
    elseif (PetAI.tThinkFunc.IsStanding()) then PetAI.tThinkFunc.DoStandAndSingleAnim("CleanFur",nil,pet:GetAnimDuration("CleanFur")*1000) end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- BarkInAttn 
-- ****************************************************************
tActions.BarkInAttn = {

	-- name
	szName = "BarkInAttn",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  if (PetAI.tThinkFunc.IsStanding()) then PetAI.tThinkFunc.DoStandAndSingleAnim({szHead="HeadBark"},"wavHeadBark"..math.random(7),pet:GetAnimDuration("HeadBark")*1000)
	  elseif (PetAI.tThinkFunc.IsSitting()) then PetAI.tThinkFunc.DoSitAndSingleAnim({szHead="HeadBark"},"wavHeadBark"..math.random(7),pet:GetAnimDuration("HeadBark")*1000)
	  elseif (PetAI.tThinkFunc.IsLyingDown()) then PetAI.tThinkFunc.DoLieDownAndSingleAnim({szHead="HeadBark"},"wavHeadBark"..math.random(7),pet:GetAnimDuration("HeadBark")*1000)
	  end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- BlinkInAttn 
-- ****************************************************************
tActions.BlinkInAttn = {

	-- name
	szName = "BlinkInAttn",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  if (PetAI.tThinkFunc.IsStanding()) then PetAI.tThinkFunc.DoStandAndSingleAnim({szBody="BodyIdle",szHead="HeadIdle",szEye="EyeBlink"},nil,pet:GetAnimDuration("EyeBlink")*1000)
	  elseif (PetAI.tThinkFunc.IsSitting()) then PetAI.tThinkFunc.DoSitAndSingleAnim({szBody="BodySitIdle",szHead="HeadIdle",szEye="EyeBlink"},nil,pet:GetAnimDuration("EyeBlink")*1000)
	  elseif (PetAI.tThinkFunc.IsLyingDown()) then PetAI.tThinkFunc.DoLieDownAndSingleAnim({szBody="BodyLayIdle",szHead="HeadIdle",szEye="EyeBlink"},nil,pet:GetAnimDuration("EyeBlink")*1000) 
	  end
	  
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tScratchSelf 
-- ****************************************************************
tActions.ScratchSelf = {

	-- name
	szName = "ScratchSelf",

	-- precondition checking function
	CheckPrecondition = function() if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then return(PetAI.tThinkFunc.IsSitting()) else return(true) end end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitScratch","wavScratchSelf",pet:GetAnimDuration("SitScratch")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tVocalize 
-- ****************************************************************
tActions.Vocalize = {

	-- name
	szName = "Vocalize",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitSpeak","wavPetSpeak"..math.random(7),pet:GetAnimDuration("SitSpeak")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Transition Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tWalkToWaterBowl 
-- ****************************************************************
tActions.WalkToWaterBowl = {

	-- name
	szName = "WalkToWaterBowl",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end	  	  
	  	  
    PetAI.tPathFunc.EnableTransNodes()
	  	 	    
    local tBowlNode = PetAI.tPathFunc.tTagNodes.WaterBowlPoint
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tBowlNode,"BodyWalk","BodyIdle")	
       
    -- face the bowl
    local tOrientPos = {tBowlNode[1]+200,tBowlNode[2],tBowlNode[3]}
    DoEvent("Pet.FacePosition("..(5)..","..tOrientPos[1]..","..tOrientPos[2]..","..tOrientPos[3]..")",ActivePetChannel)    
    
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()",ActivePetChannel)	
    if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end			
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tWalkToFoodBowl 
-- ****************************************************************
tActions.WalkToFoodBowl = {

	-- name
	szName = "WalkToFoodBowl",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  PetAI.tPathFunc.EnableTransNodes()
	  		  	    
    local tBowlNode = PetAI.tPathFunc.tTagNodes.FoodBowlPoint
       
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tBowlNode,"BodyWalk","BodyIdle")	
    
    -- face the bowl
    local tOrientPos = {tBowlNode[1]+200,tBowlNode[2],tBowlNode[3]}
    DoEvent("Pet.FacePosition("..(5)..","..tOrientPos[1]..","..tOrientPos[2]..","..tOrientPos[3]..")",ActivePetChannel)      
    
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()",ActivePetChannel)			
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScratchScratchingPost 
-- ****************************************************************
tActions.ScratchScratchingPost = {

	-- name
	szName = "ScratchScratchingPost",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.tThinkFunc.IsCat() and PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  PetAI.tPathFunc.EnableTransNodes()	
		
	  -- retrieve scratching post position and closest node	    
 	  local tPostPos = {Room.m_cScratchingPost:GetBonePosition(Room.m_cScratchingPost:GetBoneIndex("-tag cat body"))}		  
	  local tPostNode = PetAI.tPathFunc.FindClosestPathNode(tPostPos[1],tPostPos[2],tPostPos[3],"LivingRoom")
    
    -- walk to the scratching post
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tPostNode,"BodyWalk","BodyIdle")	

    local tOrientPos = {tPostPos[1]+200,tPostPos[2],tPostPos[3]}
    DoEvent("Pet.FacePosition("..(5)..","..tOrientPos[1]..","..tOrientPos[2]..","..tOrientPos[3]..")",ActivePetChannel)  
      
    -- run scratching anim and then return to idle
		PetAI.tThinkFunc.DoStandAndSingleAnim('ScratchFurniture','wavScratchFurniture',pet:GetAnimDuration("ScratchFurniture")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
    DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()",ActivePetChannel)		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ClimbOntoSofa
-- ****************************************************************
tActions.ClimbOntoSofa = {

	-- name
	szName = "ClimbOntoSofa",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for sofa climbing
    local cObject = Room.m_cSofa
    
    local tOffPos = nil
    local tOnPos = nil
    
    if CATZ then
      tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat Off Sofa"))}
      tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pug On Sofa"))} 
    else
      tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pets Jump To Sofa"))}
      tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag "..PetAI.tThinkFunc.GetTagPrefix().." On Sofa"))}   
    end
    
    -- setup actions to be performed on sofa
    local DoActionFunc = function()         
      PetAI.tThinkFunc.DoLieDown()
      DoEvent("System.Sleep("..(20*1000 + math.random(5000))..")",ActivePetChannel)      
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Right","Left",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
 	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ClimbOntoPerch
-- ****************************************************************
tActions.ClimbOntoPerch = {

	-- name
	szName = "ClimbOntoPerch",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.tThinkFunc.IsCat() and PetAI.szLocation == "Bathroom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for perch climbing
    local cObject = Room.m_cCatPerch
    local tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Pets Off Sofa"))}
    local tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat On Sofa"))}
    
    -- setup actions to be performed on perch
    local DoActionFunc = function()         
      PetAI.tThinkFunc.DoLieDown()
      DoEvent("System.Sleep("..(20*1000 + math.random(5000))..")",ActivePetChannel)
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Right","Left",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
 	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ClimbOntoCounter
-- ****************************************************************
tActions.ClimbOntoCounter = {

	-- name
	szName = "ClimbOntoCounter",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.tThinkFunc.IsCat() and PetAI.szLocation == "Kitchen") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
	
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for counter climbing
    local cObject = Room.m_cKitchen
    local tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat Off Counter"))}
    local tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat On Counter"))}
    local tLandPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat Land"))}
    
    -- setup actions to be performed on counter
    local DoActionFunc = function()         
      PetAI.tThinkFunc.DoLieDown()
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"High","Away","Toward",DoActionFunc,tLandPos)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
 	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ClimbOntoTable
-- ****************************************************************
tActions.ClimbOntoTable = {

	-- name
	szName = "ClimbOntoTable",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for coffee table climbing
    local cObject = Room.m_cCoffeeTable
    local tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pets Off Sofa"))}
    local tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag "..PetAI.tThinkFunc.GetTagPrefix().." On Sofa"))}
    
    -- setup actions to be performed on coffee table
    local DoActionFunc = function()
      PetAI.tThinkFunc.DoLieDown()    
      PetAI.tThinkFunc.DoChannelSleep(4000)   
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Left","Right",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
 	end,	
		
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ClimbOntoPetBed
-- ****************************************************************
tActions.ClimbOntoPetBed = {

	-- name
	szName = "ClimbOntoPetBed",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
	  PetAI.tPathFunc.EnableTransNodes()

	  -- retrieve bed position and closest node
	  local tBedPos = {Room.m_cPetBed:GetBonePosition(Room.m_cPetBed:GetBoneIndex("-Tag Sleep"))}
	  local tBedNode = PetAI.tPathFunc.FindClosestPathNode(tBedPos[1],tBedPos[2],tBedPos[3],"LivingRoom")

    -- walk to the bed
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tBedNode,"BodyWalk","BodyIdle")
	  
	  -- lie down and yawn	  
    DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)	  
	  PetAI.tThinkFunc.DoAnimTransition("LayDown",{szBody="BodyLayIdle",szHead="HeadYawn",szTail="TailIdle",szEye="EyeClose"},pet:GetAnimDuration("LayDown")*1000)	
    DoLuaEvent("PetAI.tSoundFX.wavPetYawn:Play()",ActivePetChannel)
    DoEvent("System.Sleep("..(20*1000 + math.random(5000))..")",ActivePetChannel)  
	  
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()") 	  	  
    if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end       	  	   
   end,	
		
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ClimbIntoDogHouse
-- ****************************************************************
tActions.ClimbIntoDogHouse = {

	-- name
	szName = "ClimbIntoDogHouse",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Backyard") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end
	  PetAI.tPathFunc.EnableTransNodes()
	
	  -- retrieve bed position and closest node	
	  local tBedPos = {Room.m_cDogHouse:GetBonePosition(Room.m_cDogHouse:GetBoneIndex("-Tag Sleep"))}		  
	  local tBedNode = PetAI.tPathFunc.FindClosestPathNode(tBedPos[1],tBedPos[2],tBedPos[3],"Backyard")
    
    -- walk to the couch
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tBedNode,"BodyWalk","BodyIdle")	
        
    DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
    PetAI.tThinkFunc.DoLieDown()
    DoEvent("System.Sleep("..(20*1000 + math.random(5000))..")",ActivePetChannel)      
    
    if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end      
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")    
   end,	
		
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


-- ****************************************************************
-- WalkToCouch 
-- ****************************************************************
tActions.WalkToCouch = {

	-- name
	szName = "WalkToCouch",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
	  PetAI.tPathFunc.EnableTransNodes()
	  	
	  local x,y,z = Room.m_cSofa:GetPosition()	
	  local tCouchNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,"LivingRoom")
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tCouchNode,"BodyWalk","BodyIdle")	
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


-- ****************************************************************
-- WalkToRefrigerator 
-- ****************************************************************
tActions.WalkToRefrigerator = {

	-- name
	szName = "WalkToRefrigerator",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
	  PetAI.tPathFunc.EnableTransNodes()
	  	
	  local x,y,z = Room.m_cRefrigerator:GetPosition()	
	  local tFrigNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,"Kitchen")
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tFrigNode,"BodyWalk","BodyIdle")	
      
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- WalkToTub 
-- ****************************************************************
tActions.WalkToTub = {

	-- name
	szName = "WalkToTub",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
	  PetAI.tPathFunc.EnableTransNodes()
	  	
	  local x,y,z = Room.m_cTub:GetPosition()	
	  local tTubNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,"Bathroom")
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tTubNode,"BodyWalk","BodyIdle")	
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


-- ****************************************************************
-- tWalkToBathroom 
-- ****************************************************************
tActions.WalkToBathroom = {

	-- name
	szName = "WalkToBathroom",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end
	  PetAI.tPathFunc.EnableTransNodes()	
	  PetAI.tThinkFunc.DoStand()	  
		PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tThinkFunc.TransitionTo("Bathroom")
		DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tWalkToKitchen
-- ****************************************************************
tActions.WalkToKitchen = {

	-- name
	szName = "WalkToKitchen",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  PetAI.tPathFunc.EnableTransNodes()	
	  PetAI.tThinkFunc.DoStand()
		PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tThinkFunc.TransitionTo("Kitchen")
		DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end		
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tWalkToLivingRoom 
-- ****************************************************************
tActions.WalkToLivingRoom = {

	-- name
	szName = "WalkToLivingRoom",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  PetAI.tPathFunc.EnableTransNodes()	
	  PetAI.tThinkFunc.DoStand()	  
		PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tThinkFunc.TransitionTo("LivingRoom")
		DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()",ActivePetChannel)		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tWalkToBackyard
-- ****************************************************************
tActions.WalkToBackyard = {

	-- name
	szName = "WalkToBackyard",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
	  PetAI.tPathFunc.EnableTransNodes()	
	  PetAI.tThinkFunc.DoStand()	  
		PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tThinkFunc.TransitionTo("Backyard")
		DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()",ActivePetChannel)
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

//-----------------------------------------------------------------
// Emergency Hunger Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- EatLeftoverFood 
-- ****************************************************************
tActions.EatLeftoverFood = {

	-- name
	szName = "EatLeftoverFood",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iFoodInBowl > 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

	  if (PetAI.szLocation != "Kitchen") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.KITCHEN)
    else     
      PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.EATING_MODE)
      PetAI.tThinkFunc.GiveItem(PetAI.tFoodItemInBowl)
      return
  	end

		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end	
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tLickChops 
-- ****************************************************************
tActions.LickChops = {

	-- name
	szName = "LickChops",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iFoodInBowl <= 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoSitAndSingleAnim({szHead="HeadLickChops",szBody="BodySitIdle",szTail="TailIdle"},nil,pet:GetAnimDuration("HeadLickChops")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end	
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tSniffFoodBowl 
-- ****************************************************************
tActions.SniffFoodBowl = {

	-- name
	szName = "SniffFoodBowl",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iFoodInBowl <= 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  if (PetAI.szLocation != "Kitchen") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.KITCHEN)
    else     
  		tActions.WalkToFoodBowl.ExecuteAction()
  		PetAI.tThinkFunc.DoStandAndSingleAnim("SniffGround","wavSniffGround",pet:GetAnimDuration("SniffGround")*1000)
  	end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tScratchFridge 
-- ****************************************************************
tActions.ScratchFridge = {

	-- name
	szName = "ScratchFridge",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iFoodInBowl <= 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
    if (PetAI.szLocation != "Kitchen") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.KITCHEN)
    else	
		  PetAI.tActions.WalkToRefrigerator.ExecuteAction()
		  PetAI.tThinkFunc.DoStandAndSingleAnim("LeanOnSurface",nil,pet:GetAnimDuration("LeanOnSurface")*1000)
  	end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Emergency Thirst Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- DrinkLeftoverWater 
-- ****************************************************************
tActions.DrinkLeftoverWater = {

	-- name
	szName = "DrinkLeftoverWater",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iWaterInBowl > 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

	  if (PetAI.szLocation != "Kitchen") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.KITCHEN)
    else     
      PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.DRINKING_MODE)
      PetAI.tThinkFunc.GiveItem(PetAI.tWaterItemInBowl)
      return
  	end

		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end	
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tPant 
-- ****************************************************************
tActions.Pant = {

	-- name
	szName = "Pant",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iWaterInBowl <= 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end			
    PetAI.tThinkFunc.DoSitAndSingleAnim({szHead="HeadPant",szBody="BodySitIdle",szTail="TailIdle"},nil,pet:GetAnimDuration("HeadPant")*1000)		
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tPantAtBowl 
-- ****************************************************************
tActions.PantAtBowl = {

	-- name
	szName = "PantAtBowl",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.iWaterInBowl <= 0) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	
   if (PetAI.szLocation != "Kitchen") then
    PetAI.tThinkFunc.LookTowardDesiredRoom(Room.KITCHEN)
   else
		tActions.WalkToWaterBowl.ExecuteAction()
		PetAI.tThinkFunc.DoStandAndSingleAnim("SniffGround","wavSniffGround",pet:GetAnimDuration("SniffGround")*1000)
   end
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end   
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Emergency Love Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tHowl 
-- ****************************************************************
tActions.Howl = {

	-- name
	szName = "Howl",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitHowl","wavDogHowl",pet:GetAnimDuration("SitHowl")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- RunToPlayer
-- ****************************************************************
tActions.RunToPlayer = {

	-- name
	szName = "RunToPlayer",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
  	local tCurRoom = PetAI.tPathFunc.tRooms[PetAI.szLocation]
  	local tAttnNode = tCurRoom.GetAttentionNode()	
	
		if not (PetAI.tPathFunc.PointsEqual(PetAI.tPathFunc.GetClosestNodeToPet(),tAttnNode)) then
  		PetAI.tThinkFunc.LoadNewAnim({szBody="Run"},0.5)
  		PetAI.tPathFunc.WalkToPathNode(tAttnNode,"Run","BodyIdle",fPetSpeed)	
  	end
  
  	DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
		  
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tApproachPlayerAndVocalize 
-- ****************************************************************
tActions.ApproachPlayerAndVocalize = {

	-- name
	szName = "ApproachPlayerAndVocalize",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
  	local tCurRoom = PetAI.tPathFunc.tRooms[PetAI.szLocation]
  	local tAttnNode = tCurRoom.GetAttentionNode()	
	
		if not (PetAI.tPathFunc.PointsEqual(PetAI.tPathFunc.GetClosestNodeToPet(),tAttnNode)) then
  		PetAI.tThinkFunc.LoadNewAnim({szBody="Walk1"},0.5)
  		PetAI.tPathFunc.WalkToPathNode(tAttnNode,"BodyWalk","BodyIdle",fPetSpeed)	
  	end
  
  	DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
	
	  if (math.random(100) > 50) then PetAI.tThinkFunc.DoSitAndSingleAnim("SitHowl","wavDogHowl",pet:GetAnimDuration("SitHowl")*1000)
	  else PetAI.tThinkFunc.DoSitAndSingleAnim("SitSpeak","wavPetSpeak"..math.random(7),pet:GetAnimDuration("SitSpeak")*1000) end
	  
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tScratchFurniture 
-- ****************************************************************
tActions.ScratchFurniture = {

	-- name
	szName = "ScratchFurniture",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
    if (PetAI.szLocation != "LivingRoom") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.LIVINGROOM)
    else   	
    
      local szTagPrefix = "dog"
      
	    if (PetAI.tThinkFunc.IsDog()) then
  	    if (PetAI.tBreed.szName == "Beagle") then szTagPrefix = "beagle"
  	    elseif (PetAI.tBreed.szName == "Pug") then szTagPrefix = "pug" end
	    else szTagPrefix = "cat" end
	  	
	    local tScratchPos = {Room.m_cSofa:GetBonePosition(Room.m_cSofa:GetBoneIndex("-tag "..szTagPrefix.." scratch"))}		  
	    local tScratchNode = PetAI.tPathFunc.FindClosestPathNode(tScratchPos[1],tScratchPos[2],tScratchPos[3],"LivingRoom")
    
      PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		  PetAI.tPathFunc.WalkToPathNode(tScratchNode,"BodyWalk","BodyIdle")	

      local x,y,z = Room.m_cSofa:GetPosition()
   	  DoEvent("Pet.FacePosition("..(5)..","..x..","..y..","..z..")",ActivePetChannel)

  		PetAI.tThinkFunc.DoStandAndSingleAnim("ScratchFurniture","wavScratchFurniture",pet:GetAnimDuration("ScratchFurniture")*1000)
    end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Emergency Grooming Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tScratchEar 
-- ****************************************************************
tActions.ScratchEar = {

	-- name
	szName = "ScratchEar",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitScratch","wavScratchSelf",pet:GetAnimDuration("SitScratch")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tCleanFur 
-- ****************************************************************
tActions.CleanFur = {

	-- name
	szName = "CleanFur",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("CleanFur","wavCleanSelf",pet:GetAnimDuration("CleanFur")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tScratchAtTub 
-- ****************************************************************
tActions.ScratchAtTub = {

	-- name
	szName = "ScratchAtTub",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	
    if (PetAI.szLocation != "Bathroom") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.BATHROOM)
    else   	    	
    	PetAI.tActions.WalkToTub.ExecuteAction()
      PetAI.tThinkFunc.DoStandAndSingleAnim("ScratchFurniture",nil,pet:GetAnimDuration("ScratchFurniture")*1000)
		end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Emergency Alertness Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tLieDownTired 
-- ****************************************************************
tActions.LieDownTired = {	

	-- name
	szName = "LieDownTired",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
		
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoStand()
	  PetAI.tThinkFunc.DoAnimTransition("LayDown",{szBody="BodyLayIdle",szHead="HeadYawn",szTail="TailIdle",szEye="EyeClose"},pet:GetAnimDuration("LayDown")*1000)	
    DoLuaEvent("PetAI.tSoundFX.wavPetYawn:Play()",ActivePetChannel)
		DoEvent("System.Sleep(4000)",ActivePetChannel)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tGoToBed 
-- ****************************************************************
tActions.GoToBed = {

	-- name
	szName = "GoToBed",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
		
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end					
	  if (PetAI.szLocation != "LivingRoom") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.LIVINGROOM)
      if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
    else   	    	
  	  PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.SLEEPING_MODE)
	  end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Emergency Bladder Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tNeedToGoVocalize 
-- ****************************************************************
tActions.NeedToGoVocalize = {

	-- name
	szName = "NeedToGoVocalize",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				

    if CATZ then PetAI.tThinkFunc.DoSitAndSingleAnim("SitSpeak","wavNeedToGo",pet:GetAnimDuration("SitSpeak")*1000)
    else PetAI.tThinkFunc.DoSitAndSingleAnim("SitHowl","wavNeedToGo",pet:GetAnimDuration("SitHowl")*1000) end

		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
} 

-- ****************************************************************
-- tDefecateInBackyard 
-- ****************************************************************
tActions.DefecateInBackyard = {

	-- name
	szName = "DefecateInBackyard",

	-- precondition checking function
	CheckPrecondition = function() return(szSpotToDefecate == nil or szSpotToDefecate == "Backyard") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
 	  szSpotToDefecate = "Backyard"
	  if (PetAI.szLocation != "Backyard") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.BACKYARD)
    else   	    	
  	  PetAI.tThinkFunc.DoDefecate()
      szSpotToDefecate = nil  	  
	  end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	

	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tDefecateInLivingRoom 
-- ****************************************************************
tActions.DefecateInLivingRoom = {

	-- name
	szName = "DefecateInLivingRoom",

	-- precondition checking function
	CheckPrecondition = function() return(szSpotToDefecate == nil or szSpotToDefecate == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
 	  szSpotToDefecate = "LivingRoom"
	  if (PetAI.szLocation != "LivingRoom") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.LIVINGROOM)
    else   	    	
  	  PetAI.tThinkFunc.DoDefecate()
      szSpotToDefecate = nil
	  end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,		
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tDefecateInKitchen 
-- ****************************************************************
tActions.DefecateInKitchen = {

	-- name
	szName = "DefecateInKitchen",

	-- precondition checking function
	CheckPrecondition = function() return(szSpotToDefecate == nil or szSpotToDefecate == "Kitchen") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
 	  szSpotToDefecate = "Kitchen"
	  if (PetAI.szLocation != "Kitchen") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.KITCHEN)
    else   	    	
  	  PetAI.tThinkFunc.DoDefecate()
      szSpotToDefecate = nil
	  end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,		
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tDefecateInBathroom 
-- ****************************************************************
tActions.DefecateInBathroom = {

	-- name
	szName = "DefecateInBathroom",

	-- precondition checking function
	CheckPrecondition = function() return(DOGZ and szSpotToDefecate == nil or szSpotToDefecate == "Bathroom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				

 	  szSpotToDefecate = "Bathroom"
 	  
	  if (PetAI.szLocation != "Bathroom") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.BATHROOM)
    else   	    	
  	  PetAI.tThinkFunc.DoDefecate()
      szSpotToDefecate = nil
	  end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,		
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tDefecateInBathroomLitterBox 
-- ****************************************************************
tActions.DefecateInBathroomLitterBox = {

	-- name
	szName = "DefecateInBathroomLitterBox",

	-- precondition checking function
	CheckPrecondition = function() return (CATZ and (szSpotToDefecate == nil or szSpotToDefecate == "Litterbox")) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 50.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
 	  
 	  szSpotToDefecate = "Litterbox"
 	  
 	  if (PetAI.szLocation != "Bathroom") then
      PetAI.tThinkFunc.LookTowardDesiredRoom(Room.BATHROOM)
 	  else
 	    PetAI.tThinkFunc.DoWalkToClosestNode({Room.m_cLitterBox:GetBonePosition(Room.m_cLitterBox:GetBoneIndex("-tag urinate"))})		  	  	  
      DoLuaEvent("PetAI.tThinkFunc.DoDefecate()",ActivePetChannel)
      DoLuaEvent("szSpotToDefecate = nil",ActivePetChannel)
		end
		
 		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end		
	end,		
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Memory Failure Actions (Confusion)
//-----------------------------------------------------------------

-- ****************************************************************
-- tConfusedVocalize 
-- ****************************************************************
tActions.ConfusedVocalize = {

	-- name
	szName = "ConfusedVocalize",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
	  PetAI.tThinkFunc.DoStand()
    DoLuaEvent("Room.DoQuestionMark()",ActivePetChannel)
		PetAI.tThinkFunc.DoSingleAnim("Confused","wavConfused",pet:GetAnimDuration("Confused")*1000)
		DoLuaEvent("Room.KillPetIndicator()",ActivePetChannel)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Obedience Failure Actions (Stubborness)
//-----------------------------------------------------------------

-- ****************************************************************
-- tShakeHeadDefiantly 
-- ****************************************************************
tActions.ShakeHeadDefiantly = {

	-- name
	szName = "ShakeHeadDefiantly",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		
		Room.DoFrownIcon()
		PetAI.tThinkFunc.LoadNewAnim({szHead="HeadShake"},0.25)
		DoLuaEvent("PetAI.tSoundFX.wavRefuse:Play()",ActivePetChannel)
		DoEvent("System.Sleep(800)",ActivePetChannel)
		DoLuaEvent("Room.KillPetIndicator()",ActivePetChannel)
		DoLuaEvent("PetAI.tThinkFunc.DoIdle()",ActivePetChannel)		
			
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Tricks
//-----------------------------------------------------------------

-- ****************************************************************
-- Promenade 
-- ****************************************************************
tActions.Promenade = {

	-- name
	szName = "Promenade",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .1,
		iAgilityMod = .1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)	
		if (bMakeAvailable == nil) then bMakeAvailable = true end		
	  if (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) and (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.TALENT_SHOW)) then
  	  local tCurRoom = PetAI.tPathFunc.tRooms[PetAI.szLocation]
  	  local tAttnNode = tCurRoom.GetAttentionNode()	
  		PetAI.tThinkFunc.LoadNewAnim({szBody="Walk1"},0.5)
  		PetAI.tPathFunc.WalkToPathNode(tAttnNode,"BodyWalk","BodyIdle",fPetSpeed)	
     	DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
      PetAI.tThinkFunc.DoPromenade()
    else
      if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then PetAI.tThinkFunc.TurnForPromenade() end
      PetAI.tThinkFunc.DoStand() 
      PetAI.tThinkFunc.DoPromenade()  
    end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end    
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iEasy,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
} 

-- ****************************************************************
-- tSit 
-- ****************************************************************
tActions.Sit = {

	-- name
	szName = "Sit",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .1,
		iAgilityMod = .1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end		
		if not (PetAI.tThinkFunc.IsSitting()) then
			if (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then 
				PetAI.tThinkFunc.DoAnimTransition("Sit","SitIdle",pet:GetAnimDuration("Sit")*1000)
        if (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.TALENT_SHOW)) then DoEvent("System.Sleep("..(2*1000)..")",ActivePetChannel) end
			else
				PetAI.tThinkFunc.DoAnimTransition("Sit",{szHead="HeadIdle",szBody="BodySitIdle"}, pet:GetAnimDuration("Sit")*1000)				
			end
		end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iEasy,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
} 

-- ****************************************************************
-- tLieDown 
-- ****************************************************************
tActions.LieDown = {

	-- name
	szName = "LieDown",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = true,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .12,
		iAgilityMod = .12,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end		
		if not (PetAI.tThinkFunc.IsLyingDown()) then
		  if (PetAI.tBreed.szName == "Pug") then PetAI.tThinkFunc.DoStand() end
			if (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then 
				PetAI.tThinkFunc.DoAnimTransition("LayDown","LayIdle",pet:GetAnimDuration("LayDown")*1000)			
        if (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.TALENT_SHOW)) then DoEvent("System.Sleep("..(2*1000)..")",ActivePetChannel) end
			else
				PetAI.tThinkFunc.DoAnimTransition("LayDown",{szBody="BodyLayIdle",szHead="HeadIdle"},pet:GetAnimDuration("LayDown")*1000)			
			end	
		end
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iEasy,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
}

-- ****************************************************************
-- tSpeak 
-- ****************************************************************
tActions.Speak = {

	-- name
	szName = "Speak",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .1,
		iStaminaMod = .1,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},

	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end		
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitSpeak","wavPetSpeak"..math.random(7),pet:GetAnimDuration("SitSpeak")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iEasy,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
}

-- ****************************************************************
-- tGivePaw 
-- ****************************************************************
tActions.GivePaw = {

	-- name
	szName = "GivePaw",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .12,
		iStaminaMod = 0,
		iAgilityMod = .1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end		
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitGivePaw",nil,pet:GetAnimDuration("SitGivePaw")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iEasy,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
}

-- ****************************************************************
-- tBeg 
-- ****************************************************************
tActions.Beg = {

	-- name
	szName = "Beg",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .2,
		iAgilityMod = .2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)			
		if (bMakeAvailable == nil) then bMakeAvailable = true end		
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitBeg",nil,pet:GetAnimDuration("SitBeg")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iEasy,
	iAgDifficulty = 90,
	
	-- table of any special effects
	tSpecialEffects = {},
		
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "BegFail" }
} 

-- ****************************************************************
-- tWavePaw 
-- ****************************************************************
tActions.WavePaw = {

	-- name
	szName = "WavePaw",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .2,
		iAgilityMod = .2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitWavePaw",nil,pet:GetAnimDuration("SitWavePaw")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iHard,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
}

-- ****************************************************************
-- tRollOver 
-- ****************************************************************
tActions.RollOver = {

	-- name
	szName = "RollOver",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .1,
		iStaminaMod = .2,
		iAgilityMod = .2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				

    PetAI.tThinkFunc.DoLieDown()
    PetAI.tThinkFunc.LoadNewAnim("RollOver",0.25)
		DoEvent("System.Sleep("..(pet:GetAnimDuration("RollOver")*1000)..")",ActivePetChannel)
		PetAI.tThinkFunc.LoadNewAnim({szBody="BodyLayIdle",szHead="HeadIdle",szTail="TailIdle"},1.0)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iHard,
	iAgDifficulty = 80,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "RollOverFail" }
}

-- ****************************************************************
-- tHide 
-- ****************************************************************
tActions.Hide = {

	-- name
	szName = "Hide",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .15,
		iStaminaMod = .2,
		iAgilityMod = .2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
    PetAI.tThinkFunc.DoLieDown()
    PetAI.tThinkFunc.LoadNewAnim("Hide",0.25)
		DoEvent("System.Sleep("..(pet:GetAnimDuration("Hide")*1000)..")",ActivePetChannel)
		PetAI.tThinkFunc.LoadNewAnim({szBody="BodyLayIdle",szHead="HeadIdle",szTail="TailIdle"},1.0)		
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iExpert,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
}

-- ****************************************************************
-- tNodHead 
-- ****************************************************************
tActions.NodHead = {

	-- name
	szName = "NodHead",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .2,
		iAgilityMod = .3,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoSitAndSingleAnim({szHead="HeadNod"},nil,pet:GetAnimDuration("HeadNod")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iHard,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
}

-- ****************************************************************
-- tShakeHead 
-- ****************************************************************
tActions.ShakeHead = {

	-- name
	szName = "ShakeHead",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = .2,
		iAgilityMod = .3,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoSitAndSingleAnim({szHead="HeadShake"},nil,pet:GetAnimDuration("HeadShake")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iHard,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {},
		
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = {}
} 

-- ****************************************************************
-- tBow 
-- ****************************************************************
tActions.Bow = {

	-- name
	szName = "Bow",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .2,
		iStaminaMod = .3,
		iAgilityMod = .3,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoSitAndSingleAnim("SitBow",nil,pet:GetAnimDuration("SitBow")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iHard,
	iAgDifficulty = 100,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "BowFail" }
}

-- ****************************************************************
-- tPlayDead 
-- ****************************************************************
tActions.PlayDead = {

	-- name
	szName = "PlayDead",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .2,
		iStaminaMod = .4,
		iAgilityMod = .4,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoLieDownAndSingleAnim("PlayDead",nil,pet:GetAnimDuration("PlayDead")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iExpert,
	iAgDifficulty = 110,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "PlayDeadFail" }
}

-- ****************************************************************
-- tJump 
-- ****************************************************************
tActions.Jump = {

	-- name
	szName = "Jump",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .2,
		iStaminaMod = .3,
		iAgilityMod = .3,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("Jump",nil,pet:GetAnimDuration("Jump")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iExpert,
	iAgDifficulty = 100,
	
	-- table of any special effects
	tSpecialEffects = {},
		
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "JumpFail" }
} 

-- ****************************************************************
-- StandOnHindLegs 
-- ****************************************************************
tActions.StandOnHindLegs = {

	-- name
	szName = "StandOnHindLegs",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .3,
		iStaminaMod = .4,
		iAgilityMod = .4,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("StandOnHindLegs",nil,pet:GetAnimDuration("StandOnHindLegs")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iExpert,
	iAgDifficulty = 130,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "StandOnHindLegsFail" }
}

-- ****************************************************************
-- tBackflip 
-- ****************************************************************
tActions.Backflip = {

	-- name
	szName = "Backflip",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = true,
	bInterruptible = false,

	-- memory values
	fMemValue = 10.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = .5,
		iStaminaMod = .5,
		iAgilityMod = .5,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMed,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("BackFlip",nil,pet:GetAnimDuration("Backflip")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iExpert,
	iAgDifficulty = 175,
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- failure actions
	tMemoryFailureActions = { "ConfusedVocalize" },
	tObedienceFailureActions = { "ShakeHeadDefiantly" },
	tAgilityFailureActions = { "BackflipFail" }
}

//-----------------------------------------------------------------
// Trick Failure Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- BowFail 
-- ****************************************************************
tActions.BowFail = {

	-- name
	szName = "BowFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoSitAndSingleAnim("BowFail",nil,pet:GetAnimDuration("BowFail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,		
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- PlayDeadFail 
-- ****************************************************************
tActions.PlayDeadFail = {

	-- name
	szName = "PlayDeadFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  	PetAI.tThinkFunc.DoLieDownAndSingleAnim("PlayDead",nil,pet:GetAnimDuration("PlayDead")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	

	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- JumpFail 
-- ****************************************************************
tActions.JumpFail = {

	-- name
	szName = "JumpFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("JumpFail",nil,pet:GetAnimDuration("JumpFail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- BackflipFail 
-- ****************************************************************
tActions.BackflipFail = {

	-- name
	szName = "BackflipFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("BackFlipFail",nil,pet:GetAnimDuration("BackFlipFail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,		
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- StandOnHindLegsFail 
-- ****************************************************************
tActions.StandOnHindLegsFail = {

	-- name
	szName = "StandOnHindLegsFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.DoStandAndSingleAnim("StandOnHindLegsFail",nil,pet:GetAnimDuration("StandOnHindLegsFail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- RollOverFail 
-- ****************************************************************
tActions.RollOverFail = {

	-- name
	szName = "RollOverFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoLieDownAndSingleAnim("RollOverFail",nil,pet:GetAnimDuration("RollOverFail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- BegFail 
-- ****************************************************************
tActions.BegFail = {

	-- name
	szName = "BegFail",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end				
		PetAI.tThinkFunc.DoSitAndSingleAnim("BegFail",nil,pet:GetAnimDuration("BegFail")*1000)
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,	
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Item Usage Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- tEatFoodBag 
-- ****************************************************************
tActions.EatFoodBag = {

	-- name
	szName = "EatFoodBag",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    PetAI.tActions.WalkToFoodBowl.ExecuteAction(false)
		PetAI.tThinkFunc.LoadNewAnim("Drink",1.0)	
    DoLuaEvent("PetAI.tSoundFX.wavEating:Play()",ActivePetChannel)		
    DoLuaEvent("PetAI.tThinkFunc.ProcessEffects(PetAI.tItems."..PetAI.tFoodItemInBowl.szName..")",ActivePetChannel)		
    DoLuaEvent("table.insert(PetAI.tActiveEffects,PetAI.tEffects.CreateAnimCancelOnHungerMaxEffect())",ActivePetChannel)
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tEatFoodCan 
-- ****************************************************************
tActions.EatFoodCan = {

	-- name
	szName = "EatFoodCan",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

	  PetAI.tActions.WalkToFoodBowl.ExecuteAction(false)
		PetAI.tThinkFunc.LoadNewAnim("Drink",1.0)
    DoLuaEvent("PetAI.tSoundFX.wavEating:Play()",ActivePetChannel)		
    DoLuaEvent("PetAI.tThinkFunc.ProcessEffects(PetAI.tItems."..PetAI.tFoodItemInBowl.szName..")",ActivePetChannel)		
		DoLuaEvent("table.insert(PetAI.tActiveEffects,PetAI.tEffects.CreateAnimCancelOnHungerMaxEffect())",ActivePetChannel)
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {
		function()
			
			
		end
	}
}

-- ****************************************************************
-- tDrinkWaterBottle 
-- ****************************************************************
tActions.DrinkWaterBottle = {

	-- name
	szName = "DrinkWaterBottle",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

	  PetAI.tActions.WalkToWaterBowl.ExecuteAction(false)	  
		PetAI.tThinkFunc.LoadNewAnim("Drink",1.0)
    DoLuaEvent("PetAI.tSoundFX.wavDrinking:Play()",ActivePetChannel)		
    DoLuaEvent("PetAI.tThinkFunc.ProcessEffects(PetAI.tItems."..PetAI.tWaterItemInBowl.szName..")",ActivePetChannel)		
		DoLuaEvent("table.insert(PetAI.tActiveEffects,PetAI.tEffects.CreateAnimCancelOnThirstMaxEffect())",ActivePetChannel)
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- tEatTreat 
-- ****************************************************************
tActions.EatTreat = {

	-- name
	szName = "EatTreat",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = tActions.GroomingEffects.iMin,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
		PetAI.tThinkFunc.LoadNewAnim({szHead="HeadDrink"},0.25)
		DoLuaEvent("PetAI.tSoundFX.wavPetEatTreat:Play()",ActivePetChannel)
		DoEvent("System.Sleep("..(pet:GetAnimDuration("HeadDrink")*1000+500)..")",ActivePetChannel)
		
    -- jump down from an elevated surface immediately (if necessary)
    local x,y,z = pet:GetPosition()
    if (PetAI.tJumpDownInfo != nil and (y > 0)) then PetAI.tThinkFunc.JumpDownFromObject() end
		
		DoLuaEvent("PetAI.tThinkFunc.DoIdle()",ActivePetChannel)

		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Head Look Actions
//-----------------------------------------------------------------

-- ****************************************************************
-- LookAtPlayer
-- ****************************************************************
tActions.LookAtPlayer = {

	-- name
	szName = "LookAtPlayer",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.CAMERA",ActivePetChannel)
    DoEvent("System.Sleep(400)",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.NONE Room.PetLookAtStop()",ActivePetChannel) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- LookAtPlayerAndBark
-- ****************************************************************
tActions.LookAtPlayerAndBark = {

	-- name
	szName = "LookAtPlayerAndBark",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    --DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.CAMERA",ActivePetChannel)
    PetAI.tThinkFunc.DoSingleAnim({szHead="HeadBark",szTail="TailExcited"},"wavHeadBark"..math.random(7),pet:GetAnimDuration("HeadBark")*1000)
    DoEvent("System.Sleep(400)",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.NONE Room.PetLookAtStop()",ActivePetChannel) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- LookAtFocalObject
-- ****************************************************************
tActions.LookAtFocalObject = {

	-- name
	szName = "LookAtFocalObject",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    local x,y,z = PetAI.cFocalObjectRef:GetPosition()
    DoEvent("Pet.FacePosition("..(5)..","..x..","..y..","..z..")",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.OBJECT",ActivePetChannel)
    DoEvent("System.Sleep(400)",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.NONE Room.PetLookAtStop()",ActivePetChannel) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- LookAtFocalObjectAndBark
-- ****************************************************************
tActions.LookAtFocalObjectAndBark = {

	-- name
	szName = "LookAtFocalObjectAndBark",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    local x,y,z = PetAI.cFocalObjectRef:GetPosition()
    if (PetAI.cFocalObjectTag != nil) then x,y,z = PetAI.cFocalObjectRef:GetBonePosition(PetAI.cFocalObjectTag) end
    DoEvent("Pet.FacePosition("..(5)..","..x..","..y..","..z..")",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.OBJECT",ActivePetChannel)
    PetAI.tThinkFunc.DoStandAndSingleAnim({szHead="HeadBark",szBody="BodyIdle",szTail="TailExcited"},"wavHeadBark"..math.random(7),pet:GetAnimDuration("HeadBark")*1000)
    DoEvent("System.Sleep(400)",ActivePetChannel)
    DoLuaEvent("PetAI.CUR_LOOK_STATE = PetAI.LOOK_STATES.NONE Room.PetLookAtStop()",ActivePetChannel) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- WalkToFocalObject
-- ****************************************************************
tActions.WalkToFocalObject = {

	-- name
	szName = "WalkToFocalObject",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

	  PetAI.tPathFunc.EnableTransNodes()
	  
    local x,y,z = PetAI.cFocalObjectRef:GetPosition()
    if (PetAI.cFocalObjectTag != nil) then x,y,z = PetAI.cFocalObjectRef:GetBonePosition(PetAI.cFocalObjectTag) end

	  local tObjectNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,PetAI.szLocation)
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tObjectNode,"BodyWalk","BodyIdle")	
            
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
		DoLuaEvent("PetAI.tPathFunc.DisableTransNodes()")		
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- LookUp
-- ****************************************************************
tActions.LookUp = {

	-- name
	szName = "LookUp",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
      PetAI.tThinkFunc.LoadNewAnim({szHead="HeadUp"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)       
    else
      PetAI.tThinkFunc.DoStand()
      PetAI.tThinkFunc.LoadNewAnim({szBody="BodyIdle",szHead="HeadUp",szTail="TailIdle"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)    
    end
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


-- ****************************************************************
-- LookDown
-- ****************************************************************
tActions.LookDown = {

	-- name
	szName = "LookDown",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
      PetAI.tThinkFunc.LoadNewAnim({szHead="HeadDown"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)       
    else
      PetAI.tThinkFunc.DoStand()
      PetAI.tThinkFunc.LoadNewAnim({szBody="BodyIdle",szHead="HeadDown",szTail="TailIdle"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)    
    end
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


-- ****************************************************************
-- LookLeft
-- ****************************************************************
tActions.LookLeft = {

	-- name
	szName = "LookLeft",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
      PetAI.tThinkFunc.LoadNewAnim({szHead="HeadLeft"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)       
    else
      PetAI.tThinkFunc.DoStand()
      PetAI.tThinkFunc.LoadNewAnim({szBody="BodyIdle",szHead="HeadLeft",szTail="TailIdle"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)  
    end
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- LookRight
-- ****************************************************************
tActions.LookRight = {

	-- name
	szName = "LookRight",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE)) then
      PetAI.tThinkFunc.LoadNewAnim({szHead="HeadRight"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)       
    else
      PetAI.tThinkFunc.DoStand()
      PetAI.tThinkFunc.LoadNewAnim({szBody="BodyIdle",szHead="HeadRight",szTail="TailIdle"},0.75)
      DoEvent("System.Sleep(600)",ActivePetChannel)  
    end
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

//-----------------------------------------------------------------
// Idle Interaction Scripts
//-----------------------------------------------------------------

-- ****************************************************************
-- ScriptApproachAndBark 
-- ****************************************************************
tActions.ScriptApproachAndBark = {

	-- name
	szName = "ScriptApproachAndBark",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
    
    PetAI.tActions.RunToPlayer.ExecuteAction(false)
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptBarkTrickBark 
-- ****************************************************************
tActions.ScriptBarkTrickBark = {

	-- name
	szName = "ScriptBarkTrickBark",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    PetAI.tThinkFunc.ExecuteRandomAction({"ChaseTail","StandOnHindLegs","Hide"})    
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptSearchUpAndDown 
-- ****************************************************************
tActions.ScriptSearchUpAndDown = {

	-- name
	szName = "ScriptSearchUpAndDown",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	

    -- walk around, look up
    PetAI.tActions.WalkAimlessly.ExecuteAction(false)
    PetAI.tActions.LookUp.ExecuteAction(false)  

    -- walk around, look down
    PetAI.tActions.WalkAimlessly.ExecuteAction(false)
    PetAI.tActions.LookDown.ExecuteAction(false)   
  
    -- walk around, look at player and bark
    PetAI.tActions.WalkAimlessly.ExecuteAction(false)
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptSearchAllOver
-- ****************************************************************
tActions.ScriptSearchAllOver = {

	-- name
	szName = "ScriptSearchAllOver",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
  
    -- do a series of three walking actions plus three random set actions 
    for i = 1,3 do
      PetAI.tActions.WalkAimlessly.ExecuteAction(false)
      PetAI.tThinkFunc.ExecuteRandomAction(tRandSet)      
    end

    -- look at player and bark
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptSitScratchBark
-- ****************************************************************
tActions.ScriptSitScratchBark = {

	-- name
	szName = "ScriptSitScratchBark",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
  
    PetAI.tThinkFunc.DoSit()
    PetAI.tActions.ScratchSelf.ExecuteAction(false)
    PetAI.tThinkFunc.DoStand()
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false) 
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptToyLookBark
-- ****************************************************************
tActions.ScriptToyLookBark = {

	-- name
	szName = "ScriptToyLookBark",

	-- precondition checking function
	CheckPrecondition = function() return((toy != nil) and (toy:GetState() == PetAI.TOY_STATE_ONGROUND)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
   
    PetAI.cFocalObjectRef = toy
    PetAI.cFocalObjectTag = nil
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil",ActivePetChannel)
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptToyWalkSniff
-- ****************************************************************
tActions.ScriptToyWalkSniff = {

	-- name
	szName = "ScriptToyWalkSniff",

	-- precondition checking function
	CheckPrecondition = function() return((toy != nil) and (toy:GetState() == PetAI.TOY_STATE_ONGROUND)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
   
    PetAI.cFocalObjectRef = toy
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil",ActivePetChannel)
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptToyLookPlayerLook
-- ****************************************************************
tActions.ScriptToyLookPlayerLook = {

	-- name
	szName = "ScriptToyLookPlayerLook",

	-- precondition checking function
	CheckPrecondition = function() return((toy != nil) and (toy:GetState() == PetAI.TOY_STATE_ONGROUND)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
   
    PetAI.cFocalObjectRef = toy
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil",ActivePetChannel)
    
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptTired
-- ****************************************************************
tActions.ScriptTired = {

	-- name
	szName = "ScriptTired",

	-- precondition checking function
	CheckPrecondition = function() return(true) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
   
    DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
    PetAI.tActions.Yawn.ExecuteAction(false)
    PetAI.tActions.LookAtPlayer.ExecuteAction(false)
    PetAI.tActions.Yawn.ExecuteAction(false)
    PetAI.tActions.LieDownTired.ExecuteAction(false)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptBackyardSniffPlant
-- ****************************************************************
tActions.ScriptBackyardSniffPlant = {

	-- name
	szName = "ScriptBackyardSniffPlant",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Backyard") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local tRandSet = {"LookLeft","LookRight","LookUp","LookDown","LookAtPlayer","LickChops"}
    PetAI.cFocalObjectRef = Room.m_cBackyard
    PetAI.cFocalObjectTag = Room.m_cBackyard:GetBoneIndex("-tag investigate")
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptBackyardBarkPlant
-- ****************************************************************
tActions.ScriptBackyardBarkPlant = {

	-- name
	szName = "ScriptBackyardBarkPlant",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Backyard") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    PetAI.cFocalObjectRef = Room.m_cBackyard
    PetAI.cFocalObjectTag = Room.m_cBackyard:GetBoneIndex("-tag investigate")
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptBarkAtFireplace
-- ****************************************************************
tActions.ScriptBarkAtFireplace = {

	-- name
	szName = "ScriptBarkAtFireplace",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom" and Room.m_bIsFireplaceOn) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    PetAI.cFocalObjectRef = Room.m_cFireplace
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLieDownFireplace
-- ****************************************************************
tActions.ScriptLieDownFireplace = {

	-- name
	szName = "ScriptLieDownFireplace",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom" and Room.m_bIsFireplaceOn) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local x,y,z = Room.m_cFireplace:GetPosition()
    PetAI.cFocalObjectRef = Room.m_cLivingRoom
    PetAI.cFocalObjectTag = Room.m_cLivingRoom:GetBoneIndex("-tag Investigate")
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    DoEvent("Pet.FacePosition("..(5)..","..x..","..y..","..z..")",ActivePetChannel)
    PetAI.tThinkFunc.DoLieDown()
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptSniffFireplace
-- ****************************************************************
tActions.ScriptSniffFireplace = {

	-- name
	szName = "ScriptSniffFireplace",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom" and (not Room.m_bIsFireplaceOn)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local x,y,z = Room.m_cFireplace:GetPosition()
    PetAI.cFocalObjectRef = Room.m_cLivingRoom
    PetAI.cFocalObjectTag = Room.m_cLivingRoom:GetBoneIndex("-tag Investigate")
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    DoEvent("Pet.FacePosition("..(5)..","..x..","..y..","..z..")",ActivePetChannel)
    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- SniffPeeMess
-- ****************************************************************
tActions.SniffPeeMess = {

	-- name
	szName = "SniffPeeMess",

	-- precondition checking function
	CheckPrecondition = function() return((cPeeStain != nil) and (PetAI.szPeeLocation == PetAI.szLocation)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local x,y,z = cPeeStain:GetPosition()
	  local tPooNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,PetAI.szLocation)
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tPooNode,"BodyWalk","BodyIdle")	

    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


-- ****************************************************************
-- SniffPooMess
-- ****************************************************************
tActions.SniffPooMess = {

	-- name
	szName = "SniffPooMess",

	-- precondition checking function
	CheckPrecondition = function() return((cPoo != nil) and (PetAI.szPooLocation == PetAI.szLocation)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end	
  
    local x,y,z = cPoo:GetPosition()
	  local tPooNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,PetAI.szLocation)
    
    PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
		PetAI.tPathFunc.WalkToPathNode(tPooNode,"BodyWalk","BodyIdle")	

    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
        
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptJumpOnCouchAndBark
-- ****************************************************************
tActions.ScriptJumpOnCouchAndBark = {

	-- name
	szName = "ScriptJumpOnCouchAndBark",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for sofa climbing
    local cObject = Room.m_cSofa

    if CATZ then
      tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat Off Sofa"))}
      tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pug On Sofa"))} 
    else
      tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pets Jump To Sofa"))}
      tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag "..PetAI.tThinkFunc.GetTagPrefix().." On Sofa"))}   
    end
    
    -- setup actions to be performed on sofa
    local DoActionFunc = function()         
      PetAI.tThinkFunc.DoLieDown()
      PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false)
      PetAI.tThinkFunc.DoChannelSleep(4000+math.random(11000)) 
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Right","Left",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptJumpOnCouchAndSleep
-- ****************************************************************
tActions.ScriptJumpOnCouchAndSleep = {

	-- name
	szName = "ScriptJumpOnCouchAndSleep",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for sofa climbing
    local cObject = Room.m_cSofa

    if CATZ then
      tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-Tag Cat Off Sofa"))}
      tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pug On Sofa"))} 
    else
      tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pets Jump To Sofa"))}
      tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag "..PetAI.tThinkFunc.GetTagPrefix().." On Sofa"))}   
    end
    
    -- setup actions to be performed on sofa
    local DoActionFunc = function()   
      PetAI.tThinkFunc.DoAnimTransition("SleepBegin","SleepIdle1",pet:GetAnimDuration("SleepBegin")*1000)
      PetAI.tThinkFunc.DoChannelSleep(4000+math.random(11000)) 
      PetAI.tThinkFunc.DoAnimTransition("SleepEnd",{szBody="BodyIdle",szHead="HeadIdle",szTail="TailIdle"},pet:GetAnimDuration("SleepEnd")*1000)         
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Right","Left",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptJumpOnTableAndBark
-- ****************************************************************
tActions.ScriptJumpOnTableAndBark = {

	-- name
	szName = "ScriptJumpOnTableAndBark",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for coffee table climbing
    local cObject = Room.m_cCoffeeTable
    local tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pets Off Sofa"))}
    local tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag "..PetAI.tThinkFunc.GetTagPrefix().." On Sofa"))}
    
    -- setup actions to be performed on coffee table
    local DoActionFunc = function()
      PetAI.tThinkFunc.DoStand()
      PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false)      
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Left","Right",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptJumpOnTableAndLieDown
-- ****************************************************************
tActions.ScriptJumpOnTableAndLieDown = {

	-- name
	szName = "ScriptJumpOnTableAndLieDown",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    -- configure variables for coffee table climbing
    local cObject = Room.m_cCoffeeTable
    local tOffPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag Pets Off Sofa"))}
    local tOnPos = {cObject:GetBonePosition(cObject:GetBoneIndex("-tag "..PetAI.tThinkFunc.GetTagPrefix().." On Sofa"))}
    
    -- setup actions to be performed on coffee table
    local DoActionFunc = function()
      PetAI.tThinkFunc.DoLieDown()
      PetAI.tThinkFunc.DoChannelSleep(4000+math.random(11000))     
    end

    -- run the action on object helper function
    PetAI.tThinkFunc.DoActionOnObject(tOnPos,tOffPos,"Med","Left","Right",DoActionFunc)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptTiredUsePetBed
-- ****************************************************************
tActions.ScriptTiredUsePetBed = {

	-- name
	szName = "ScriptTiredUsePetBed",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.tActions.Yawn.ExecuteAction(false)
    PetAI.tThinkFunc.DoWalkToClosestNode({Room.m_cPetBed:GetPosition()})
    PetAI.tThinkFunc.DoFaceCamera()
    PetAI.tActions.LieDownTired.ExecuteAction(false)
    PetAI.tThinkFunc.DoChannelSleep(3000)
    PetAI.tActions.Yawn.ExecuteAction(false)
    PetAI.tThinkFunc.DoPetSleep(4000+math.random(11000)) 
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptScratchPost
-- ****************************************************************
tActions.ScriptScratchPost = {

	-- name
	szName = "ScriptScratchPost",

	-- precondition checking function
	CheckPrecondition = function() return(CATZ and PetAI.szLocation == "LivingRoom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cScratchingPost
    PetAI.cFocalObjectTag = Room.m_cScratchingPost:GetBoneIndex("-tag cat body")
    PetAI.tActions.LookAtFocalObject.ExecuteAction(false)
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tThinkFunc.DoFaceObject(Room.m_cScratchingPost)
    PetAI.tThinkFunc.DoStandAndSingleAnim('ScratchFurniture','wavScratchFurniture',pet:GetAnimDuration("ScratchFurniture")*1000)
    PetAI.tThinkFunc.DoFaceCamera()
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptScratchBarkFridge
-- ****************************************************************
tActions.ScriptScratchBarkFridge = {

	-- name
	szName = "ScriptScratchBarkFridge",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Kitchen" and (not Room.m_bIsFridgeOpen)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cRefrigerator
    PetAI.cFocalObjectTag = nil
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    PetAI.tThinkFunc.DoStandAndSingleAnim('LeanOnSurface',nil,pet:GetAnimDuration("LeanOnSurface")*1000)
    PetAI.tThinkFunc.DoFaceCamera()
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptSniffOpenFridge
-- ****************************************************************
tActions.ScriptSniffOpenFridge = {

	-- name
	szName = "ScriptSniffOpenFridge",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Kitchen" and Room.m_bIsFridgeOpen) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cRefrigerator
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
    PetAI.tThinkFunc.DoFaceCamera()
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookBarkFridge
-- ****************************************************************
tActions.ScriptLookBarkFridge = {

	-- name
	szName = "ScriptLookBarkFridge",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Kitchen" and (not Room.m_bIsFridgeOpen)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cRefrigerator
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookBarkRadio
-- ****************************************************************
tActions.ScriptLookBarkRadio = {

	-- name
	szName = "ScriptLookBarkRadio",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Kitchen" and ((radio.m_nCurStation != 0) and (radio.m_nCurStation != nil))) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cBoomBox
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookWhineRadio
-- ****************************************************************
tActions.ScriptLookWhineRadio = {

	-- name
	szName = "ScriptLookWhineRadio",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Kitchen" and ((radio.m_nCurStation == 0) or (radio.m_nCurStation == nil))) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cBoomBox
    PetAI.cFocalObjectTag = nil
    PetAI.tActions.LookAtFocalObject.ExecuteAction(false)
    PetAI.tActions.Speak.ExecuteAction(false)
    PetAI.tThinkFunc.DoFaceCamera()
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookBarkKitchenSink
-- ****************************************************************
tActions.ScriptLookBarkKitchenSink = {

	-- name
	szName = "ScriptLookBarkKitchenSink",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Kitchen" and (Room.m_tHouseSFX.wavSinkFaucet:IsPlaying() == 1)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cKitchenFaucet
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookBarkBathroomSink
-- ****************************************************************
tActions.ScriptLookBarkBathroomSink = {

	-- name
	szName = "ScriptLookBarkBathroomSink",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Bathroom" and (Room.m_tHouseSFX.wavSinkFaucet:IsPlaying() == 1)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cBathroomFaucet
    PetAI.cFocalObjectTag = nil
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookBarkTub
-- ****************************************************************
tActions.ScriptLookBarkTub = {

	-- name
	szName = "ScriptLookBarkTub",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Bathroom" and (Room.m_tHouseSFX.wavTub:IsPlaying() == 1)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cTub
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptLookBarkToilet
-- ****************************************************************
tActions.ScriptLookBarkToilet = {

	-- name
	szName = "ScriptLookBarkToilet",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Bathroom" and (Room.m_tHouseSFX.wavToilet:IsPlaying() == 1)) end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = false,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cToilet
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.LookAtFocalObjectAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptSniffToilet
-- ****************************************************************
tActions.ScriptSniffToilet = {

	-- name
	szName = "ScriptSniffToilet",

	-- precondition checking function
	CheckPrecondition = function() return(PetAI.szLocation == "Bathroom") end,

  -- action use count
  iUseCount = 0,
  
	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cToilet
    PetAI.cFocalObjectTag = nil    
    PetAI.tActions.WalkToFocalObject.ExecuteAction(false)
    PetAI.tThinkFunc.DoFaceObject(Room.m_cToilet)
    PetAI.tActions.SniffRandomObject.ExecuteAction(false)
    PetAI.tThinkFunc.DoFaceCamera()
    PetAI.tActions.LookAtPlayerAndBark.ExecuteAction(false)
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}

-- ****************************************************************
-- ScriptUseLitterBox
-- ****************************************************************
tActions.ScriptUseLitterBox = {

	-- name
	szName = "ScriptUseLitterBox",

	-- precondition checking function
	CheckPrecondition = function() return(CATZ and PetAI.szLocation == "Bathroom") end,

  -- action use count
  iUseCount = 0,

	-- flags
	bReinforceable = false,
	bInterruptible = true,

	-- memory values
	fMemValue = 100.0,
	fMemMaxValue = 100.0,

	-- attribute modifiers (conferred during execution)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- action execution function
	ExecuteAction = function(bMakeAvailable)		
		if (bMakeAvailable == nil) then bMakeAvailable = true end

    PetAI.cFocalObjectRef = Room.m_cLitterBox
    PetAI.cFocalObjectTag = nil    
    PetAI.tThinkFunc.DoFaceObject(Room.m_cLitterBox)
    PetAI.tActions.LookAtFocalObject.ExecuteAction(false)
    PetAI.tActions.DefecateInBathroomLitterBox.ExecuteAction(false)
    PetAI.tThinkFunc.DoFaceCamera()
    DoLuaEvent("PetAI.cFocalObjectRef = nil PetAI.cFocalObjectTag = nil",ActivePetChannel)
   
		if (bMakeAvailable) then DoLuaEvent("PetAI.tThinkFunc.MakeAvailable()",ActivePetChannel) end
	end,
	
	-- difficulty settings
	iObDifficulty = tActions.ObedienceThresholds.iNone,
	iAgDifficulty = 0,
	
	-- table of any special effects
	tSpecialEffects = {}
}


return(tActions)
