//-----------------------------------------------------------------
// Breeds
//-----------------------------------------------------------------

local tBreeds = {}

//-----------------------------------------------------------------
// Dog Breeds
//-----------------------------------------------------------------

tBreeds.tDog = {}

-- ****************************************************************
-- tBeagle
-- ****************************************************************
tBreeds.tDog.Beagle = {

	-- name
	szName = "Beagle",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 18,
		iInitAgility = 23,
		iInitObedience = 11,
		iInitStamina = 28
	},
	
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.10,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.10,
		fThirstMod = 0.0,
		fAlertnessMod = -0.05,
		fGroomingMod = -0.05,
		fLoveMod = 0.10,
		fBladderMod = 0.0
	},
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}
}

-- ****************************************************************
-- tBorderCollie
-- ****************************************************************
tBreeds.tDog.BorderCollie = {

	-- name
	szName = "BorderCollie",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 22,
		iInitAgility = 17,
		iInitObedience = 23,
		iInitStamina = 18
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = -0.10,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.10,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}	
}

-- ****************************************************************
-- tGermanShepard
-- ****************************************************************
tBreeds.tDog.GermanShepard = {

	-- name
	szName = "GermanShepard",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 27,
		iInitAgility = 18,
		iInitObedience = 18,
		iInitStamina = 17
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = -0.5,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.10,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}		
}

-- ****************************************************************
-- tGoldenRetriever
-- ****************************************************************
tBreeds.tDog.GoldenRetriever = {

	-- name
	szName = "GoldenRetriever",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 24,
		iInitAgility = 24,
		iInitObedience = 10,
		iInitStamina = 22
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.0,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 1.5,
		fThirstMod = 1.5,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.0,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}		
}

-- ****************************************************************
-- tPug
-- ****************************************************************
tBreeds.tDog.Pug = {

	-- name
	szName = "Pug",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 11,
		iInitAgility = 18,
		iInitObedience = 22,
		iInitStamina = 23
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.10,
		fLoveMod = 0.10,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = -0.05,
		fLoveMod = -0.05,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}			
}

//-----------------------------------------------------------------
// Cat Breeds
//-----------------------------------------------------------------

tBreeds.tCat = {}

-- ****************************************************************
-- tAbyssinian
-- ****************************************************************
tBreeds.tCat.Abyssinian = {

	-- name
	szName = "Abyssinian",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 25,
		iInitAgility = 23,
		iInitObedience = 13,
		iInitStamina = 26
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.10,
		fLoveMod = 0.15,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.10,
		fThirstMod = 0.0,
		fAlertnessMod = -0.05,
		fGroomingMod = -0.05,
		fLoveMod = 0.10,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}			
}

-- ****************************************************************
-- tBengal
-- ****************************************************************
tBreeds.tCat.Bengal = {

	-- name
	szName = "Bengal",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 24,
		iInitAgility = 17,
		iInitObedience = 23,
		iInitStamina = 18
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.05,
		fLoveMod = 0.10,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.5,
		fThirstMod = 0.5,
		fAlertnessMod = 0.0,
		fGroomingMod = -0.10,
		fLoveMod = -0.15,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}
}

-- ****************************************************************
-- tBurmese
-- ****************************************************************
tBreeds.tCat.Burmese = {

	-- name
	szName = "Burmese",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 20,
		iInitAgility = 18,
		iInitObedience = 20,
		iInitStamina = 24
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.0,
		fLoveMod = 0.10,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.0,
		fLoveMod = -0.15,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}	
}

-- ****************************************************************
-- tMaineCoon
-- ****************************************************************
tBreeds.tCat.MaineCoon = {

	-- name
	szName = "MaineCoon",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 24,
		iInitAgility = 22,
		iInitObedience = 26,
		iInitStamina = 16
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = -0.10,
		fThirstMod = -0.10,
		fAlertnessMod = 0.0,
		fGroomingMod = -0.15,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},
		
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = 0.15,
		fThirstMod = 0.15,
		fAlertnessMod = 0.10,
		fGroomingMod = 0.20,
		fLoveMod = 0.0,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}		
}

-- ****************************************************************
-- tSiamese
-- ****************************************************************
tBreeds.tCat.Siamese = {

	-- name
	szName = "Siamese",

	-- initial stat settings
	tInitStats = {
		iInitIntelligence = 24,
		iInitAgility = 30,
		iInitObedience = 8,
		iInitStamina = 22
	},
		
	-- need satiation modifiers
	tNeedSatiateModifiers = {
		fHungerMod = 0.0,
		fThirstMod = 0.0,
		fAlertnessMod = 0.0,
		fGroomingMod = 0.10,
		fLoveMod = -0.35,
		fBladderMod = 0.0
	},
	
	-- need depletion modifiers
	tNeedDepleteModifiers = {
		fHungerMod = -0.05,
		fThirstMod = -0.05,
		fAlertnessMod = 0.0,
		fGroomingMod = -0.05,
		fLoveMod = -0.30,
		fBladderMod = 0.0
	},	
	
	-- special behaviors (optional)	
	tSpecialBehaviors = {}			
}

return(tBreeds)