local tEffects = {}

//-----------------------------------------------------------------
// CreateEffect
//-----------------------------------------------------------------
function tEffects.CreateEffect()

	-- create base effect table
	local tEffect = {}
		
	-- create PetAI.tThinkFunc.Standard PetAI.tThinkFunc.Update function, using three abstract functions to be filled in
	tEffect.Update = function ()
		
		-- if no terminator is given, or terminator evaluates to true...
		if (tEffect.Terminator == nil) or (tEffect.Terminator()) then
		
			-- run the effect's closing function (if any) and then return false	
			if (not (tEffect.OnTerminate == nil)) then tEffect.OnTerminate() end
			return(false)
		
		-- otherwise...
		else
		
			-- run the effect's PetAI.tThinkFunc.Standard processing function (if any)
			if (not (tEffect.Processor == nil)) then tEffect.Processor() end
			return(true)
			
		end
	end
	
	-- return the resulting effect table instance
	return(tEffect)
end

//-----------------------------------------------------------------
// CreateAnimCancelOnHungerMaxEffect
//-----------------------------------------------------------------
function tEffects.CreateAnimCancelOnHungerMaxEffect() 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
		
	-- turn the need's decay off to keep from interfering with results
	PetAI.tNeeds.tHunger.bDecayOn = false
	
	-- set effect to cancel pet's current animation when terminated
	tEffect.OnTerminate = function ()
	  if (PetAI.iFoodInBowl <= 0) then 
	    Room.m_cKibble:SetVisible(0) 
      PetAI.tFoodItemInBowl = nil	    
    end 
		PetAI.iWaitTime = 0
		PetAI.tNeeds.tHunger.bDecayOn = true
	end
	
	-- set effect to terminate when need's value is filled to max
	tEffect.Terminator = function() 
		return((not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.EATING_MODE)) or (PetAI.tNeeds.tHunger.iCurValue >= PetAI.tNeeds.tHunger.iMaxValue) or (PetAI.iFoodInBowl <= 0))
	end
	
	return(tEffect)
end

//-----------------------------------------------------------------
// CreateAnimCancelOnThirstMaxEffect
//-----------------------------------------------------------------
function tEffects.CreateAnimCancelOnThirstMaxEffect() 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
		
	-- turn the need's decay off to keep from interfering with results
	PetAI.tNeeds.tThirst.bDecayOn = false
	
	-- set effect to cancel pet's current animation when terminated
	tEffect.OnTerminate = function ()
	  if (PetAI.iWaterInBowl <= 0) then 
	    Room.m_cBowlWater:SetVisible(0) 
      PetAI.tWaterItemInBowl = nil	    
	  end   
		PetAI.iWaitTime = 0
		PetAI.tNeeds.tThirst.bDecayOn = true
	end
	
	-- set effect to terminate when need's value is filled to max
	tEffect.Terminator = function() 
		return((not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.DRINKING_MODE)) or (PetAI.tNeeds.tThirst.iCurValue >= PetAI.tNeeds.tThirst.iMaxValue) or (PetAI.iWaterInBowl <= 0))
	end
	
	return(tEffect)
end

//-----------------------------------------------------------------
// CreateAnimCancelOnNeedMaxEffect
//-----------------------------------------------------------------
function tEffects.CreateAnimCancelOnNeedMaxEffect(tNeed,cConsumableObject) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()

	-- store effect's linked need
	tEffect.tLinkedNeed = tNeed
	
	-- store ref to consumable object to be removed on cancel
	tEffect.cConsumableToRemove = cConsumableObject
	
	-- store current need setting for restoration at event termination
	tEffect.bSavedDecaySetting = tNeed.bDecayOn
	
	-- turn the need's decay off to keep from interfering with results
	tNeed.bDecayOn = false
	
	-- set effect to cancel pet's current animation when terminated
	tEffect.OnTerminate = function ()
	  if not (tEffect.cConsumableToRemove == nil) then tEffect.cConsumableToRemove:SetVisible(0) end
    PetAI.tThinkFunc.MakeAvailable()    
		PetAI.iWaitTime = 0
		tEffect.tLinkedNeed.bDecayOn = tEffect.bSavedDecaySetting
	end
	
	-- set effect to terminate when need's value is filled to max
	tEffect.Terminator = function() 
		return(tEffect.tLinkedNeed.iCurValue >= tEffect.tLinkedNeed.iMaxValue)
	end
	
	return(tEffect)
end


//-----------------------------------------------------------------
// CreateNeedOverTimeEffect
//-----------------------------------------------------------------
function tEffects.CreateNeedOverTimeEffect(tOwnerAction,iStartTime,tNeed,fAmount,iRate) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
	
	-- store effect's owner
	tEffect.tOwnerAction = tOwnerAction

	-- store effect's start time
	tEffect.iLastUpdateTime = iStartTime

	-- set effect to continually modify attrib's value until terminated
	tEffect.Processor = function ()
		if (FoxGetTickCount() - tEffect.iLastUpdateTime > iRate) then

      if (tNeed.szName == "Hunger") then 
        PetAI.iFoodInBowl = PetAI.iFoodInBowl - fAmount 
        if (PetAI.iFoodInBowl < 0) then PetAI.iFoodInBowl = 0 end
      elseif (tNeed.szName == "Thirst") then 
        PetAI.iWaterInBowl = PetAI.iWaterInBowl - fAmount 
        if (PetAI.iWaterInBowl < 0) then PetAI.iWaterInBowl = 0 end
      end    

			PetAI.tThinkFunc.SetValue(tNeed,fAmount)
			tEffect.iLastUpdateTime = FoxGetTickCount()
		end
	end

	-- set effect to terminate when action is changed
	tEffect.Terminator = function() return((tNeed.iCurValue >= tNeed.iMaxValue) or ((PetAI.tCurAction == nil) or (PetAI.tCurAction != tOwnerAction))) end

	return(tEffect)
end

//-----------------------------------------------------------------
// CreateNeedWhilePettingEffect
//-----------------------------------------------------------------
function tEffects.CreateNeedWhilePettingEffect(iStartTime,tNeed,fAmount,iRate,iInitialWait) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
	
	-- store effect's start time
	tEffect.iLastUpdateTime = iStartTime

	-- store effect's initial delay time
	tEffect.iDelay = iInitialWait

	-- set effect to continually modify attrib's value until terminated
	tEffect.Processor = function ()
		if (tEffect.iDelay == 0) and (FoxGetTickCount() - tEffect.iLastUpdateTime > iRate) then
			PetAI.tThinkFunc.SetValue(tNeed,fAmount)
			tEffect.iLastUpdateTime = FoxGetTickCount()
		elseif (tEffect.iDelay == 0) then
			return
		elseif (FoxGetTickCount() - tEffect.iLastUpdateTime > tEffect.iDelay) then 
			tEffect.iDelay = 0
			tEffect.iLastUpdateTime = FoxGetTickCount()
		end		
	end

	-- set effect to terminate when action is changed
	tEffect.Terminator = function() return(not PetAI.bIsBeingPet) end

	return(tEffect)
end

//-----------------------------------------------------------------
// CreateNeedWhileSleepingEffect
//-----------------------------------------------------------------
function tEffects.CreateNeedWhileSleepingEffect(iStartTime,tNeed,fAmount,iRate,iInitialWait) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
	
	-- store effect's start time
	tEffect.iLastUpdateTime = iStartTime

	-- store effect's initial delay time
	tEffect.iDelay = iInitialWait

	-- set effect to continually modify attrib's value until terminated
	tEffect.Processor = function ()
		if (tEffect.iDelay == 0) and (FoxGetTickCount() - tEffect.iLastUpdateTime > iRate) then
			PetAI.tThinkFunc.SetValue(tNeed,fAmount)
			tEffect.iLastUpdateTime = FoxGetTickCount()
		elseif (tEffect.iDelay == 0) then
			return
		elseif (FoxGetTickCount() - tEffect.iLastUpdateTime > tEffect.iDelay) then 
			tEffect.iDelay = 0
			tEffect.iLastUpdateTime = FoxGetTickCount()
		end		
	end

	-- set effect to terminate when action is changed
	tEffect.Terminator = function() return(not PetAI.tThinkFunc.IsSleepIdle()) end

	return(tEffect)
end

//-----------------------------------------------------------------
// CreateStatTimeReleaseEffect
//-----------------------------------------------------------------
function tEffects.CreateStatTimeReleaseEffect(tOwnerAction,iStartTime,tStat,fAmount,iDuration) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
	
	-- store effect's owner
	tEffect.tOwnerAction = tOwnerAction

	-- set effect to modify stat's max value when terminated
	tEffect.OnTerminate = function ()
		if (FoxGetTickCount() - iStartTime > iDuration) then
			Room.EarnStat(tStat.szName)
			PetAI.tThinkFunc.AdjustMax(tStat,fAmount)		
		end
	end
	
	-- set effect to terminate when duration is expired or action is changed
	tEffect.Terminator = function() 
		local bExpired = (FoxGetTickCount() - iStartTime > iDuration)
		local bActionChanged = not (PetAI.tCurAction == tOwnerAction)
		return(bExpired or bActionChanged)
	end

	return(tEffect)
end

//-----------------------------------------------------------------
// CreateBrushStatTimeReleaseEffect
//-----------------------------------------------------------------
function tEffects.CreateBrushStatTimeReleaseEffect(iStartTime,tStat,fAmount,iDuration) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
	
	-- set effect to modify stat's max value when terminated
	tEffect.OnTerminate = function ()
		if (FoxGetTickCount() - iStartTime > iDuration) then
			Room.EarnStat(tStat.szName)
			PetAI.tThinkFunc.AdjustMax(tStat,fAmount)		
		end
	end
	
	-- set effect to terminate when duration is expired or action is changed
	tEffect.Terminator = function() 
	  if (not PetAI.bIsBeingPet) then iStartTime = FoxGetTickCount() end
		local bExpired = (FoxGetTickCount() - iStartTime > iDuration)
		local bFinishedBrushing = (PetAI.cBrushInHand == nil)
		return(bExpired or bFinishedBrushing)
	end

	return(tEffect)
end

//-----------------------------------------------------------------
// CreateTubStatTimeReleaseEffect
//-----------------------------------------------------------------
function tEffects.CreateTubStatTimeReleaseEffect(iStartTime,tStat,fAmount,iDuration) 

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()
	
	-- set effect to modify stat's max value when terminated
	tEffect.OnTerminate = function ()
		if (FoxGetTickCount() - iStartTime > iDuration) then
			Room.EarnStat(tStat.szName)
			PetAI.tThinkFunc.AdjustMax(tStat,fAmount)		
		end
	end
	
	-- set effect to terminate when duration is expired or action is changed
	tEffect.Terminator = function() 
	  if (not PetAI.bIsBeingPet) then iStartTime = FoxGetTickCount() end
		local bExpired = (FoxGetTickCount() - iStartTime > iDuration)
		local bOutOfTub = (not PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE))
		return(bExpired or bOutOfTub)
	end

	return(tEffect)
end

//-----------------------------------------------------------------
// CreateFoodBasedAttribEffect
//-----------------------------------------------------------------
function tEffects.CreateFoodBasedAttribEffect(tAttribModifiers,EffectModifier)

	-- create base effect table
	local tEffect = PetAI.tEffects.CreateEffect()

	-- use modifier ID to keep track of added depletion modifier
	tEffect.iModifierID = 0

	-- initiate attribute effect
	table.insert(tAttribModifiers,EffectModifier)
	tEffect.iModifierID = table.getn(tAttribModifiers)	

	-- set effect to terminate following Pet defecation
	tEffect.Terminator = function () 
		local bContainsEmptyBladder = not (string.find(PetAI.tCurAction.szName,"Defecate") == nil)
		return(tEmptyBladder)				
	end

	-- set effect to remove added attribute effect when terminated
	tEffect.OnTerminate = function()
		table.remove(tAttribModifiers,tEffect.iModifierID)
	end	
end

return(tEffects)