local tInformalTricks = {}

//-----------------------------------------------------------------
// CreateInformalTrick
//-----------------------------------------------------------------
function tInformalTricks.CreateInformalTrick()

	-- create base informal trick table
	local tInformalTrick = {}

	-- create update function, using three abstract functions to be filled in
	tInformalTrick.Update = function ()

		if (tInformalTrick.IsReady == nil) or (not tInformalTrick.IsReady()) then

			return(true)

		-- if no terminator is given, or terminator evaluates to true...
		elseif (tInformalTrick.Terminator == nil) or (tInformalTrick.Terminator()) then

			-- run the informal trick's closing function (if any) and then return false
			if (not (tInformalTrick.OnTerminate == nil)) then tInformalTrick.OnTerminate() end
			return(false)

		-- otherwise...
		else

			-- run the informal trick's processing function (if any)
			if (not (tInformalTrick.Processor == nil)) then tInformalTrick.Processor() end
			return(true)

		end
	end

	-- return the resulting effect table instance
	return(tInformalTrick)
end

//-----------------------------------------------------------------
// CancelInformalTrick
//-----------------------------------------------------------------
function tInformalTricks.CancelInformalTrick(tInformalTrick)
  tInformalTrick.Terminator = nil
end

//-----------------------------------------------------------------
// CreateFetchTrick
//-----------------------------------------------------------------
function tInformalTricks.CreateFetchTrick(cItem,fCatchProximity)

  -- Use the global 'toy' instead
  cItem = nil

	-- retrieve base informal trick event table
	local tTrick = PetAI.tInformalTricks.CreateInformalTrick()

  --****************************************************************
	-- Initialization
  --****************************************************************

	-- setup trick event variables
	tTrick.tBackyardRef = PetAI.tPathFunc.tRooms.Backyard
	tTrick.tEndNodeRef = PetAI.tPathFunc.tPathMap[tTrick.tBackyardRef.iRowOffset + (tTrick.tBackyardRef.iNumRows - 2)][tTrick.tBackyardRef.iColOffset + math.floor(tTrick.tBackyardRef.iNumCols/3)]
	tTrick.tItemStartRef = {-230,70,150}
	tTrick.tMouthPos = nil
	tTrick.iMouthBoneIndex = pet:GetBoneIndex("-tag Mouth01")
	tTrick.fCatchProximity = fCatchProximity
	tTrick.bCollisionOff = false
  tTrick.tCurDestNode = nil

  tTrick.iLastCheckTime = FoxGetTickCount()

  -- disable trick voice commands
  Room.trick_frame:Disable()
  
  PetAI.tPathFunc.EnableTransNodes()

  PetAI.tThinkFunc.DoStand()	  
	PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
	PetAI.tThinkFunc.TransitionTo("Backyard")

	-- prepare pet for fetch trick
	DoLuaEvent("PetAI.tThinkFunc.DoIdle()",ActivePetChannel)
	DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)

  --****************************************************************
	-- PrepareFetch
  --****************************************************************
  tTrick.PrepareFetch = function()

  	PetAI.bActionInProgress = true
  	PetAI.bFetchTrickReady = false
  	PetAI.bFetchTrickComplete = false
  	
	  tTrick.szCurState = "ITEM_IN_HAND"
  	tTrick.iStartTime = nil	  	
  end

  tTrick.PrepareFetch()

  --****************************************************************
	-- EndFetch
  --****************************************************************
  tTrick.EndFetch = function()
    if (toy != nil) then
      local iToyValue = GetPetToyCost(toy:GetName())
      PetAI.tThinkFunc.SetValue(PetAI.tNeeds.tLove,5+math.floor(iToyValue/50))
    	PetAI.tCurTrickOfTheDay.ProcessUpdate("PerformedFetch",toy:GetName())
      MyGrabToy(toy)
     end
   	 tTrick.PrepareFetch()
  end

  --****************************************************************
	-- CheckItemCollision
  --****************************************************************
	tTrick.CheckItemCollision = function ()

		if (tTrick.bCollisionOff) then return end

		-- get current pet mouth position
		tTrick.tMouthPos = {pet:GetBonePosition(tTrick.iMouthBoneIndex)}

    if (toy == nil) then 
      return(false) 
    else
      local x,y,z = toy:GetPosition()

      local bWithinCatchProximity = (PetAI.tPathFunc.DistanceBetweenTwoPoints({x,y,z},tTrick.tMouthPos) < tTrick.fCatchProximity)
      local bAtClosestNode = PetAI.tPathFunc.PointsEqual(PetAI.tPathFunc.FindClosestPathNode(x,y,z,"Backyard"),PetAI.tPathFunc.GetClosestNodeToPet())
  
	    if (bWithinCatchProximity or ((toy:IsOnGround() == 1) and bAtClosestNode)) then
  	    toy:Link(pet)
		    toy:SetAttachmentBoneIndex(tTrick.iMouthBoneIndex)
		    toy:Pause()
		    RemoveToyFromPhysics()		
	  	  return(true)	  	
	    else
  	    return(false)
	    end
    end
	end

  --****************************************************************
	-- OnTerminate
  --****************************************************************
	tTrick.OnTerminate = function ()

    -- destroy temp flags
		PetAI.bFetchTrickReady = nil
    PetAI.bFetchTrickComplete = nil

    -- disable all trans nodes now that trick is completed
    PetAI.tPathFunc.DisableTransNodes()

    -- enable trick voice commands
    Room.trick_frame:Enable()

		-- reset flags on termination
		PetAI.bActionInProgress = false
		Room.PetLookAtStop()
	end

  --****************************************************************
	-- IsReady
  --****************************************************************
	tTrick.IsReady = function()

		-- if flag already set, return true
		if (PetAI.bFetchTrickReady) then return(true)

		-- otherwise set flag following completion of current event queue
		elseif (PetAI.szLocation == "Backyard") and (PetAI.tThinkFunc.IsIdle()) then
			DoLuaEvent("PetAI.bFetchTrickReady = true")
		end
	end

  --****************************************************************
	-- Terminator
  --****************************************************************
	tTrick.Terminator = function()
    if (toy == nil) or (not ToyIsFetchable(toy)) or (Room.m_nCurRoom != Room.BACKYARD) then
      return(true)
		else return(false) end
	end

  --****************************************************************
	-- Initialization
  --****************************************************************
	tTrick.Processor = function ()
	
    -- if pet is in the middle of a non-interruptible action, return immediately
    if ((PetAI.tCurAction != nil) and (not PetAI.tCurAction.bInterruptible)) then return end
	
    if (PetAI.bFetchTrickComplete) then tTrick.EndFetch() end
	
		if (tTrick.szCurState == "ITEM_IN_HAND") then

			-- ##########################################################
			-- ITEM_IN_HAND State
			-- ##########################################################

			-- transition to new state
			if (toy != nil) and (PetAI.tThinkFunc.IsIdle()) then
    
			  if (toy:IsFlying() == 1) then tTrick.szCurState = "ITEM_IN_FLIGHT"
			  elseif (toy:IsOnGround() == 1) then tTrick.szCurState = "ITEM_ON_GROUND" end
      end

		elseif (tTrick.szCurState == "ITEM_IN_FLIGHT") then

			-- ##########################################################
			-- ITEM_IN_FLIGHT State
			-- ##########################################################

      -- get item position
      local x,y,z = toy:GetPosition()
      
      -- send tip dialog for active inventory button
      PetAI.DoHelpDialog(77)
      
      if (tTrick.tCurDestNode == nil) then tTrick.tCurDestNode = {pet:GetPosition()} end

			if (tTrick.CheckItemCollision()) then
				tTrick.szCurState = "ITEM_PICKED_UP"
				FlushChannel(ActivePetChannel)
        return
		  elseif (FoxGetTickCount() - tTrick.iLastCheckTime > 400)  and (not (PetAI.tPathFunc.PointsEqual(tTrick.tCurDestNode,{x,y,z}))) then
				FlushChannel(ActivePetChannel)
				tTrick.iLastCheckTime = FoxGetTickCount()
				local a,b,c = pet:GetPosition()
        tTrick.tCurDestNode = tPathFunc.FindClosestPathNode(x,y,z,PetAI.szLocation)
 		    DoEvent("Pet.WalkToPosition(Run,BodyIdle,100,90.0,"..a..","..b..","..c..","..tTrick.tCurDestNode[1]..","..tTrick.tCurDestNode[2]..","..tTrick.tCurDestNode[3]..")",ActivePetChannel)
			end

		elseif (tTrick.szCurState == "ITEM_ON_GROUND") then

			-- ##########################################################
			-- ITEM_ON_GROUND State
			-- ##########################################################

				local x,y,z = toy:GetPosition()
				local tClosestGroundNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z-20,"Backyard")

				PetAI.tThinkFunc.LoadNewAnim("Run",1.0)
				PetAI.tPathFunc.WalkToPathNode(tClosestGroundNode,"Run","BodyIdle")
				DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
				PetAI.tThinkFunc.DoPickUpFromGround()

				tTrick.fCatchProximity = tTrick.fCatchProximity

                tTrick.tCurDestNode = tClosestGroundNode

				tTrick.szCurState = "ITEM_BEING_CHASED"

				tTrick.bCollisionOff = false

		elseif (tTrick.szCurState == "ITEM_BEING_CHASED") then
			-- ##########################################################
			-- ITEM_BEING_CHASED State
			-- ##########################################################

			local x,y,z = pet:GetPosition()

			if (tTrick.CheckItemCollision()) then
				tTrick.szCurState = "ITEM_PICKED_UP"
				FlushChannel(ActivePetChannel)
		  else
		    if (PetAI.tPathFunc.PointsEqual(tTrick.tCurDestNode,PetAI.tPathFunc.FindClosestPathNode(x,y,z,PetAI.szLocation))) then
			    tTrick.szCurState = "ITEM_IN_FLIGHT"
			  end
			end

		elseif (tTrick.szCurState == "ITEM_PICKED_UP") then
			-- ##########################################################
			-- ITEM_PICKED_UP State
			-- ##########################################################

			PetAI.tThinkFunc.LoadNewAnim("Run",1)
			PetAI.tPathFunc.WalkToPathNode(tTrick.tEndNodeRef,"Run","BodyIdle")
      tTrick.szCurState = "ITEM_BEING_RETURNED"

		elseif (tTrick.szCurState == "ITEM_BEING_RETURNED") then
			-- ##########################################################
			-- ITEM_BEING_RETURNED State
			-- ##########################################################
 
			local x,y,z = pet:GetPosition()
			local tClosestNode = PetAI.tPathFunc.FindClosestPathNode(x,y,z,"Backyard")

			if (PetAI.tPathFunc.PointsEqual(tClosestNode,tTrick.tEndNodeRef)) then
	  		DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)   	 
        DoLuaEvent("PetAI.bFetchTrickComplete = true",ActivePetChannel)
        tTrick.szCurState = "ITEM_RETURNED"
			end

		elseif (tTrick.szCurState == "ITEM_RETURNED") then
			-- ##########################################################
			-- ITEM_RETURNED State
			-- ##########################################################

      if (PetAI.bFetchTrickComplete) then 
        tTrick.EndFetch() 
      end  
		end
	end

	-- return newly-created informal trick event
	return(tTrick)
end

//-----------------------------------------------------------------
// CreatePlayWithToyTrick
//-----------------------------------------------------------------
function tInformalTricks.CreatePlayWithToyTrick(cItem,fGrabProximity)

    -- use global toy instead
    cItem = nil

	-- retrieve base informal trick event table
	local tTrick = PetAI.tInformalTricks.CreateInformalTrick()

  --****************************************************************
	-- Initialization
  --****************************************************************

	-- setup trick event variables
	tTrick.tBackyardRef = PetAI.tPathFunc.tRooms.Backyard
	tTrick.tItemThrowTarget = PetAI.tPathFunc.tPathMap[tTrick.tBackyardRef.iRowOffset + math.ceil(tTrick.tBackyardRef.iNumRows/2)][tTrick.tBackyardRef.iColOffset + math.floor(tTrick.tBackyardRef.iNumCols/3)]
	tTrick.tItemStartRef = {-230,80,180}
  tTrick.tItemLandRef = nil
	tTrick.szCurState = "PET_LOOK_FOR_ITEM"
	tTrick.tMouthPos = nil
	tTrick.iMouthBoneIndex = pet:GetBoneIndex("-tag Mouth01")

	-- make the pet busy and create an event 'ready' flag
	PetAI.bActionInProgress = true
	PetAI.bPlayWithToyComplete = false

  -- disable trick voice commands
  Room.trick_frame:Disable()

  PetAI.tPathFunc.EnableTransNodes()

  -- stand up and transition to the backyard (from doorway, if necessary)
  PetAI.tThinkFunc.DoStand()	  
	PetAI.tThinkFunc.LoadNewAnim("Walk1",0.5)
	PetAI.tThinkFunc.TransitionTo("Backyard")

	-- prepare pet for toy playing trick
	DoLuaEvent("PetAI.tThinkFunc.DoIdle()",ActivePetChannel)

	-- acknowledge the player's trick request
	DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
	PetAI.tThinkFunc.DoStandAndSingleAnim({szHead="HeadBark"},"wavHeadBark"..math.random(7),pet:GetAnimDuration("HeadBark")*1000)

  --****************************************************************
	-- CheckItemCollision
  --****************************************************************
	tTrick.CheckItemCollision = function ()

		-- get current pet mouth position
		tTrick.tMouthPos = {pet:GetBonePosition(tTrick.iMouthBoneIndex)}

    if (toy == nil) then 
      return(false) 
    else
      local x,y,z = toy:GetPosition()

      local bWithinCatchProximity = (PetAI.tPathFunc.DistanceBetweenTwoPoints({x,y,z},tTrick.tMouthPos) < fGrabProximity)
      local bAtClosestNode = PetAI.tPathFunc.PointsEqual(PetAI.tPathFunc.FindClosestPathNode(x,y,z,"Backyard"),PetAI.tPathFunc.GetClosestNodeToPet())
  
	    if (bWithinCatchProximity or ((toy:IsOnGround() == 1) and bAtClosestNode)) then
  	    toy:Link(pet)
		    toy:SetAttachmentBoneIndex(tTrick.iMouthBoneIndex)
		    toy:Pause()
	  	  return(true)	  	
	    else
  	    return(false)
	    end
    end
	end

  --****************************************************************
	-- OnTerminate
  --****************************************************************
	tTrick.OnTerminate = function ()

		-- reset item
		if (toy != nil) then
		  toy:UnLink()
		  toy:Link(Room.m_cSceneManager)
		  toy:Throw(0,0,0)   
    end

    -- give love boost for toy interaction
    local iToyValue = GetPetToyCost(toy:GetName())
    PetAI.tThinkFunc.SetValue(PetAI.tNeeds.tLove,5+math.floor(iToyValue/50))

    -- disable all trans nodes now that trick is completed
    PetAI.tPathFunc.DisableTransNodes()

    -- enable trick voice commands
    Room.trick_frame:Enable()

		-- reset flags on termination
		PetAI.bActionInProgress = false
		PetAI.bPlayWithToyComplete = nil
		Room.PetLookAtStop()
	end

  --****************************************************************
	-- IsReady
  --****************************************************************
	tTrick.IsReady = function()
		return(true)
	end

  --****************************************************************
	-- Terminator
  --****************************************************************
	tTrick.Terminator = function()
		return(PetAI.bPlayWithToyComplete)
	end

  --****************************************************************
	-- Initialization
  --****************************************************************
	tTrick.Processor = function ()
	
    -- if pet is in the middle of a non-interruptible action, return immediately
    if ((PetAI.tCurAction != nil) and (not PetAI.tCurAction.bInterruptible)) then return end
	
		if (tTrick.szCurState == "PET_LOOK_FOR_ITEM") then

			-- ##########################################################
			-- PET_LOOK_FOR_ITEM State
			-- ##########################################################

			if (toy:IsOnGround() == 1) then

				-- retrieve the pet's current position and closest node
				local x,y,z = pet:GetPosition()

				local tPetPos = {pet:GetPosition()}
				local tItemPos = {toy:GetPosition()}

        tTrick.tItemLandRef = tItemPos

				local tClosestPetNode = PetAI.tPathFunc.FindClosestPathNode(tPetPos[1],tPetPos[2],tPetPos[3],"Backyard")
				local tClosestItemNode = PetAI.tPathFunc.FindClosestPathNode(tItemPos[1],tItemPos[2],tItemPos[3]-10,"Backyard")

				-- if not already in position, move the pet into position for the trick
				if not (PetAI.tPathFunc.PointsEqual(tClosestPetNode,tClosestItemNode)) then
					PetAI.tThinkFunc.LoadNewAnim("Run",1)
					PetAI.tPathFunc.WalkToPathNode(tClosestItemNode,"Run","BodyIdle",120)
				end

				DoEvent("Room.MakePetFaceCamera("..PetAI.fTurningSpeed..")",ActivePetChannel)
				DoEvent("System.Sleep(400)",ActivePetChannel)
				tTrick.szCurState = "PET_WALK_TO_ITEM"
			end

		elseif (tTrick.szCurState == "PET_WALK_TO_ITEM") then

			-- ##########################################################
			-- PET_WALK_TO_ITEM State
			-- ##########################################################

				if (tTrick.CheckItemCollision()) then
					tTrick.szCurState = "PET_PLAY_WITH_ITEM"
					local iRand = math.random(3)
					if (iRand == 1) then PetAI.tThinkFunc.DoStandAndSingleAnim("PlayBiteTearJump",nil,pet:GetAnimDuration("Confused")*1000)
					elseif (iRand == 2) then 
					  if CATZ then PetAI.tThinkFunc.DoStandAndSingleAnim("PlayBiteTearJump",nil,pet:GetAnimDuration("Confused")*1000)
					  else PetAI.tThinkFunc.DoStandAndSingleAnim("PlayShakeInMouth",nil,pet:GetAnimDuration("PlayShakeInMouth")*1000) end
					elseif (iRand == 3) then PetAI.tThinkFunc.DoStandAndSingleAnim("PlayPounce",nil,pet:GetAnimDuration("PlayPounce")*1000)
					end
					DoEvent("System.Sleep(1000)",ActivePetChannel)
					DoLuaEvent("PetAI.bPlayWithToyComplete = true",ActivePetChannel)
				end

		elseif (tTrick.szCurState == "PET_PLAY_WITH_ITEM") then

			-- ##########################################################
			-- PET_PLAY_WITH_ITEM State
			-- ##########################################################

			-- return immediately, awaiting termination
			return
		end
	end

	-- return newly-created informal trick event
	return(tTrick)
end

return(tInformalTricks)
