//-----------------------------------------------------------------
// Items
//-----------------------------------------------------------------

local tItems = {}

//-----------------------------------------------------------------
// Grooming Brushes
//-----------------------------------------------------------------

-- ****************************************************************
-- tGroomingBrushWood
-- ****************************************************************
tItems.tGroomingBrushWood = {

	-- name
	szName = "tGroomingBrushWood",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
		
	-- table of attribute modifiers (conferred when given)
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.01,
		iAgilityMod = 0,
		iObedienceMod = 0.01,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = .6,
		iGroomingMod = .6,
		iBladderMod = 0			
	},
	
	-- table of any special effects
	tSpecialEffects = {},
	
	-- usage action reference
	szUsageAction = "BeBrushed"
}

-- ****************************************************************
-- tGroomingBrushPlastic
-- ****************************************************************
tItems.tGroomingBrushPlastic = {

	-- name
	szName = "tGroomingBrushPlastic",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.02,
		iAgilityMod = 0,
		iObedienceMod = 0.02,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = .8,
		iGroomingMod = .8,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeBrushed"
}

-- ****************************************************************
-- tGroomingBrushSilver
-- ****************************************************************
tItems.tGroomingBrushSilver = {

	-- name
	szName = "tGroomingBrushSilver",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.04,
		iAgilityMod = 0,
		iObedienceMod = 0.04,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 1,
		iGroomingMod = 1,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeBrushed"
}

-- ****************************************************************
-- tGroomingBrushGold
-- ****************************************************************
tItems.tGroomingBrushGold = {

	-- name
	szName = "tGroomingBrushGold",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.06,
		iAgilityMod = 0,
		iObedienceMod = 0.06,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 3,
		iGroomingMod = 1.5,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeBrushed"	
}

//-----------------------------------------------------------------
// Shampoo
//-----------------------------------------------------------------

-- ****************************************************************
-- tShampooGeneric
-- ****************************************************************
tItems.tShampooGeneric = {

	-- name
	szName = "tShampooGeneric",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.07,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 2,
		iGroomingMod = 2,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},

	-- usage action reference	
	szUsageAction = "BeShampooed"	
}

-- ****************************************************************
-- tShampooBrandName
-- ****************************************************************
tItems.tShampooBrandName = {

	-- name
	szName = "tShampooBrandName",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.05,
		iStaminaMod = 0.05,
		iAgilityMod = 0,
		iObedienceMod = 0.05,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 3,
		iGroomingMod = 3,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeShampooed"	
}

-- ****************************************************************
-- tShampooOrganic
-- ****************************************************************
tItems.tShampooOrganic = {

	-- name
	szName = "tShampooOrganic",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.07,
		iStaminaMod = 0.07,
		iAgilityMod = 0,
		iObedienceMod = 0.07,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 4,
		iGroomingMod = 4,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeShampooed"	
}

-- ****************************************************************
-- tShampooLuxury
-- ****************************************************************
tItems.tShampooLuxury = {

	-- name
	szName = "tShampooLuxury",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.1,
		iStaminaMod = 0.1,
		iAgilityMod = 0,
		iObedienceMod = 0.1,
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 5,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeShampooed"	
}

//-----------------------------------------------------------------
// Food Bags
//-----------------------------------------------------------------

-- ****************************************************************
-- tFoodBagGeneric
-- ****************************************************************
tItems.tFoodBagGeneric = {

	-- name
	szName = "tFoodBagGeneric",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 2,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
			PetAI.tNeeds.tBladder.iDecayAmount = PetAI.tNeeds.tBladder.iDecayAmount + (-0.2)
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatFoodBag"	
}

-- ****************************************************************
-- tFoodBagBrandName
-- ****************************************************************
tItems.tFoodBagBrandName = {

	-- name
	szName = "tFoodBagBrandName",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.1,	
		iHungerMod = 4,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 2,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatFoodBag"	
}

-- ****************************************************************
-- tFoodBagOrganic
-- ****************************************************************
tItems.tFoodBagOrganic = {

	-- name
	szName = "tFoodBagOrganic",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.2,	
		iHungerMod = 6,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 4,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatFoodBag"	
}

-- ****************************************************************
-- tFoodBagLuxury
-- ****************************************************************
tItems.tFoodBagLuxury = {

	-- name
	szName = "tFoodBagLuxury",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.2,	
		iHungerMod = 8,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 6,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatFoodBag"	
}

//-----------------------------------------------------------------
// Food Cans
//-----------------------------------------------------------------

-- ****************************************************************
-- tFoodCanGeneric
-- ****************************************************************
tItems.tFoodCanGeneric = {

	-- name
	szName = "tFoodCanGeneric",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 2,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 1,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
			
	-- table of any special effects	
	tSpecialEffects = { 
--		function()
--			table.insert(PetAI.tActiveEffects,PetAI.tEffects.CreateFoodBasedAttribEffect(PetAI.tNeeds.tHunger,PetAI.tThinkFunc.CreatePercentageModifier(0.5)))			
--		end,
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
		-- usage action reference	
	szUsageAction = "EatFoodCan"	
}

-- ****************************************************************
-- tFoodCanBrandName
-- ****************************************************************
tItems.tFoodCanBrandName = {

	-- name
	szName = "tFoodCanBrandName",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.1,	
		iHungerMod = 4,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 3,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference		
	szUsageAction = "EatFoodCan"	
}

-- ****************************************************************
-- tFoodCanOrganic
-- ****************************************************************
tItems.tFoodCanOrganic = {

	-- name
	szName = "tFoodCanOrganic",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.2,	
		iHungerMod = 6,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatFoodCan"	
}

-- ****************************************************************
-- tFoodCanLuxury
-- ****************************************************************
tItems.tFoodCanLuxury = {

	-- name
	szName = "tFoodCanLuxury",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.2,
		iAgilityMod = 0,
		iObedienceMod = 0.2,	
		iHungerMod = 8,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 7,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatFoodCan"	
}

//-----------------------------------------------------------------
// Water Bottles
//-----------------------------------------------------------------

-- ****************************************************************
-- tWaterBottleGeneric
-- ****************************************************************
tItems.tWaterBottleGeneric = {

	-- name
	szName = "tWaterBottleGeneric",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 2,
		iAlertnessMod = 0,
		iLoveMod = 0,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "DrinkWaterBottle"	
}

-- ****************************************************************
-- tWaterBottleBrandName
-- ****************************************************************
tItems.tWaterBottleBrandName = {

	-- name
	szName = "tWaterBottleBrandName",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 4,
		iAlertnessMod = 0,
		iLoveMod = 1,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "DrinkWaterBottle"	
}

-- ****************************************************************
-- tWaterBottlePremium
-- ****************************************************************
tItems.tWaterBottlePremium = {

	-- name
	szName = "tWaterBottlePremium",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.1,	
		iHungerMod = 0,
		iThirstMod = 6,
		iAlertnessMod = 0,
		iLoveMod = 2,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "DrinkWaterBottle"	
}

-- ****************************************************************
-- tWaterBottleLuxury
-- ****************************************************************
tItems.tWaterBottleLuxury = {

	-- name
	szName = "tWaterBottleLuxury",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0,
		iObedienceMod = 0.2,	
		iHungerMod = 0,
		iThirstMod = 8,
		iAlertnessMod = 0,
		iLoveMod = 3,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "DrinkWaterBottle"	
}

//-----------------------------------------------------------------
// Pet Treats
//-----------------------------------------------------------------

-- ****************************************************************
-- tPetTreatGeneric
-- ****************************************************************
tItems.tPetTreatGeneric = {

	-- name
	szName = "tPetTreatGeneric",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = true,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.17,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 1,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatTreat"	
}

-- ****************************************************************
-- tPetTreatOrganic
-- ****************************************************************
tItems.tPetTreatOrganic = {

	-- name
	szName = "tPetTreatOrganic",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = true,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.26,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 2,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatTreat"	
}

-- ****************************************************************
-- tPetTreatLuxury
-- ****************************************************************
tItems.tPetTreatLuxury = {

	-- name
	szName = "tPetTreatLuxury",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = true,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.35,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 4,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {
		function()
			PetAI.tNeeds.tBladder.bDecayOn = true
		end		
	},
	
	-- usage action reference	
	szUsageAction = "EatTreat"	
}

//-----------------------------------------------------------------
// Squirt Bottles
//-----------------------------------------------------------------

-- ****************************************************************
-- tSquirtBottleStandard
-- ****************************************************************
tItems.tSquirtBottleStandard = {

	-- name
	szName = "tSquirtBottleStandard",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = true,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0,
		iAgilityMod = 0,
		iObedienceMod = 0.05,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = -8,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "BeSquirted"	
}

//-----------------------------------------------------------------
// Balls
//-----------------------------------------------------------------

-- ****************************************************************
-- tBallBlueRubber
-- ****************************************************************
tItems.tBallBlueRubber = {

	-- name
	szName = "tBallBlueRubber",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 3,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithBall"	
}

-- ****************************************************************
-- tBallGreenTennis
-- ****************************************************************
tItems.tBallGreenTennis = {

	-- name
	szName = "tBallGreenTennis",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 4,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithBall"	
}

-- ****************************************************************
-- tBallRedYarn
-- ****************************************************************
tItems.tBallRedYarn = {

	-- name
	szName = "tBallRedYarn",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithBall"	
}

-- ****************************************************************
-- tBallPinkRubberBand
-- ****************************************************************
tItems.tBallPinkRubberBand = {

	-- name
	szName = "tBallPinkRubberBand",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.2,
		iAgilityMod = 0.2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 6,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithBall"	
}

-- ****************************************************************
-- tBallBaseballAutographed
-- ****************************************************************
tItems.tBallBaseballAutographed = {

	-- name
	szName = "tBallBaseballAutographed",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.1,
		iStaminaMod = 0.2,
		iAgilityMod = 0.2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 7,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithBall"	
}

-- ****************************************************************
-- tBallGolden
-- ****************************************************************
tItems.tBallGolden = {

	-- name
	szName = "tBallGolden",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.2,
		iStaminaMod = 0.3,
		iAgilityMod = 0.2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 8,
		iGroomingMod = 0,
		iBladderMod = 0			
	},

	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithBall"	
}

//-----------------------------------------------------------------
// Flying Discs
//-----------------------------------------------------------------

-- ****************************************************************
-- tFlyingDiscBlue
-- ****************************************************************
tItems.tFlyingDiscBlue = {

	-- name
	szName = "tFlyingDiscBlue",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 4,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithDisc"	
}

-- ****************************************************************
-- tFlyingDiscGreen
-- ****************************************************************
tItems.tFlyingDiscGreen = {

	-- name
	szName = "tFlyingDiscGreen",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0.2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithDisc"	
}

-- ****************************************************************
-- tFlyingDiscRed
-- ****************************************************************
tItems.tFlyingDiscRed = {

	-- name
	szName = "tFlyingDiscRed",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.2,
		iAgilityMod = 0.2,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 6,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithDisc"	
}

-- ****************************************************************
-- tFlyingDiscGolden
-- ****************************************************************
tItems.tFlyingDiscGolden = {

	-- name
	szName = "tFlyingDiscGolden",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.2,
		iAgilityMod = 0.4,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 8,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithDisc"	
}

//-----------------------------------------------------------------
// Miscellaneous
//-----------------------------------------------------------------

-- ****************************************************************
-- tBone
-- ****************************************************************
tItems.tBone = {

	-- name
	szName = "tBone",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.2,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "ChewOnBone"	
}

-- ****************************************************************
-- tWoodenStick
-- ****************************************************************
tItems.tWoodenStick = {

	-- name
	szName = "tWoodenStick",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "ChewOnStick"
}

-- ****************************************************************
-- tSlipperMoccasin
-- ****************************************************************
tItems.tSlipperMoccasin = {

	-- name
	szName = "tSlipperMoccasin",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.1,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "ChewOnSlipper"	
}

-- ****************************************************************
-- tMouseCatnip
-- ****************************************************************
tItems.tMouseCatnip = {

	-- name
	szName = "tMouseCatnip",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.1,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0.1,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithCatnip"	
}

-- ****************************************************************
-- tNewspaperRolled
-- ****************************************************************
tItems.tNewspaperRolled = {

	-- name
	szName = "tNewspaperRolled",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0.1,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0.1,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 5,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "CarryNewspaper"	
}

-- ****************************************************************
-- tTeddyBear
-- ****************************************************************
tItems.tTeddyBear = {

	-- name
	szName = "tTeddyBear",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.1,
		iAgilityMod = 0.1,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 8,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithTeddyBear"	
}

-- ****************************************************************
-- tRubberDuckSqueaky
-- ****************************************************************
tItems.tRubberDuckSqueaky = {

	-- name
	szName = "tRubberDuckSqueaky",
	
	-- single use flag, used to confer attrib modifiers
	bSingleUse = false,
	
	-- table of attribute modifiers (conferred when given)	
	tAttribModifiers = {
		iIntelligenceMod = 0,
		iStaminaMod = 0.5,
		iAgilityMod = 0,
		iObedienceMod = 0,	
		iHungerMod = 0,
		iThirstMod = 0,
		iAlertnessMod = 0,
		iLoveMod = 8,
		iGroomingMod = 0,
		iBladderMod = 0			
	},
	
	-- table of any special effects	
	tSpecialEffects = {},
	
	-- usage action reference	
	szUsageAction = "PlayWithRubberDuck"	
}

return(tItems)