//-----------------------------------------------------------------
// PetAI Declaration
//-----------------------------------------------------------------

PetAI = {}

-- current and last action tables
PetAI.tCurAction = nil
PetAI.tLastAction = nil
PetAI.tSecretTrickToDo = nil

-- busy flag utilized to avoid interruptions
PetAI.bActionInProgress = false

-- flag indicating whether pet is holding an object in its mouth
PetAI.bIsHoldingObject = false

PetAI.PET_STATES = {
  AI_DISABLED = 1,
  IDLE_MODE = 2,
  EATING_MODE = 3,
  DRINKING_MODE = 4,
  ATTENTION_MODE = 5,
  BATHTUB_MODE = 6,
  TALENT_SHOW = 7,
  INFORMAL_TRICK = 8,
  BRUSHING_MODE = 9,
  SLEEPING_MODE = 10
}

PetAI.CUR_STATE = PetAI.PET_STATES.IDLE_MODE

PetAI.TOY_STATE_ONGROUND = 3

-- focal control
PetAI.LOOK_STATES = {
  NONE = 1,
  CAMERA = 2,
  OBJECT = 3,
}

PetAI.Disable = function() PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.AI_DISABLED) end
PetAI.Enable = function() PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE) end

PetAI.CUR_LOOK_STATE = NONE
PetAI.cFocalObjectRef = nil
PetAI.cFocalObjectTag = nil

-- flag indicating whether or not dog/cat is being pet
PetAI.bIsBeingPet = false

-- sleep change timer
PetAI.iTimeUntilSleepChange = 0

-- food/water counters
PetAI.iFoodInBowl = 0
PetAI.tFoodItemInBowl = nil

PetAI.iWaterInBowl = 0
PetAI.tWaterItemInBowl = nil

-- scolding control
PetAI.iLastScoldTime = 0
PetAI.iScoldsInARow = 0

-- flag for calling pets down from elevated surfaces
PetAI.bCanBeCalledDown = false

-- blink flag
PetAI.bNeedToBlink = false

-- species (i.e. dog or cat)
PetAI.szSpecies = gSpecies

-- pet's gender
PetAI.szGender = "Male"

-- name
PetAI.szName = "Fido"

-- beed (undeclared at start-up)
PetAI.tBreed = nil

-- next defecation object to produce (alternates between poop,pee)
PetAI.szDefecateToDo = "Poop"

-- current location
PetAI.szLocation = "Backyard"

-- flag for delaying AI during camera moves
PetAI.bWaitingForCamera = false

-- flag indicating if a voice command was given
PetAI.bVoiceCommandGiven = false

-- attention span
PetAI.iAttentionSpan = 0
PetAI.iMaxAttentionSpan = 13000

-- table of active behavioral effects
PetAI.tActiveEffects = {}

-- active informal trick event
PetAI.tActiveInformalTrick = nil

-- action reinforcement time
PetAI.iReinforcementTime = 0

-- wait time between idle action selections
PetAI.iWaitTime = 4000

-- current poo and pee locations (if any)
PetAI.szPooLocation = nil
PetAI.szPeeLocation = nil

-- last update time
PetAI.iLastUpdateTime = 0

-- current orientation in 'Attention' mode
PetAI.fCurAttnAngle = 270.0

-- memory bonus conferred in trick performance
PetAI.fMemBonus = 0

-- pet turning speed (in degrees per second)
PetAI.fTurningSpeed = 140

-- flag for detecting whether or not the player is currently holding a brush object
PetAI.cBrushInHand = nil

-- flag for detecting whether or not pet has climbed onto an elevated obstacle
PetAI.bIgnoringCalls = false
PetAI.tJumpDownInfo = nil

-- last time a flee was generated (based on grooming value)
PetAI.iLastFleeTime = 0

-- flag for controlling turning of stats dialog on/off
PetAI.bNeedEmergencyClosed = false

-- petting sound control
PetAI.cBrushingSoundRef = nil
PetAI.cPettingSoundRef = nil
PetAI.iTimeToNextBrushingSound = 250
PetAI.iTimeToNextPettingSound = 3000

-- miscellaneous sound files
PetAI.tSoundFX = {
	wavNo = CxWave(),
	wavWhistle = CxWave(),
	wavTreatGirl = CxWave(),
	wavTreatBoy = CxWave(),
	wavDogHowl = CxWave(),
	wavDogGrowl = CxWave(),
	wavDogLowGrowl = CxWave(),
	wavConfused = CxWave(),
  wavRefuse = CxWave(),
  wavSnore = CxWave(),

	wavPetYawn = CxWave(),
	wavPetEatTreat = CxWave(),

	wavEating = CxWave(),
	wavDrinking = CxWave(),

	wavJingleBall = CxWave(),
	wavSqueakyDuck = CxWave(),

	wavPetSpeak1 = CxWave(),
	wavPetSpeak2 = CxWave(),
	wavPetSpeak3 = CxWave(),
	wavPetSpeak4 = CxWave(),
	wavPetSpeak5 = CxWave(),
	wavPetSpeak6 = CxWave(),
	wavPetSpeak7 = CxWave(),

	wavHeadBark1 = CxWave(),
	wavHeadBark2 = CxWave(),
	wavHeadBark3 = CxWave(),
	wavHeadBark4 = CxWave(),
	wavHeadBark5 = CxWave(),
	wavHeadBark6 = CxWave(),
	wavHeadBark7 = CxWave(),

  wavCleanSelf = CxWave(),
  wavDrink = CxWave(),
  wavEat = CxWave(),
  wavPee = CxWave(),
	wavScratchFurniture = CxWave(),
	wavScratchSelf = CxWave(),
	wavSniffGround = CxWave(),
	wavStandSprayed = CxWave(),
	wavSitSprayed = CxWave(),
	wavLaySprayed = CxWave(),

	wavNeedToGo = CxWave(),
	wavShakeOffWater = CxWave(),
	wavFleeBitten = CxWave(),

	wavBrushing1 = CxWave(),
	wavBrushing2 = CxWave(),

	wavPetting1 = CxWave(),
	wavPetting2 = CxWave(),
	wavPetting3 = CxWave(),
	wavPetting4 = CxWave(),
	wavPetting5 = CxWave(),
	wavPetting6 = CxWave(),
	wavPetting7 = CxWave(),
	wavPetting8 = CxWave(),
	wavPetting9 = CxWave(),
	wavPetting10 = CxWave(),

	wavTSApplause = CxWave(),
  wavTSLaugh = CxWave(),
	wavTSClap01 = CxWave(),
	wavTSClap02 = CxWave(),
	wavTSClap03 = CxWave(),
	wavTSFail = CxWave(),
	wavTSWow = CxWave(),
	wavTSIntro = CxWave(),
	wavTSEnding = CxWave(),
	wavTSRound1Begin = CxWave(),
	wavTSRound1End = CxWave(),
	wavTSRound1Fail = CxWave(),
	wavTSRound2Begin = CxWave(),
	wavTSRound2End  = CxWave(),
	wavTSRound2Fail  = CxWave(),
	wavTSRound3Begin = CxWave(),
}

-- current orientation
PetAI.fCurOrientation = 0

-- pet cleaning data
PetAI.szCurTubZone = nil
PetAI.tCurTubData = nil
PetAI.tCurShampooInUse = nil

-- talent show performance counts
PetAI.tTalentShowCounts = {
  Easy = 0,
  Medium = 0,
  Hard = 0
}

-- talent show win counts
PetAI.tTalentShowWins = {
  Easy = 0,
  Medium = 0,
  Hard = 0
}

//-----------------------------------------------------------------
// Load Other AI Scripts
//-----------------------------------------------------------------

-- actions
PetAI.tActions = dofile("Pets/Actions.lua")

-- AI reasoning functionality
PetAI.tThinkFunc = dofile("Pets/ThinkFunc.lua")

-- pathfinding functionality
PetAI.tPathFunc = dofile("Pets/PathFunc.lua")

-- petting functionality
PetAI.tPettingFunc = dofile("Pets/PettingFunc.lua")

-- breeds
PetAI.tBreeds = dofile("Pets/Breeds.lua")

-- effects
PetAI.tEffects = dofile("Pets/Effects.lua")

-- informal tricks
PetAI.tInformalTricks = dofile("Pets/InformalTricks.lua")

-- items
PetAI.tItems = dofile("Pets/Items.lua")

-- 'trick of the day' functionality
PetAI.tTrickOfTheDayFunc = dofile("Pets/TrickOfTheDay.lua")

-- talent show functionality
PetAI.TalentShow = dofile("Pets/TalentShow.lua")

//-----------------------------------------------------------------
// Cursor Control
//-----------------------------------------------------------------

PetAI.szCursorInHand = "Default"

function SetShowerCursor()
	SetCursorEx(CURSOR_SHOWER)
end

function SetSquirtCursor()
	SetCursorEx(CURSOR_SPRAY)
end

PetAI.SetCursor = function(szCursorType)
  if (szCursorType == "Default") then
    RevertToDefaultCursor()
   elseif (szCursorType == "Brush") then
    SetBrushCursor()
  elseif (szCursorType == "SquirtBottle") then
    SetSquirtCursor()
    --PetAI.tThinkFunc.CreateHandheld('Objects/obj_squirtbottle_01.lua')
  end
  PetAI.szCursorInHand = szCursorType
end

//-----------------------------------------------------------------
// Dialog Boxes
//-----------------------------------------------------------------

-- flags for managing help dialog boxes
PetAI.tHelpDialogInfo = {}
for i = 1,80 do table.insert(PetAI.tHelpDialogInfo,false) end

PetAI.MiscHelpInfo = {
	iNumAttnModeCalls = 0,
	bHasSatDown = false,
	bHasLaidDown = false,
	iLastTrickButtonTime = 0,
	szFirstTrickPosition = nil,
	szFirstActiveTrickButton = nil,
	iNumPoopMesses = 0
}

PetAI.DoHelpDialog = function(iNum,szTrickName,bRepeat,bTimeOut)

	-- set dialog to single-use if repeat parameter not set
  if (bRepeat == nil) then bRepeat = false end

	-- set dialog to timeout if parameter not set
	if (bTimeOut == nil) then bTimeOut = TRUE end

	-- if the dialog has already been sent, return immediately
	if (PetAI.tHelpDialogInfo[iNum]) then return end

	-- configure tip text string
	local szTipText = "Tip_"
	if (iNum < 10) then szTipText = szTipText.."0" end
	szTipText = szTipText..iNum

	-- send the dialog box
	if not (szTrickName == nil) then
		local szDialogBoxText = GetLanguageString(szTipText)
    local szDialogTrickName = GetLanguageString("TrickName_"..szTrickName)

		--szDialogBoxText = string.gsub(szDialogBoxText,"%s",string.upper(szTrickName))
		szDialogBoxText = string.format(szDialogBoxText,szDialogTrickName)
		DoDialogBox(szDialogBoxText)
	else
		DoDialogBox(GetLanguageString(szTipText))
	end

	-- set the help dialog flag (if not set to repeat)
  if not (bRepeat) then	PetAI.tHelpDialogInfo[iNum] = true end
end

PetAI.CheckNeedHelpDialogs = function()
	if (PetAI.tNeeds.tHunger.iCurValue < (PetAI.tNeeds.tHunger.iLowThreshold)) then PetAI.DoHelpDialog(2) end
	if (PetAI.tNeeds.tThirst.iCurValue < (PetAI.tNeeds.tThirst.iLowThreshold)) then PetAI.DoHelpDialog(3) end
	if (PetAI.tNeeds.tGrooming.iCurValue < (PetAI.tNeeds.tGrooming.iLowThreshold)) then PetAI.DoHelpDialog(4) end
	if (PetAI.tNeeds.tAlertness.iCurValue < (PetAI.tNeeds.tAlertness.iLowThreshold)) then PetAI.DoHelpDialog(78) end
	if (PetAI.tNeeds.tLove.iCurValue < (PetAI.tNeeds.tLove.iLowThreshold)) then PetAI.DoHelpDialog(6) end
end

//-----------------------------------------------------------------
// GetPetAccessoryPoints
//-----------------------------------------------------------------
PetAI.GetPetAccessoryPoints = function()
  local iPoints = 0
  if (pet.acc.bootie1 != nil) then iPoints = iPoints + 1 end
  if (pet.acc.hat != nil) then iPoints = iPoints + 1 end
  if (pet.acc.tailpom != nil) then iPoints = iPoints + 1 end
  return(iPoints)
end

//-----------------------------------------------------------------
// Trick of the Day
//-----------------------------------------------------------------

-- pet 'trick of the day' data
PetAI.tCurTrickOfTheDay = nil

PetAI.SetDelayTrickOfTheDay = function(iTime)
  if (iTime == nil) then iTime = 10000 end
  PetAI.tCurTrickOfTheDay = PetAI.tTrickOfTheDayFunc.CreateTOD_None(iTime)
  Room.stats_dialog.m_cTrickOfTheDayBody:SetString(GetTrickOfTheDay())
end

PetAI.SetTrickOfTheDay = function()

  PetAI.tCurTrickOfTheDay = nil
  local tTricksOfTheDay = {"OneEasyTrick","OneHardTrick","TwoTricks","ThreeTricks","OneFetch","TwoFetches","ThreeFetches","EasyTrickPhoto","HardTrickPhoto","BeautyPhoto","CutePhoto"}

  local tPossibleTricksOfTheDay = {}

  for i in ipairs(tTricksOfTheDay) do
    if (PetAI.tTrickOfTheDayFunc.PreconditionChecks["TOD_"..tTricksOfTheDay[i]]()) then table.insert(tPossibleTricksOfTheDay,tTricksOfTheDay[i]) end
  end

  if (table.getn(tTricksOfTheDay) == 0) then
    PetAI.tCurTrickOfTheDay = PetAI.tTrickOfTheDayFunc.CreateTOD_None(900000)
  else
    local szRandomTOD = tPossibleTricksOfTheDay[math.random(table.getn(tPossibleTricksOfTheDay))]
    PetAI.tCurTrickOfTheDay = PetAI.tTrickOfTheDayFunc["CreateTOD_"..szRandomTOD]()
  end

  DoOkDialog(GetLanguageString("TOD_Heading")..": "..GetTrickOfTheDay())
  Room.stats_dialog.m_cTrickOfTheDayBody:SetString(GetTrickOfTheDay())
  
  Room.stats_dialog.tab3:Flash(true)
  
  local nChannel = EventChannelManager.CreateChannel()
  
  DoEvent("System.Sleep(15000)", nChannel)
  DoLuaEvent("Room.stats_dialog.tab3:Flash(false)", nChannel)
  
  DoLuaEvent("DoLuaEvent('EventChannelManager.DestroyChannel("..nChannel..")', GetSystemChannel())", nChannel)
end

//-----------------------------------------------------------------
// Restoring Needs Relative to Time
//-----------------------------------------------------------------
PetAI.RestoreNeedsFromPrevSession = function()

  -- calculate time since previous session
  local iTimePassed = FoxGetTimeSeconds() - PetAI.m_nKennelTime

  -- if time exceeds twenty-four hours, send special tip dialog
  if (iTimePassed >= (24*60*60*1000)) then PetAI.DoHelpDialog(79) end

  -- determine amount of time passed relative to six hour replenishment cycle
  local fPercentIncrease = iTimePassed/(6*60*60*1000)

  -- determine amount of time passed relative to three day depletion cycle
  local fPercentDecrease = iTimePassed/(3*24*60*60*1000)

  -- clamp percentages to 100%
  if (fPercentIncrease > 1) then fPercentIncrease = 1 end
  if (fPercentDecrease > 1) then fPercentDecrease = 1 end

  -- increase alertness need value regardless of kennel status
  PetAI.tThinkFunc.SetValue(PetAI.tNeeds.tAlertness,fPercentIncrease*PetAI.tNeeds.tAlertness.iMaxValue)

  -- construct temp table of all other needs
  local tEffectedNeeds = {PetAI.tNeeds.tHunger,PetAI.tNeeds.tThirst,PetAI.tNeeds.tLove,PetAI.tNeeds.tBladder,PetAI.tNeeds.tGrooming}

  -- if pet was kenneled, increase the needs relative to six hour schedule
  if (PetAI.m_bKenneled) then
    for i,v in ipairs(tEffectedNeeds) do
      PetAI.tThinkFunc.SetValue(v,fPercentIncrease*v.iMaxValue)
    end
  else
    -- otherwise, if pet was not kenneled, decrease needs relative to three day schedule
    for i,v in ipairs(tEffectedNeeds) do
      PetAI.tThinkFunc.SetValue(v,-1*(fPercentDecrease*v.iMaxValue))
    end
  end
end


//-----------------------------------------------------------------
// Secret Tricks
//-----------------------------------------------------------------

PetAI.FindInTable = function(tTable,szString)
  for i = 1,table.getn(tTable) do if (tTable[i] == szString) then return(i) end end
  return(0)
end


if CATZ then
  PetAI.tSecretTrickInfo = {
    tVoiceCommands = {"ShakeHead","LieDown","Jump"},
    tBaseTricks = {"GivePaw","RollOver","StandOnHindLegs"},
    tSecretTricks = {"WavePaw","PlayDead", "Backflip"}
  }
else
  PetAI.tSecretTrickInfo = {
    tVoiceCommands = {"ShakeHead","NodHead","LieDown","Jump"},
    tBaseTricks = {"GivePaw","Beg","RollOver","StandOnHindLegs"},
    tSecretTricks = {"WavePaw", "Bow", "PlayDead", "Backflip"}
  }
end

PetAI.CheckForSecretTrick = function(szVoiceCommand)

  local iTableRef = PetAI.FindInTable(PetAI.tSecretTrickInfo.tVoiceCommands,szVoiceCommand)

  if (iTableRef > 0) then
    if (not (PetAI.tCurAction == nil)) and (PetAI.tCurAction.szName == PetAI.tSecretTrickInfo.tBaseTricks[iTableRef]) then
      return(PetAI.tActions[PetAI.tSecretTrickInfo.tSecretTricks[iTableRef]])
    end
  end

  return(nil)
end


//-----------------------------------------------------------------
// Trick Processing Functions
//-----------------------------------------------------------------

PetAI.tEasyTricks = {"Promenade","Sit","LieDown","Speak","GivePaw","Beg","RollOver","Hide"}
PetAI.tHardTricks = {"NodHead","ShakeHead","Jump","StandOnHindLegs"}
PetAI.tAllTricks = {"Promenade","Sit","LieDown","Speak","GivePaw","Beg","RollOver","Hide","NodHead","ShakeHead","Jump","StandOnHindLegs"}
PetAI.tSecretTricks = {"Backflip","PlayDead","Bow","WavePaw"}


PetAI.IsEasyTrick = function(szTrickName)
  local tTricks = PetAI.tEasyTricks
  for i in ipairs(tTricks) do if (tTricks[i] == szTrickName) then return(true) end end
  return(false)
end

PetAI.IsHardTrick = function(szTrickName)
  local tTricks = PetAI.tHardTricks
  for i in ipairs(tTricks) do if (tTricks[i] == szTrickName) then return(true) end end
  return(false)
end

PetAI.IsSecretTrick = function(szTrickName)
  local tTricks = PetAI.tSecretTricks
  for i in ipairs(tTricks) do if (tTricks[i] == szTrickName) then return(true) end end
  return(false)
end

PetAI.GetLearnedTrickSubset = function(tTrickSet)
  local tLearnedTricks = {}
  for i in ipairs(tTrickSet) do
    if (PetAI.tVoiceCommands[tTrickSet[i]].bActive) then
      table.insert(tLearnedTricks,tTrickSet[i])
    end
  end
  return(tLearnedTricks)
end

PetAI.GetOwnedFetchableToySubset = function()
  local tToys = {}
  for i = 1,6 do if (not (player.m_tInventory["ball_0"..i] == nil)) and (player.m_tInventory["ball_0"..i] > 0) then table.insert(tToys,"ball_0"..i) end end
  for i = 1,4 do if (not (player.m_tInventory["flyingdisc_0"..i] == nil)) and (player.m_tInventory["flyingdisc_0"..i] > 0) then table.insert(tToys,"flyingdisc_0"..i) end end
  return(tToys)
end

//-----------------------------------------------------------------
// Textures
//-----------------------------------------------------------------

PetAI.DoTextureSwitch = function(iTextureNum)
	if (PetAI.szSpecies == "Dog") and (PetAI.tBreed.szName == "GermanShepard") then
		pet:SetTexture("Mod_xD"..string.lower(PetAI.tBreed.szName).."_0"..iTextureNum.."T.dds")
	end
end

//-----------------------------------------------------------------
// Animation
//-----------------------------------------------------------------

--PetAI.szCurAnim = "Idle"

PetAI.szTurnAnim = "TurnNone"

PetAI.vCurAnim = {
	szHead = nil,
	szLEar = nil,
	szREar = nil,
	szTail = nil,
	szBody = nil,
	szTongue = nil
}

//-----------------------------------------------------------------
// Idle Actions
//-----------------------------------------------------------------

-- table of idle actions to perform in lieu of user input
PetAI.tIdleActions = {
	"AmbleAround",
	"SniffRandomObject",
	"LieDown",
	"Stretch",
	"Yawn",
	"ScratchSelf",
	"ChaseTail",
	"TurnAndBark",
	"Vocalize",
	"ClimbOntoSofa",
	"ClimbOntoTable",
	"ClimbOntoCounter",
	"ScratchScratchingPost",
  "SniffPooMess",
  "SniffPeeMess",
}

PetAI.tIdleScripts = {
  "ScriptApproachAndBark",
  "ScriptBarkTrickBark",
  "ScriptSearchUpAndDown",
  "ScriptSearchAllOver",
  "ScriptSitScratchBark",
  "ScriptToyLookBark",
  "ScriptToyWalkSniff",
  "ScriptToyLookPlayerLook",
  "ScriptBackyardSniffPlant",
  "ScriptBackyardBarkPlant",
  "ScriptBarkAtFireplace",
  "ScriptLieDownFireplace",
  "ScriptSniffFireplace",
  "ScriptJumpOnCouchAndBark",
  "ScriptJumpOnCouchAndSleep",
  "ScriptJumpOnTableAndBark",
  "ScriptJumpOnTableAndLieDown",
  "ScriptScratchPost",
  "ScriptScratchBarkFridge",
  "ScriptSniffOpenFridge",
  "ScriptLookBarkFridge",
  "ScriptLookBarkRadio",
  "ScriptLookWhineRadio",
  "ScriptLookBarkRadio",
  "ScriptLookBarkBathroomSink",
  "ScriptLookBarkToilet",
  "ScriptLookBarkTub",
  "ScriptSniffToilet"
}

PetAI.tAttnIdleActions = {
	"SniffRandomObject",
	"ScratchSelf",
	"BarkInAttn",
	"BlinkInAttn",
	"CleanInAttn",
	"LookUp",
	"LookDown",
	"Stand",
}

PetAI.IsAttnIdleAction = function(szTrickName)
  local tTricks = PetAI.tAttnIdleActions
  for i in ipairs(tTricks) do if (tTricks[i] == szTrickName) then return(true) end end
  return(false)
end

//-----------------------------------------------------------------
// Stats
//-----------------------------------------------------------------

-- pet statistical data
PetAI.tStats = {}

-- ****************************************************************
-- tIntelligence
-- ****************************************************************
PetAI.tStats.tIntelligence = {

	-- name
	szName = "Intelligence",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 100,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- attributes depressed when in critical value state
	tDepressAttribs = {},

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = 0.5,
	iDecayRate = 1000,
	iLastDecayTime = 0
}

-- ****************************************************************
-- tStamina
-- ****************************************************************
PetAI.tStats.tStamina = {

	-- name
	szName = "Stamina",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 100,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,
	iValueToChange = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = {},

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = 0.5,
	iDecayRate = 1000,
	iLastDecayTime = 0
}

-- ****************************************************************
-- tAgility
-- ****************************************************************
PetAI.tStats.tAgility = {

	-- name
	szName = "Agility",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 100,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- attributes depressed when in critical value state
	tDepressAttribs = {},

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = 0.5,
	iDecayRate = 1000,
	iLastDecayTime = 0
}

-- ****************************************************************
-- tObedience
-- ****************************************************************
PetAI.tStats.tObedience = {

	-- name
	szName = "Obedience",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 100,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- attributes depressed when in critical value state
	tDepressAttribs = {},

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = 0.5,
	iDecayRate = 1000,
	iLastDecayTime = 0
}

//-----------------------------------------------------------------
// Needs
//-----------------------------------------------------------------

-- pet need data
PetAI.tNeeds = {}

-- ****************************************************************
-- tBladder
-- ****************************************************************
PetAI.tNeeds.tBladder = {

	-- name
	szName = "Bladder",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 100,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- decay paramters
	bDecayOn = false,
	iDecayAmount = -1.1,
	iDecayRate = 1000,
	iLastDecayTime = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = { PetAI.tNeeds.tGrooming },

	-- actions to perform when in critical value state
	tEmergencyActions = {
		"NeedToGoVocalize",
		"DefecateInBackyard",
		"DefecateInLivingRoom",
		"DefecateInKitchen",
		"DefecateInBathroom",
		"DefecateInBathroomLitterBox",
	  "ScriptUseLitterBox"
	},

	-- satiation and depletion modifiers, applied to all value changes
	tSatiateModifiers = {},
	tDepleteModifiers = {}
}

-- ****************************************************************
-- tHunger
-- ****************************************************************
PetAI.tNeeds.tHunger = {

	-- name
	szName = "Hunger",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 75,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = -0.1,
	iDecayRate = 8000,
	iLastDecayTime = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = { PetAI.tStats.tAgility, PetAI.tStats.tStamina },

	-- actions to perform when in critical value state
	tEmergencyActions = {
    "EatLeftoverFood",
		"LickChops",
		"SniffFoodBowl",
		"ScratchFridge",
	},

	-- satiation and depletion modifiers, applied to all value changes
	tSatiateModifiers = {},
	tDepleteModifiers = {}
}

-- ****************************************************************
-- tThirst
-- ****************************************************************
PetAI.tNeeds.tThirst = {

	-- name
	szName = "Thirst",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 75,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = -0.35,
	iDecayRate = 8000,
	iLastDecayTime = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = { PetAI.tStats.tAgility, PetAI.tStats.tStamina },

	-- actions to perform when in critical value state
	tEmergencyActions = {
    "DrinkLeftoverWater",
		"Pant",
		"PantAtBowl",
	},

	-- satiation and depletion modifiers, applied to all value changes
	tSatiateModifiers = {},
	tDepleteModifiers = {}
}

-- ****************************************************************
-- tAlertness
-- ****************************************************************
PetAI.tNeeds.tAlertness = {

	-- name
	szName = "Alertness",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 100,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = -0.1,
	iDecayRate = 6000,
	iLastDecayTime = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = { PetAI.tStats.tIntelligence },

	-- actions to perform when in critical value state
	tEmergencyActions = {
		"Yawn",
		"LieDownTired",
		"GoToBed",
    "ScriptTired",
    "ScriptTiredUsePetBed",		
	},

	-- satiation and depletion modifiers, applied to all value changes
	tSatiateModifiers = {},
	tDepleteModifiers = {}
}

-- ****************************************************************
-- tLove
-- ****************************************************************
PetAI.tNeeds.tLove = {

	-- name
	szName = "Love",

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- values
	iCurValue = 75,
	iMaxValue = 100,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- decay parameters
	bDecayOn = true,
	iDecayAmount = -0.2,
	iDecayRate = 7000,
	iLastDecayTime = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = { PetAI.tStats.tObedience },

	-- actions to perform when in critical value state
	tEmergencyActions = {
		"Howl",
		"ApproachPlayerAndVocalize",
		"ScratchFurniture",
		"Vocalize",
	},

	-- satiation and depletion modifiers, applied to all value changes
	tSatiateModifiers = {},
	tDepleteModifiers = {}
}

-- ****************************************************************
-- tGrooming
-- ****************************************************************
PetAI.tNeeds.tGrooming = {

	-- name
	szName = "Grooming",

	-- values
	iCurValue = 75,
	iMaxValue = 100,

	-- enabled flag
	bEnabled = true,

  -- critical flag
  bCritical = false,

	-- thresholds
	iLowThreshold = 10,
	iHighThreshold = 90,

	-- decay parameters
	bDecayOn = false,
	iDecayAmount = 0,
	iDecayRate = 0,
	iLastDecayTime = 0,

	-- attributes depressed when in critical value state
	tDepressAttribs = { PetAI.tNeeds.tLove },

	-- actions to perform when in critical value state
	tEmergencyActions = {
		"ScratchEar",
		"CleanFur",
		"ScratchAtTub",
	},

	-- satiation and depletion modifiers, applied to all value changes
	tSatiateModifiers = {},
	tDepleteModifiers = {}
}

//-----------------------------------------------------------------
// Behavioral Memory
//-----------------------------------------------------------------

-- set of voice command/trick mappings
PetAI.tVoiceCommands = {}

-- action mapping for F1 key's voice command
PetAI.tVoiceCommands.Promenade = {
	bActive = false,
	bDialogShown = false,
	szTrick = "Promenade",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.Promenade.cSoundFX:Load("VO_Stay.wav") end
}

-- action mapping for F2 key's voice command
PetAI.tVoiceCommands.Sit = {
	bActive = false,
	bDialogShown = false,
	szTrick = "Sit",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.Sit.cSoundFX:Load("VO_Sit.wav") end
}

-- action mapping for F3 key's voice command
PetAI.tVoiceCommands.LieDown = {
	bActive = false,
	bDialogShown = false,
	szTrick = "LieDown",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.LieDown.cSoundFX:Load("VO_Lie Down.wav") end
}

-- action mapping for F4 key's voice command
PetAI.tVoiceCommands.Speak = {
	bActive = false,
	bDialogShown = false,
	szTrick = "Speak",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.Speak.cSoundFX:Load("VO_Speak.wav") end
}

-- action mapping for F5 key's voice command
PetAI.tVoiceCommands.GivePaw = {
	bActive = false,
	bDialogShown = false,
	szTrick = "GivePaw",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.GivePaw.cSoundFX:Load("VO_Paw.wav") end
}

-- action mapping for F6 key's voice command
PetAI.tVoiceCommands.Beg = {
	bActive = false,
	bDialogShown = false,
	szTrick = "Beg",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.Beg.cSoundFX:Load("VO_Beg.wav") end
}

-- action mapping for F7 key's voice command
PetAI.tVoiceCommands.RollOver = {
	bActive = false,
	bDialogShown = false,
	szTrick = "RollOver",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.RollOver.cSoundFX:Load("VO_Roll Over.wav") end
}

-- action mapping for F8 key's voice command
PetAI.tVoiceCommands.Hide = {
	bActive = false,
	bDialogShown = false,
	szTrick = "Hide",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.Hide.cSoundFX:Load("VO_Hide.wav") end
}

-- action mapping for F9 key's voice command
PetAI.tVoiceCommands.NodHead = {
	bActive = false,
	bDialogShown = false,
	szTrick = "NodHead",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.NodHead.cSoundFX:Load("VO_Nod.wav") end
}

-- action mapping for F10 key's voice command
PetAI.tVoiceCommands.ShakeHead = {
	bActive = false,
	bDialogShown = false,
	szTrick = "ShakeHead",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.ShakeHead.cSoundFX:Load("VO_Shake.wav") end
}

-- action mapping for F11 key's voice command
PetAI.tVoiceCommands.Jump = {
	bActive = false,
	bDialogShown = false,
	szTrick = "Jump",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.Jump.cSoundFX:Load("VO_Jump.wav") end
}

-- action mapping for F12 key's voice command
PetAI.tVoiceCommands.StandOnHindLegs = {
	bActive = false,
	bDialogShown = false,
	szTrick = "StandOnHindLegs",
	cSoundFX = CxWave(),
	InitCommand = function() PetAI.tVoiceCommands.StandOnHindLegs.cSoundFX:Load("VO_Stand High.wav") end
}