//-----------------------------------------------------------------
// Petting Blend Patterns
//-----------------------------------------------------------------

tBlendPatterns = {}

-- Body Wiggle, Butt wiggle
 
--*****************************************************************
-- HEAD PETTING ANIM DESCRIPTIONS
--*****************************************************************
-- "HeadBark" 			: pet barks/meows looking forward
-- "HeadCockToLeft" : pet tilts head to the left
-- "HeadConfused"		: pet tilts head and acts dumb, w/tongue out
-- "HeadUp"					: pet tilts head up
-- "HeadDown"				: pet tilts head down
-- "HeadDrink"			: pet shakes head, looking forward and licking
-- "HeadGrowl"			: pet tilts head upward, bottom lip shakes
-- "HeadIdle"				: pet sways head as normal, looking forward
-- "HeadKissLeft"   : pet tilts head and licks to its left
-- "HeadKissRight"  : pet tilts head and licks to its right
-- "HeadLeft"				: pet tilts head left
-- "HeadRight"			: pet tilts head right
-- "HeadNod"				: pet nods head in agreement
-- "HeadPant"				: pet quickly sways head (as in idle) w/tongue
-- "HeadPet1"			  : pet looks down, ears and bottom lip palpitate
-- "HeadPet2"				: pet shakes head left and right happily
-- "HeadPet3"				: pet looks up and sways to allow chin scratch
-- "HeadShake"			: pet shakes head in disagreement, though happy
-- "HeadYawn"				: pet yawns, tongue out, in boredom

--*****************************************************************
-- TAIL PETTING ANIM DESCRIPTIONS
--*****************************************************************
-- "TailExcited" 		: pet wags tail happily left/right
-- "TailIdle" 			: pet gently wags tail left/right 
-- "Tail1"					: pet slowly moves tail around randomly
-- "Tail2"					: same as "TailIdle" anim
-- "Tail3"					: pet wags tail left/right very slowly
-- "Tail4"					: pet wags tail left/right very quickly
-- "Tail5"					: pet tucks tail between its legs
-- "Tail6"					: pet wags tail up/down, as if in exclamation

--*****************************************************************
-- BODY PETTING ANIM DESCRIPTIONS (NOT READY YET)
--*****************************************************************
-- "BodyWiggle" 		: pet wiggles body excitedly
-- "BodyRaiseRear"	: pet raises rump, i.e. given posterior petting 

--*****************************************************************
-- EAR PETTING ANIM DESCRIPTIONS (NOT READY YET)
--*****************************************************************
-- "WiggleEars"			:	pet wiggles both ears
-- "RaiseEars"			: pet raises both ears above head
-- "RightEarWiggle"	: pet wiggles right ear only
-- "RightEarUp"			: pet raises right ear only
-- "LeftEarWiggle"	:	pet wiggles left ear only
-- "LeftEarUp"			: pet raises left ear only

--*****************************************************************
-- EYE PETTING ANIM DESCRIPTIONS
--*****************************************************************
-- "EyeBlink"			:	pet blinks both eyes
-- "EyeClose"			: pet closes eyes; open on blend out
-- "EyeSquint"		: pet squints momentarily

tBlendPatterns.tFacingToward = { tStanding = {}, tSitting = {}, tLyingDown = {} }
tBlendPatterns.tFacingAway = { tStanding = {}, tSitting = {}, tLyingDown = {} }
tBlendPatterns.tFacingLeft = { tStanding = {}, tSitting = {}, tLyingDown = {} }
tBlendPatterns.tFacingRight = { tStanding = {}, tSitting = {}, tLyingDown = {} }

--*****************************************************************
-- Blend Patterns for Pet Facing Toward Player
--*****************************************************************

--
-- tBlendPatterns.<direction>.<pose>.<zone>[<index>].fnTweakBone
--
--     Tweak bone movement during petting.
--
-- input parameters:
--     u_x, u_y   :  centered normalized mouse coordinates
--     u_length   :  distance to the center of the screen, i.e., sqrt(u_x*u_x + u_y*u_y)
--
-- output parameters:
--     on           : (boolean) if false, do not tweak anything
--     name         : name of the bone to move (use GrannyViewer to find it)
--     axis         : axis of rotation (local coordinates)
--     angle        : the tweak rotation angle
--     qav_factor   : constant multiplier for the quaternion angular velocity
--                        (smaller ==> slower movement,  larger ==> faster movement)
--

fnUDHeadPet =
    function(u_x, u_y, u_length, param)
        param.on = false
        
        param.name = "Bip01 Spine2"
        
        param.axis.x = -math.udir(u_x)
        param.axis.y = 0
        param.axis.z = 0
        
        param.angle = 40*u_length

        param.qav_factor_min = 0.1
        param.qav_factor = 2*math.abs(u_x)
        param.qav_factor_max = 1
    end

fnLRHeadPet =
    function(u_x, u_y, u_length, param)
        param.on = true
        
        param.name = "Bip01 Neck1"
        
        param.axis.x = 0
        param.axis.y = -u_y
        param.axis.z = -u_x
        
        param.angle = 25*u_length

        param.qav_factor_min = 1
        param.qav_factor = 1
        param.qav_factor_max = 1
    end

fnLRHeadPet2 =
    function(u_x, u_y, u_length, param)
        param.on = true
        
        param.name = "Bip01 Neck1"
        
        param.axis.x = 0
        param.axis.y = -u_y
        param.axis.z = -u_x
        
        param.angle = 50*u_length

        param.qav_factor_min = 1
        param.qav_factor = 1
        param.qav_factor_max = 1
    end

fnLRHeadPet3 =
    function(u_x, u_y, u_length, param)
        param.on = false
        
        param.name = "Bip01 Spine2"
        
        param.axis.x = 0
        param.axis.y = 0
        param.axis.z = -math.udir(u_x)
        
        param.angle = 40*u_length

        param.qav_factor_min = 0.1
        param.qav_factor = 2*math.abs(u_x)
        param.qav_factor_max = 1
    end

fnLRSpine =
    function(u_x, u_y, u_length, param)
        param.on = true
        
        param.name = "Bip01 Neck1"
        
        param.axis.x = 0
        param.axis.y = 0
        param.axis.z = math.udir(u_x)
        
        param.angle = 57*u_length

        param.qav_factor_min = 0.1
        param.qav_factor = 2*math.abs(u_x)
        param.qav_factor_max = 1
    end

fnGazeCamera =
    function(u_x, u_y, u_length, param)
        param.on = false
        
        param.name = "Bip01 Spine2"
        
        param.axis.x = -math.udir(u_x)
        param.axis.y = 0
        param.axis.z = 0
        
        param.angle = 40*u_length

        param.qav_factor_min = 0.1
        param.qav_factor = 2*math.abs(u_x)
        param.qav_factor_max = 1
    end

-- pet standing

	--[head]
tBlendPatterns.tFacingToward.tStanding.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet },
} 

	--[tail] (not really visible from this view anyway)
tBlendPatterns.tFacingToward.tStanding.tTail = {
--	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szEyeAnim = nil, szTongueAnim = nil },
	{ szHeadAnim = "HeadCockToLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = nil },
} 
	--[legs]
tBlendPatterns.tFacingToward.tStanding.tLegs = {
	{ szHeadAnim = "HeadIdle", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnLRSpine },
--	{ szHeadAnim = "HeadCockToLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil },
}
	--[back]
tBlendPatterns.tFacingToward.tStanding.tBack = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
} 

-- pet sitting

	--[head]
tBlendPatterns.tFacingToward.tSitting.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet },
} 
	--[tail] (shouldn't really be able to get to tail at this view)
tBlendPatterns.tFacingToward.tSitting.tTail = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = nil },
} 

	--[legs]
tBlendPatterns.tFacingToward.tSitting.tLegs = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRSpine },
}

	--[back]
tBlendPatterns.tFacingToward.tSitting.tBack = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
}

-- pet lying down
	--[head]
tBlendPatterns.tFacingToward.tLyingDown.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet },
} 

	--[tail] (procedural)
tBlendPatterns.tFacingToward.tLyingDown.tTail = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = nil },
} 

	--[legs]
tBlendPatterns.tFacingToward.tLyingDown.tLegs = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRSpine },
}

	--[back]
tBlendPatterns.tFacingToward.tLyingDown.tBack = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = nil },
}

--*****************************************************************
-- Blend Patterns for Pet Facing Away from Player
--*****************************************************************

-- pet standing

tBlendPatterns.tFacingAway.tStanding.tHead = {
	{ szHeadAnim = "HeadUp", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
} 

tBlendPatterns.tFacingAway.tStanding.tTail = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = nil },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = nil },
} 

tBlendPatterns.tFacingAway.tStanding.tLegs = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnLRHeadPet2 },
}

tBlendPatterns.tFacingAway.tStanding.tBack = {
	{ szHeadAnim = "HeadIdle", szBodyAnim = "BodyWiggle", szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRSpine },
	{ szHeadAnim = "HeadIdle", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRSpine },
}

-- pet sitting

tBlendPatterns.tFacingAway.tSitting.tHead = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },

} 

tBlendPatterns.tFacingAway.tSitting.tTail = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
} 

tBlendPatterns.tFacingAway.tSitting.tLegs = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
}

tBlendPatterns.tFacingAway.tSitting.tBack = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
}

-- pet lying down

tBlendPatterns.tFacingAway.tLyingDown.tHead = {
	{ szHeadAnim = "HeadUp", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet2 },
} 

tBlendPatterns.tFacingAway.tLyingDown.tTail = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },} 

tBlendPatterns.tFacingAway.tLyingDown.tLegs = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },}

tBlendPatterns.tFacingAway.tLyingDown.tBack = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnLRHeadPet3 },}

--*****************************************************************
-- Blend Patterns for Pet Facing to the Left
--*****************************************************************

-- pet standing

tBlendPatterns.tFacingLeft.tStanding.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDHeadPet },
} 

tBlendPatterns.tFacingLeft.tStanding.tTail = {
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = nil },
} 

tBlendPatterns.tFacingLeft.tStanding.tLegs = {
	{ szHeadAnim = "HeadDown", szBodyAnim = "BodyRaiseRear", szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyesClose", fnTweakBone = nil },
}

tBlendPatterns.tFacingLeft.tStanding.tBack = {
	{ szHeadAnim = "HeadRight", szBodyAnim = "BodyWiggle", szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = nil },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
}

-- pet sitting

tBlendPatterns.tFacingLeft.tSitting.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
} 

tBlendPatterns.tFacingLeft.tSitting.tTail = {
	{ szHeadAnim = "HeadIdle", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnGazeCamera },
} 

tBlendPatterns.tFacingLeft.tSitting.tLegs = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDLeftLeg },
}

tBlendPatterns.tFacingLeft.tSitting.tBack = {
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnUDHeadPet },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
} 

-- pet lying down

tBlendPatterns.tFacingLeft.tLyingDown.tHead = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDHeadPet },
} 

tBlendPatterns.tFacingLeft.tLyingDown.tTail = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnUDHeadPet },
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDHeadPet },
} 

tBlendPatterns.tFacingLeft.tLyingDown.tLegs = {
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnGazeCamera },
}

tBlendPatterns.tFacingLeft.tLyingDown.tBack = {
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
	{ szHeadAnim = "HeadRight", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
}

--*****************************************************************
-- Blend Patterns for Pet Facing to the Right
--*****************************************************************

-- pet standing

tBlendPatterns.tFacingRight.tStanding.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDHeadPet },
} 

tBlendPatterns.tFacingRight.tStanding.tTail = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = nil },
} 

tBlendPatterns.tFacingRight.tStanding.tLegs = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail6", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyesClose", fnTweakBone = nil },
}

tBlendPatterns.tFacingRight.tStanding.tBack = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = "BodyWiggle", szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = nil },
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
}

-- pet sitting

tBlendPatterns.tFacingRight.tSitting.tHead = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
} 

tBlendPatterns.tFacingRight.tSitting.tTail = {
	{ szHeadAnim = "HeadIdle", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnGazeCamera },
} 

tBlendPatterns.tFacingRight.tSitting.tLegs = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDLeftLeg },
}

tBlendPatterns.tFacingRight.tSitting.tBack = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnUDHeadPet },
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = "Tail3", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
} 

-- pet lying down

tBlendPatterns.tFacingRight.tLyingDown.tHead = {
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDHeadPet },
} 

tBlendPatterns.tFacingRight.tLyingDown.tTail = {
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnUDHeadPet },
	{ szHeadAnim = "HeadLeft", szBodyAnim = nil, szTailAnim = nil, szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnUDHeadPet },
} 

tBlendPatterns.tFacingRight.tLyingDown.tLegs = {
	{ szHeadAnim = "HeadIdle", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = nil, fnTweakBone = fnGazeCamera },
}

tBlendPatterns.tFacingRight.tLyingDown.tBack = {
	{ szHeadAnim = "HeadDown", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
	{ szHeadAnim = "HeadPet3", szBodyAnim = nil, szTailAnim = "Tail4", szLEarAnim = nil, 	szREarAnim = nil, szTongueAnim = nil, szEyeAnim = "EyeClose", fnTweakBone = fnGazeCamera },
}

return(tBlendPatterns)
