local tPettingFunc = {}

tPettingFunc.szLastPose = "Standing"

tPettingFunc.tBlendPatterns = dofile("Pets/PettingBlend.lua")

tPettingFunc.tLastBlendPattern = nil

//-----------------------------------------------------------------
// SetCurPose
//-----------------------------------------------------------------
tPettingFunc.SetCurPose = function()
    if (PetAI.tThinkFunc.IsStanding()) then PetAI.tPettingFunc.szLastPose = "Standing"
    elseif (PetAI.tThinkFunc.IsSitting()) then PetAI.tPettingFunc.szLastPose = "Sitting"
    else PetAI.tPettingFunc.szLastPose = "LyingDown" end
end

//-----------------------------------------------------------------
// CheckPoseChange
//-----------------------------------------------------------------
tPettingFunc.CheckPoseChange = function()
    if (PetAI.tThinkFunc.IsStanding()) and (PetAI.tPettingFunc.szLastPose == "Standing") then return(false)
    elseif (PetAI.tThinkFunc.IsSitting()) and (PetAI.tPettingFunc.szLastPose == "Sitting") then return(false)
    elseif (PetAI.tThinkFunc.IsLyingDown()) and (PetAI.tPettingFunc.szLastPose == "LyingDown") then return(false)
    else return(true) end
end

//-----------------------------------------------------------------
// OnPokePet
//-----------------------------------------------------------------
tPettingFunc.OnPokePet = function(szZone)
  if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE) and (PetAI.tCurAction == nil)) then
    PetAI.tThinkFunc.RestoreAttentionSpan()
      PetAI.tPettingFunc.UpdateTrickLadder("Poke"..szZone)
  end
end

//-----------------------------------------------------------------
// OnStartPetting
//-----------------------------------------------------------------
tPettingFunc.OnStartPetting = function(szZone, bChangeZone)

  if not (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE) or PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE) or PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BRUSHING_MODE)) then return end

  -- restore attention span counter
  PetAI.tThinkFunc.RestoreAttentionSpan()

    -- set petting flag
    PetAI.bIsBeingPet = true
  PetAI.szCurPetZone = szZone

  -- set love modification value with default value
  local iLoveMod = 2

    if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE)) then
      -- ************************************************************
    -- Tub Grooming Mode
      -- ************************************************************

    PetAI.tThinkFunc.LoadNewAnim({szBody="BodyWiggle",szHead="HeadPet3",szTail="TailExcited"},1.0)
      if (PetAI.szCurTubZone != szZone) then SetActiveGlitterSprite("bubblesLv"..PetAI.tCurTubData[szZone].iLevel) end
      PetAI.szCurTubZone = szZone
    iLoveMod = PetAI.tCurShampooInUse.tAttribModifiers.iLoveMod

    elseif (PetAI.cBrushInHand != nil) then
      -- ************************************************************
    -- Brushing Mode
      -- ************************************************************
    local iGroomingEffect = PetAI.tEffects.CreateNeedWhilePettingEffect(FoxGetTickCount(),PetAI.tNeeds.tGrooming,PetAI.cBrushInHand.tAttribModifiers.iGroomingMod,1000,0)
      table.insert(PetAI.tActiveEffects,iGroomingEffect)
    end

  -- insert love need effect
  if (iLoveMod != 0) then
    local iLoveEffect = PetAI.tEffects.CreateNeedWhilePettingEffect(FoxGetTickCount(),PetAI.tNeeds.tLove,iLoveMod,1000,0)
    table.insert(PetAI.tActiveEffects,iLoveEffect)
  end

  -- reset anims to default
    if (not bChangeZone) then
        PetAI.tThinkFunc.DoIdle()
    end

  -- get current orientation direction
    local szDirection = ""
    if (PetAI.fCurOrientation == 0) then szDirection = "tFacingToward"
    elseif (PetAI.fCurOrientation == 60) then szDirection = "tFacingRight"
    elseif (PetAI.fCurOrientation == 180) then szDirection = "tFacingAway"
    elseif (PetAI.fCurOrientation == 300) then szDirection = "tFacingLeft" end

    -- get current pose
    local szPose = ""
    if (PetAI.tThinkFunc.IsStanding()) then szPose = "tStanding"
    elseif (PetAI.tThinkFunc.IsSitting()) then szPose = "tSitting"
    else szPose = "tLyingDown" end

  -- get blend table reference
    local tBlendTableRef = PetAI.tPettingFunc.tBlendPatterns[szDirection][szPose]["t"..szZone]

  -- load new blending anim table
    if not (tBlendTableRef == nil) then
        local iRand = math.random(table.getn(tBlendTableRef))
        local tBlendRef = tBlendTableRef[iRand]
        local tPettingAnim = {
            szHead = tBlendRef.szHeadAnim,
            szTail = tBlendRef.szTailAnim,
            szBody = tBlendRef.szBodyAnim,
            szLEar = tBlendRef.szLEarAnim,
            szREar = tBlendRef.szREarAnim,
            szTongue = tBlendRef.szTongueAnim,
            szEye = tBlendRef.szEyeAnim,
       fnTweakBone = tBlendRef.fnTweakBone,
        }

        PetAI.tThinkFunc.LoadNewAnim(tPettingAnim,1)
        PetAI.tPettingFunc.tLastBlendPattern = tPettingAnim;
    end
end

//-----------------------------------------------------------------
// OnEndPetting
//-----------------------------------------------------------------
tPettingFunc.OnEndPetting = function(szZone, iTime, bChangeZone)

    if not (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE) or PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE) or PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BRUSHING_MODE)) then return end

    -- restore attention span counter
    PetAI.tThinkFunc.RestoreAttentionSpan()

    -- set petting flag
    PetAI.bIsBeingPet = false

    if (szZone == "Head") then
        local iPattern = PetAI.tPettingFunc.iLastBlendPattern
        if (not bChangeZone) then
            PetAI.tThinkFunc.DoIdle()
        end
    elseif (szZone == "Back") or (szZone == "Legs") or (szZone == "Tail")  then
        if (not bChangeZone) then
            PetAI.tThinkFunc.DoIdle()
        end
    end
end

//-----------------------------------------------------------------
// OnPushPet
//-----------------------------------------------------------------
tPettingFunc.OnPushPet = function(szZone,iDirection)
  if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.ATTENTION_MODE) and (PetAI.tCurAction == nil)) then
    PetAI.tThinkFunc.RestoreAttentionSpan()
      local tDirectionNames = {"Up","Right","Down","Left"}
      PetAI.tPettingFunc.UpdateTrickLadder("Push"..szZone..tDirectionNames[iDirection+1])
  end
end

//-----------------------------------------------------------------
// UpdateTrickLadder
//-----------------------------------------------------------------
function tPettingFunc.UpdateTrickLadder(szNextStep)
    if (toy == nil and cHandheld == nil) then

        PetAI.tThinkFunc.DeActivateVCButtons()

        local vNextStep = tPettingFunc.CurTrickLadderPos[szNextStep]

        if not (vNextStep == nil) then
            if (type(vNextStep) == "function") then
                vNextStep()
            elseif (type(vNextStep) == "string") then
                PetAI.tPettingFunc.PerformTrick(vNextStep)
            elseif (type(vNextStep) == "table") then
                PetAI.tPettingFunc.CurTrickLadderPos = vNextStep
                PetAI.fMemBonus = PetAI.fMemBonus + 20
                return
            end
        end

        DoLuaEvent("PetAI.tPettingFunc.ResetTrickLadder()")
    end
end

//-----------------------------------------------------------------
// ResetTrickLadder
//-----------------------------------------------------------------
function tPettingFunc.ResetTrickLadder()
    if (PetAI.tThinkFunc.IsStanding()) then
        PetAI.tPettingFunc.CurTrickLadderPos = PetAI.tPettingFunc.TrickLadder.Standing
        PetAI.fMemBonus = 0
    elseif (PetAI.tThinkFunc.IsSitting()) then
        PetAI.tPettingFunc.CurTrickLadderPos = PetAI.tPettingFunc.TrickLadder.Sitting
        PetAI.fMemBonus    = 20
    elseif (PetAI.tThinkFunc.IsLyingDown()) then
        PetAI.tPettingFunc.CurTrickLadderPos = PetAI.tPettingFunc.TrickLadder.LyingDown
        PetAI.fMemBonus = 40
    end
end

//-----------------------------------------------------------------
// PerformTrick
//-----------------------------------------------------------------
function tPettingFunc.PerformTrick(szTrickName)

    local tTrickAction = PetAI.tActions[szTrickName]

    if (PetAI.tThinkFunc.ChangeAction(tTrickAction)) then
    PetAI.tThinkFunc.RestoreAttentionSpan()

    -- help dialog to send
    local iHelpNum = 0

      -- do help dialog
      if (szTrickName == "Promenade") then iHelpNum = 15
      elseif (szTrickName == "Sit") then iHelpNum = 16
      elseif (szTrickName == "LieDown") then iHelpNum = 17
      elseif (szTrickName == "Speak") then iHelpNum = 18
      elseif (szTrickName == "GivePaw") then iHelpNum = 19
      elseif (szTrickName == "Beg") then iHelpNum = 20
      elseif (szTrickName == "RollOver") then iHelpNum = 21
      elseif (szTrickName == "Hide") then iHelpNum = 22
      elseif (szTrickName == "NodHead") then iHelpNum = 23
      elseif (szTrickName == "ShakeHead") then iHelpNum = 24
      elseif (szTrickName == "Jump") then iHelpNum = 25
      elseif (szTrickName == "StandOnHindLegs") then iHelpNum = 26 end

    if (szTrickName == "Sit") then PetAI.MiscHelpInfo.bHasSatDown = true
    elseif (szTrickName == "LieDown") then PetAI.MiscHelpInfo.bHasLaidDown = true end

    -- send help dialog after trick performance
    DoLuaEvent("PetAI.DoHelpDialog("..iHelpNum..")",ActivePetChannel)
  end
end

tPettingFunc.TrickLadder = {}

tPettingFunc.TrickLadder.Standing = {
    PokeBack = "Promenade",
    PushHeadDown = "Sit",
    PushHeadLeft = function() PetAI.tThinkFunc.DoTurnLeft() end,
    PushHeadRight = function() PetAI.tThinkFunc.DoTurnRight() end,
    PokeHead = "Speak",
    PushHeadUp = { PokeHead = "Jump" },
    PokeTail = { PushHeadUp = "StandOnHindLegs" }
}

tPettingFunc.TrickLadder.Sitting = {
    PushHeadDown = "LieDown",
    PushHeadUp = PetAI.tThinkFunc.DoStand,
    PokeLegs = "GivePaw",
    PushLegsLeft = "Beg",
    PushLegsRight = "Beg",

    PokeHead = {
        PushHeadUp = "NodHead",
        PushHeadDown = "NodHead",
        PushHeadLeft = "ShakeHead",
        PushHeadRight = "ShakeHead",
    }
}

tPettingFunc.TrickLadder.LyingDown = {
    PushHeadUp = "Sit",
    PushBackLeft = "RollOver",
    PushBackRight = "RollOver",
    PokeHead = "Hide"
}

--
-- TrackCursor()
--
--     Pet's head tracks the cursor
--
-- input parameters:
--     u_x, u_y   :  centered normalized mouse coordinates
--
-- output parameters:
--     tweak_bone : see fnTweakBone
--
tPettingFunc.TrackCursor = function(u_x, u_y, u_length, param)
    param.on = true

    param.name = "Bip01 Head"

    param.axis.x = u_x
    param.axis.y = -u_y
    param.axis.z = 0

    param.angle = 40*u_length

    param.qav_factor_min = 1.2
    param.qav_factor = 1.2
    param.qav_factor_max = 1.2
end

//-----------------------------------------------------------------
// LoadBubbleModel
//-----------------------------------------------------------------
tPettingFunc.LoadBubbleModel = function(name, filename, bone, texture_index)
    MyAssert(pet != nil)

    PetAI.tPettingFunc.tBubbleModels = PetAI.tPettingFunc.tBubbleModels or {}

    if (PetAI.tPettingFunc.tBubbleModels[name] != nil) then
        PetAI.tPettingFunc.tBubbleModels[name]:UnLoad()
    end

    if (filename != "") then

        PetAI.tPettingFunc.tBubbleModels[name] = Load3DObject(filename)
        PetAI.tPettingFunc.tBubbleModels[name]:SetTexture(PetAI.tPettingFunc.tBubbleModels[name].data.available_textures[texture_index])
        PetAI.tPettingFunc.tBubbleModels[name]:Link(pet)
        PetAI.tPettingFunc.tBubbleModels[name]:SetAttachmentBoneIndex(pet:GetBoneIndex(bone))

        PetAI.tPettingFunc.tBubbleModels[name].texture = texture_index
        PetAI.tPettingFunc.tBubbleModels[name].filename = filename
    end
end

//-----------------------------------------------------------------
// UpdatePettingSfx
//-----------------------------------------------------------------
tPettingFunc.UpdatePettingSfx = function(iTimeBetweenUpdates)
  if (PetAI.cPettingSoundRef == nil) or (PetAI.cPettingSoundRef:IsDone()) then

    if (PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BRUSHING_MODE) or PetAI.tThinkFunc.IsInState(PetAI.PET_STATES.BATHTUB_MODE)) then
      PetAI.iTimeToNextBrushingSound = PetAI.iTimeToNextBrushingSound - iTimeBetweenUpdates

      if (PetAI.iTimeToNextBrushingSound <= 0) then
        PetAI.cBrushingSoundRef = PetAI.tSoundFX["wavBrushing"..math.random(2)]
        PetAI.cBrushingSoundRef:Play()
        PetAI.iTimeToNextBrushingSound = 250
      end
    end

    PetAI.iTimeToNextPettingSound = PetAI.iTimeToNextPettingSound - iTimeBetweenUpdates

    if (PetAI.iTimeToNextPettingSound <= 0) then
      PetAI.cPettingSoundRef = PetAI.tSoundFX["wavPetting"..math.random(10)]
      PetAI.cPettingSoundRef:Play()
      PetAI.iTimeToNextPettingSound = math.random(2000) + 2000
    end

  end
end


return(tPettingFunc)
