//-----------------------------------------------------------------
// DistanceBetweenTwoPoints
//-----------------------------------------------------------------
function DistanceBetweenTwoPoints(tA,tB)
	local fX = tA[1]-tB[1]
	local fY = tA[2]-tB[2]
	local fZ = tA[3]-tB[3]		
	return(math.sqrt(fX^2 + fY^2 + fZ^2))
end

-- ****************************************************************
-- Ball Object Functionality
-- ****************************************************************
cBallSet = {}

//-----------------------------------------------------------------
// CreateBall
//-----------------------------------------------------------------
function CreateBall(iTextureNum, iX, iY, iZ)
  local cBall = CBall()
  cBall:Load("Objects/toy_ball.lua")
  cBall:SetPosition(iX, iY, iZ)
  cBall:SetVisible(1)
  cBall:SetMass(20.0)
  cBall:SetElasticity(0.7)  
  cBall:SetTexture("Mod_xCDBall_0"..iTextureNum.."T.dds")
  cBall:Link(Room.m_cSceneManager)
  table.insert(cBallSet,cBall)
  return cBall
end

//-----------------------------------------------------------------
// UpdateBalls
//-----------------------------------------------------------------
function UpdateBalls()

	local iBoneIndex = pet:GetBoneIndex("Mouth01")
	local x,y,z = pet:GetBonePosition(iBoneIndex)
	local tMouthPos = {x,y,z}
	
	for i in ipairs(cBallSet) do
		x,y,z = cBallSet[i]:GetPosition()
		local tBallPos = {x,y,z}
--[[		if (DistanceBetweenTwoPoints(tBallPos,tMouthPos) < 20.0) then-- and PetAI.tThinkFunc.IsUsingPickUpAction()) then
			cBallSet[i]:Link(dog)
			cBallSet[i]:SetAttachmentBoneIndex(iBoneIndex)			
			cBallSet[i]:Pause()
		end ]]--
		cBallSet[i]:Update(FoxGetTickCount())
	end
end

//-----------------------------------------------------------------
// DestroyBall
//-----------------------------------------------------------------
function DestroyBall()
	for i in ipairs(cBallSet) do
		cBallSet[i]:UnLink()
		cBallSet[i] = nil
	end
end

-- ****************************************************************
-- Disc Object Functionality
-- ****************************************************************
cDiscSet = {}

//-----------------------------------------------------------------
// CreateDisc
//-----------------------------------------------------------------
function CreateDisc(iTextureNum, iX, iY, iZ)
  local cDisc = CDisc()
  cDisc:Load("Objects/toy_frisbee.lua")
  cDisc:SetPosition(iX, iY, iZ)
  cDisc:SetVisible(1)
  cDisc:SetMass(2.0)
  cDisc:SetTexture("Mod_xCDflyingdiscs_0"..iTextureNum.."T.dds")
  cDisc:Link(Room.m_cSceneManager)
  table.insert(cDiscSet,cDisc)
  return cDisc
end

//-----------------------------------------------------------------
// UpdateDiscs
//-----------------------------------------------------------------
function UpdateDiscs()

	local iBoneIndex = pet:GetBoneIndex("Mouth01")
	local x,y,z = pet:GetBonePosition(iBoneIndex)
	local tMouthPos = {x,y,z}
	
	for i in ipairs(cDiscSet) do
		x,y,z = cDiscSet[i]:GetPosition()
		local tDiscPos = {x,y,z}
			cDiscSet[i]:Update(FoxGetTickCount())
	end
end

//-----------------------------------------------------------------
// DestroyDisc
//-----------------------------------------------------------------
function DestroyDisc()
	for i in ipairs(cDiscSet) do
		cDiscSet[i]:UnLink()
		cDiscSet[i] = nil
	end
end

-- ****************************************************************
-- Rigid Body Object Functionality
-- ****************************************************************
cRBodySet = {}

//-----------------------------------------------------------------
// CreateRBody
//-----------------------------------------------------------------
function CreateRBody(iX, iY, iZ)
  local cRBody = CRigidBody()
  cRBody:Load("Objects/toy_teddybear.lua")
  cRBody:SetPosition(iX, iY, iZ)
  cRBody:SetVisible(1)
  cRBody:SetElasticity(0.3)
  cRBody:SetMass(80.0)
  cRBody:Link(Room.m_cSceneManager)
  table.insert(cRBodySet,cRBody)
  return cRBody
end

//-----------------------------------------------------------------
// UpdateRBodies
//-----------------------------------------------------------------
function UpdateRBodies()
--[[
	local iBoneIndex = pet:GetBoneIndex("Mouth01")
	local x,y,z = pet:GetBonePosition(iBoneIndex)
	local tMouthPos = {x,y,z}
	]]--

	
	for i in ipairs(cRBodySet) do
		x,y,z = cRBodySet[i]:GetPosition()
		local tRBodyPos = {x,y,z}
			cRBodySet[i]:Update(FoxGetTickCount())
	end

end

//-----------------------------------------------------------------
// DestroyRBody
//-----------------------------------------------------------------
function DestroyRBody()
	for i in ipairs(cRBodySet) do
		cRBodySet[i]:UnLink()
		cRBodySet[i] = nil
	end
end