TalentShow = {}

//-----------------------------------------------------------------
// Variable Declarations
//-----------------------------------------------------------------
TalentShow.bActive = false
TalentShow.szCurState = "STATE_WELCOME"
TalentShow.iCurRound = 1

TalentShow.szDiffSetting = "Easy"
TalentShow.iRank = 1
TalentShow.tCurOpponents = {}
TalentShow.iLastUpdateTime = 0
TalentShow.iLastMsgUpdateTime = 0
TalentShow.iCurTotal = 0

TalentShow.iCurTrickSeqMarker = 1

TalentShow.iTimeLimit = 0

TalentShow.tDeadSoundObjects = {}

TalentShow.tTricksToDo = {}
TalentShow.iNumFailures = 0
TalentShow.iCompletionTime = 0

TalentShow.bIsWalkingAround = false

TalentShow.tTricksPerformed = {}

TalentShow.FindInTable = function(tTable,szString)
  for i = 1,table.getn(tTable) do if (tTable[i] == szString) then return(i) end end
  return(0)
end

TalentShow.DisableTricks = function() HideToolTip() Room.trick_frame:Erase() end
TalentShow.EnableTricks = function() Room.trick_frame:Enable() Room.trick_frame:Paint() end

//-----------------------------------------------------------------
// Setup Ranking
//-----------------------------------------------------------------
TalentShow.tCurRanking = {
  Easy = 1,
  Medium = 1,
  Hard = 1,
}

TalentShow.PrintRankings = function()
  print("Rankings: Easy = "..PetAI.TalentShow.tCurRanking.Easy.." Medium = "..PetAI.TalentShow.tCurRanking.Medium.." Hard = "..PetAI.TalentShow.tCurRanking.Hard)
end


TalentShow.tCurRankInfo = nil

TalentShow.tLastRankFailure = {
  szLevel = "Easy",
  iRank = 1
}

TalentShow.tRankingInfo = {
  Easy = {
    { iTargetScore = 10, iRound1Time = 40, Reward1 = 40, Reward2 = 25, Reward3 = 12 },   -- Rank 1
    { iTargetScore = 12, iRound1Time = 30, Reward1 = 60, Reward2 = 37, Reward3 = 16 },   -- Rank 2
    { iTargetScore = 14, iRound1Time = 25, Reward1 = 75, Reward2 = 49, Reward3 = 24 },   -- Rank 3
    { iTargetScore = 16, iRound1Time = 20, Reward1 = 90, Reward2 = 60, Reward3 = 30 },   -- Rank 4
    { iTargetScore = 20, iRound1Time = 20, Reward1 = 100, Reward2 = 75, Reward3 = 40 },  -- Rank 5
    { iTargetScore = 20, iRound1Time = 20, Reward1 = 100, Reward2 = 75, Reward3 = 40 },   -- Rank 6 (MAX)
  },

  Medium = {
    { iTargetScore = 20, iRound1Time = 40, Reward1 = 200, Reward2 = 110, Reward3 = 60 },  -- Rank 1
    { iTargetScore = 24, iRound1Time = 30, Reward1 = 250, Reward2 = 135, Reward3 = 70 },  -- Rank 2
    { iTargetScore = 28, iRound1Time = 25, Reward1 = 300, Reward2 = 160, Reward3 = 84 },  -- Rank 3
    { iTargetScore = 32, iRound1Time = 20, Reward1 = 350, Reward2 = 185, Reward3 = 96 },  -- Rank 4
    { iTargetScore = 40, iRound1Time = 20, Reward1 = 400, Reward2 = 210, Reward3 = 107 },  -- Rank 5
    { iTargetScore = 40, iRound1Time = 20, Reward1 = 400, Reward2 = 210, Reward3 = 107 },  -- Rank 6 (MAX)
  },

  Hard = {
    { iTargetScore = 40, iRound1Time = 40, Reward1 = 600, Reward2 = 320, Reward3 = 165 },  -- Rank 1
    { iTargetScore = 45, iRound1Time = 30, Reward1 = 700, Reward2 = 370, Reward3 = 190 },  -- Rank 2
    { iTargetScore = 50, iRound1Time = 25, Reward1 = 800, Reward2 = 430, Reward3 = 220 },  -- Rank 3
    { iTargetScore = 55, iRound1Time = 20, Reward1 = 900, Reward2 = 485, Reward3 = 245 },  -- Rank 4
    { iTargetScore = 65, iRound1Time = 20, Reward1 = 1000, Reward2 = 540, Reward3 = 275 },  -- Rank 5
    { iTargetScore = 65, iRound1Time = 20, Reward1 = 1000, Reward2 = 540, Reward3 = 275 },  -- Rank 6 (MAX)
  },
}

//-----------------------------------------------------------------
// GetImageForBreed
//-----------------------------------------------------------------
TalentShow.GetImageForBreed = function(szBreedName)
  if CATZ then
    if (szBreedName == "Abyssinian") then return("But_xCadoptabyssinian_01T.tga")
    elseif (szBreedName == "Bengal") then return("But_xCadoptbengal_01T.tga")
    elseif (szBreedName == "Burmese") then return("But_xCadoptburmese_01T.tga")
    elseif (szBreedName == "MaineCoon") then return("But_xCadoptmainecoon_01T.tga")
    elseif (szBreedName == "Siamese") then return("But_xCadoptsiamese_01T.tga") end
  else
    if (szBreedName == "Beagle") then return("But_xDadoptbeagle_01T.tga")
    elseif (szBreedName == "BorderCollie") then return("But_xDadoptbordercollie_01T.tga")
    elseif (szBreedName == "GermanShepard") then return("But_xDadoptgermanshepard_01T.tga")
    elseif (szBreedName == "GoldenRetriever") then return("But_xDadoptgoldenretriever_01T.tga")
    elseif (szBreedName == "Pug") then return("But_xDadoptpug_01T.tga") end
  end
end

//-----------------------------------------------------------------
//LoadOpponents
//-----------------------------------------------------------------
TalentShow.LoadOpponents = function()

  local szPetName = ""
  local szPetBreedImage = ""
  local tBreedImages = nil

  local tScores = {PetAI.TalentShow.tCurRankInfo.iTargetScore,0.75*PetAI.TalentShow.tCurRankInfo.iTargetScore,0.50*PetAI.TalentShow.tCurRankInfo.iTargetScore}

  if CATZ then
    tBreedImages = {"But_xCadoptabyssinian_01T.tga","But_xCadoptbengal_01T.tga","But_xCadoptsiamese_01T.tga","But_xCadoptburmese_01T.tga","But_xCadoptmainecoon_01T.tga"}
  else
    tBreedImages = {"But_xDadoptgermanshepard_01T.tga","But_xDadoptbordercollie_01T.tga","But_xDadoptgoldenretriever_01T.tga","But_xDadoptbeagle_01T.tga","But_xDadoptpug_01T.tga"}
  end

  PetAI.TalentShow.tOpponents = {}

  local IsInTable = function(tTable,vItem) for i = 1,table.getn(tTable) do if (tTable[i] == vItem) then return(true) end end return(false) end
  local tUsedNames = {}
  local tUsedBreeds = {}

  -- randomly generate other contestants
  for i = 1,3 do
    szPetName = GetLanguageString("TS_RandomName"..(i*math.random(6)))
    szPetBreedImage = tBreedImages[math.random(table.getn(tBreedImages))]

    -- ensure the pet's name and breed will be unique among the contestants    
    while (IsInTable(tUsedNames,szPetName)) do szPetName = GetLanguageString("TS_RandomName"..(i*math.random(6))) end
    while (IsInTable(tUsedBreeds,szPetBreedImage)) do szPetBreedImage = tBreedImages[math.random(table.getn(tBreedImages))] end
            
    table.insert(PetAI.TalentShow.tOpponents,{szName = szPetName, szBreedImage = szPetBreedImage, iPlace = i, iScore = tScores[i]})
    table.insert(tUsedNames,szPetName)
    table.insert(tUsedBreeds,szPetBreedImage)
  end
  
  -- dump temp tables
  tUsedNames = nil
  tUsedBreeds = nil
end

//-----------------------------------------------------------------
// Setup Opponent Images
//-----------------------------------------------------------------

TalentShow.LoadOpponentImages = function()
  local tBreedImages = nil
  local tPicRef = nil

  local iHeight = GetAppHeight()

  local iStartX = GetAppWidth()/4
  local iXStep = GetAppWidth()/4

  local iX = iStartX

  local iY = iHeight * 0.75 -- 1280x1024 and higher modes
  if (iHeight < 768) then
    iY = iHeight * 0.65 -- 800x600 mode
  else
    if ( iHeight < 1024 ) then
       iY = iHeight * 0.7 -- 1024x768 mode
    end
  end

  for i = 1,3 do

    TalentShow["Opponent"..i] = CxSprite()
    TalentShow["Opponent"..i]:LoadSurface(PetAI.TalentShow.tOpponents[i].szBreedImage,5)
    TalentShow["Opponent"..i]:Link(Room.this)
    TalentShow["Opponent"..i]:Paint(iX,iY,EPOS.TOPCENTER)

    tPicRef = TalentShow["Opponent"..i]

    TalentShow["Opponent"..i.."Label"] = Text { position = {0,0}, size = {tPicRef:GetWidth(),tPicRef:GetHeight()}, pointsize = 18, text = "", font = g_nFont2, color = 0xFFF0F0F0, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER + TEXT_WORD_WRAP}
    TalentShow["Opponent"..i.."Label"]:Paint(iX,iY + tPicRef:GetHeight(),EPOS.TOPCENTER)
    TalentShow["Opponent"..i.."Label"]:SetString(PetAI.TalentShow.tOpponents[i].szName)
    TalentShow["Opponent"..i.."Label"]:Link(Room.this)

    iX = iX + iXStep
  end
end

TalentShow.RemoveOpponentImages = function()
  for i = 1,3 do
    if (TalentShow["Opponent"..i] != nil) then TalentShow["Opponent"..i]:ReleaseSurface() end
    if (TalentShow["Opponent"..i.."Label"] != nil) then TalentShow["Opponent"..i.."Label"]:ReleaseSurface() end
  end
end

//-----------------------------------------------------------------
// Setup Scrolling Button
//-----------------------------------------------------------------

TalentShow.cNextButton = CLuaButton()
TalentShow.cNextButton:SetName("Next")
TalentShow.cNextButton:LoadSurface("But_xCDbookoftricksrightarrow_01T.tga")
TalentShow.cNextButton:Link(Room.this);
TalentShow.cNextButton:SetOnClicked("PetAI.TalentShow.RemoveFrontMsg() if (table.getn(PetAI.TalentShow.MsgQueue) > 0) then PetAI.TalentShow.LoadNextMsg() end")
TalentShow.cNextButton:Paint(GetAppWidth()/2,GetAppHeight()*(0.25),EPOS.TOPCENTER)
TalentShow.cNextButton:Erase()

TalentShow.cCloseButton = CLuaButton()
TalentShow.cCloseButton:SetName("Return to House")
TalentShow.cCloseButton:LoadSurface("But_xCDhouse_01T.tga")
TalentShow.cCloseButton:Link(Room.this);
TalentShow.cCloseButton:SetOnClicked("PetAI.tThinkFunc.ChangeState(PetAI.PET_STATES.IDLE_MODE)")
TalentShow.cCloseButton:SetOnMouseEnter("DoToolTipForButton(PetAI.TalentShow.cCloseButton,'ReturnToHouse')")
TalentShow.cCloseButton:SetOnMouseExit("HideToolTip()")
TalentShow.cCloseButton:Paint(GetAppWidth()/2,GetAppHeight()*(0.30),EPOS.TOPCENTER)
TalentShow.cCloseButton:Erase()

//-----------------------------------------------------------------
// Setup Dialog Box
//-----------------------------------------------------------------

TalentShow.MSG_TYPES = {
  TIMED_OUT = 1,
  USER_CONTROL = 2,
  PERMANENT = 3
}

TalentShow.MsgQueue = {}

TalentShow.DialogBox = CxSprite()
TalentShow.DialogBox:LoadSurface("COMMON/PETZ_DialogBox.tga")
local iPointSize = 12

if (GetAppWidth() == 800) then
  TalentShow.DialogBox:LoadSurface("Textures/UI_xCDthindialogbox_01T.tga")
  TalentShow.DialogBox:Paint(GetAppWidth()/2,0,EPOS.TOPCENTER)
  iPointSize = 14
else
  TalentShow.DialogBox:LoadSurface("Textures/UI_xCDthindialogbox1024_01T.tga")
  TalentShow.DialogBox:Paint(GetAppWidth()/2,0,EPOS.TOPCENTER)
  iPointSize = 18
end

TalentShow.DialogBox:SetZOrder(ZORDER.TOPMOST)
TalentShow.DialogBox:Link(Room.this)

local iW = TalentShow.DialogBox:GetWidth()
local iH = TalentShow.DialogBox:GetHeight()

TalentShow.DialogBoxText = Text { position = {0,0}, size = {GetAppWidth()*0.75,GetAppHeight()/10}, pointsize = iPointSize, text = "", font = g_nFont2, color = 0xFFF0F0F0, bkcolor = 0x00000000, flags = TEXT_CENTER_CENTER + TEXT_WORD_WRAP}
TalentShow.DialogBoxText:Paint(GetAppWidth()/2,GetAppHeight()/4,EPOS.BOTTOMCENTER)

TalentShow.DialogBoxText:Erase()
TalentShow.DialogBox:Erase()

TalentShow.AddNewMsg = function(szMsgText,iMsgType,iMsgDuration,szMsgSoundFile,MsgEffectFunc)
  if (iMsgType == nil) then iMsgType = PetAI.TalentShow.MSG_TYPES.TIMED_OUT end
  table.insert(PetAI.TalentShow.MsgQueue,{szText=szMsgText,iType=iMsgType,iDuration=iMsgDuration,szSoundFile=szMsgSoundFile,EffectFunc=MsgEffectFunc})
  if (table.getn(PetAI.TalentShow.MsgQueue) == 1) then PetAI.TalentShow.LoadNextMsg() end
end

TalentShow.LoadNextMsg = function()
  PetAI.TalentShow.DialogBoxText:Enable()
  PetAI.TalentShow.DialogBoxText:SetString(TalentShow.MsgQueue[1].szText)

  if (TalentShow.MsgQueue[1].iType == PetAI.TalentShow.MSG_TYPES.USER_CONTROL) then
    PetAI.TalentShow.cNextButton:Paint()
  else PetAI.TalentShow.cNextButton:Erase() end

  if not (PetAI.TalentShow.MsgQueue[1].szSoundFile == nil) then
      local cNewSound = CxWave()
      cNewSound:Load(PetAI.TalentShow.MsgQueue[1].szSoundFile)
      cNewSound:Play()
      table.insert(PetAI.TalentShow.tDeadSoundObjects,cNewSound)
  end
  --PetAI.TalentShow.DialogBox:Paint()
  if (TalentShow.MsgQueue[1].EffectFunc != nil) then TalentShow.MsgQueue[1].EffectFunc() end
  PetAI.TalentShow.DialogBoxText:Paint()
  PetAI.TalentShow.iLastMsgUpdateTime = FoxGetTickCount()
end

TalentShow.RemoveFrontMsg = function()
  if (table.getn(PetAI.TalentShow.MsgQueue) == 0) then return end
  PetAI.TalentShow.DialogBox:Erase()
  PetAI.TalentShow.DialogBoxText:Erase()
  PetAI.TalentShow.cNextButton:Erase()
  if not (PetAI.TalentShow.MsgQueue[1].cSound == nil) then PetAI.TalentShow.MsgQueue[1].cSound:Stop() end
  table.remove(PetAI.TalentShow.MsgQueue,1)
end

//-----------------------------------------------------------------
// ProcessContestants
//-----------------------------------------------------------------
TalentShow.ProcessContestants = function()

  PetAI.TalentShow.tContestants = {}

  -- load all contestants
  table.insert(PetAI.TalentShow.tContestants,{szName = PetAI.szName, szBreedImage = PetAI.TalentShow.GetImageForBreed(PetAI.tBreed.szName), iPlace = 0, iScore = PetAI.TalentShow.iCurTotal})
  for i = 1,3 do table.insert(PetAI.TalentShow.tContestants,PetAI.TalentShow.tOpponents[i]) end

  table.sort(PetAI.TalentShow.tContestants,function(a,b) return(a.iScore > b.iScore) end)

  for i = 1,4 do PetAI.TalentShow.tContestants[i].iPlace = i end
end

//-----------------------------------------------------------------
// LoadResultsScreen
//-----------------------------------------------------------------
TalentShow.LoadResultsScreen = function()

  PetAI.TalentShow.tContestantDisplays = {}

  local x,y
  local xSpacing = GetAppWidth()/6
  local xStart = GetAppWidth()/2 - (1.5*xSpacing)
  local cImage = nil
  local cInfoBox = nil
  local this = nil

  for i = 1,4 do
    this = PetAI.TalentShow.tContestants[i]
    x = xStart + (i-1)*xSpacing
    y = GetAppHeight() - GetAppHeight()*0.33
    cImage = Sprite {filename = this.szBreedImage, numframes = 5, position = {x,y}, epos = EPOS.TOPCENTER, parent = Room.this}
    cInfoBox = Text { position = {x,y+cImage:GetHeight()}, epos = EPOS.TOPCENTER, size = {200,200}, pointsize = iPointSize, text = "", font = g_nFont2, color = 0xFFF0F0F0, parent = Room.this, bkcolor = 0x00000000, flags = TEXT_TOP_CENTER + TEXT_WORD_WRAP}
    cInfoBox:SetString(this.szName.."\n"..GetLanguageString("TS_Award"..this.iPlace).."\n"..string.format(GetLanguageString("TS_Score"),this.iScore))
    table.insert(PetAI.TalentShow.tContestantDisplays,{image = cImage, text = cInfoBox})
  end

  PetAI.TalentShow.cCloseButton:Paint()
end

//-----------------------------------------------------------------
// RemoveResultsScreen
//-----------------------------------------------------------------
TalentShow.RemoveResultsScreen = function()

    if (PetAI.TalentShow.tContestantDisplays != nil) then
        for i, v in ipairs(PetAI.TalentShow.tContestantDisplays) do
            v.image:Kill()
            v.text:Kill()
        end
    end

    PetAI.TalentShow.tContestants = nil
    PetAI.TalentShow.tContestantDisplays = nil
end


//-----------------------------------------------------------------
// Time Functionality
//-----------------------------------------------------------------

TalentShow.GetTimeString = function(iMilliTime)
  local iNumSecs = math.floor(iMilliTime/1000)
  local iNumMilliSecs = math.floor(iMilliTime - iNumSecs*1000)/10
  local szTimeText = ""
  local szMilliText = ""

  if (iNumMilliSecs < 10) then szMilliText = string.format("0%d",iNumMilliSecs)
  else szMilliText = string.format("%d",iNumMilliSecs) end

  return(string.format("%d:%s",iNumSecs,szMilliText))
end

TalentShow.UpdateTimer = function(iMilliTime)
  local iNumSecs = math.floor(iMilliTime/1000)
  local iNumMilliSecs = math.floor(iMilliTime - iNumSecs*1000)/10
  SetTalentTimer(iNumSecs,iNumMilliSecs)
end

//-----------------------------------------------------------------
// Difficulty Setting
//-----------------------------------------------------------------
TalentShow.GetHighestTalentShowLevel = function()

  -- setup variables
  local iShowLevel = 0
  local tLearnedTricks = PetAI.GetLearnedTrickSubset(PetAI.tAllTricks)
  local iNumLearned = table.getn(tLearnedTricks)

  if (PetAI.tVoiceCommands.Promenade.bActive) then

    -- set available difficulty levels depending on num tricks learned
    if (iNumLearned >= 4) then iShowLevel = 1 end
    if (iNumLearned >= 8) then iShowLevel = 2 end
    if (iNumLearned >= 12) then iShowLevel = 3 end
  end

  -- return the determined highest difficulty level
  return(iShowLevel)
end

//-----------------------------------------------------------------
// IsReadyForNewRound
//-----------------------------------------------------------------
TalentShow.IsReadyForNewRound = function()
  local bCamChannelEmpty = IsChannelEmpty(Room.m_nCameraChannel)
  local bCamTrackChannelEmpty = IsChannelEmpty(Room.m_nCameraTrackChannel)
  local bIsIdle = PetAI.tThinkFunc.IsIdle()

  return(bCamChannelEmpty and bCamTrackChannelEmpty and bIsIdle)
end

//-----------------------------------------------------------------
// Initialize
//-----------------------------------------------------------------
TalentShow.Initialize = function(szDiffLevel)
  PetAI.TalentShow.bActive = true
  PetAI.TalentShow.iRank = TalentShow.tCurRanking[szDiffLevel]
  PetAI.TalentShow.szDiffSetting = szDiffLevel
  PetAI.TalentShow.tCurRankInfo = TalentShow.tRankingInfo[PetAI.TalentShow.szDiffSetting][PetAI.TalentShow.iRank]

  PetAI.TalentShow.LoadOpponents()

  PetAI.TalentShow.szCurState = "STATE_WELCOME"
  PetAI.TalentShow.iCurRound = 1

  PetAI.TalentShow.cCloseButton:Link(Room.this)

  PetAI.TalentShow.cNextButton:Link(Room.this)
  PetAI.TalentShow.cNextButton:Paint()

  PetAI.TalentShow.DisableTricks()
  Room.trick_button:Disable()

  -- initialize the timer
  SetTalentTimer(0,0)

   -- reset point totals
  PetAI.TalentShow.iCurTotal = 0
  PetAI.TalentShow.iRound1Points = 0
  PetAI.TalentShow.iRound2Points = 0
  PetAI.TalentShow.iRound3Points = 0
end

//-----------------------------------------------------------------
// StopAllMusic
//-----------------------------------------------------------------
TalentShow.StopAllMusic = function()
	PetAI.tSoundFX.wavTSApplause:Stop()
	PetAI.tSoundFX.wavTSClap01:Stop()
	PetAI.tSoundFX.wavTSClap02:Stop()
	PetAI.tSoundFX.wavTSClap03:Stop()
	PetAI.tSoundFX.wavTSFail:Stop()
	PetAI.tSoundFX.wavTSWow:Stop()
	PetAI.tSoundFX.wavTSIntro:Stop()
	PetAI.tSoundFX.wavTSEnding:Stop()
	PetAI.tSoundFX.wavTSRound1Begin:Stop()
	PetAI.tSoundFX.wavTSRound1End:Stop()
	PetAI.tSoundFX.wavTSRound1Fail:Stop()
	PetAI.tSoundFX.wavTSRound2Begin:Stop()
	PetAI.tSoundFX.wavTSRound2End:Stop()
	PetAI.tSoundFX.wavTSRound2Fail:Stop()
	PetAI.tSoundFX.wavTSRound3Begin:Stop()

  -- stop and remove any dynamically-generated sfx
  while (table.getn(PetAI.TalentShow.tDeadSoundObjects) > 0) do
    PetAI.TalentShow.tDeadSoundObjects[1]:Stop()
    PetAI.TalentShow.tDeadSoundObjects[1]:Release()
    table.remove(PetAI.TalentShow.tDeadSoundObjects,1)
  end

end

//-----------------------------------------------------------------
// Terminate
//-----------------------------------------------------------------
TalentShow.Terminate = function()
  TalentShow.bActive = false
  PetAI.TalentShow.StopAllMusic()
  PetAI.TalentShow.RemoveOpponentImages()
  PetAI.TalentShow.RemoveResultsScreen()
  PetAI.TalentShow.cNextButton:Erase()
  PetAI.TalentShow.cCloseButton:Erase()
  PetAI.TalentShow.EnableTricks()
  Room.trick_button:Enable()
  while (table.getn(PetAI.TalentShow.MsgQueue) > 0) do PetAI.TalentShow.RemoveFrontMsg() end
end

//-----------------------------------------------------------------
// Update
//-----------------------------------------------------------------
TalentShow.Update = function(iElapsedTime)

  local this = PetAI.TalentShow

  -- sfx indices to remove
  local tSfxToRemove = {}

  -- check if any sfx can now be deleted
  for i=1,table.getn(this.tDeadSoundObjects) do
   if not (this.tDeadSoundObjects[i]:IsPlaying() == 1) then
     this.tDeadSoundObjects[i]:Release()
     table.insert(tSfxToRemove,i)
   end
  end

  -- remove any dead sfx
  while (table.getn(tSfxToRemove) > 0) do
    table.remove(this.tDeadSoundObjects,tSfxToRemove[1])
    table.remove(tSfxToRemove,1)
  end

  if (table.getn(this.MsgQueue) > 0) then
    -- ************************************************************
    -- Process Message Queue
    -- ************************************************************

    if (this.MsgQueue[1].iType == this.MSG_TYPES.TIMED_OUT) then

      this.MsgQueue[1].iDuration = this.MsgQueue[1].iDuration - (iElapsedTime - this.iLastUpdateTime)

      if (this.MsgQueue[1].iDuration < 0) then
        this.UpdateRound()
        this.RemoveFrontMsg()
        SetTalentTimer(0,0)        
        if (table.getn(this.MsgQueue) > 0) then this.LoadNextMsg() end
      elseif (this.szCurState == "STATE_DO_ROUND") then
        PetAI.TalentShow.UpdateTimer(this.MsgQueue[1].iDuration)
      end
    end

  elseif (this.szCurState == "STATE_WELCOME") then
    -- ************************************************************
    -- Welcome State
    -- ************************************************************

    -- play intro music
    PetAI.tSoundFX.wavTSIntro:Play()

    -- adjust rank display text (if necessary)
    local iDisplayRank = this.iRank

    -- load the introductory welcome message
    local szMsg = string.format(GetLanguageString("TS_Welcome"..this.szDiffSetting),iDisplayRank)
    this.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,"ts_applause.wav")

    -- transition to next state
    this.szCurState = "STATE_PET_ID"

  elseif (this.szCurState == "STATE_PET_ID") then
    -- ************************************************************
    -- Pet ID State
    -- ************************************************************

    -- load the 'next contestant' message
    local szMsg = string.format(GetLanguageString("TS_PetID"),GetLanguageString("TS_Breed"..PetAI.tBreed.szName),PetAI.szName)
    this.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000)

    if (PetAI.tTalentShowCounts[this.szDiffSetting] == 0) then
      -- configure load new pet performance message
      local szPetGender = GetLanguageString("TS_His")
      if (PetAI.szGender == "Female") then szPetGender = GetLanguageString("TS_Her") end
      if ((gLanguage == "German") or (gLanguage == "French")) then this.AddNewMsg(string.format(GetLanguageString("TS_PetNew"),PetAI.szName,PetAI.szName),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,"ts_applause.wav")
      elseif ((gLanguage == "Italian") or (gLanguage == "Spanish")) then this.AddNewMsg(string.format(GetLanguageString("TS_PetNew"),PetAI.szName),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,"ts_applause.wav")
      else this.AddNewMsg(string.format(GetLanguageString("TS_PetNew"),szPetGender,PetAI.szName),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,"ts_applause.wav") end
    else
      -- configure and load pet performance history message
      local iShowCount = PetAI.tTalentShowCounts[TalentShow.szDiffSetting]
      local iWinCount = PetAI.tTalentShowWins[TalentShow.szDiffSetting]
      local szDiffSetting = GetLanguageString("TS_"..this.szDiffSetting)
      szMsg = string.format(GetLanguageString("TS_PetHistory"),PetAI.szName,iShowCount,szDiffSetting,iWinCount)
      this.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,"ts_applause.wav")
    end

     -- manage opponent image rendering
    local ShowOpponentImages = function() PetAI.TalentShow.LoadOpponentImages() end
    local DumpOpponentImages = function() TalentShow.RemoveOpponentImages() end

    -- load 'to beat' talent show message
    szMsg = string.format(GetLanguageString("TS_ToBeat"),this.tOpponents[1].szName,this.tOpponents[2].szName,this.tOpponents[3].szName)
    this.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,nil,ShowOpponentImages)

    -- increment show count
    PetAI.tTalentShowCounts[this.szDiffSetting] = PetAI.tTalentShowCounts[this.szDiffSetting] + 1

    -- load round preparation message
    this.AddNewMsg(GetLanguageString("TS_ReadyRound"..this.iCurRound),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,nil,DumpOpponentImages)

    -- transition to next state
    this.szCurState = "STATE_WAIT_UNTIL_READY"

  elseif (this.szCurState == "STATE_WAIT_UNTIL_READY") then
    -- ************************************************************
    -- Round Readiness Delay State
    -- ************************************************************

    -- transition to the round execution state when the pet is ready
    if (this.IsReadyForNewRound()) then this.szCurState = "STATE_PREPARE_ROUND" end

  elseif (this.szCurState == "STATE_PREPARE_ROUND") then
    -- ************************************************************
    -- Round Preparation State
    -- ************************************************************

    -- run round-specific preparation function
    this["Round"..this.iCurRound].Prepare()

    -- transition to next state
    this.szCurState = "STATE_DO_ROUND"

  elseif (this.szCurState == "STATE_DO_ROUND") then
    -- ************************************************************
    -- Round Performance State
    -- ************************************************************

    this.szCurState = "STATE_SCORE_ROUND"

  elseif (this.szCurState == "STATE_SCORE_ROUND") then
    -- ************************************************************
    -- Round Scoring State
    -- ************************************************************

    PetAI.TalentShow.DisableTricks()

    if (PetAI.tCurAction != nil) then return end

    -- run round-specific score function
    this["Round"..this.iCurRound].Score()

    -- increment round counter
    this.iCurRound = this.iCurRound + 1

    -- check if talent show is complete, otherwise loop
    if (this.iCurRound > 3) then this.szCurState = "STATE_END"
    else
      this.AddNewMsg(GetLanguageString("TS_ReadyRound"..this.iCurRound),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000)
      this.szCurState = "STATE_WAIT_UNTIL_READY"
    end


  elseif (this.szCurState == "STATE_END") then
    -- ************************************************************
    -- End State
    -- ************************************************************

    local iFinishingPlace = 0
    local iReward = 0

    -- collapse the trick button set to keep from blocking text
    Room.trick_frame:Erase()

    -- process contestants' final scores
    this.ProcessContestants()

    -- determine finishing place by sorting through contestant set
    for i=1,4 do if (this.tContestants[i].szName == PetAI.szName) then iFinishingPlace = this.tContestants[i].iPlace break end end

    -- if the pet has placed in the top three...
    if (iFinishingPlace != 4) then

      -- play congratulatory sfx
      PetAI.tSoundFX.wavTSApplause:Play()

      -- give cash reward
      iReward = this.tCurRankInfo["Reward"..iFinishingPlace]
      Room.EarnMoney(iReward)

      -- keep track of total winnings from all shows at this difficulty level
      PetAI.tTalentShowWins[this.szDiffSetting] = PetAI.tTalentShowWins[this.szDiffSetting]+iReward

      -- increase ranking (if not at top)
      if (this.tCurRanking[this.szDiffSetting] < 6) then this.tCurRanking[this.szDiffSetting] = this.tCurRanking[this.szDiffSetting] + 1 end

    -- otherwise, if pet has failed to place...
    else

      -- play consoling sfx
      PetAI.tSoundFX.wavTSFail:Play()

      -- if the pet has failed this ranking twice in a row, decrement its current rank for this difficult setting (if not already max)
      if (this.iRank < 6) and (this.szDiffSetting == this.tLastRankFailure.szLevel) and (this.iRank == this.tLastRankFailure.iRank) then
        if (this.tCurRanking[this.szDiffSetting] > 1) then
          this.tCurRanking[this.szDiffSetting] = this.tCurRanking[this.szDiffSetting] - 1
        end
      end

      -- save this rank failure to check for future rank decrements
      this.tLastRankFailure.szLevel = this.szDiffSetting
      this.tLastRankFailure.iRank = this.iRank
    end

    local szYourScoreMsg = string.format(GetLanguageString("TS_YourScore"),this.iRound1Points,this.iRound2Points,this.iRound3Points,this.iCurTotal)
    local szPlaceMsg = string.format(GetLanguageString("TS_WinPlace"..iFinishingPlace),PetAI.szName,iReward)
    local szClosingMsg = szYourScoreMsg.."\n"..szPlaceMsg.."\n"..GetLanguageString("TS_Bye")


    -- load closing message
    this.AddNewMsg(szClosingMsg,PetAI.TalentShow.MSG_TYPES.PERMANENT,8000,nil,PetAI.TalentShow.LoadResultsScreen)

    -- restore camera settings for talent show room
    local tCamPos = Room.rooms[Room.m_nCurRoom].HomeEye
	  DoEvent("Room.MoveCamera(100, 20, " ..tCamPos[1]..", "..tCamPos[2]..", "..tCamPos[3]..")", Room.m_nCameraTrackChannel)

    -- set the talent show to close after the camera move
    PetAI.TalentShow.szCurState = "STATE_CLOSE"

    -- play ending music
    PetAI.tSoundFX.wavTSEnding:Play()

  elseif (this.szCurState == "STATE_CLOSE") then
    -- ************************************************************
    -- Closing State
    -- ************************************************************
  end

  -- store last update time
  this.iLastUpdateTime = iElapsedTime
end

 //-----------------------------------------------------------------
// Round One Preparation
//-----------------------------------------------------------------

TalentShow.Round1 = {}
TalentShow.Round2 = {}
TalentShow.Round3 = {}

TalentShow.IsDontSitTrick = function(szTrickName)

  if (szTrickName == "GivePaw") then
    return(true)
  end

  if (szTrickName == "Beg") then
    return(true)
  end

  if (szTrickName == "Nod") then
    return(true)
  end

  if (szTrickName == "Shake") then
    return(true)
  end

  return(false)
end

TalentShow.IsDontLieDownTrick = function(szTrickName)
  if (szTrickName == "RollOver") then
    return(true)
  end

  if (szTrickName == "Hide") then
    return(true)
  end

  return(false)
end

//-----------------------------------------------------------------
// Round One Preparation
//-----------------------------------------------------------------
TalentShow.Round1.Prepare = function()

     -- reset 'tricks to do' set for new round
     PetAI.TalentShow.tTricksToDo = {}

    -- determine number of tricks and round time limit
    if (TalentShow.iRank == 1)     then PetAI.TalentShow.iNumTricks = 2 PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.tCurRankInfo.iRound1Time
    elseif (TalentShow.iRank == 2) then PetAI.TalentShow.iNumTricks = 2 PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.tCurRankInfo.iRound1Time
    elseif (TalentShow.iRank == 3) then PetAI.TalentShow.iNumTricks = 3 PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.tCurRankInfo.iRound1Time
    elseif (TalentShow.iRank == 4) then PetAI.TalentShow.iNumTricks = 3 PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.tCurRankInfo.iRound1Time
    elseif (TalentShow.iRank == 5) then PetAI.TalentShow.iNumTricks = 3 PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.tCurRankInfo.iRound1Time
    elseif (TalentShow.iRank == 6) then PetAI.TalentShow.iNumTricks = 3 PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.tCurRankInfo.iRound1Time
    end

    -- grab list of currently-learned tricks
    local tLearnedTricks = PetAI.GetLearnedTrickSubset(PetAI.tAllTricks)

    -- remove Promenade from the list of tricks

    local i;
    local j;

    for i = 1, table.getn(tLearnedTricks) do
        if (tLearnedTricks[i] == "Promenade") then
            table.remove(tLearnedTricks,i)
        end
    end

    -- determine which tricks the pet needs to perform

    for i = 1, PetAI.TalentShow.iNumTricks do
      local iRand = math.random(table.getn(tLearnedTricks))
      local szTrick = tLearnedTricks[iRand] -- pick a random trick
      table.insert(PetAI.TalentShow.tTricksToDo,szTrick)
      table.remove(tLearnedTricks,iRand)

      -- if the chosen trick should not be followed by Sit, remove Sit from future choices

      if (TalentShow.IsDontSitTrick(szTrick) == true) then
        for j = 1,table.getn(tLearnedTricks) do
            if (tLearnedTricks[j] == "Sit") then
                table.remove(tLearnedTricks,j)
            end
        end

      -- if the chosen trick should not be followed by LieDown, remove LieDown from future choices

      else
        if (TalentShow.IsDontLieDownTrick(szTrick) == true) then
            for j = 1,table.getn(tLearnedTricks) do
                if (tLearnedTricks[j] == "LieDown") then
                    table.remove(tLearnedTricks,j)
                end
            end
        end
      end
    end

--    for i = 1,PetAI.TalentShow.iNumTricks do
--      local iRand = math.random(iCnt)
--      table.insert(PetAI.TalentShow.tTricksToDo,tLearnedTricks[iRand])
--      table.remove(tLearnedTricks,iRand)
--   end

    -- configure and load dialog box output message
    if (PetAI.TalentShow.iNumTricks == 2) then
      local szMsg = string.format(GetLanguageString("TS_TwoTricks"), GetLanguageString("TrickName_"..PetAI.TalentShow.tTricksToDo[1]), GetLanguageString("TrickName_"..PetAI.TalentShow.tTricksToDo[2]),PetAI.TalentShow.iTimeLimit)
      PetAI.TalentShow.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.TIMED_OUT,PetAI.TalentShow.iTimeLimit*1000,nil,PetAI.TalentShow.EnableTricks)
    elseif (PetAI.TalentShow.iNumTricks == 3) then
      local szMsg = string.format(GetLanguageString("TS_ThreeTricks"), GetLanguageString("TrickName_"..PetAI.TalentShow.tTricksToDo[1]), GetLanguageString("TrickName_"..PetAI.TalentShow.tTricksToDo[2]), GetLanguageString("TrickName_"..PetAI.TalentShow.tTricksToDo[3]),PetAI.TalentShow.iTimeLimit)
      PetAI.TalentShow.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.TIMED_OUT,PetAI.TalentShow.iTimeLimit*1000,nil,PetAI.TalentShow.EnableTricks)
    end

    -- initialize the sequence marker
    PetAI.TalentShow.iCurTrickSeqMarker = 1

    -- initialize the failure count
    PetAI.TalentShow.iNumFailures = 0

    -- initialize completion time
    PetAI.TalentShow.iCompletionTime = 0

    -- play round bkg music
    PetAI.tSoundFX.wavTSRound1Begin:Play()

    -- augment time limit for use in timing calculations
    PetAI.TalentShow.iTimeLimit = PetAI.TalentShow.iTimeLimit*1000

    PetAI.TalentShow.UpdateTimer(PetAI.TalentShow.iTimeLimit)
 end

//-----------------------------------------------------------------
// Round Two Preparation
//-----------------------------------------------------------------
TalentShow.Round2.Prepare = function()

    -- configure pet gender string
    local szPetGender = GetLanguageString("TS_Him")
    if (PetAI.szGender == "Female") then szPetGender = GetLanguageString("TS_Her") end

    -- reset staying flag
    PetAI.TalentShow.bIsWalkingAround = false

    -- set time limit
    PetAI.TalentShow.iTimeLimit = 10*1000

     -- play round bkg music
    PetAI.tSoundFX.wavTSRound2Begin:Play()

    -- load dialog box for second round
    local szMsg = string.format(GetLanguageString("TS_Round2"),PetAI.szName,szPetGender)
    PetAI.TalentShow.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.TIMED_OUT,PetAI.TalentShow.iTimeLimit,nil,PetAI.TalentShow.EnableTricks)

    PetAI.TalentShow.UpdateTimer(PetAI.TalentShow.iTimeLimit)
 end

//-----------------------------------------------------------------
// Round Three Preparation
//-----------------------------------------------------------------
TalentShow.Round3.Prepare = function()

    -- reset 'tricks performed' set for new round
    PetAI.TalentShow.tTricksPerformed = {}

    -- set time limit
    PetAI.TalentShow.iTimeLimit = 20*1000

    -- play round bkg music
    PetAI.tSoundFX.wavTSRound3Begin:Play()

    -- load dialog box for third round
    local szMsg = string.format(string.format(GetLanguageString("TS_Round3"),PetAI.szName))
    PetAI.TalentShow.AddNewMsg(szMsg,PetAI.TalentShow.MSG_TYPES.TIMED_OUT,PetAI.TalentShow.iTimeLimit,nil,PetAI.TalentShow.EnableTricks)

    PetAI.TalentShow.UpdateTimer(PetAI.TalentShow.iTimeLimit)
 end

//-----------------------------------------------------------------
// UpdateRound
//-----------------------------------------------------------------
TalentShow.UpdateRound = function(szUpdateInfo)
  if not (PetAI.TalentShow.szCurState == "STATE_DO_ROUND") then return end
  PetAI.TalentShow["Round"..PetAI.TalentShow.iCurRound].Update(szUpdateInfo)
end

//-----------------------------------------------------------------
// Round One Update
//-----------------------------------------------------------------
 TalentShow.Round1.Update = function(szTrickPerformed)

  local this = PetAI.TalentShow

  -- if the trick performance string is nil, time is up; check for success and close round
  if (szTrickPerformed == nil) and (this.iCurTrickSeqMarker <= table.getn(this.tTricksToDo)) then
    PetAI.tSoundFX.wavTSRound1Begin:Stop()
    PetAI.tSoundFX.wavTSRound1Fail:Play()

 elseif (this.iCurTrickSeqMarker > table.getn(this.tTricksToDo)) then

    PetAI.tSoundFX.wavTSRound1Begin:Stop()
    PetAI.tSoundFX.wavTSRound1End:Play()
    PetAI.TalentShow.RemoveFrontMsg()
    SetTalentTimer(0,0)   
    
  else

    -- if the performed trick is the next in the current sequence
    if (szTrickPerformed == this.tTricksToDo[this.iCurTrickSeqMarker]) then
      -- advance the marker
      this.iCurTrickSeqMarker = this.iCurTrickSeqMarker + 1

      -- play a congratulatory sound effect
      DoLuaEvent("PetAI.tSoundFX['wavTSClap0"..math.random(3).."']:Play()",ActivePetChannel)

    else
      -- otherwise, increment the failure count
      PetAI.TalentShow.iNumFailures = PetAI.TalentShow.iNumFailures + 1
    end

    if (this.iCurTrickSeqMarker > table.getn(this.tTricksToDo)) then
      if (table.getn(PetAI.TalentShow.MsgQueue) > 0) then PetAI.TalentShow.MsgQueue[1].iDuration = 0 end
      PetAI.TalentShow.iCompletionTime = math.floor(30000 - this.MsgQueue[1].iDuration)
    end

  end
end

//-----------------------------------------------------------------
// Round Two Update
//-----------------------------------------------------------------
 TalentShow.Round2.Update = function(szTrickPerformed)

  -- if a nil event is sent, time is up; if round successful, play appropriate sfx
  if (szTrickPerformed == "Promenade") then
    -- if the pet is currently performing a 'Promenade Trick' trick, set success
    PetAI.TalentShow.bIsWalkingAround = true
    if (table.getn(PetAI.TalentShow.MsgQueue) > 0) then PetAI.TalentShow.MsgQueue[1].iDuration = 0 end 
  elseif (szTrickPerformed == nil) and not (PetAI.TalentShow.bIsWalkingAround) then
    PetAI.tSoundFX.wavTSRound2Begin:Stop()
    PetAI.tSoundFX.wavTSFail:Play()
  elseif (szTrickPerformed == nil) and (PetAI.TalentShow.bIsWalkingAround) then
    -- otherwise, if time is up and round is not successful, play appropriate sfx
    PetAI.tSoundFX.wavTSRound2Begin:Stop()
    PetAI.tSoundFX.wavTSApplause:Play()
  end
 end

//-----------------------------------------------------------------
// Round Three Update
//-----------------------------------------------------------------
TalentShow.Round3.Update = function(szTrickPerformed)

  local this = PetAI.TalentShow

  -- if a nil event is sent, time is up; play appropriate sfx
  if (szTrickPerformed == nil) then
    PetAI.tSoundFX.wavTSRound3Begin:Stop()
  -- otherwise, if the performed trick is an acceptable or secret trick...
  elseif (not (this.FindInTable(PetAI.tAllTricks,szTrickPerformed) == 0)) or (not (this.FindInTable(PetAI.tSecretTricks,szTrickPerformed) == 0)) then

    -- if the trick hasn't already been performed...
    if (PetAI.TalentShow.FindInTable(PetAI.TalentShow.tTricksPerformed,szTrickPerformed) == 0) then

      -- store the trick in the table of performed tricks
      table.insert(PetAI.TalentShow.tTricksPerformed,szTrickPerformed)

      -- play appropriate sfx if trick is normal or secret
      if not (this.FindInTable(PetAI.tAllTricks,szTrickPerformed) == 0) then DoLuaEvent("PetAI.tSoundFX['wavTSClap0"..math.random(3).."']:Play()",ActivePetChannel)
      elseif not (this.FindInTable(PetAI.tSecretTricks,szTrickPerformed) == 0) then DoLuaEvent("PetAI.tSoundFX.wavTSWow:Play()",ActivePetChannel) end
    end
  end
end

//-----------------------------------------------------------------
// Round One Score
//-----------------------------------------------------------------
TalentShow.Round1.Score = function()

  local this = PetAI.TalentShow

  -- calculate earned points
  this.iRound1Points = 0

  -- if trick sequence was successfully completed
  if (this.iCurTrickSeqMarker > table.getn(this.tTricksToDo)) then

    local iTimePoints = 0
    local iFailurePoints = 0
    local iDiffBonusPoints = 0

    -- calculate points to award based on completion time
    if (this.iCompletionTime > 0 and this.iCompletionTime <= 10) then iTimePoints = 5
    elseif (this.iCompletionTime > 10 and this.iCompletionTime <= 20) then iTimePoints = 4
    elseif (this.iCompletionTime > 20) then iTimePoints = 3 end

    if (this.szDiffSetting == "Medium") then iDiffBonusPoints = (table.getn(this.tTricksToDo))*2
    elseif (this.szDiffSetting == "Hard") then iDiffBonusPoints = (table.getn(this.tTricksToDo))*3
    else iDiffBonusPoints = 0 end

    -- calculate points to award based on number of failed attempts
    if (this.iNumFailures == 0) then iFailurePoints = 5
    elseif (this.iNumFailures == 1) then iFailurePoints = 4
    elseif (this.iNumFailures == 2) then iFailurePoints = 3
    elseif (this.iNumFailures > 2) then iFailurePoints = 0 end

    -- calculate final point total
    this.iRound1Points = iTimePoints + iFailurePoints + iDiffBonusPoints
  end

  -- determine sound file to play based on points
  local szSoundFile = "ts_applause.wav"
  if (this.iRound1Points == 0) then szSoundFile = "ts_fail.wav" end

  -- report earned points to the user
  PetAI.TalentShow.AddNewMsg(string.format(GetLanguageString("TS_ScoreRound1"),this.iRound1Points),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,szSoundFile,PetAI.TalentShow.DisableTricks)

  -- update total
  PetAI.TalentShow.iCurTotal = PetAI.TalentShow.iCurTotal + this.iRound1Points
end

//-----------------------------------------------------------------
// Round Two Score
//-----------------------------------------------------------------
TalentShow.Round2.Score = function()

  local this = PetAI.TalentShow

  -- calculate earned points
  this.iRound2Points = 0

  -- calculate points to award for pet's grooming
  local fGroomingPercent = PetAI.tNeeds.tGrooming.iCurValue/PetAI.tNeeds.tGrooming.iMaxValue
  local iGroomingPoints = math.ceil(5*fGroomingPercent)

  -- calculate points to award for pet's walking around
  local iPromenadePoints = 0
  if (PetAI.TalentShow.bIsWalkingAround) then iPromenadePoints = 5 end

  local iCostumePoints = 0

  -- determine accessory points
  iCostumePoints = PetAI.GetPetAccessoryPoints()*2

  -- calculate point total
  this.iRound2Points = iGroomingPoints + iPromenadePoints + iCostumePoints

  -- determine sound file to play based on points
  local szSoundFile = "ts_applause.wav"
  if (this.iRound2Points == 0) then szSoundFile = "ts_fail.wav" end

  -- report earned points to the user
  PetAI.TalentShow.AddNewMsg(string.format(GetLanguageString("TS_ScoreRound2"),PetAI.szName,this.iRound2Points),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,szSoundFile,PetAI.TalentShow.DisableTricks)

  -- update total
  PetAI.TalentShow.iCurTotal = PetAI.TalentShow.iCurTotal + this.iRound2Points

  -- determine sound file to play based on total points
  szSoundFile = "ts_applause.wav"
  if (this.iCurTotal == 0) then szSoundFile = "ts_fail.wav" end

  -- load total info dialog box
  PetAI.TalentShow.AddNewMsg(string.format(GetLanguageString("TS_TotalRound2"),PetAI.TalentShow.iCurTotal),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,szSoundFile)
end

//-----------------------------------------------------------------
// Round Three Score
//-----------------------------------------------------------------
TalentShow.Round3.Score = function()

  local this = PetAI.TalentShow

  -- calculate earned points
  this.iRound3Points = 0

  local iNumNormalTricks = 0
  local iNumSecretTricks = 0
  local iNumTotalTricks = 0
  local iTrickPoints = 0
  local iSecretTrickPoints = 0

  for i = 1,table.getn(PetAI.TalentShow.tTricksPerformed) do
    if not (PetAI.TalentShow.FindInTable(PetAI.tAllTricks,PetAI.TalentShow.tTricksPerformed[i]) == 0) then iNumNormalTricks = iNumNormalTricks + 1
    elseif not (PetAI.TalentShow.FindInTable(PetAI.tSecretTricks,PetAI.TalentShow.tTricksPerformed[i]) == 0) then iNumSecretTricks = iNumSecretTricks + 1 end
  end

  iNumTotalTricks = iNumNormalTricks + iNumSecretTricks

  if (iNumTotalTricks >= 5) then iTrickPoints = 10
  elseif (iNumTotalTricks == 4) then iTrickPoints = 7
  elseif (iNumTotalTricks == 3) then iTrickPoints = 5
  elseif (iNumTotalTricks == 2) then iTrickPoints = 3
  elseif (iNumTotalTricks == 1) then iTrickPoints = 2 end

  iSecretTrickPoints = iNumSecretTricks*3

  this.iRound3Points = iTrickPoints + iSecretTrickPoints

  -- determine sound file to play based on points
  local szSoundFile = "ts_applause.wav"
  if (this.iRound3Points == 0) then szSoundFile = "ts_fail.wav" end

  -- report earned points to the user
  PetAI.TalentShow.AddNewMsg(string.format(GetLanguageString("TS_ScoreRound3"),PetAI.szName,this.iRound3Points),PetAI.TalentShow.MSG_TYPES.USER_CONTROL,3000,szSoundFile,PetAI.TalentShow.DisableTricks)

  -- update total
  PetAI.TalentShow.iCurTotal = PetAI.TalentShow.iCurTotal + this.iRound3Points
end

return(TalentShow)