local tTrickOfTheDayFunc = {}

//-----------------------------------------------------------------
// Helper Functions
//-----------------------------------------------------------------

tTrickOfTheDayFunc.tEasyTricks = {"Promenade","Sit","LieDown","Speak","GivePaw","Beg","RollOver","Hide"}
tTrickOfTheDayFunc.tHardTricks = {"NodHead","ShakeHead","Jump","StandOnHindLegs"}
tTrickOfTheDayFunc.tAllTricks = {"Promenade","Sit","LieDown","Speak","GivePaw","Beg","RollOver","Hide","NodHead","ShakeHead","Jump","StandOnHindLegs"}

tTrickOfTheDayFunc.IsEasyTrick = function(szTrickName)
  local tTricks = PetAI.tTrickOfTheDayFunc.tEasyTricks
  for i in ipairs(tTricks) do if (tTricks[i] == szTrickName) then return(true) end end
  return(false)
end

tTrickOfTheDayFunc.IsHardTrick = function(szTrickName)
  local tTricks = PetAI.tTrickOfTheDayFunc.tHardTricks
  for i in ipairs(tTricks) do if (tTricks[i] == szTrickName) then return(true) end end
  return(false)
end

tTrickOfTheDayFunc.GetLearnedTrickSubset = function(tTrickSet)
  local tLearnedTricks = {}
  for i in ipairs(tTrickSet) do
    if (PetAI.tVoiceCommands[tTrickSet[i]].bActive) then
      table.insert(tLearnedTricks,tTrickSet[i])
    end
  end
  return(tLearnedTricks)
end

tTrickOfTheDayFunc.GetOwnedFetchableToySubset = function()
  local tToys = {}
  for i = 1,6 do if (not (player.m_tInventory["ball_0"..i] == nil)) and (player.m_tInventory["ball_0"..i] > 0) then table.insert(tToys,"ball_0"..i) end end
  for i = 1,4 do if (not (player.m_tInventory["flyingdisc_0"..i] == nil)) and (player.m_tInventory["flyingdisc_0"..i] > 0) then table.insert(tToys,"flyingdisc_0"..i) end end
  return(tToys)
end

//-----------------------------------------------------------------
// PreconditionChecking
//-----------------------------------------------------------------

--****************************************************************
-- CheckPrecondition
--****************************************************************
tTrickOfTheDayFunc.PreconditionChecks = {

  TOD_OneEasyTrick = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tEasyTricks)) > 0)
  end,

  TOD_OneHardTrick = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tHardTricks)) > 0)
  end,

  TOD_TwoTricks = function()
    local iNumEasyTricks = table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tEasyTricks))
    local iNumHardTricks = table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tHardTricks))
    return(iNumEasyTricks + iNumHardTricks > 1)
  end,

  TOD_ThreeTricks = function()
    local iNumEasyTricks = table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tEasyTricks))
    local iNumHardTricks = table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tHardTricks))
    return(iNumEasyTricks + iNumHardTricks > 2)
  end,

  TOD_OneFetch = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetOwnedFetchableToySubset()) > 0)
  end,

  TOD_TwoFetches = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetOwnedFetchableToySubset()) > 1)
  end,

  TOD_ThreeFetches = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetOwnedFetchableToySubset()) > 2)
  end,

  TOD_EasyTrickPhoto = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tEasyTricks)) > 0)
  end,

  TOD_HardTrickPhoto = function()
    return(table.getn(PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tHardTricks)) > 0)
  end,

  TOD_BeautyPhoto = function()
    return(true)
  end,

  TOD_CutePhoto = function()
    return(true)
  end
}

//-----------------------------------------------------------------
// CreateTrickOfTheDay
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTrickOfTheDay()

    -- create base trick of the day table
    local tTrickOfTheDay = {}

  -- trick reward value
  tTrickOfTheDay.iReward = 0

    -- trick display text
    tTrickOfTheDay.szText = ""

    -- update processing function
    tTrickOfTheDay.ProcessUpdate = nil

    -- completion checking function
  tTrickOfTheDay.IsFinished = function() return(true) end

    -- delay TOD checking function
    tTrickOfTheDay.IsDelayTOD = function() return(tTrickOfTheDay.iReward == 0) end

    -- return the resulting trick of the day table instance
    return(tTrickOfTheDay)
end

//-----------------------------------------------------------------
// CreateTrickBasedTOD
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTrickBasedTOD(tTrickSet,iNumTricks)

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  tTrick.tTricksToDo = {}

  -- make a copy of the given trick set
  local tTrickSetCopy = {}
  for i in ipairs(tTrickSet) do table.insert(tTrickSetCopy,tTrickSet[i]) end

  -- create a random table of tricks to do based on specified set, number
  for i = 1, iNumTricks do
    local iRandTrickNum = math.random(table.getn(tTrickSetCopy))
    local szRandTrickName = tTrickSetCopy[iRandTrickNum]
    table.insert(tTrick.tTricksToDo,szRandTrickName)

    -- remove the selected trick from the set copy to avoid repeats
    table.remove(tTrickSetCopy,iRandTrickNum)
  end

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText,szTrickName)

    -- if no trick name is specified, return immediately
    if (szTrickName == nil) then return end

    if (szUpdateText == "PerformedTrick") then
      for i in ipairs(tTrick.tTricksToDo) do
        if (szTrickName == tTrick.tTricksToDo[i]) then
            table.remove(tTrick.tTricksToDo,i)
            return
        end
      end
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function() return(table.getn(tTrick.tTricksToDo) == 0) end

  -- return configured trick-based TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_OneEasyTrick
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_OneEasyTrick()

  -- compile a table of the pet's currently-learned easy tricks
  local tLearnedEasyTricks = PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tEasyTricks)

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickBasedTOD(tLearnedEasyTricks,1)

  -- set unique trick parameters
  local szTrickName = GetLanguageString("TrickName_"..tTrick.tTricksToDo[1])
  tTrick.szText = string.format(GetLanguageString("TOD_OneEasyTrick"),string.upper(szTrickName),TODPrize_OneEasyTrick)
  tTrick.iReward = TODPrize_OneEasyTrick

  -- return configured trick table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_OneHardTrick
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_OneHardTrick()

  -- compile a table of the pet's currently-learned easy tricks
  local tLearnedHardTricks = PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tHardTricks)

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickBasedTOD(tLearnedHardTricks,1)

  -- set unique trick parameters
  local szTrickName = GetLanguageString("TrickName_"..tTrick.tTricksToDo[1])
  tTrick.szText = string.format(GetLanguageString("TOD_OneHardTrick"),string.upper(szTrickName),TODPrize_OneHardTrick)
  tTrick.iReward = TODPrize_OneHardTrick

  -- return configured trick table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_TwoTricks
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_TwoTricks()

  -- compile a table of the pet's currently-learned easy tricks
  local tLearnedTricks = PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tAllTricks)

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickBasedTOD(tLearnedTricks,2)

  -- set unique trick parameters
  local szTrickOneName = GetLanguageString("TrickName_"..tTrick.tTricksToDo[1])
  local szTrickTwoName = GetLanguageString("TrickName_"..tTrick.tTricksToDo[2])
  tTrick.szText = string.format(GetLanguageString("TOD_TwoTricks"),string.upper(szTrickOneName),string.upper(szTrickTwoName),TODPrize_TwoTricks)
  tTrick.iReward = TODPrize_TwoTricks

  -- return configured trick table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_ThreeTricks
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_ThreeTricks()

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- initialize core trick parameters
  tTrick.iNumTricksToDo = 3
  tTrick.iStartTime = 0
  tTrick.tPerformedTricks = {}

  -- set unique trick parameters
  tTrick.szText = string.format(GetLanguageString("TOD_ThreeTricks"),TODPrize_ThreeTricks)
  tTrick.iReward = TODPrize_ThreeTricks

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText,szTrickName)
    if (szTrickName == nil) then return
    elseif (szUpdateText == "PerformedTrick") then

      -- check for treat repetition, returning immediately if found
      for i in ipairs(tTrick.tPerformedTricks) do
        if (szTrickName == tTrick.tPerformedTricks[i]) then return end
      end

      if (tTrick.iNumTricksToDo == 3) then tTrick.iStartTime = FoxGetTickCount() end
      tTrick.iNumTricksToDo = tTrick.iNumTricksToDo - 1
      table.insert(tTrick.tPerformedTricks,szTrickName)
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    if (tTrick.iNumTricksToDo == 0) and (FoxGetTickCount() - tTrick.iStartTime < 60000) then
      return(true)
    elseif (FoxGetTickCount() - tTrick.iStartTime > 60000) then
      tTrick.iNumTricksToDo = 3
      tTrick.iStartTime = 0
      tTrick.tPerformedTricks = {}
    end
    return(false)
  end

  -- return configured trick-based TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateFetchBasedTOD
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateFetchBasedTOD(tToySet,iNumFetches)

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  tTrick.tToysToFetch = {}

  -- make a copy of the given toy set
  local tToySetCopy = {}
  for i in ipairs(tToySet) do table.insert(tToySetCopy,tToySet[i]) end

  -- create a random table of toys to fetch based on specified set, number
  for i = 1, iNumFetches do
    local iRandToyNum = math.random(table.getn(tToySetCopy))
    local szRandToyName = tToySetCopy[iRandToyNum]
    table.insert(tTrick.tToysToFetch,szRandToyName)

    -- remove the selected toy from the set copy to avoid repeats
    table.remove(tToySetCopy,iRandToyNum)
  end

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText,szToyName)

    -- if no trick name is specified, return immediately
    if (szToyName == nil) then return end

    if (szUpdateText == "PerformedFetch") then
      for i in ipairs(tTrick.tToysToFetch) do
        if (szToyName == tTrick.tToysToFetch[i]) then
            table.remove(tTrick.tToysToFetch,i)
            return
        end
      end
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function() return(table.getn(tTrick.tToysToFetch) == 0) end

  -- return configured fetch-based TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_OneFetch
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_OneFetch()

  -- compile a table of the pet's currently-learned easy tricks
  local tOwnedFetchableToys = PetAI.tTrickOfTheDayFunc.GetOwnedFetchableToySubset()

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateFetchBasedTOD(tOwnedFetchableToys,1)

  -- set unique trick parameters
  local szToyName = string.gsub(GetLanguageString(tTrick.tToysToFetch[1]), '\n', ' ', 99)
  tTrick.szText = string.format(GetLanguageString("TOD_OneFetch"),szToyName,TODPrize_OneFetch)
  tTrick.iReward = TODPrize_OneFetch

  -- return configured trick table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_TwoFetches
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_TwoFetches()

  -- compile a table of the pet's currently-learned easy tricks
  local tOwnedFetchableToys = PetAI.tTrickOfTheDayFunc.GetOwnedFetchableToySubset()

    -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateFetchBasedTOD(tOwnedFetchableToys,2)

  -- set unique trick parameters
  local szToyOneName = string.gsub(GetLanguageString(tTrick.tToysToFetch[1]), '\n', ' ', 99)
  local szToyTwoName = string.gsub(GetLanguageString(tTrick.tToysToFetch[2]), '\n', ' ', 99)
  tTrick.szText = string.format(GetLanguageString("TOD_TwoFetches"),szToyOneName,szToyTwoName,TODPrize_TwoFetches)
  tTrick.iReward = TODPrize_TwoFetches

  -- return configured trick table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_ThreeFetches
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_ThreeFetches()

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- initialize core trick parameters
  tTrick.iNumFetchesToDo = 3
  tTrick.iStartTime = 0
  tTrick.tFetchedToys = {}

  -- set unique trick parameters
  tTrick.szText = string.format(GetLanguageString("TOD_ThreeFetches"),TODPrize_ThreeFetches)
  tTrick.iReward = TODPrize_ThreeFetches

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText,szToyName)
    if (szToyName == nil) then return
    elseif (szUpdateText == "PerformedFetch") then

      -- check for treat repetition, returning immediately if found
      for i in ipairs(tTrick.tFetchedToys) do
        if (szTrickName == tTrick.tFetchedToys[i]) then return end
      end

      if (tTrick.iNumFetchesToDo == 3) then tTrick.iStartTime = FoxGetTickCount() end
      tTrick.iNumFetchesToDo = tTrick.iNumFetchesToDo - 1
      table.insert(tTrick.tFetchedToys,szToyName)
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    if (tTrick.iNumFetchesToDo == 0) and (FoxGetTickCount() - tTrick.iStartTime < 60000) then
      return(true)
    elseif (FoxGetTickCount() - tTrick.iStartTime > 60000) then
      tTrick.iNumFetchesToDo = 3
      tTrick.iStartTime = 0
      tTrick.tFetchedToys = {}
    end
    return(false)
  end

  -- return configured trick-based TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_EasyTrickPhoto
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_EasyTrickPhoto()

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- randomly-select an easy trick for the player to photograph
  local tLearnedEasyTricks = PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tEasyTricks)
  tTrick.szTrickToPhoto = tLearnedEasyTricks[math.random(table.getn(tLearnedEasyTricks))]

  -- set unique trick parameters
  local szTrickName = GetLanguageString("TrickName_"..tTrick.szTrickToPhoto)
  tTrick.szText = string.format(GetLanguageString("TOD_EasyTrickPhoto"),szTrickName,TODPrize_EasyTrickPhoto)
  tTrick.iReward = TODPrize_EasyTrickPhoto
  tTrick.bFinished = false

  -- use the 'submit' button in the photo interface
  g_bSubmitPhoto = true

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText)
    if (szUpdateText == "TakenPhoto") then
      if ((PetAI.tCurAction != nil) and (PetAI.tCurAction.szName == tTrick.szTrickToPhoto)) then
        g_bSubmitPhoto = false
        tTrick.bFinished = true
      end
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    return(tTrick.bFinished)
  end

  -- return configured balance TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_HardTrickPhoto
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_HardTrickPhoto()

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- randomly-select a hard trick for the player to photograph
  local tLearnedHardTricks = PetAI.tTrickOfTheDayFunc.GetLearnedTrickSubset(PetAI.tTrickOfTheDayFunc.tHardTricks)
  tTrick.szTrickToPhoto = tLearnedHardTricks[math.random(table.getn(tLearnedHardTricks))]

  -- set unique trick parameters
  local szTrickName = GetLanguageString("TrickName_"..tTrick.szTrickToPhoto)
  tTrick.szText = string.format(GetLanguageString("TOD_HardTrickPhoto"),szTrickName,TODPrize_HardTrickPhoto)
  tTrick.iReward = TODPrize_HardTrickPhoto
  tTrick.bFinished = false

  -- use the 'submit' button in the photo interface
  g_bSubmitPhoto = true

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText)
    if (szUpdateText == "TakenPhoto") then
      if ((PetAI.tCurAction != nil) and (PetAI.tCurAction.szName == tTrick.szTrickToPhoto)) then
        g_bSubmitPhoto = false
        tTrick.bFinished = true
      end
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    return(tTrick.bFinished)
  end

  -- return configured balance TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_BeautyPhoto
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_BeautyPhoto()

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- set unique trick parameters
  tTrick.szText = GetLanguageString("TOD_BeautyPhoto")
  tTrick.iReward = TODPrize_BeautyPhoto
  tTrick.bFinished = false

  -- use the 'submit' button in the photo interface
  g_bSubmitPhoto = true

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText)
    if (szUpdateText == "TakenPhoto") then

        -- determine costume point value
        local iCostumePoints = PetAI.GetPetAccessoryPoints()

        -- determine photo award
        tTrick.iReward = math.ceil(PetAI.tNeeds.tGrooming.iCurValue/5) + math.ceil(iCostumePoints*2)

        -- maintain minimum reward value
        if (tTrick.iReward < TODPrize_BeautyPhoto) then tTrick.iReward = TODPrize_BeautyPhoto end

        g_bSubmitPhoto = false
        tTrick.bFinished = TRUE
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    return(tTrick.bFinished)
  end

  -- return configured balance TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_CutePhoto
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_CutePhoto()

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- set unique trick parameters
  tTrick.szText = GetLanguageString("TOD_CutePhoto")
  tTrick.iReward = TODPrize_CutePhoto
  tTrick.bFinished = false

  -- use the 'submit' button in the photo interface
  g_bSubmitPhoto = true

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText)
    if (szUpdateText == "TakenPhoto") then

        -- determine if current pose is relevant
        local iPoseBonus = 0
        if (PetAI.tCurAction != nil) and (PetAI.IsEasyTrick(PetAI.tCurAction.szName)) then iPoseBonus = 15
        elseif (PetAI.tCurAction != nil) and (PetAI.IsHardTrick(PetAI.tCurAction.szName)) then iPoseBonus = 30 end

        -- determine costume point value
        local iCostumePoints = PetAI.GetPetAccessoryPoints()

        -- determine photo award
        tTrick.iReward = iPoseBonus + math.ceil(PetAI.tNeeds.tGrooming.iCurValue/5) + math.ceil(iCostumePoints*2)

        -- maintain minimum reward value
        if (tTrick.iReward < TODPrize_CutePhoto) then tTrick.iReward = TODPrize_CutePhoto end

        g_bSubmitPhoto = false
        tTrick.bFinished = TRUE
        -- TODO: Calculate reward given grooming, accessories, pose
    end
  end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    return(tTrick.bFinished)
  end

  -- return configured balance TOD table
  return(tTrick)
end

//-----------------------------------------------------------------
// CreateTOD_None
//-----------------------------------------------------------------
function tTrickOfTheDayFunc.CreateTOD_None(iTimeToDelay)

  -- retrieve base trick of the day event table
  local tTrick = PetAI.tTrickOfTheDayFunc.CreateTrickOfTheDay()

  -- set unique trick parameters
  tTrick.szText = string.format(GetLanguageString("TOD_None"))
  tTrick.iReward = 0
  tTrick.iStartTime = FoxGetTickCount()
  tTrick.iWaitTime = iTimeToDelay

  --****************************************************************
    -- ProcessUpdate
  --****************************************************************
  tTrick.ProcessUpdate = function(szUpdateText) return end

  --****************************************************************
    -- IsFinished
  --****************************************************************
  tTrick.IsFinished = function()
    return(FoxGetTickCount() - tTrick.iStartTime > tTrick.iWaitTime)
  end

  -- return configured balance TOD table
  return(tTrick)
end

return(tTrickOfTheDayFunc)