-- charset=utf-8

language = {}

function GetLanguageString(s)

    if (language[gLanguage] != nil) then
        if (language[gLanguage][s] != nil) then
            return(language[gLanguage][s])
        else
            -- String did not exist as is, try prepending "Dogz_", or "Catz_"
            --
            s = fox.app.GetAppName().."_"..s

            if (language[gLanguage][s] != nil) then
                return(language[gLanguage][s])
            else
                return("Undefined String")
            end
        end
    else
        return("Undefined Language")
    end
end


language.English = {
    YouWin="You win!",
    YouLose="You lose!",
    Round="Round %d",
    BonusUnlocked="Bonus unlocked!",
    GotoMainMenu="Are you sure you want to go to the main menu?",
    Paused="Paused",
    Pause="Paused",
    Loading="Loading",
    Uninstall="Uninstall",

    SettingTitle="Settings",
    SettingsVolume="Volume",
    SettingsVideo="Video",
    SettingsAntiAliasing="Smoother Lines",

    Tip_01="Click on the screen to call your new pet.",
    Tip_02="Your pet is hungry. There is food in your suitcase.",
    Tip_03="Your pet is thirsty. There is water in your suitcase.",
    Tip_04="Your pet needs a bath. Shampoo is available in the Petz Store.",
    Tip_05="Your pet is tired. Time to give it a rest.",
    Tip_06="Your pet needs love. Try petting it for a while.",
    Tip_07="This is the Petz Store. Buy all your pet needs here.",
    Tip_08="This is your suitcase. Things you buy are kept here.",
    Tip_09="Reward your pet by giving it a treat.",
    Tip_10="Scold your pet by squirting it with water.",
    Tip_11="Use these buttons to give your pet commands.",
    Tip_12="This box shows how your pet is feeling now.",
    Tip_13="Press the mouse button and rub your pet. It loves attention!",
    Tip_14="Press the mouse button and push down on your pet to make it sit.",
    Tip_15="You made your pet walk around. Press the blue button to say WALK AROUND!",
    Tip_16="You made your pet sit down. Press the blue button to say SIT!",
    Tip_17="You made your pet lie down. Press the blue button to say LIE DOWN!",
    Tip_18="You made your pet speak. Press the blue button to say SPEAK!",
    Tip_19="You made your pet offer its paw. Press the blue button to say PAW!",
    Tip_20="You made your pet beg. Press the blue button to say BEG!",
    Tip_21="You made your pet roll over. Press the blue button to say ROLL OVER!",
    Tip_22="You made your pet hide its face. Press the blue button to say HIDE!",
    Tip_23="You made your pet nod its head. Press the blue button to say NOD!",
    Tip_24="You made your pet shake its head. Press the blue button to say SHAKE!",
    Tip_25="You made your pet jump up. Press the blue button to say JUMP!",
    Tip_26="You made your pet stand up high. Press the blue button to say STAND HIGH!",
    Tip_27="Push down on your pet a few times to make it lie down.",
    Tip_28="Keep showing your pet how to %s until it learns the trick.",
    Tip_29="A treat will help your pet learn what %s means.",

    Tip_31="Try saying %s again, and treat your pet when it obeys.",
    Tip_32="Your pet is more likely to obey if you feed it.",
    Tip_33="Your pet is more likely to obey if you water it.",
    Tip_34="Your pet is more likely to obey if you pet it.",
    Tip_35="Your pet is more likely to obey if you clean it.",
    Tip_36="Your pet is more likely to obey if you let it rest.",
    Tip_37="Your pet is more likely to obey if you play with it.",
    Tip_38="Your pet tried hard to %s. A treat may help it do better next time.",
    Tip_39="Your pet will not understand you if you speak too quickly.",
    Tip_40="Your pet may forget how to %s if you scold it!",
    Tip_41="Your pet has forgotten the %s trick.",
    Tip_42="Do you want to go to the kitchen to feed your pet?",
    Tip_43="Do you want to go to the kitchen to water your pet?",
    Tip_44="Do you want to go to the bathtub to wash your pet?",

    Tip_45="Your pet has learned what WALK AROUND means!",
    Tip_46="Your pet has learned what SIT means!",
    Tip_47="Your pet has learned what LIE DOWN means!",
    Tip_48="Your pet has learned what SPEAK means!",
    Tip_49="Your pet has learned what PAW means!",
    Tip_50="Your pet has learned what BEG means!",
    Tip_51="Your pet has learned what ROLL OVER means!",
    Tip_52="Your pet has learned what HIDE means!",
    Tip_53="Your pet has learned what NOD means!",
    Tip_54="Your pet has learned what SHAKE means!",
    Tip_55="Your pet has learned what JUMP means!",
    Tip_56="Your pet has learned what STAND HIGH means!",

    Tip_57="Do you want to go to the back yard to play with your pet?",

    Tip_58="To throw a toy, swipe the cursor and push the mouse button.",

    Tip_59="Your pet must know 4 tricks, including WALK AROUND, to enter the Level 1 Talent Show.",
    Tip_60="Your pet must know 8 tricks to enter the Level 2 Talent Show.",
    Tip_61="Your pet must know 12 tricks to enter the Level 3 Talent Show.",

    DogDesc_Beagle="These hunting dogs are bundles of energy. Beagles are very loving, but also very independent, so it takes patience to train them. Short hair makes them easy to groom. Careful! These little pranksters will scratch up anything they can.",
    DogDesc_Collie="These intelligent dogs are a pleasure to train. Border Collies are loving and obedient companions. However, their long hair requires more attention than other breeds.",
    DogDesc_Shepherd="Shepherds are loyal pets. Their capacity for love is nearly boundless.\nThey are also very adept learners. Their long fur is tricky to manage, though, and they bark more than other breeds.",
    DogDesc_Retriever="These little puppies love to play. They are bright and quick, friendly and loving. Labs are fast learners, but may have trouble paying attention. They also need more water than other breeds, as they tend to slobber.",
    DogDesc_Pug="These puppies are little jokers. They love to play, and they're very loving. Training a pug is tricky, but they love the attention, so you won't mind. Show them all the love you've got and they'll love you right back. Short hair makes grooming a breeze.",

    CatDesc_Abyssinian="This intelligent, independent cat loves high places. It will jump on anything it can. Abyssinians also have much more energy than other breeds. They can play for hours at a time. Their sleek coats don't require much attention.",
    CatDesc_Bengal="This bright cat is easy to train and nearly trouble-free, perfect for new pet owners. The Bengal needs more food and water than other breeds.",
    CatDesc_Burmese="These intelligent, obedient cats stick close by their owners. Burmese also have a tendency to scratch anything that comes their way. Be firm!",
    CatDesc_MaineCoon="These big cats are very smart and surprisingly quick. Maine Coons learn new tricks easily, but they need more food, rest and grooming than other breeds.",
    CatDesc_Siamese="Sleek and agile, Siamese are the elite of the feline world. They love attention, but they prefer to take care of themselves. They are also extremely vocal. If you like meowing, this is the cat for you!",

    foodcan_04 = "Economy pet food",
    foodcan_03 = "Flavored pet food",
    foodcan_02 = "Organic pet food",
    foodcan_01 = "Deluxe pet food",
    foodbag_04 = "Economy pet chow",
    foodbag_03 = "Flavored pet chow",
    foodbag_02 = "Organic pet chow",
    foodbag_01 = "Deluxe pet chow",
    waterbottle_01 = "Economy water",
    waterbottle_04 = "Vitamin water",
    waterbottle_03 = "Organic water",
    waterbottle_02 = "Deluxe water",
    shampoo_03 = "Economy shampoo",
    shampoo_01 = "Organic shampoo",
    shampoo_02 = "Luxury shampoo",

    foodcan_04x = "Economy pet food\n(3 cans)",
    foodcan_03x = "Flavored pet food\n(3 cans)",
    foodcan_02x = "Organic pet food\n(3 cans)",

    foodbag_04x = "Economy pet chow\n(3 bags)",
    foodbag_03x = "Flavored pet chow\n(3 bags)",
    foodbag_02x = "Organic pet chow\n(3 bags)",

    waterbottle_01x = "Economy water\n(3 bottles)",
    waterbottle_04x = "Vitamin water\n(3 bottles)",
    waterbottle_03x = "Organic water\n(3 bottles)",

    shampoo_03x = "Economy shampoo\n(3 bottles)",
    shampoo_01x = "Organic shampoo\n(3 bottles)",

    treats_03x = "Economy treats\n(3 cans)",
    treats_01x = "Organic treats\n(3 cans)",

    brush_01 = "Wooden pet brush",
    brush_02 = "Cobalt blue\npet brush",
    brush_03 = "Sterling silver\npet brush",
    brush_04 = "Luxury gold\npet brush",
    treats_03 = "Economy treat",
    treats_01 = "Organic treat",
    treats_02 = "Gourmet treat",

    bandanacollar_01 = "Bright red\nbandana",
    collar_01 = "Brown leather\ncollar",
    collar_02 = "Black leather\ncollar",
    collar_03 = "White leather\ncollar",
    collar_04 = "Blue suede\ncollar",
    collar_05 = "Green suede\ncollar",
    collar_06 = "Red suede\ncollar",
    collar_07 = "Reptile skin\ncollar",
    collar_08 = "Royal jeweled\ncollar",
    floralcollar_01= "Blue flower\ncollar",
    floralcollar_02= "Pink flower\ncollar",
    floralcollar_03= "Dark flower\ncollar",
    chaincollar_01 = "Silver chain\ncollar",
    chaincollar_02 = "Gold chain\ncollar",
    chaincollar_03 = "Steel chain\ncollar",
    gmcollar_01 = "Gold medal\ncollar",

    booties_01 = "Athletic booties",
    booties_03 = "White leather\nbooties",
    booties_02 = "Steel-toe booties",
    pombooties_01 = "Holiday pom-pom\nbooties",
    pombooties_03 = "Ballet pom-pom\nbooties",
    pombooties_02 = "Leopard pom-pom\nbooties",
    baseballhat_01 = "Baseball cap",
    beeniehat_01 = "Propeller beanie",
    sombrerohat_01 = "Sombrero",
    cowboyhat_01 = "Cowboy hat",
    jesterhat_01 = "Jester cap",
    piratehat_01 = "Pirate hat",
    princesshat_01 = "Princess hat",
    wizardhat_01 = "Wizard hat",
    tiarahat_01 = "Royal tiara\ncrown",
    vikinghat_01 = "Viking hat",
    mohawkhat_01 = "Green Mohawk",
    tailpom_01 = "Pink tail\npom-pom",
    tailpom_02 = "Red tail\npom-pom",
    tailpom_03 = "Blue tail\npom-pom",
    tailpom_04 = "Leopard tail\npom-pom",
    tailpom_05 = "White tail\npom-pom",
    tailpom_06 = "Sparkly tail\npom-pom",

    livingroom_01="Standard living\nroom for\nfirst-time buyers",
    livingroom_02="Modern living\nroom for a\ncontemporary style",
    livingroom_03="Rustic living room\nfor gracious\ncountry living",
    livingroom_04="Luxury living room\n for discriminating\ntastes",
    Bathroom_01="Standard bathroom\nfor first-time\nbuyers",
    Bathroom_02="Modern bathroom\nfor a\ncontemporary style",
    Bathroom_03="Rustic bathroom\nfor gracious\ncountry living",
    Bathroom_04="Luxury bathroom\nfor discriminating\ntastes",
    Kitchen_01="Standard kitchen\nfor first-time\nbuyers",
    Kitchen_02="Modern kitchen for\na contemporary\nstyle",
    Kitchen_03="Rustic kitchen\nfor gracious\ncountry living",
    Kitchen_04="Luxury kitchen\nfor discriminating\ntastes",

    foodbowl_01 = "Cobalt blue\nfeeding bowl",
    foodbowl_03 = "Cherry red\nfeeding bowl",
    foodbowl_04 = "Biscuit pattern\nfeeding bowl",
    foodbowl_02 = "Stainless steel\nfeeding bowl",
    arearug_01 = "Modern throw rug",
    arearug_02 = "Art deco\nthrow rug",
    arearug_03 = "Patterned rug",
    arearug_04 = "Luxury oriental\nrug",
    coffeetable_01 = "Rustic coffee\ntable",
    coffeetable_02 = "Modern coffee\ntable",
    coffeetable_03 = "Luxury coffee\ntable",
    easychair_04 = "Beige cloth\neasy chair",
    easychair_03 = "Brown leather\neasy chair",
    easychair_02 = "Crushed velour\neasy chair",
    easychair_01 = "Blue satin\neasy chair",
    kitchenchair_01 = "Modern kitchen\nchair",
    kitchenchair_02 = "Rustic kitchen\nchair",
    kitchenchair_03 = "Luxury kitchen\nchair",
    kitchentable_01 = "Standard kitchen\ntable",
    kitchentable_02 = "Modern kitchen\ntable",
    kitchentable_03 = "Rustic kitchen\ntable",
    kitchentable_04 = "Luxury kitchen\ntable",
    fridge_01 = "Standard\nrefrigerator",
    fridge_02 = "Modern\nrefrigerator",
    fridge_03 = "Rustic\nrefrigerator",
    fridge_04 = "Deluxe\nrefrigerator",
    petbed_04 = "Sheepskin\npet bed",
    petbed_01 = "Crushed velour\npet bed",
    petbed_02 = "Hand-quilted\npet bed",
    petbed_03 = "Genuine leopard\npet bed",
    sofa_01 = "Beige cloth\nsofa",
    sofa_03 = "Brown leather\nsofa",
    sofa_04 = "Quilted sofa",
    sofa_02 = "Blue satin\nsofa",
    toilet_01 = "Beige porcelain\ntoilet",
    toilet_02 = "Powder blue\ntoilet",
    toilet_03 = "Pale avocado\ntoilet",
    toilet_04 = "Stainless steel\ntoilet",
    tub_01 = "Beige porcelain\nbathtub",
    tub_02 = "Powder blue\nbathtub",
    tub_03 = "Pale avocado\nbathtub",
    tub_04 = "Polished gold\nbathtub",
    doghouse_01 = "Standard\npet house",
    doghouse_02 = "Modern\npet house",
    doghouse_03 = "Rustic\npet house",
    doghouse_04 = "Luxury\npet house",
    ball_01 = "Yellow tennis\nball",
    ball_02 = "Blue squeeze\nball",
    ball_03 = "Rubber band\nball",
    ball_04 = "Autographed\nbaseball",
    ball_06 = "Gold lamé\nluxury ball",
    flyingdisc_01 = "Plastic\nflying disc",
    flyingdisc_02 = "Advanced\nflying disc",
    flyingdisc_04 = "Expert\nflying disc",
    flyingdisc_03 = "Luxury gold\nflying disc",
    stick_01 = "Wooden stick",
    newspaper_01 = "Rolled\nnewspaper",
    mocassin_01 = "Leather\nmocassin",
    squeekybone_01 = "Rubber bone\ntoy",
    teddy_01 = "Stuffed teddy\nbear",
    squeekyduck_01 = "Squeaky duck\ntoy",

    -- catz-specific stuff

    ball_05 = "Ball of\nred yarn",
    jingleball_04 = "Pink jingle\nball",
    jingleball_02 = "Blue jingle\nball",
    jingleball_01 = "Royal purple\njingle ball",
    jingleball_03 = "Gold lamé\njingle ball",
    toymouse_01 = "Catnip\nmouse",
    litterbox_01 = "Green\nlitter box",
    litterbox_02 = "Blue\nlitter box",
    litterbox_04 = "Red\nlitter box",
    litterbox_03 = "Stainless steel\nlitter box",
    scratchingpost_01 = "Standard\nscratching post",
    scratchingpost_02 = "Deluxe\nscratching post",
    perch_02 = "Standard\ncat perch",
    perch_01 = "Deluxe\ncat perch",

    Dogz_fur_01 = "Standard\nfur 1",
    Dogz_fur_02 = "Standard\nfur 2",
    Dogz_fur_03 = "Standard\nfur 3",
    Dogz_fur_04 = "Timber wolf\nfur",
    Dogz_fur_05 = "Dalmation\nfur",
    Dogz_fur_06 = "Robotic steel",

    Catz_fur_01 = "Standard\nfur 1",
    Catz_fur_02 = "Standard\nfur 2",
    Catz_fur_03 = "Standard\nfur 3",
    Catz_fur_04 = "Shadow gray\nfur",
    Catz_fur_05 = "Natural auburn\nfur",
    Catz_fur_06 = "Natural blonde\nfur",
    Catz_fur_07 = "Shocking pink\nfur",
    Catz_fur_08 = "Powder blue\nfur",
    Catz_fur_09 = "Tiger fur",
    Catz_fur_10 = "Leopard fur",
    Catz_fur_11 = "Robotic steel",
    Catz_fur_12 = "Giraffe",
    Catz_fur_13 = "Zebra",
    Catz_fur_14 = "Cheetah",

    Dogz_MainMenuTextNoPet = "Welcome to Dogz.\nIt's time to adopt your first puppy!",
    Catz_MainMenuTextNoPet = "Welcome to Catz.\nIt's time to adopt your first kitten!",
    Dogz_MainMenuText = "Welcome back to Dogz.\nPlay with this puppy or choose a new one!",
    Catz_MainMenuText = "Welcome back to Catz.\nPlay with this kitty or choose a new one!",

    Dogz_LoadMenuTitle = "Load Puppy",
    Catz_LoadMenuTitle = "Load Kitten",

    Dogz_KennelTitle = "Adopt Puppy",
    Catz_KennelTitle = "Adopt Kitten",

    Settings = "Settings",
    Video = "Video",
    Volume = "Volume",
    AntiAlias = "Smoother Lines",

    AdoptCertificate = "Adoption Certificate",

    PrintYesNo="Are you sure you want to print?",
    DeletePhotoYesNo="Are you sure you want to delete this photo?",
    DeletePetYesNo="Are you sure you want to delete this pet?",

    TOD_Heading="Trick of the Day",
    TOD_None="Watch for a new Trick of the Day coming soon!",
    TOD_Winner="You just won $%d in the Trick of the Day. Well done!",
    TOD_OneEasyTrick="Make your pet do the %s trick to win $%d!",
    TOD_OneHardTrick="Make your pet do the %s trick to win $%d!",
    TOD_TwoTricks="Make your pet %s and then %s to win $%d!",
    TOD_ThreeTricks="Make your pet do three different tricks in a row to win $%d!",
    TOD_OneFetch="Make your pet fetch the %s to win $%d!",
    TOD_TwoFetches="Make your pet fetch the %s and then the %s to win $%d!",
    TOD_ThreeFetches="Make your pet fetch three different toys in a row to win $%d!",
    TOD_Balance="Make your pet balance a toy on its nose. Win $%d for every 3 seconds!",
    TOD_Treat="Hold a treat above your pet's nose as long as you can. Win $%d for every 3 seconds!",
    TOD_EasyTrickPhoto="Submit a new photo of your pet doing the %s trick to win $%d!",
    TOD_HardTrickPhoto="Submit a new photo of your pet doing the %s trick to win $%d!",
    TOD_BeautyPhoto="Clean your pet and dress it up. Then submit a photo to win a prize!",
    TOD_CutePhoto="Clean your pet, dress it up and pose it. Then submit a photo to win a prize!",

    ToolTip_Options="Options",
    ToolTip_Store="Store",
    ToolTip_Shows="Talent Shows",
    ToolTip_Inventory="My Stuff",
    ToolTip_Camera="Take Picture",
    ToolTip_Praise="Praise",
    ToolTip_Treat="Treat",
    ToolTip_Scold="Scold",
    ToolTip_Tricks="Tricks",
    ToolTip_Stats="About Pet",

    ToolTip_CareTab="Food and care items",
    ToolTip_ToysTab="Toys",
    ToolTip_ClothingTab="Clothing and accessories",
    ToolTip_HouseTab="Home decor and furnishings",

    ToolTip_Bathroom="Bathroom",
    ToolTip_LivingRoom="Playroom",
    ToolTip_Kitchen="Kitchen",
    ToolTip_Backyard="Outdoors",

    ToolTip_Promenade="Say WALK AROUND!",
    ToolTip_Sit="Say SIT!",
    ToolTip_LieDown="Say LIE DOWN!",
    ToolTip_Speak="Say SPEAK!",
    ToolTip_GivePaw="Say PAW!",
    ToolTip_Beg="Say BEG!",
    ToolTip_RollOver="Say ROLL OVER!",
    ToolTip_Hide="Say HIDE!",
    ToolTip_NodHead="Say NOD!",
    ToolTip_ShakeHead="Say SHAKE!",
    ToolTip_Jump="Say JUMP!",
    ToolTip_StandOnHindLegs="Say STAND HIGH!",

    ToolTip_ShowerHead="Shower",
    ToolTip_Shampoo="Shampoo",
    ToolTip_LeaveAttentionMode="Leave Closeup",
    ToolTip_LeaveTubMode="Exit Tub",

    TrickName_Promenade="WALK AROUND",
    TrickName_Sit="SIT",
    TrickName_LieDown="LIE DOWN",
    TrickName_Speak="SPEAK",
    TrickName_GivePaw="PAW",
    TrickName_Beg="BEG",
    TrickName_RollOver="ROLL OVER",
    TrickName_Hide="HIDE",
    TrickName_NodHead="NOD",
    TrickName_ShakeHead="SHAKE",
    TrickName_Jump="JUMP",
    TrickName_StandOnHindLegs="STAND HIGH",

    TS_WelcomeEasy="Welcome to the Petz Talent Show, Easy Level %d!",
    TS_WelcomeMedium="Welcome to the Petz Talent Show, Medium Level %d!",
    TS_WelcomeHard="Welcome to the Petz Talent Show, Hard Level %d!",
    TS_PetID="Our next contestant is a %s named %s.",
    TS_BreedGermanShepard="German Shepherd puppy",
    TS_BreedBorderCollie="Border Collie puppy",
    TS_BreedGoldenRetriever="Labrador Retriever puppy",
    TS_BreedBeagle="Beagle puppy",
    TS_BreedPug="Pug puppy",
    TS_BreedAbyssinian="Abyssinian kitten",
    TS_BreedBengal="Bengal kitten",
    TS_BreedBurmese="Burmese kitten",
    TS_BreedMaineCoon="Maine Coon kitten",
    TS_BreedSiamese="Siamese kitten",
    TS_PetNew="It`s %s first visit to this show. Let`s give %s a big hand!",
    TS_His="his",
    TS_Him="him",
    TS_Her="her",
    TS_PetHistory="%s has been in %d %s shows, winning a total of $%d!",
    TS_Easy="Easy",
    TS_Medium="Medium",
    TS_Hard="Hard",
    TS_ToBeat="The pets to beat today are %s in 1st place, %s in 2nd and %s in 3rd.",
    TS_ReadyRound1="Get ready. Round 1 is about to begin!",
    TS_TwoTricks="Perform %s and %s in order within %d seconds. Go!",
    TS_ThreeTricks="Perform %s, %s and %s in order within %d seconds. Go!",
    TS_ScoreRound1="Your score for round 1 was %d points!",
    TS_ReadyRound2="Time now for the Grooming and Beauty round!",
    TS_Round2="Ask %s to WALK AROUND so the judges can look at %s.",
    TS_ScoreRound2="%s wins a Grooming and Beauty Bonus of %d points.",
    TS_TotalRound2="Total score so far is %d points!",
    TS_ReadyRound3="Get ready for our third and final round: Freestyle!",
    TS_Round3="Make %s do as many different tricks as you can before time runs out. Go!",
    TS_ScoreRound3="%s wins a Freestyle Bonus of %d points.",
    TS_RankingScore="With a final score of %d, %s wins the %s of $%d!",
    TS_Place1="first prize",
    TS_Place2="second prize",
    TS_Place3="third prize",
    TS_NoRankingScore="Final score for this show was %d. Better luck next time to %s!",
    TS_Bye="Thanks for visiting the Petz Talent Show!",

    -- The following should be generic pet names
    -- suitable for either a dog or a cat
    -- 10 for males, 10 for females

    TS_RandomName1="Spike",
    TS_RandomName2="Prince",
    TS_RandomName3="Duke",
    TS_RandomName4="Buddy",
    TS_RandomName5="Joker",
    TS_RandomName6="Furball",
    TS_RandomName7="King",
    TS_RandomName8="Killer",
    TS_RandomName9="Blackie",
    TS_RandomName10="Piggy",
    TS_RandomName11="Princess",
    TS_RandomName12="Duchess",
    TS_RandomName13="Lady",
    TS_RandomName14="Sneaker",
    TS_RandomName15="Snout",
    TS_RandomName16="Stinky",
    TS_RandomName17="Queen",
    TS_RandomName18="Tiny",
    TS_RandomName19="Fluffy",
    TS_RandomName20="Flopsy",

    GermanShepard="German Shepherd",
    BorderCollie="Border Collie",
    GoldenRetriever="Labrador Retriever",
    Beagle="Beagle",
    Pug="Pug",
    Abyssinian="Abyssinian",
    Bengal="Bengal",
    Burmese="Burmese",
    MaineCoon="Maine Coon",
    Siamese="Siamese",

    SelectFur="Select a fur",
    SelectCollar="Select a collar",

    Yes="Yes",
    No="No",

    AskUseKennel = "Would you like to Kennel your pet for $20?",

    BookOfTricksAdvanced = "Advanced\nBook of Tricks",
    BookOfTricksExpert = "Expert\nBook of Tricks",
    BookOfTricksSecret = "Secret\nBook of Tricks",

    Tip_Banner="Tips",
    Tip_62="Your pet has learned enough tricks to enter the Easy Talent Show!",
    Tip_63="Your pet has learned enough tricks to enter the Advanced Talent Show!",
    Tip_64="Your pet has learned enough tricks to enter the Expert Talent Show!",
    Tip_65="You earn $5 every time you make your pet do a trick.",
    Tip_66="You just called your pet! Now you can pet and play with it.",
    Tip_67="Give your pet a treat to reward it when it does something you like.",
    Tip_68="Squirt your pet to scold it when it does something you don't like.",
    Tip_69="Your pet just made a mess! Click on the mess to clean it up.",
    Tip_70="Use treats and squirts to teach your pet where it's okay to make messes.",
    Tip_71="Use the shower head to rinse your pet after shampooing.",
    Tip_72="Earn extra money by making your pet do tricks, or entering Talent Shows.",
    Tip_73="The Book of Tricks will show you how to make your pet do tricks.",
    Tip_74="You just used up all of your pet food. Visit the Store to buy more.",
    Tip_75="You just used up all of your pet water. Visit the Store to buy more.",
    Tip_76="You just used up all of your shampoo. Visit the Store to buy more.",
    Tip_77="Click on the circle to the right to take back the things you throw.",

    ConfirmOverwrite = "There is already a pet with that name. Are you sure you want to replace that pet with this new one?",

    ReadMeLink = "ReadMe",      -- Name of shortcut to readme.txt
    ManualLink = "Manual",      -- Name of shortcut to Manual.pdf
    RegisterLink = "Register",  -- Name of shortcut for registering the product

    QuitConfirm="Are you sure you want to quit?",

    Level1="Level 1",
    Level2="Level 2",
    Level3="Level 3",

    TS_LevelEasy="Easy",
    TS_LevelAdvanced="Advanced",
    TS_LevelExpert="Expert",

    NoBreedSelected="No breed selected",
    SelectBreed="Select a breed",
    CustomizeYourPet="Customize your pet",
    NameYourPet="Name your pet",

    Boy="Boy",
    Girl="Girl",

    UninstallDelete = "Do you also want to delete all user-created files?",

    Okay="OK",

    AutorunPlay="Play",
    AutorunInstall="Install",
    AutorunUninstall="Uninstall",
    AutorunReadMe="Read Me",
    AutorunManual="Manual",
    AutorunRegister="Register",
    AutorunQuit="Quit",

    LabelInventory="My Stuff",
    LabelStore="Petz Store",

    TS_YourScore="Round 1: %d     Round 2: %d     Round 3: %d     Total: %d",
    TS_WinPlace1="%s wins 1st Place! Your prize is $%d!",
    TS_WinPlace2="%s wins 2nd Place! Your prize is $%d!",
    TS_WinPlace3="%s wins 3rd Place! Your prize is $%d!",
    TS_WinPlace4="%s came in last. Better luck next time!",
    TS_Award1="1st Place",
    TS_Award2="2nd Place",
    TS_Award3="3rd Place",
    TS_Award4="4th Place",
    TS_Score="Score: %d",

    StatBreed="Breed",
    StatBirthday="Birthday",
    StatIntelligence="Intelligence",
    StatAgility="Agility",
    StatStamina="Stamina",
    StatObedience="Obedience",

    NeedLove="Love",
    NeedHunger="Hunger",
    NeedThirst="Thirst",
    NeedGrooming="Grooming",
    NeedAlertness="Alertness",

    BookOfTricks = "Beginner's\nBook of Tricks",

    ToolTip_ReturnToHouse="Return Home",

    BrushPrompt="Do you want to go to the bathroom to brush your pet?",
    remove_clothes="Remove all clothes",

    NeedLoveRed="Your pet is lonely. Time to pet or play with it.",
    NeedHungerRed="Your pet is hungry. Time to feed it.",
    NeedThirstRed="Your pet is thirsty. Time to water it.",
    NeedGroomingRed="Your pet is dirty. Time to brush or shampoo it.",
    NeedAlertnessRed="Your pet is tired. Time to let it sleep.",

    StatIntelligenceTip="How quickly your pet learns.",
    StatAgilityTip="How well your pet performs hard tricks.",
    StatStaminaTip="How quickly your pet gets tired.",
    StatObedienceTip="How often your pet does what you say.",

    Tip_78="Your pet is very tired. Time to let it sleep for a while.",
    Tip_79="Welcome back! You haven't played with your pet for a while.",

-- PLEASE add all new text BELOW this line, or it will not get translated! -BM

    EmptyCartButton="Empty Cart",
    EmptyButton="Empty",
    BackButton="Back",
    NextButton="Next",

    NeedLoveGreen="Play with your pet to make it feel loved.",
    NeedLoveYellow="Your pet is getting lonely. Time to pet or play with it.",

    NeedHungerGreen="Feed your pet when it gets hungry.",
    NeedHungerYellow="Your pet is getting hungry. Time to feed it.",

    NeedThirstGreen="Water your pet when it gets thirsty.",
    NeedThirstYellow="Your pet is getting thirsty. Time to water it.",

    NeedGroomingGreen="Clean or brush your pet when it gets dirty.",
    NeedGroomingYellow="Your pet is getting dirty. Time to brush or shampoo it.",

    NeedAlertnessGreen="Let your pet sleep when it gets tired.",
    NeedAlertnessYellow="Your pet is getting tired. Time to let it sleep.",

    PrinterNotFound = "Printer not found. Be sure it is turned on and plugged in.",

    BrushPrompt2="Do you want to brush your pet now?",

    Tip_80="It takes practice for your pet to learn more than a few tricks. Keep showing your pet how to %s, and give it a treat when it obeys.",

    NeedsTitle="Needs",
    StatsTitle="Stats",

    ubisoft_copyright = "(C) Ubisoft",
}

language.French = {

    YouWin="Gagné !",
    YouLose="Perdu !",
    Round="Manche %d",
    BonusUnlocked="Bonus débloqué !",
    GotoMainMenu="Es-tu sûr de vouloir aller au menu principal ?",
    Paused="Pause",
    Pause="Pause",
    Loading="Chargement",
    Uninstall="Désinstaller",
    SettingTitle="Configuration",
    SettingsVolume="Volume",
    SettingsVideo="Affichage",
    SettingsAntiAliasing="Lignes plus lisses",

    Tip_01="Clique sur l'écran pour appeler ton nouvel animal.",
    Tip_02="Ton animal a faim. Tu trouveras de la nourriture dans ta mallette.",
    Tip_03="Ton animal a soif. Tu trouveras de l'eau dans ta mallette.",
    Tip_04="Ton animal a besoin de prendre un bain. Tu peux trouver du shampooing à la boutique Petz.",
    Tip_05="Ton animal est fatigué. C'est l'heure pour lui de se reposer.",
    Tip_06="Ton animal a besoin d'amour. Chouchoute-le un peu.",
    Tip_07="Voici la boutique Petz. Achète tout ce dont ton animal a besoin ici.",
    Tip_08="Voici ta mallette. Tout ce que tu achètes y est rangé.",
    Tip_09="Récompense ton animal en lui donnant une friandise.",
    Tip_10="Réprimande ton animal en l'éclaboussant avec de l'eau.",
    Tip_11="Utilise ces boutons pour donner des ordres à ton animal.",
    Tip_12="Cette boîte t'indique ce que ressent ton animal en ce moment.",
    Tip_13="Fais un clic gauche et caresse ton animal. Il adore qu'on s'occupe de lui !",
    Tip_14="Fais un clic gauche et pousse ton animal pour le faire asseoir.",
    Tip_15="Ton animal a fait une promenade. Appuie sur le bouton bleu pour dire VA TE PROMENER !",
    Tip_16="Ton animal s'est assis. Appuie sur le bouton bleu pour dire ASSIS !",
    Tip_17=" Ton animal s'est couché. Appuie sur le bouton bleu pour dire COUCHÉ !",
    Tip_18="Ton animal a parlé. Appuie sur le bouton bleu pour dire PARLE !",
    Tip_19="Ton animal a donné la patte. Appuie sur le bouton bleu pour dire DONNE LA PATTE !",
    Tip_20="Ton animal a fait le beau. Appuie sur le bouton bleu pour dire FAIS LE BEAU !",
    Tip_21="Ton animal s'est couché sur le dos. Appuie sur le bouton bleu pour dire SUR LE DOS !",
    Tip_22="Ton animal s'est caché la tête. Appuie sur le bouton bleu pour dire CACHE-TOI !",
    Tip_23="Ton animal a hoché la tête. Appuie sur le bouton bleu pour dire HOCHE LA TÊTE !",
    Tip_24="Ton animal a secoué la tête. Appuie sur le bouton bleu pour dire SECOUE LA TÊTE !",
    Tip_25="Ton animal a sauté. Appuie sur le bouton bleu pour dire SAUTE !",
    Tip_26="Ton animal s'est mis debout. Appuie sur le bouton bleu pour dire DEBOUT !",
    Tip_27="Appuie plusieurs fois sur ton animal pour qu'il se couche.",
    Tip_28="Montre à ton animal ce que %s veut dire jusqu'à ce qu'il y arrive.",
    Tip_29="Une friandise aiderait ton animal à comprendre ce que %s signifie.",
    Tip_31="Redis %s, et donne une friandise à ton animal quand il obéit.",
    Tip_32="Il y a plus de chances que ton animal t'obéisse si tu le nourris.",
    Tip_33="Il y a plus de chances que ton animal t'obéisse si tu lui donnes à boire.",
    Tip_34="Il y a plus de chances que ton animal t'obéisse si tu le cajoles.",
    Tip_35="Il y a plus de chances que ton animal t'obéisse si tu lui fais sa toilette.",
    Tip_36="Il y a plus de chances que ton animal t'obéisse si tu le laisses se reposer.",
    Tip_37="Il y a plus de chances que ton animal t'obéisse si tu joues avec lui.",
    Tip_38="Ton animal a travaillé très dur pour tenter de réussir le tour %s. Une friandise l'aiderait à progresser.",
    Tip_39="Ton animal ne comprendra pas ce que tu lui dis si tu parles trop vite.",
    Tip_40="Ton animal pourrait oublier le tour %s si tu le réprimandes !",
    Tip_41="Ton animal a oublié le tour %s.",
    Tip_42="Veux-tu aller dans la cuisine pour donner à manger à ton animal ?",
    Tip_43="Veux-tu aller dans la cuisine pour donner à boire à ton animal ?",
    Tip_44="Veux-tu aller vers la baignoire pour donner un bain à ton animal ?",
    Tip_45="Ton animal a appris ce que signifiait VA TE PROMENER !",
    Tip_46="Ton animal a appris ce que signifiait ASSIS !",
    Tip_47="Ton animal a appris ce que signifiait COUCHÉ !",
    Tip_48="Ton animal a appris ce que signifiait PARLE !",
    Tip_49="Ton animal a appris ce que signifiait DONNE LA PATTE !",
    Tip_50="Ton animal a appris ce que signifiait FAIS LE BEAU !",
    Tip_51="Ton animal a appris ce que signifiait SUR LE DOS !",
    Tip_52="Ton animal a appris ce que signifiait CACHE-TOI !",
    Tip_53="Ton animal a appris ce que signifiait HOCHE LA TÊTE !",
    Tip_54="Ton animal a appris ce que signifiait SECOUE LA TÊTE !",
    Tip_55="Ton animal a appris ce que signifiait SAUTE !",
    Tip_56="Ton animal a appris ce que signifiait DEBOUT !",
    Tip_57="Veux-tu aller jouer dans le jardin avec ton animal ?",
    Tip_58="Pour lancer un jouet, fais glisser le curseur et fais un clic gauche.",
    Tip_59="Pour participer au niveau 1 du Concours de Talent, ton animal doit savoir réaliser 4 tours, dont VA TE PROMENER.",
    Tip_60="Pour participer au niveau 2 du Concours de Talent, ton animal doit savoir réaliser 8 tours.",
    Tip_61="Pour participer au niveau 3 du Concours de Talent, ton animal doit savoir réaliser 12 tours.",

    DogDesc_Beagle="Ces chiens de chasse sont de vraies boules d'énergie. Les Beagles sont adorables, mais très indépendants, il faut donc être très patient pour réussir à les dresser. C'est très facile de les laver car ils ont le poil court. Attention ! Ces petits farceurs déchiquettent tout ce qui leur passe entre les pattes.",
    DogDesc_Collie="Ces chiens sont très intelligents, c'est un plaisir de les entraîner.\nLes Border Collies sont des compagnons tendres et obéissants. Mais leurs longs poils nécessitent plus de soins que d'autres chiens.",
    DogDesc_Shepherd="Les chiens de berger sont des animaux d'une grande loyauté. L'amour qu'ils manifestent est sans borne. De plus, ce sont d'excellents élèves. Mais l'entretien de leurs longs poils est un cauchemar, et ils aboient plus que n'importe quelle autre race de chiens.",
    DogDesc_Retriever="Ces chiots adorent jouer. Ils sont vifs et malins, tendres et adorables. Les Labradors comprennent très vite, mais ils ont du mal à se concentrer. Ils ont également plus besoin d'eau que les chiens des autres races car ils ont tendance à beaucoup baver.",
    DogDesc_Pug="Ces chiots sont des petits farceurs. Ils adorent jouer, et ils sont très câlins. Dresser un Carlin est une tâche difficile, mais ils adorent qu'on prenne soin d'eux, donc tout ira bien. Donne-leur plein d'amour et ils te le rendront bien. Grâce à leurs poils courts, leur toilette est un jeu d'enfant.",
    CatDesc_Abyssinian="Ce chat intelligent et indépendant adore les endroits situés en hauteur. Il saute partout où il peut. Les Abyssins ont plus d'énergie que les autres chats. Ils peuvent jouer plusieurs heures de suite. Leur pelage soyeux nécessite très peu d'entretien.",
    CatDesc_Bengal="Ce chat très vif est facile à dresser, et ne fait quasiment jamais de bêtise, c'est le premier chat idéal pour un maître. Les Bengals ont besoin de plus de nourriture et d'eau que les autres races de chats.",
    CatDesc_Burmese="Ces chats sont intelligents, obéissants, et ne quittent pas leur maître d'une semelle. Le Burmese a également tendance à griffer tout ce qui lui passe entre les pattes. Sois ferme !",
    CatDesc_MaineCoon="Ces gros chats sont très malins et étonnamment rapides. Les Maine Coon apprennent très vite, mais ils ont besoin de plus de nourriture, de repos et de soin que les autres races de chats.",
    CatDesc_Siamese="Soyeux et agiles, les Siamois constituent l'élite de la population féline. Ils adorent que l'on prenne soin d'eux, mais ils préfèrent s'occuper d'eux eux-mêmes. De plus ils aiment donner de la voix. Si tu aimes les miaulements, ce chat est fait pour toi !",

    foodcan_04 ="Nourriture pour\nanimaux premier prix",
    foodcan_03 ="Nourriture\naromatisée\npour animaux",
    foodcan_02 ="Nourriture bio\npour animaux",
    foodcan_01 ="Nourriture\nde luxe\npour animaux",
    foodbag_04 ="Croquettes pour\nanimaux premier prix",
    foodbag_03 ="Croquettes\naromatisées\npour animaux",
    foodbag_02 ="Croquettes bio\npour animaux",
    foodbag_01 ="Croquettes\nde luxe\npour animaux",
    waterbottle_01 ="Eau premier prix",
    waterbottle_04 ="Eau énergétique",
    waterbottle_03 ="Eau bio",
    waterbottle_02 ="Eau de luxe",
    shampoo_03 ="Shampooing\npremier prix",
    shampoo_01 ="Shampooing bio",
    shampoo_02 ="Shampooing de luxe",

    foodcan_04x ="Nourriture pour\nanimaux premier prix\n(3 boîtes)",
    foodcan_03x ="Nourriture aromatisée\npour animaux\n(3 boîtes)",
    foodcan_02x ="Nourriture bio\npour animaux\n(3 boîtes)",

    foodbag_04x ="Croquettes pour\nanimaux premier prix\n(3 sacs)",
    foodbag_03x ="Croquettes\naromatisées pour\nanimaux (3 sacs)",
    foodbag_02x ="Croquettes bio\npour animaux\n(3 sacs)",

    waterbottle_01x ="Eau premier prix\n(3 bouteilles)",
    waterbottle_04x ="Eau énergétique\n(3 bouteilles)",
    waterbottle_03x ="Eau bio\n(3 bouteilles)",

    shampoo_03x ="Shampooing\npremier prix\n(3 bouteilles)",
    shampoo_01x ="Shampooing bio\n(3 bouteilles)",

    treats_03x ="Friandises\npremier prix\n(3 boîtes)",
    treats_01x ="Friandises bio\n(3 boîtes)",

    brush_01 ="Brosse en bois",
    brush_02 ="Brosse bleu cobalt",
    brush_03 ="Brosse argentée",
    brush_04 ="Brosse de luxe\ndorée",
    treats_03 ="Friandise\npremier prix",
    treats_01 ="Friandise bio",
    treats_02 ="Friandise gourmet",

    bandanacollar_01 ="Bandana rouge",
    collar_01 ="Collier en\ncuir brun",
    collar_02 ="Collier en\ncuir noir",
    collar_03 ="Collier en\ncuir blanc",
    collar_04 ="Collier en\ndaim bleu",
    collar_05 ="Collier en\ndaim vert",
    collar_06 ="Collier en\ndaim rouge",
    collar_07 ="Collier en peau\nde crocodile",
    collar_08 ="Collier serti\nde diamant",
    floralcollar_01="Collier à\nfleurs bleues",
    floralcollar_02="Collier à\nfleurs roses",
    floralcollar_03="Collier à\nfleurs foncées",
    chaincollar_01 ="Chaîne\nargentée",
    chaincollar_02 ="Chaîne\ndorée",
    chaincollar_03 ="Chaîne\nen acier",
    gmcollar_01 ="Collier avec\nmédaille dorée",

    booties_01 ="Chaussons\nde sport",
    booties_03 ="Chaussons en\ncuir blanc",
    booties_02 ="Chaussons à\ntalon en acier",
    pombooties_01 ="Chaussons de\nfête à pompon",
    pombooties_03 ="Chaussons de\ndanse à pompon",
    pombooties_02 ="Chaussons à\npompon léopard",
    baseballhat_01 ="Casquette de\nbase-ball",
    beeniehat_01 ="Casquette\nà hélice",
    sombrerohat_01 ="Sombrero",
    cowboyhat_01 ="Chapeau\nde cowboy",
    jesterhat_01 ="Bonnet de\ntroubadour",
    piratehat_01 ="Chapeau\nde pirate",
    princesshat_01 ="Chapeau\nde princesse",
    wizardhat_01 ="Chapeau\nde sorcier",
    tiarahat_01 ="Diadème\nroyal",
    vikinghat_01 ="Chapeau\nde viking",
    mohawkhat_01 ="Coiffe indienne\nverte",
    tailpom_01 ="Pompon rose\npour la queue",
    tailpom_02 ="Pompon rouge\npour la queue",
    tailpom_03 ="Pompon bleu\npour la queue",
    tailpom_04 ="Pompon léopard\npour la queue",
    tailpom_05 ="Pompon blanc\npour la queue",
    tailpom_06 ="Pompon à\npaillettes\npour la queue",

livingroom_01="Salle de séjour\nclassique pour\nacheteurs novices",
livingroom_02="Salle de séjour\nmoderne pour un\nstyle contemporain",
livingroom_03="Salle de séjour\nrustique pour\nune vie champêtre",
livingroom_04="Salle de séjour\nde luxe pour\nles goûts délicats",
Bathroom_01="Salle de bain\nclassique pour\nacheteurs novices",
Bathroom_02="Salle de bain\nmoderne pour un\nstyle contemporain",
Bathroom_03="Salle de bain\nrustique pour\nune vie champêtre",
Bathroom_04="Salle de bain\nde luxe pour\nles goûts délicats",
Kitchen_01="Cuisine classique\npour acheteurs\nnovices",
Kitchen_02="Cuisine moderne\npour un\nstyle contemporain",
Kitchen_03="Cuisine rustique\npour une\nvie champêtre",
Kitchen_04="Cuisine de luxe\npour les\ngoûts délicats",

    foodbowl_01 ="Gamelle\nbleu cobalt",
    foodbowl_03 ="Gamelle\nrouge cerise",
    foodbowl_04 ="Gamelle en\nforme de biscuit",
    foodbowl_02 ="Gamelle en\nacier inoxydable",
    arearug_01 ="Tapis\nmoderne",
    arearug_02 ="Tapis\nArt déco",
    arearug_03 ="Tapis\nà motifs",
    arearug_04 ="Tapis oriental\nde luxe",
    coffeetable_01 ="Table basse\nrustique",
    coffeetable_02 ="Table basse\nmoderne",
    coffeetable_03 ="Table basse\nde luxe",
    easychair_04 ="Fauteuil\nbeige",
    easychair_03 ="Fauteuil\nen cuir brun",
    easychair_02 ="Fauteuil\nen velours",
    easychair_01 ="Fauteuil\nen satin bleu",
    kitchenchair_01 ="Chaise de\ncuisine moderne",
    kitchenchair_02 ="Chaise de\ncuisine rustique",
    kitchenchair_03 ="Chaise de\ncuisine\nde luxe",
    kitchentable_01 ="Table de\ncuisine classique",
    kitchentable_02 ="Table de\ncuisine moderne",
    kitchentable_03 ="Table de\ncuisine\nrustique",
    kitchentable_04 ="Table de\ncuisine\nde luxe",
    fridge_01 ="Réfrigérateur\nclassique",
    fridge_02 ="Réfrigérateur\nmoderne",
    fridge_03 ="Réfrigérateur\nrustique",
    fridge_04 ="Réfrigérateur\nde luxe",
    petbed_04 ="Couverture en\npeau de mouton",
    petbed_01 ="Couverture\nen feutre",
    petbed_02 ="Couverture\ncousue main",
    petbed_03 ="Couverture en\nléopard véritable",
    sofa_01 ="Canapé\nbeige",
    sofa_03 ="Canapé en\ncuir brun",
    sofa_04 ="Canapé\nmatelassé",
    sofa_02 ="Canapé en\nsatin bleu",
    toilet_01 ="Toilette en\nporcelaine",
    toilet_02 ="Toilette\nbleu-gris",
    toilet_03 ="Toilette\nvert amande",
    toilet_04 ="Toilette en\nacier inoxydable",
    tub_01 ="Baignoire en\nporcelaine beige",
    tub_02 ="Baignoire\nbleu-gris",
    tub_03 ="Baignoire\nvert amande",
    tub_04 ="Baignoire\ndorée",
    doghouse_01 ="Niche\nclassique",
    doghouse_02 ="Niche\nmoderne",
    doghouse_03 ="Niche\nrustique",
    doghouse_04 ="Niche\nde luxe",
    ball_01 ="Balle de\ntennis jaune",
    ball_02 ="Balle en\néponge bleue",
    ball_03 ="Balle en\ncaoutchouc",
    ball_04 ="Balle de\nbase-ball\ndédicacée",
    ball_06 ="Balle de luxe\nen or",
    flyingdisc_01 ="Frisbee\nen plastique",
    flyingdisc_02 ="Frisbee pour\ninitiés",
    flyingdisc_04 ="Frisbee pour\nprofessionnels",
    flyingdisc_03 ="Frisbee de luxe\nen or",
    stick_01 ="Bâton\nde bois",
    newspaper_01 ="Journal\nenroulé",
    mocassin_01 ="Mocassins\nen cuir",
    squeekybone_01 ="Os en\ncaoutchouc",
    teddy_01 ="Ourson\nen peluche",
    squeekyduck_01 ="Canard en\nplastique",

    -- catz-specific stuff

    ball_05 ="Pelote de\nfil rouge",
    jingleball_04 ="Balle à\ngrelot rose",
    jingleball_02 ="Balle à\ngrelot bleue",
    jingleball_01 ="Balle à\ngrelot pourpre",
    jingleball_03 ="Balle à\ngrelot dorée",
    toymouse_01 ="Souris",
    litterbox_01 ="Bac à litière\nvert",
    litterbox_02 ="Bac à litière\nbleu",
    litterbox_04 ="Bac à litière\nrouge",
    litterbox_03 ="Bac à litière\nen acier\ninoxydable",
    scratchingpost_01 ="Griffoir\nclassique",
    scratchingpost_02 ="Griffoir\nde luxe",
    perch_02 ="Arbre à\nchat classique",
    perch_01 ="Arbre à\nchat de luxe",

    Dogz_fur_01 ="Pelage\nclassique 1",
    Dogz_fur_02 ="Pelage\nclassique 2",
    Dogz_fur_03 ="Pelage\nclassique 3",
    Dogz_fur_04 ="Pelage de\nloup des bois",
    Dogz_fur_05 ="Pelage de\ndalmatien",
    Dogz_fur_06 ="Acier robot",

    Catz_fur_01 = "Pelage\nclassique 1",
    Catz_fur_02 = "Pelage\nclassique 2",
    Catz_fur_03 = "Pelage\nclassique 3",
    Catz_fur_04 = "Pelage gris",
    Catz_fur_05 = "Pelage rouge",
    Catz_fur_06 = "Pelage beige\nnaturel",
    Catz_fur_07 = "Pelage rose\nflamboyant",
    Catz_fur_08 = "Pelage\nbleu-gris",
    Catz_fur_09 = "Pelage\ntigré",
    Catz_fur_10 = "Pelage\nléopard",
    Catz_fur_11 = "Acier robot",
    Catz_fur_12 = "Girafe",
    Catz_fur_13 = "Zèbre",
    Catz_fur_14 = "Guépard",

    Dogz_MainMenuTextNoPet ="Bienvenue sur Dogz.\nL'heure est venue pour toi d'adopter ton premier chiot !",
    Catz_MainMenuTextNoPet ="Bienvenue sur Catz.\nL'heure est venue pour toi d'adopter ton premier chaton !",
    Dogz_MainMenuText ="Bienvenue sur Dogz.\nJoue avec ton chiot ou choisis-en un autre !",
    Catz_MainMenuText ="Bienvenue sur Catz.\nJoue avec ton chaton ou choisis-en un autre !",

    Dogz_LoadMenuTitle ="Charger chiot",
    Catz_LoadMenuTitle ="Charger chaton",

    Dogz_KennelTitle ="Adopter chiot",
    Catz_KennelTitle ="Adopter chaton",

    Settings ="Configuration",
    Video ="Affichage",
    Volume ="Volume",
    AntiAlias ="Lignes plus lisses",

    AdoptCertificate ="Certificat d'adoption",

    PrintYesNo="Es-tu sûr de vouloir imprimer ?",
    DeletePhotoYesNo="Es-tu sûr de vouloir supprimer cette photo ?",
    DeletePetYesNo="Es-tu sûr de vouloir supprimer cet animal ?",

    TOD_Heading="Le tour du jour",
    TOD_None="Un nouveau tour du jour sera bientôt disponible !",
    TOD_Winner="Tu viens de gagner %d$ pour le tour du jour. Bien joué !",
    TOD_OneEasyTrick="Fais faire le tour %s à ton animal pour gagner %d$ !",
    TOD_OneHardTrick="Fais faire le tour %s à ton animal pour gagner %d$ !",
    TOD_TwoTricks="Fais faire le tour %s puis le tour %s à ton animal pour gagner %d$ !",
    TOD_ThreeTricks="Fais faire trois tours de suite à ton animal pour gagner %d$ !",
    TOD_OneFetch="Envoie ton animal chercher : %s pour gagner %d$ !",
    TOD_TwoFetches="Envoie ton animal chercher : %s puis %s pour gagner %d$ !",
    TOD_ThreeFetches="Envoie ton animal chercher trois jouets différents pour gagner %d$ !",
    TOD_Balance="Fais tenir un jouet en équilibre sur le museau de ton animal. Tu gagneras %d$ toutes les trois secondes !",
    TOD_Treat="Tiens une friandise au-dessus du museau de ton animal le plus longtemps possible. Tu gagneras %d$ toutes les 3 secondes.",
    TOD_EasyTrickPhoto="Présente une nouvelle photo de ton animal réalisant le tour %s pour gagner %d$ !",
    TOD_HardTrickPhoto="Présente une nouvelle photo de ton animal réalisant le tour %s pour gagner %d$!",
    TOD_BeautyPhoto="Lave ton animal et habille-le, puis présente une photo pour remporter un prix !",
    TOD_CutePhoto="Lave ton animal, habille-le et fais-le poser, puis présente une photo pour remporter un prix !",

ToolTip_Options="Options",
ToolTip_Store="Boutique",
ToolTip_Shows="Concours de Talent",
ToolTip_Inventory="Inventaire",
ToolTip_Camera="Prendre photo",
ToolTip_Praise="Féliciter",
ToolTip_Treat="Friandise",
ToolTip_Scold="Réprimander",
ToolTip_Tricks="Tours",
ToolTip_Stats="Infos animal",

    ToolTip_CareTab="Alimentation et soin",
    ToolTip_ToysTab="Jouets",
    ToolTip_ClothingTab="Vêtements et accessoires",
    ToolTip_HouseTab="Décoration et mobilier",


ToolTip_Bathroom="Salle de bain",
ToolTip_LivingRoom="Salle de jeux",
ToolTip_Kitchen="Cuisine",
ToolTip_Backyard="Jardin",

    ToolTip_Promenade="Dire VA TE PROMENER !",
    ToolTip_Sit="Dire ASSIS !",
    ToolTip_LieDown="Dire COUCHÉ !",
    ToolTip_Speak="Dire PARLE !",
    ToolTip_GivePaw="Dire DONNE LA PATTE !",
    ToolTip_Beg="Dire FAIS LE BEAU !",
    ToolTip_RollOver="Dire SUR LE DOS !",
    ToolTip_Hide="Dire CACHE-TOI !",
    ToolTip_NodHead="Dire HOCHE LA TÊTE !",
    ToolTip_ShakeHead="Dire SECOUE LA TÊTE !",
    ToolTip_Jump="Dire SAUTE !",
    ToolTip_StandOnHindLegs="Dire DEBOUT !",


ToolTip_ShowerHead="Douche",
ToolTip_Shampoo="Shampooing",
ToolTip_LeaveAttentionMode="Quitter gros-plan",
ToolTip_LeaveTubMode="Sortir baignoire",


    TrickName_Promenade="PROMENER",
    TrickName_Sit="ASSIS",
    TrickName_LieDown="COUCHÉ",
    TrickName_Speak="PARLER",
    TrickName_GivePaw="DONNER LA PATTE",
    TrickName_Beg="FAIRE LE BEAU",
    TrickName_RollOver="SUR LE DOS",
    TrickName_Hide="SE CACHER",
    TrickName_NodHead="HOCHER LA TÊTE",
    TrickName_ShakeHead="SECOUER LA TÊTE",
    TrickName_Jump="SAUTER",
    TrickName_StandOnHindLegs="DEBOUT",

    TS_WelcomeEasy="Bienvenue au Concours de Talent Petz, Niveau facile %d !",
    TS_WelcomeMedium="Bienvenue au Concours de Talent Petz, Niveau moyen %d !",
    TS_WelcomeHard="Bienvenue au Concours de Talent Petz, Niveau difficile %d !",
    TS_PetID="Notre participant suivant est un %s prénommé %s.",
    TS_BreedGermanShepard="Chiot berger-allemand",
    TS_BreedBorderCollie="Chiot Border Collie",
    TS_BreedGoldenRetriever="Chiot Labrador Retriever",
    TS_BreedBeagle="Chiot Beagle",
    TS_BreedPug="Chiot Carlin",
    TS_BreedAbyssinian="Chaton Abyssin",
    TS_BreedBengal="Chaton Bengal",
    TS_BreedBurmese="Chaton Burmese",
    TS_BreedMaineCoon="Chaton Maine Coon",
    TS_BreedSiamese="Chaton Siamois",
    TS_PetNew="%s participe pour la première fois à ce concours. Un grand bravo à %s !",
    TS_His="son",
    TS_Him="lui",
    TS_Her="elle",
    TS_PetHistory="%s a participé aux concours %d %s, et a remporté un montant total de %d $ !",
    TS_Easy="Facile",
    TS_Medium="Moyen",
    TS_Hard="Difficile",
    TS_ToBeat="Les animaux qu'il faut détrôner aujourd'hui sont %s à la 1re place, %s à la 2e et %s à la 3e.",
    TS_ReadyRound1="Attention ! La 1re manche va commencer !",
    TS_TwoTricks="Réalise dans l'ordre %s, puis %s en %d secondes. C'est parti !",
    TS_ThreeTricks="Réalise dans l'ordre %s, %s et %s en %d secondes. C'est parti !",
    TS_ScoreRound1="Ton score est de %d points pour la 1re manche !",
    TS_ReadyRound2="Passons maintenant à la manche consacrée au Toilettage et à la Beauté !",
    TS_Round2="Dis à %s VA TE PROMENER pour que les juges puissent l'observer.",
    TS_ScoreRound2="%s a remporté un Bonus Toilettage et Beauté de %d points.",
    TS_TotalRound2="Pour l'instant le score total est de %d points !",
    TS_ReadyRound3="Nous passons à la 3e et dernière manche : le Freestyle !",
    TS_Round3="Demande à %s de réaliser le plus de tours possible avant la fin du temps autorisé.",
    TS_ScoreRound3="%s a remporté un Bonus Freestyle de %d points.",
    TS_RankingScore="Avec un score final de %d, %s remporte le %s de $%d !",
    TS_Place1="premier prix",
    TS_Place2="deuxième prix",
    TS_Place3="troisième prix",
    TS_NoRankingScore="Le score final de ce concours s'élève à %d. Bonne chance à %s pour la prochaine fois !",
    TS_Bye="Merci d'avoir participé au Concours de Talent Petz !",

    TS_RandomName1="Spike",
    TS_RandomName2="Prince",
    TS_RandomName3="Duc",
    TS_RandomName4="Copain",
    TS_RandomName5="Farceur",
    TS_RandomName6="Boule de poil",
    TS_RandomName7="Champion",
    TS_RandomName8="Terreur",
    TS_RandomName9="Noirot",
    TS_RandomName10="Cochonnet",
    TS_RandomName11="Princesse",
    TS_RandomName12="Duchesse",
    TS_RandomName13="Lady",
    TS_RandomName14="Filou",
    TS_RandomName15="Museau",
    TS_RandomName16="Clochard",
    TS_RandomName17="Championne",
    TS_RandomName18="Riquiqui",
    TS_RandomName19="Peluche",
    TS_RandomName20="Flop",

    GermanShepard="Berger allemand",
    BorderCollie="Border Collie",
    GoldenRetriever="Labrador Retriever",
    Beagle="Beagle",
    Pug="Carlin",
    Abyssinian="Abyssin",
    Bengal="Bengal",
    Burmese="Burmese",
    MaineCoon="Maine Coon",
    Siamese="Siamois",

    SelectFur="Choisis un pelage",
    SelectCollar="Choisis un collier",

    Yes="Oui",
    No="Non",

    AskUseKennel ="Veux-tu mettre ton chien au chenil pour 20$ ?",

    BookOfTricksAdvanced ="Livre de tours\nniveau Avancé",
    BookOfTricksExpert ="Livre de tours\nniveau\nProfessionnel",
    BookOfTricksSecret ="Livre de tours\nsecret",


    PrinterNotFound="Imprimante non déctectée. Assurez-vous qu'elle soit allumée et branchée.",

Tip_Banner="Astuces",
Tip_62="Ton animal sait faire assez de tours pour pouvoir participer au Concours de Talent niveau Facile!",
Tip_63="Ton animal sait faire assez de tours pour pouvoir participer au Concours de Talent niveau Initié!",
Tip_64="Ton animal sait faire assez de tours pour pouvoir participer au Concours de Talent niveau Professionnel!",
Tip_65="Tu gagneras 5$ à chaque fois que ton animal réalisera un tour.",
Tip_66="Tu viens d'appeler ton animal ! Maintenant tu peux le câliner et jouer avec.",
Tip_67="Récompense ton animal avec une friandise quand il fait quelque chose qui te plaît.",
Tip_68="Éclabousse ton animal quand il fait quelque chose que tu n'apprécies pas.",
Tip_69="Ton animal a mis un sacré bazar ! Clique sur le désordre pour tout ranger.",
Tip_70="Utilise friandises et éclaboussures pour apprendre à ton animal où il a le droit de mettre le bazar.",
Tip_71="Utilise la pomme de douche pour rincer ton animal après le shampooing.",
Tip_72="Gagne plus d'argent en faisant faire des tours à ton animal, ou en participant au Concours de Talent.",
Tip_73="Le Livre de tours t'expliquera comment faire faire des tours à ton animal.",
Tip_74="Tu as épuisé tes réserves de nourriture pour ton animal. Va en racheter à la boutique.",
Tip_75="Tu as épuisé tes réserves d'eau pour ton animal. Va en racheter à la boutique.",
Tip_76="Tu as utilisé tout le shampooing. Va en racheter à la boutique.",
Tip_77="Clique sur le cercle à droite pour ramasser les objets que tu as jetés.",
ConfirmOverwrite="Ce nom a déjà été attribué à un animal. Es-tu sûr de vouloir remplacer cet animal par le nouveau ?",
ReadMeLink="Lisez-moi",
ManualLink="Manuel",
RegisterLink="Enregistrer",
QuitConfirm="Es-tu sûr de vouloir quitter cette partie ?",
Level1="Niveau 1",
Level2="Niveau 2",
Level3="Niveau 3",
TS_LevelEasy="Facile",
TS_LevelAdvanced="Initié",
TS_LevelExpert="Professionnel",
NoBreedSelected="Aucune race sélectionnée",
SelectBreed="Sélectionne une race",
CustomizeYourPet="Personnalise ton animal",
NameYourPet="Donne un nom à ton animal",
Boy="Mâle",
Girl="Femelle",
UninstallDelete="Veux-tu également supprimer tous les fichiers créés par l'utilisateur ?",
Okay="OK",
AutorunPlay="Jouer",
AutorunInstall="Installer",
AutorunUninstall="Désinstaller",
AutorunReadMe="Lisez-moi",
AutorunManual="Manuel",
AutorunRegister="Enregistrer",
AutorunQuit="Quitter",
LabelInventory="Mon inventaire",
LabelStore="Boutique Petz",

TS_YourScore="Manche 1 : %d   Manche 2 : %d   Manche 3 : %d   Total : %d",
TS_WinPlace1="%s a gagné la 1re place! Tu remportes $%d !",
TS_WinPlace2="%s a gagné la 2e place! Tu remportes $%d !",
TS_WinPlace3="%s a gagné la 3e place! Tu remportes $%d !",
TS_WinPlace4="%s arrive à la dernière place. Bonne chance pour la prochaine fois !",
TS_Award1="1re place",
TS_Award2="2e place",
TS_Award3="3e place",
TS_Award4="4e place",
TS_Score="Score : %d",

StatBreed="Race",
StatBirthday="Anniversaire",
StatIntelligence="Intelligence",
StatAgility="Agilité",
StatStamina="Endurance",
StatObedience="Obéissance",

NeedLove="Amour",
NeedHunger="Faim",
NeedThirst="Soif",
NeedGrooming="Toilettage",
NeedAlertness="Vivacité",

BookOfTricks="Livre de tours pour débutants",
ReturnHouse="Retourner à la maison",

ToolTip_ReturnToHouse="Retourner à la maison",
BrushPrompt="Veux-tu aller brosser ton animal dans la salle de bain ?",

remove_clothes="Retirer tous les vêtements",

NeedLoveGreen="Joue avec ton animal pour qu'il se sente aimé.",
NeedLoveYellow="Ton animal se sent seul. Caresse-le ou joue avec lui.",
NeedLoveRed="Ton animal est tout seul. C'est le moment de jouer avec lui ou de le câliner.",
NeedHungerGreen="Nourris ton animal quand il a faim.",
NeedHungerYellow="Ton animal a faim. Donne-lui à manger.",
NeedHungerRed="Ton animal a faim. C'est l'heure de lui donner à manger.",
NeedThirstGreen="Donne à boire à ton animal quand il a soif.",
NeedThirstYellow="Ton animal a soif. Donne-lui à boire.",
NeedThirstRed="Ton animal a soif. C'est l'heure de lui donner à boire.",
NeedGroomingGreen="Lave ou brosse ton animal quand il se salit.",
NeedGroomingYellow="Ton animal est sale. Brosse-le ou lave-le.",
NeedGroomingRed="Ton animal est sale. C'est le moment de le brosser ou de lui faire un shampooing.",
NeedAlertnessGreen="Fais dormir ton animal quand il est fatigué.",
NeedAlertnessYellow="Ton animal est fatigué. Fais-le dormir.",
NeedAlertnessRed="Ton animal est fatigué. C'est l'heure de le laisser dormir.",

StatIntelligenceTip="Vitesse d'apprentissage de ton animal.",
StatAgilityTip="Qualité des tours que réalise ton animal.",
StatStaminaTip="Vitesse à laquelle ton animal fatigue.",
StatObedienceTip="Fréquence à laquelle ton animal fait ce que tu lui dis.",

Tip_78="Ton animal est très fatigué. Il faut le laisser dormir un moment.",
Tip_79="Te revoilà enfin ! Tu as beaucoup manqué à ton animal.",

-- PLEASE add all new text BELOW this line, or it will not get translated! -BM

    PrinterNotFound="Impossible de trouver l'imprimante. Assure-toi qu'elle est bien allumée et branchée.",

    BrushPrompt2="Veux-tu brosser ton animal maintenant?",

    Tip_80="Pour apprendre de nouveaux tours, ton animal a besoin d'entraînement. Continue à lui apprendre comment %s, et récompense-le quand il obéit.",

    NeedsTitle="Besoins",
    StatsTitle="Stats",

    ubisoft_copyright = "(C) Ubisoft",
}

language.Spanish = {

    YouWin="¡Has ganado!",
    YouLose="¡Has perdido!",
    Round="%d ronda",
    BonusUnlocked="¡Bonificación desbloqueada!",
    GotoMainMenu="¿Seguro que quieres ir al menú principal?",
    Paused="En pausa",
    Pause="En pausa",
    Loading="Cargando",
    Uninstall="Desinstalar",

    SettingTitle="Configuración",
    SettingsVolume="Volumen",
    SettingsVideo="Vídeo",
    SettingsAntiAliasing="Suavizar líneas",

    Tip_01="Toca la pantalla para bautizar a tu nueva mascota.",
    Tip_02="Tu mascota tiene hambre. Hay comida en tu maleta.",
    Tip_03="Tu mascota tiene sed. Hay agua en tu maleta.",
    Tip_04="Tu mascota necesita un baño. Puedes comprar champú en la tienda Petz.",
    Tip_05="Tu mascota está cansada. Es hora de irse a descansar.",
    Tip_06="Tu mascota necesita amor. Prueba a mimarla un rato.",
    Tip_07="Ésta es la tienda Petz. Aquí puedes comprar todo lo que necesite tu mascota.",
    Tip_08="Ésta es tu maleta. Las cosas que has comprado se guardan aquí.",
    Tip_09="Dale una golosina a tu mascota cuando se porte bien.",
    Tip_10="Castiga a tu mascota rociándola con agua.",
    Tip_11="Usa estos botones para dar órdenes a tu mascota.",
    Tip_12="Este recuadro muestra cómo se siente tu mascota en cada momento.",
    Tip_13="Pulsa el botón y acaricia a tu mascota. ¡Le encanta que le hagan caso!",
    Tip_14="Pulsa el botón y empuja a tu mascota hacia abajo para que se siente.",

    Tip_15="Has conseguido que tu mascota camine en círculo. Pulsa el botón azul para decir: ¡PASEA!",
    Tip_16="Has conseguido que tu mascota se siente. Pulsa el botón azul para decir: ¡SIÉNTATE!",
    Tip_17="Has conseguido que tu mascota se tumbe. Pulsa el botón azul para decir: ¡TÚMBATE!",
    Tip_18="Has conseguido que tu mascota hable. Pulsa el botón azul para decir: ¡HABLA!",
    Tip_19="Has conseguido que tu mascota dé la patita. Pulsa el botón azul para decir: ¡PATITA!",
    Tip_20="Has conseguido que tu mascota pida. Pulsa el botón azul para decir: ¡PIDE!",
    Tip_21="Has conseguido que tu mascota se ponga patas arriba. Pulsa el botón azul para decir: ¡RUEDA!",
    Tip_22="Has conseguido que tu mascota esconda la cara. Pulsa el botón azul para decir: ¡ESCÓNDETE!",
    Tip_23="Has conseguido que tu mascota asienta. Pulsa el botón azul para decir: ¡ASIENTE!",
    Tip_24="Has conseguido que tu mascota menee la cabeza. Pulsa el botón azul para decir: ¡SACUDE!",
    Tip_25="Has conseguido que tu mascota salte. Pulsa el botón azul para decir: ¡SALTA!",
    Tip_26="Has conseguido que tu mascota se ponga en pie. Pulsa el botón azul para decir: ¡ARRIBA!",

    Tip_27="Dale varios empujoncitos hacia abajo a tu mascota para que se tumbe.",
    Tip_28="Sigue practicando con tu mascota hasta que aprenda a hacer las monerías: %s.",
    Tip_29="Las golosinas ayudarán a tu mascota a entender lo que significa %s.",

    Tip_31="Prueba a repetir la monería %s, y cuando tu mascota obedezca, dale una golosina.",
    Tip_32="Tu mascota será más obediente si le das de comer.",
    Tip_33="Tu mascota será más obediente si le das de beber.",
    Tip_34="Tu mascota será más obediente si la mimas.",
    Tip_35="Tu mascota será más obediente si la limpias.",
    Tip_36="Tu mascota será más obediente si le dejas descansar.",
    Tip_37="Tu mascota será más obediente si juegas con ella.",
    Tip_38="Tu mascota se ha esforzado mucho para obtener: %s. Una golosina le ayudaría a hacerlo mejor la próxima vez.",
    Tip_39="Tu mascota no te entenderá si le hablas demasiado deprisa.",
    Tip_40="¡Si regañas a tu mascota podría olvidar: %s!",
    Tip_41="Tu mascota ha olvidado la monería: %s.",
    Tip_42="¿Quieres ir a la cocina a dar de comer a tu mascota?",
    Tip_43="¿Quieres ir a la cocina a dar de beber a tu mascota?",
    Tip_44="¿Quieres ir a la bañera a lavar a tu mascota?",

    Tip_45="¡Tu mascota ha aprendido lo que significa PASEA!",
    Tip_46="¡Tu mascota ha aprendido lo que significa SIÉNTATE!",
    Tip_47="¡Tu mascota ha aprendido lo que significa TÚMBATE!",
    Tip_48="¡Tu mascota ha aprendido lo que significa HABLA!",
    Tip_49="¡Tu mascota ha aprendido lo que significa PATITA!",
    Tip_50="¡Tu mascota ha aprendido lo que significa PIDE!",
    Tip_51="¡Tu mascota ha aprendido lo que significa RUEDA!",
    Tip_52="¡Tu mascota ha aprendido lo que significa ESCÓNDETE!",
    Tip_53="¡Tu mascota ha aprendido lo que significa ASIENTE!",
    Tip_54="¡Tu mascota ha aprendido lo que significa SACUDE!",
    Tip_55="¡Tu mascota ha aprendido lo que significa SALTA!",
    Tip_56="¡Tu mascota ha aprendido lo que significa ARRIBA!",

    Tip_57="¿Quieres ir al patio de atrás a jugar con tu mascota?",

    Tip_58="Para lanzar un juguete, mueve el cursor de un lado a otro y pulsa el botón.",

    Tip_59="Tu mascota debe conocer 4 monerías, incluida PASEA, para participar en el concurso de talentos de nivel 1.",
    Tip_60="Tu mascota debe conocer 8 monerías para participar en el concurso de talentos de nivel 2.",
    Tip_61="Tu mascota debe conocer 12 monerías para participar en el concurso de talentos de nivel 3.",

    DogDesc_Beagle="Estos perros de caza rebosan energía. Los beagles son encantadores, pero también muy independientes, así que hace falta paciencia para entrenarlos. El pelo corto hace que sean más fáciles de cepillar. ¡Pero, ojo! A estos diablillos les encanta arañar todo lo que pillan.",
    DogDesc_Collie="Estos perros son tan inteligentes que entrenarlos es un placer. Los collies son compañeros amorosos y obedientes. Sin embargo, su largo pelaje requiere de más cuidados que los de otras razas.",
    DogDesc_Shepherd="Los pastores son unas mascotas muy leales. Su capacidad de ofrecer cariño es casi inagotable. Además, les gusta mucho aprender. Sin embargo, su pelo necesita mucha atención y suelen ladrar más que otras razas.",
    DogDesc_Retriever="A estos cachorrillos les encanta jugar. Son listos, rápidos, amistosos y cariñosos. Los labradores son perros muy inteligentes, pero tienen dificultades para mantener la atención. También necesitan más agua que otras razas, pues tienen cierta tendencia a babear.",
    DogDesc_Pug="Estos cachorrillos son muy animados. Les encanta estar todo el día jugando, y son muy cariñosos. Entrenar a un pug es complicado, pero a todos ellos les encanta recibir atención, así que no te preocupes. Demuéstrales lo mucho que los quieres y te devolverán tu cariño con creces. Además, gracias a su pelo corto, cepillarlos es un juego de niños.",

    CatDesc_Abyssinian="A este inteligente e independiente minino le encantan los lugares elevados y es capaz de saltar sobre cualquier cosa. Además, como todos los abisinios, tiene mucha más energía que otras razas. Estos gatos son capaces de pasarse horas jugando. Su fino pelaje no requiere demasiados cuidados.",
    CatDesc_Bengal="Este inteligente gato es fácil de entrenar y casi no causa problemas, así que es ideal como primera mascota. Eso sí, el bengalí necesita más comida y agua que otras razas.",
    CatDesc_Burmese="Estas inteligentes y obedientes criaturas nunca se despegan de sus propietarios. Además, los birmanos tienen la costumbre de arañar todo lo que se pone a tiro. ¡Mucha firmeza con ellos!",
    CatDesc_MaineCoon="Estos grandes gatos poseen una gran inteligencia y una rapidez sorprendente. Los maine coons aprenden trucos nuevos con facilidad, pero necesitan más comida, descanso y cuidados que las demás razas.",
    CatDesc_Siamese="Esbeltos y ágiles, los siameses son la élite del mundo felino. Les encanta la atención, pero prefieren cuidarse solos. Además, son la elocuencia personificada. ¡Si te van los maullidos, éste es tu gato!",

    foodcan_04="Comida\neconómica",
    foodcan_03="Comida\naromatizada",
    foodcan_02="Comida\norgánica",
    foodcan_01="Comida\nde lujo",
    foodbag_04="Pienso\neconómico",
    foodbag_03="Pienso\naromatizado",
    foodbag_02="Pienso\norgánico",
    foodbag_01="Pienso\nde lujo",
    waterbottle_01="Agua económica",
    waterbottle_04="Agua con\nvitaminas",
    waterbottle_03="Agua orgánica",
    waterbottle_02="Agua de lujo",
    shampoo_03="Champú\neconómico",
    shampoo_01="Champú\norgánico",
    shampoo_02="Champú\nde lujo",

    foodcan_04x="Comida\neconómica\n(3 latas)",
    foodcan_03x="Comida\naromatizada\n(3 latas)",
    foodcan_02x="Comida\norgánica\n(3 latas)",

    foodbag_04x="Pienso\neconómico\n(3 bolsas)",
    foodbag_03x="Pienso\naromatizado\n(3 bolsas)",
    foodbag_02x="Pienso\norgánico\n(3 bolsas)",

    waterbottle_01x="Agua\neconómica\n(3 botellas)",
    waterbottle_04x="Agua con\nvitaminas\n(3 botellas)",
    waterbottle_03x="Agua\norgánica\n(3 botellas)",

    shampoo_03x="Champú\neconómico\n(3 frascos)",
    shampoo_01x="Champú\norgánico\n(3 frascos)",

    treats_03x="Golosinas\neconómicas\n(3 latas)",
    treats_01x="Golosinas\norgánicas\n(3 latas)",

    brush_01="Cepillo\nde madera",
    brush_02="Cepillo\nazul cobalto",
    brush_03="Cepillo\nplateado",
    brush_04="Cepillo dorado\nde lujo",
    treats_03="Golosinas\neconómicas",
    treats_01="Golosinas\norgánicas",
    treats_02="Golosinas\nde gourmet",

    bandanacollar_01="Pañuelo\nrojo fuerte",
    collar_01="Collar de\ncuero marrón",
    collar_02="Collar de\ncuero negro",
    collar_03="Collar de\ncuero blanco",
    collar_04="Collar de\nante azul",
    collar_05="Collar de\nante verde",
    collar_06="Collar de\nante rojo",
    collar_07="Collar de\npiel de\nserpiente",
    collar_08="Collar\nenjoyado",
    floralcollar_01="Collar azul\nde flores",
    floralcollar_02="Collar rosa\nde flores",
    floralcollar_03="Collar\noscuro\nde flores",
    chaincollar_01="Collar\nplateado\nde flores",
    chaincollar_02="Collar de\ncadenas\ndoradas",
    chaincollar_03="Collar\nde cadenas\nde acero",
    gmcollar_01="Collar de\nmedalla dorada",

    booties_01="Zapatillitas",
    booties_03="Patucos de\ncuero blanco",
    booties_02="Patucos con\ntacón de acero",
    pombooties_01="Patucos con\nborlas de\ncumpleaños",
    pombooties_03="Patucos con\nborlas de\nballet",
    pombooties_02="Patucos con\nborlas de\nleopardo",
    baseballhat_01="Gorra\nde béisbol",
    beeniehat_01="Sombrerito\ncon hélice",
    sombrerohat_01="Sombrero",
    cowboyhat_01="Sombrero de\nvaquero",
    jesterhat_01="Gorro\nde juglar",
    piratehat_01="Sombrero\npirata",
    princesshat_01="Gorro\nde princesa",
    wizardhat_01="Gorro\nde mago",
    tiarahat_01="Tiara\nreal",
    vikinghat_01="Casco\nvikingo",
    mohawkhat_01="Mohawk\nverde",
    tailpom_01="Pompón rosa\npara la cola",
    tailpom_02="Pompón rojo\npara la cola",
    tailpom_03="Pompón azul\npara la cola",
    tailpom_04="Pompón de\nleopardo para\nla cola",
    tailpom_05="Pompón blanco\npara la cola",
    tailpom_06="Pompón\nbrillante\npara la cola",

livingroom_01="Salón estándar para compradores novatos",
livingroom_02="Salón moderno con un estilo contemporáneo",
livingroom_03="Salón rústico para la vida en el campo",
livingroom_04="Salón de lujo para gustos exquisitos",
Bathroom_01="Baño estándar para compradores novatos",
Bathroom_02="Baño moderno con un estilo contemporáneo",
Bathroom_03="Baño rústico para la vida en el campo",
Bathroom_04="Baño de lujo para gustos exquisitos",
Kitchen_01="Cocina estándar para compradores novatos",
Kitchen_02="Cocina moderna de estilo contemporáneo",
Kitchen_03="Cocina moderna para la vida en el campo",
Kitchen_04="Cocina de lujo para gustos exquisitos",

    foodbowl_01="Cuenco para\nla comida\nazul cobalto",
    foodbowl_03="Cuenco para\nla comida\nrojo cereza",
    foodbowl_04="Cuenco para la\ncomida con dibujo\nde galletitas",
    foodbowl_02="Cuenco para la\ncomida de\nacero inoxidable",
    arearug_01="Jarapa\nmoderna",
    arearug_02="Jarapa\nart decó",
    arearug_03="Alfombra\nestampada",
    arearug_04="Alfombra oriental\nde lujo",
    coffeetable_01="Mesa de\ncafé rústica",
    coffeetable_02="Mesa de\ncafé moderna",
    coffeetable_03="Mesa de\ncafé de lujo",
    easychair_04="Sillón de\ntela beis",
    easychair_03="Sillón de\ncuero marrón",
    easychair_02="Sillón de\nterciopelo\narrugado",
    easychair_01="Sillón de\n satén azul",
    kitchenchair_01="Silla de\ncocina moderna",
    kitchenchair_02="Silla de\ncocina rústica",
    kitchenchair_03="Silla de\ncocina de lujo",
    kitchentable_01="Mesa de\ncocina estándar",
    kitchentable_02="Mesa de cocina\nmoderna",
    kitchentable_03="Mesa de cocina\nrústica",
    kitchentable_04="Mesa de cocina\nde lujo",
    fridge_01="Nevera\nestándar",
    fridge_02="Nevera\nmoderna",
    fridge_03="Nevera\nrústica",
    fridge_04="Nevera\nde lujo",
    petbed_04="Camita de\npiel de oveja",
    petbed_01="Camita de\nterciopelo\narrugado",
    petbed_02="Camita\nacolchada",
    petbed_03="Camita de\nleopardo genuino ",
    sofa_01="Sofá de\ntela beis",
    sofa_03="Sofá de\ncuero marrón",
    sofa_04="Sofá\nacolchado",
    sofa_02="Sofá de\nsatén azul",
    toilet_01="Inodoro de\nporcelana beis",
    toilet_02="Inodoro azul\npálido",
    toilet_03="Inodoro verde\naguacate",
    toilet_04="Inodoro de\nacero inoxidable",
    tub_01="Bañera de\nporcelana beis",
    tub_02="Bañera azul\npálido",
    tub_03="Bañera verde\naguacate",
    tub_04="Bañera de\noro bruñido",
    doghouse_01="Casita\nestándar",
    doghouse_02="Casita\nmoderna",
    doghouse_03="Casita\nrústica",
    doghouse_04="Casita\nde lujo",
    ball_01="Pelota de\ntenis amarilla",
    ball_02="Pelota elástica\nazul",
    ball_03="Pelota\nde goma",
    ball_04="Pelota de\nbéisbol\nautografiada",
    ball_06="Pelota de\nlamé dorado\nde lujo",
    flyingdisc_01="Fresbee de\nplástico",
    flyingdisc_02="Fresbee\navanzado",
    flyingdisc_04="Fresbee\nprofesional",
    flyingdisc_03="Fresbee dorado\nde lujo",
    stick_01="Palo de\nmadera",
    newspaper_01="Periódico\nenrollado",
    mocassin_01="Mocasín\nde cuero",
    squeekybone_01="Hueso de\nplástico",
    teddy_01="Osito de\npeluche",
    squeekyduck_01="Patito de\nplástico",

    -- catz-specific stuff

    ball_05="Pelota de\nhilo rojo",
    jingleball_04="Pelota con\ncascabeles\nrosa",
    jingleball_02="Pelota con\ncascabeles\nazul",
    jingleball_01="Pelota con\ncascabeles\npúrpura",
    jingleball_03="Pelota de lamé\ndorado con\ncascabeles",
    toymouse_01="Ratón\nde nébeda",
    litterbox_01="Cajón de\narena verde",
    litterbox_02="Cajón de\narena azul",
    litterbox_04="Cajón de\narena rojo",
    litterbox_03="Cajón de\narena de acero\ninoxidable",
    scratchingpost_01="Arañador\nestándar",
    scratchingpost_02="Arañador\nde lujo",
    perch_02="Percha para\ngato estándar",
    perch_01="Percha para\ngato de lujo",

    Dogz_fur_01="Pelaje\nestándar 1",
    Dogz_fur_02="Pelaje\nestándar 2",
    Dogz_fur_03="Pelaje\nestándar 3",
    Dogz_fur_04="Pelaje\nde lobo",
    Dogz_fur_05="Pelaje\nde dálmata",
    Dogz_fur_06="Acero\nde robot",

    Catz_fur_01="Pelaje\nestándar 1",
    Catz_fur_02="Pelaje\nestándar 2",
    Catz_fur_03="Pelaje\nestándar 3",
    Catz_fur_04="Gris\noscuro",
    Catz_fur_05="Rojo\nnatural",
    Catz_fur_06="Rubio\nnatural",
    Catz_fur_07="Rosa\nbrillante",
    Catz_fur_08="Azul\npálido",
    Catz_fur_09="Tigre",
    Catz_fur_10="Leopardo",
    Catz_fur_11="Acero\nde robot",
    Catz_fur_12="Jirafa",
    Catz_fur_13="Cebra",
    Catz_fur_14="Guepardo",

    Dogz_MainMenuTextNoPet="Bienvenidos a Dogz.\n¡Es hora de adoptar un cachorrito!",
    Catz_MainMenuTextNoPet="Bienvenidos a Catz.\n ¡Es hora de adoptar una cría!",
    Dogz_MainMenuText="Hola de nuevo.\n¡Juega con este cachorrito o elige uno nuevo!",
    Catz_MainMenuText="Hola de nuevo.\n¡Juega con este gatito o elige uno nuevo!",

    Dogz_LoadMenuTitle="Cargar",
    Catz_LoadMenuTitle="Cargar",

    Dogz_KennelTitle="Adoptar perrito",
    Catz_KennelTitle="Adoptar gatito",

    Settings="Configuración",
    Video="Vídeo",
    Volume="Volumen",
    AntiAlias="Suavizar líneas",

    AdoptCertificate="Certificado de adopción",

    PrintYesNo="¿Seguro que quieres imprimir?",
    DeletePhotoYesNo="¿Seguro que quieres borrar esta foto?",
    DeletePetYesNo="¿Seguro que quieres borrar esta cría?",

    TOD_Heading="Truco del día",
    TOD_None="¡Pronto habrá nuevos Trucos del día!",
    TOD_Winner="Acabas de ganar %d $ con el Truco del día. ¡Bien hecho!",
    TOD_OneEasyTrick="¡Consigue que tu mascota realice la monería %s y gana %d $!",
    TOD_OneHardTrick="¡Consigue que tu mascota realice la monería %s y gana %d $!",
    TOD_TwoTricks="¡Si tu mascota hace las monerías %s y %s, ganarás %d $!",
    TOD_ThreeTricks="¡Consigue que tu mascota haga tres monerías seguidas y gana %d $!",
    TOD_OneFetch="¡Consigue que tu mascota vaya a buscar un objeto: %s y gana: %d $!",
    TOD_TwoFetches="¡Si tu mascota va a buscar un %s y luego un %s, ganarás %d $!",
    TOD_ThreeFetches="¡Consigue que tu mascota traiga tres juguetes seguidos y gana %d $!",
    TOD_Balance="Consigue que tu mascota mantenga un juguete en equilibrio sobre el morro. ¡Ganarás %d $ por cada 3 segundos!",
    TOD_Treat="Mantén una golosina sobre el morro de tu mascota todo lo que puedas. ¡Ganarás %d $ por cada 3 segundos!",
    TOD_EasyTrickPhoto="Ganarás %d $ si consigues que tu mascota haga la siguiente monería: %s.",
    TOD_HardTrickPhoto="Ganarás %d $ si consigues que tu mascota haga la siguiente monería: %s.",
    TOD_BeautyPhoto="Lava y viste a tu mascota. ¡Hazle una foto, envíala y gana un premio!",
    TOD_CutePhoto="Lava y viste a tu mascota, y luego consigue que pose. ¡Hazle una foto, envíala y gana un premio!",

ToolTip_Options="Opciones",
ToolTip_Store="Tienda",
ToolTip_Shows="Concurso de talentos",
ToolTip_Inventory="Mis cosas",
ToolTip_Camera="Haz una foto",
ToolTip_Praise="Alabar",
ToolTip_Treat="Mimar",
ToolTip_Scold="Regañar",
ToolTip_Tricks="Trucos",
ToolTip_Stats="Sobre tu mascota",

    ToolTip_CareTab="Objetos de alimentación y cuidado",
    ToolTip_ToysTab="Juguetes",
    ToolTip_ClothingTab="Ropa y accesorios",
    ToolTip_HouseTab="Decoración y modelos",

ToolTip_Bathroom="Baño",
ToolTip_LivingRoom="Sala de juegos",
ToolTip_Kitchen="Cocina",
ToolTip_Backyard="Aire libre",

    ToolTip_Promenade="¡Decir PASEA!",
    ToolTip_Sit="¡Decir SIÉNTATE!",
    ToolTip_LieDown="¡Decir TÚMBATE!",
    ToolTip_Speak="¡Decir HABLA!",
    ToolTip_GivePaw="¡Decir PATITA!",
    ToolTip_Beg="¡Decir PIDE!",
    ToolTip_RollOver="¡Decir RUEDA!",
    ToolTip_Hide="¡Decir ESCÓNDETE!",
    ToolTip_NodHead="¡Decir ASIENTE!",
    ToolTip_ShakeHead="¡Decir SACUDE!",
    ToolTip_Jump="¡Decir SALTA!",
    ToolTip_StandOnHindLegs="¡Decir ARRIBA!",


ToolTip_ShowerHead="Ducha",
ToolTip_Shampoo="Champú",
ToolTip_LeaveAttentionMode="Salir de primer plano",
ToolTip_LeaveTubMode="Salir de bañera",

    TrickName_Promenade="PASEA",
    TrickName_Sit="SIÉNTATE",
    TrickName_LieDown="TÚMBATE",
    TrickName_Speak="HABLA",
    TrickName_GivePaw="PATITA",
    TrickName_Beg="PIDE",
    TrickName_RollOver="RUEDA",
    TrickName_Hide="ESCÓNDETE",
    TrickName_NodHead="ASIENTE",
    TrickName_ShakeHead="SACUDE",
    TrickName_Jump="SALTA",
    TrickName_StandOnHindLegs="ARRIBA",

    TS_WelcomeEasy="¡Bienvenidos al concurso de talentos Petz, nivel fácil %d!",
    TS_WelcomeMedium="¡Bienvenidos al concurso de talentos Petz, nivel medio %d!",
    TS_WelcomeHard="¡Bienvenidos al concurso de talentos Petz, nivel difícil %d!",
    TS_PetID="El próximo concursante es un %s llamado %s.",
    TS_BreedGermanShepard="Pastor alemán",
    TS_BreedBorderCollie="Collie",
    TS_BreedGoldenRetriever="Labrador",
    TS_BreedBeagle="Beagle",
    TS_BreedPug="Pug ",
    TS_BreedAbyssinian="Abisinio",
    TS_BreedBengal="Bengalí",
    TS_BreedBurmese="Birmano",
    TS_BreedMaineCoon="Maine Coon",
    TS_BreedSiamese="Siamés",
    TS_PetNew="¡Demos a %s un gran aplauso!",
    TS_His="su",
    TS_Him="su",
    TS_Her="su",
    TS_PetHistory="¡%s ha estado en %d concursos de categoría %s, en los que ha ganado un total de %d $!",
    TS_Easy="Fácil",
    TS_Medium="Media",
    TS_Hard="Difícil",
    TS_ToBeat="La clasificación final de este concurso es: %s en 1º lugar, %s en 2º y %s en 3º.",
    TS_ReadyRound1="Preparados. ¡La primera ronda está a punto de empezar!",
    TS_TwoTricks="Realiza %s y %s por este orden en %d segundos. ¡Adelante!",
    TS_ThreeTricks="Realiza %s, %s y %s por este orden en %d segundos. ¡Adelante!",
    TS_ScoreRound1="¡En la primera ronda has obtenido %d puntos!",
    TS_ReadyRound2="¡Y ahora llega la ronda de cepillado y belleza!",
    TS_Round2="Pídele a %s que PASEE Para que los jueces puedan echarle un buen vistazo.",
    TS_ScoreRound2="%s ha ganado una bonificación por cepillado y belleza de %d puntos.",
    TS_TotalRound2="¡Su puntuación total hasta el momento es de %d!",
    TS_ReadyRound3="Y llega el momento de la tercera y última ronda: ¡La ronda de estilo libre!",
    TS_Round3="Consigue que %s haga todas las monerías posibles en el tiempo disponible. ¡Adelante!",
    TS_ScoreRound3="%s obtiene una bonificación en la ronda de estilo libre de %d puntos.",
    TS_RankingScore="¡Con una puntuación final de %d, %s gana el %s de %d $!",
    TS_Place1="primer premio",
    TS_Place2="segundo premio",
    TS_Place3="tercer premio",
    TS_NoRankingScore="La puntuación final en este concurso ha sido de %d. ¡Más suerte la próxima vez, %s!",
    TS_Bye="¡Gracias por acudir al concurso de talentos Petz!",

    TS_RandomName1="Spike",
    TS_RandomName2="Príncipe",
    TS_RandomName3="Duque",
    TS_RandomName4="Chico",
    TS_RandomName5="Joker",
    TS_RandomName6="Bolita",
    TS_RandomName7="Rey",
    TS_RandomName8="Maloso",
    TS_RandomName9="Negrito",
    TS_RandomName10="Cerdito",
    TS_RandomName11="Princesa",
    TS_RandomName12="Duquesa",
    TS_RandomName13="Lady",
    TS_RandomName14="Sneaker",
    TS_RandomName15="Hociquillo",
    TS_RandomName16="Tufillo",
    TS_RandomName17="Reina",
    TS_RandomName18="Cani",
    TS_RandomName19="Fluffy",
    TS_RandomName20="Flopsy",

    GermanShepard="Pastor alemán",
    BorderCollie="Collie",
    GoldenRetriever="Labrador",
    Beagle="Beagle",
    Pug="Pug",
    Abyssinian="Abisinio",
    Bengal="Bengalí",
    Burmese="Birmano",
    MaineCoon="Maine Coon",
    Siamese="Siamés",

    SelectFur="Elige un pelaje",
    SelectCollar="Elige un collar",

    Yes="Sí",
    No="No",

    AskUseKennel="¿Quieres alojar a tu gatito en una caseta por 20 $?",

    BookOfTricksAdvanced="Libro de monerías avanzadas",
    BookOfTricksExpert="Libro de monerías superiores",
    BookOfTricksSecret="Libro de monerías secretas",

 Tip_Banner="Consejos",
 Tip_62="¡Tu mascota ha aprendido suficientes trucos para participar en el concurso de talentos fácil!",
 Tip_63="¡Tu mascota ha aprendido suficientes trucos para participar en el concurso de talentos avanzado!",
 Tip_64="¡Tu mascota ha aprendido suficientes trucos para participar en el concurso de talentos experto!",
 Tip_65="Ganas 5 $ cada vez que tu mascota hace un truco.",
 Tip_66="¡Has llamado a tu mascota! Ahora puedes acariciarla y jugar con ella.",
 Tip_67="Dale a tu mascota una golosina para recompensarla cuando hace algo que te gusta.",
 Tip_68="Rocía con agua a tu mascota para regañarla cuando haga algo que no te guste.",
 Tip_69="¡Tu mascota la ha armado! Haz clic en la suciedad para limpiarla.",
 Tip_70="Usa golosinas y remojones para que tu mascota sepa dónde puede hacer sus necesidades.",
 Tip_71="Usa la alcachofa de la ducha para enjuagar a tu mascota tras enjabonarla.",
 Tip_72="Gana dinero adicional haciendo que tu mascota haga trucos o participando en concursos de talentos.",
 Tip_73="El libro de trucos te mostrará cómo enseñarle trucos a tu mascota.",
 Tip_74="Has usado toda tu comida para mascotas. Visita la tienda para comprar más.",
 Tip_75="Has usado toda el agua para mascotas. Visita la tienda para comprar más.",
 Tip_76="Has usado todo tu champú. Visita la tienda para comprar más.",
 Tip_77="Haz clic en el círculo para recoger las cosas que tiras.",
 ConfirmOverwrite ="Ya hay una mascota con ese nombre. ¿Quieres sustituirla con ésta?",
 ReadMeLink ="Readme (Léame)",
 ManualLink ="Manual",
 RegisterLink ="Registrar",
 QuitConfirm="¿Seguro que quieres salir?",
 Level1="Nivel 1",
 Level2="Nivel 2",
 Level3="Nivel 3",
 TS_LevelEasy="Fácil",
 TS_LevelAdvanced="Avanzado",
 TS_LevelExpert="Experto",
 NoBreedSelected="Raza no seleccionada",
 SelectBreed="Seleccionar raza",
 CustomizeYourPet="Personaliza tu mascota",
 NameYourPet="Pon nombre a tu mascota",
 Boy="Chico",
 Girl="Chica",
 UninstallDelete ="¿Deseas eliminar también todos los perfiles creados por el usuario?",
 Okay="Aceptar",
 AutorunPlay="Jugar",
 AutorunInstall="Instalar",
 AutorunUninstall="Desinstalar",
 AutorunReadMe="Readme (Léame)",
 AutorunManual="Manual",
 AutorunRegister="Registrar",
 AutorunQuit="Salir",
 LabelInventory="Mis cosas",
 LabelStore="Tienda Petz",
TS_YourScore="Ronda 1: %d     Ronda 2: %d     Ronda 3: %d     Total: %d",
TS_WinPlace1="¡%s gana el primer puesto! ¡Tu premio es $%d!",
TS_WinPlace2="¡%s gana el segundo puesto! ¡Tu premio es $%d!",
TS_WinPlace3="¡%s gana el tercer puesto! ¡Tu premio es $%d!",
TS_WinPlace4="%s ha quedado en último lugar. ¡Más suerte la próxima vez!",
TS_Award1="Primer puesto",
TS_Award2="Segundo puesto",
TS_Award3="Tercer puesto",
TS_Award4="Cuarto puesto",
TS_Score="Puntuación: %d",

StatBreed="Raza",
StatBirthday="Cumpleaños",
StatIntelligence="Inteligencia",
StatAgility="Agilidad",
StatStamina="Resistencia",
StatObedience="Obediencia",

NeedLove="Amor",
NeedHunger="Hambre",
NeedThirst="Sed",
NeedGrooming="Aseo",
NeedAlertness="Atención",

BookOfTricks="Libro de trucos de principiante",
ReturnHouse="Volver a la casa",

ToolTip_ReturnToHouse="Volver a la casa",
BrushPrompt="¿Quieres ir al baño a cepillar a tu mascota?",
remove_clothes="Quitar todas las ropas",

NeedLoveGreen="Juega con tu mascota para que se sienta querida.",
NeedLoveYellow="Tu mascota está sola. Acaríciala o juega con ella.",
NeedLoveRed="Tu mascota está sola. Acaríciala o juega con ella.",
NeedHungerGreen="Alimenta a tu mascota cuando tenga hambre.",
NeedHungerYellow="Tu mascota tiene hambre. Es hora de alimentarla.",
NeedHungerRed="Tu mascota tiene hambre. Es hora de alimentarla.",
NeedThirstGreen="Da de beber a tu mascota cuando esté sedienta.",
NeedThirstYellow="Tu mascota tiene sed. Es hora de darle agua.",
NeedThirstRed="Tu mascota tiene sed. Es hora de darle agua.",
NeedGroomingGreen="Limpia o cepilla a tu mascota cuando esté sucia.",
NeedGroomingYellow="Tu mascota está sucia. Es hora de cepillarla o lavarla con champú.",
NeedGroomingRed="Tu mascota está sucia. Es hora de cepillarla o lavarla con champú.",
NeedAlertnessGreen="Deja que tu mascota duerma cuando esté cansada.",
NeedAlertnessYellow="Tu mascota está cansada. Es hora de dejarla dormir.",
NeedAlertnessRed="Tu mascota está cansada. Es hora de dejarla dormir.",

StatIntelligenceTip="Lo rápido que aprende tu mascota.",
StatAgilityTip="Lo bien que tu mascota realiza trucos difíciles.",
StatStaminaTip="Lo rápido que se cansa tu mascota.",
StatObedienceTip="Con cuánta frecuencia tu mascota hace lo que le dices.",

Tip_78="Tu mascota está muy cansada. Es hora de que duerma un rato.",
Tip_79="¡Bienvenido! Tu mascota te ha echado de menos.",

-- PLEASE add all new text BELOW this line, or it will not get translated! -BM

    PrinterNotFound="No hay ninguna impresora. Comprueba que está encendida y conectada.",

    BrushPrompt2="¿Quieres cepillar a tu mascota?",

    Tip_80="Llevará tiempo que tu mascota aprenda más trucos. Sigue enseñando a tu mascota trucos cómo %s, y dala una golosina cuando obedezca.",

    NeedsTitle="Necesidades",
    StatsTitle="Rasgos",

    ubisoft_copyright = "(C) Ubisoft",
}

language.German = {

    YouWin="Du hast gewonnen!",
    YouLose="Du hast verloren!",
    Round="Runde %d",
    BonusUnlocked="Bonus freigeschaltet!",
    GotoMainMenu="Bist du sicher, dass du zum Hauptmenü möchtest?",
    Paused="Angehalten",
    Pause="Angehalten",
    Loading="Lädt",
    Uninstall="Deinstallieren",

    SettingTitle="Einstellungen",
    SettingsVolume="Lautstärke",
    SettingsVideo="Video",
    SettingsAntiAliasing="Weichere Linien",

    Tip_01="Klicke auf den Bildschirm, um deinen neuen Liebling zu rufen.",
    Tip_02="Dein Liebling hat Hunger. In deinem Koffer ist Futter.",
    Tip_03="Dein Liebling hat Durst. In deinem Koffer ist Wasser.",
    Tip_04="Dein Liebling braucht ein Bad. Shampoo gibt es im Petz-Store.",
    Tip_05="Dein Liebling ist müde. Gönn ihm etwas Ruhe.",
    Tip_06="Dein Liebling braucht Liebe. Kraul ihn eine Zeit lang.",
    Tip_07="Das ist der Petz-Store. Hier kannst du alles kaufen, was dein Liebling braucht.",
    Tip_08="Das ist dein Koffer. Dinge, die du kaufst, werden hier drin aufbewahrt.",
    Tip_09="Belohne deinen Liebling, indem du ihm ein Leckerchen gibst.",
    Tip_10="Schimpf mit deinem Liebling, indem du ihn mit Wasser bespritzt.",
    Tip_11="Benutze diesen Button, um deinem Liebling Befehle zu geben.",
    Tip_12="Dieses Kästchen zeigt an, wie sich dein Liebling gerade fühlt.",
    Tip_13="Drücke die Maustaste und rubbele deinen Liebling. Er liebt Aufmerksamkeit!",
    Tip_14="Drücke die Maustaste und drücke deinen Liebling herunter, damit er Sitz macht.",
    Tip_15="Du hast deinem Liebling befohlen, im Kreis zu laufen. Drücke den blauen Button, um LAUF HERUM zu befehlen!",
    Tip_16="Du hast deinem Liebling befohlen, Sitz zu machen. Drücke den blauen Button, um SITZ zu befehlen!",
    Tip_17="Du hast deinem Liebling befohlen, Platz zu machen. Drücke den blauen Button, um PLATZ zu befehlen!",
    Tip_18="Du hast deinem Liebling befohlen, Laut zu geben. Drücke den blauen Button, um GIB LAUT zu befehlen!",
    Tip_19="Du hast deinem Liebling befohlen, Pfötchen zu geben. Drücke den blauen Button, um GIB PFÖTCHEN zu befehlen!",
    Tip_20="Du hast deinem Liebling befohlen, zu betteln. Drücke den blauen Button, um BETTEL zu befehlen!",
    Tip_21="Du hast deinem Liebling befohlen, herumzurollen. Drücke den blauen Button, um ROLL HERUM zu befehlen!",
    Tip_22="Du hast deinem Liebling befohlen, sein Gesicht zu verstecken. Drücke den blauen Button, um VERSTECK DICH zu befehlen!",
    Tip_23="Du hast deinem Liebling befohlen, zu nicken. Drücke den blauen Button, um NICKE MIT DEM KOPF zu befehlen!",
    Tip_24="Du hast deinem Liebling befohlen, den Kopf zu schütteln. Drücke den blauen Button, um SCHÜTTLE DEN KOPF zu befehlen!",
    Tip_25="Du hast deinem Liebling befohlen, hochzuspringen. Drücke den blauen Button, um SPRING zu befehlen!",
    Tip_26="Du hast deinem Liebling befohlen, sich aufzurichten. Drücke den blauen Button, um MACH MÄNNCHEN zu befehlen!",
    Tip_27="Drücke ein paar Mal auf deinen Liebling, damit er sich hinlegt.",
    Tip_28="Zeig ihm immer wieder, wie man %s macht, bis er das Kunststück beherrscht.",
    Tip_29="Ein Leckerchen hilft deinem Liebling, zu verstehen, was %s bedeutet.",

    Tip_31="Sag %s noch mal und gib deinem Liebling ein Leckerchen, wenn er gehorcht.",
    Tip_32="Dein Liebling gehorcht eher, wenn du ihn fütterst.",
    Tip_33="Dein Liebling gehorcht eher, wenn du ihm Wasser gibst.",
    Tip_34="Dein Liebling gehorcht eher, wenn du ihn kraulst.",
    Tip_35="Dein Liebling gehorcht eher, wenn du ihn wäschst.",
    Tip_36="Dein Liebling gehorcht eher, wenn du ihn ausruhen lässt.",
    Tip_37="Dein Liebling gehorcht eher, wenn du mit ihm spielst.",
    Tip_38="Dein Liebling hat sich Mühe gegeben, %s zu machen. Mit einem Leckerchen geht es vielleicht besser.",
    Tip_39="Dein Liebling versteht dich nicht, wenn du zu schnell sprichst.",
    Tip_40="Dein Liebling könnte wieder vergessen, wie man %s macht, wenn du mit ihm schimpfst!",
    Tip_41="Dein Liebling hat das Kunststück %s vergessen.",
    Tip_42="Möchtest du in die Küche gehen, um deinen Liebling zu füttern?",
    Tip_43="Möchtest du in die Küche gehen, um deinem Liebling Wasser zu geben?",
    Tip_44="Möchtest du zur Badewanne gehen, um deinen Liebling zu waschen?",

    Tip_45="Dein Liebling hat verstanden, was HERUMLAUFEN bedeutet!",
    Tip_46="Dein Liebling hat verstanden, was SITZ bedeutet!",
    Tip_47="Dein Liebling hat verstanden, was PLATZ bedeutet!",
    Tip_48="Dein Liebling hat verstanden, was GIB LAUT bedeutet!",
    Tip_49="Dein Liebling hat verstanden, was GIB PFÖTCHEN bedeutet!",
    Tip_50="Dein Liebling hat verstanden, was BETTEL bedeutet!",
    Tip_51="Dein Liebling hat verstanden, was ROLL HERUM bedeutet!",
    Tip_52="Dein Liebling hat verstanden, was VERSTECK DICH bedeutet!",
    Tip_53="Dein Liebling hat verstanden, was KOPFNICKEN bedeutet!",
    Tip_54="Dein Liebling hat verstanden, was KOPFSCHÜTTELN bedeutet!",
    Tip_55="Dein Liebling hat verstanden, was SPRING bedeutet!",
    Tip_56="Dein Liebling hat verstanden, was MACH MÄNNCHEN bedeutet!",

    Tip_57="Möchtest du in den Hinterhof gehen, um mit deinem Liebling zu spielen?",

    Tip_58="Um ein Spielzeug zu werfen, schwing mit dem Cursor und drücke die Maustaste.",

    Tip_59="Dein Liebling muss 4 Kunststücke, inklusive LAUF HERUM, beherrschen, um am Talentwettbewerb teilzunehmen.",
    Tip_60="Dein Liebling muss acht Kunststücke beherrschen, um am Talentwettbewerb auf Niveau 2 teilzunehmen.",
    Tip_61="Dein Liebling muss zwölf Kunststücke beherrschen, um am Talentwettbewerb auf Niveau 3 teilzunehmen.",

    DogDesc_Beagle="Beagles sind wahre Energiebündel. Diese Jagdhunde sind sehr liebevoll, aber auch sehr freiheitsliebend. Deshalb braucht man Geduld, sie zu erziehen.\nDas kurze Fell ist leicht zu pflegen. Doch Vorsicht! Diese kleinen Schlingel zerkratzen alles, was ihnen zwischen die Pfoten kommt.",
    DogDesc_Collie="Border Collies sind intelligente Hunde und es ist eine Freude, sie zu erziehen.\nSie sind liebevolle und gehorsame Gefährten. Ihr langes Fell benötigt jedoch mehr Pflege als das anderer Rassen.",
    DogDesc_Shepherd="Schäferhunde sind treue Tiere. Ihre Liebe ist nahezu grenzenlos. Sie sind außerdem sehr gelehrige Schüler. Ihr langes Fell ist jedoch etwas schwierig zu pflegen und sie bellen auch mehr als andere Rassen.",
    DogDesc_Retriever="Labrador-Welpen spielen für ihr Leben gern.\nSie sind schlau und schnell, freundlich und liebevoll. Labradore lernen schnell, haben aber manchmal Schwierigkeiten, sich zu konzentrieren. Sie brauchen auch mehr Wasser als andere Rassen, da sie dazu neigen, zu sabbern.",
    DogDesc_Pug="Mops-Welpen sind kleine Witzbolde. Sie lieben es, zu spielen und sie sind sehr liebevoll. Einen Mops zu erziehen ist schwierig, doch sie lieben die Aufmerksamkeit, weshalb es dir bestimmt nichts ausmacht. Gib ihnen all deine Liebe und sie werden sie dir sogleich zurück geben. Das kurze Fell macht die Pflege völlig unkompliziert.",

    CatDesc_Abyssinian="Abessinier-Katzen sind intelligente, unabhängige Tiere, die hochliegende Plätze lieben. Sie werden auf alles Mögliche draufspringen. Abessinier verfügen auch über viel mehr Energie als andere Rassen. Sie können viele Stunden ununterbrochen spielen. Ihr glattes Fell bedarf keiner umfangreichen Pflege.",
    CatDesc_Bengal="Die Bengal-Katze ist schlau und daher leicht zu erziehen und fast völlig problemlos. Sie eignet sich perfekt für neue Katzenbesitzer. Sie braucht mehr Futter und Wasser als andere Rassen.",
    CatDesc_Burmese="Burma-Katzen sind intelligente, gehorsame Katzen, die sich in der Nähe ihrer Besitzer aufhalten. Sie neigen auch dazu, alles zu kratzen, was sich ihnen nähert. Sei streng!",
    CatDesc_MaineCoon="Maine Coons sind sehr schlau und erstaunlich schnell. Sie lernen neue Kunststücke sehr schnell, aber sie brauchen mehr Futter, Ruhe und Pflege als andere Rassen.",
    CatDesc_Siamese="Die geschmeidigen und flinken Siam-Katzen sind die Elite der Katzenwelt. Sie lieben die Aufmerksamkeit, aber sie ziehen es vor, sich allein zu beschäftigen. Sie geben außerdem viele Geräusche von sich. Wenn du Miauen liebst, dann ist das deine Katze!",

    foodcan_04="Tierfutter zum\nSparpreis",
    foodcan_03="Aromatisiertes\nTierfutter",
    foodcan_02="Biologisches\nTierfutter",
    foodcan_01="Luxus-Tierfutter",
    foodbag_04="Trockenfutter\nzum Sparpreis",
    foodbag_03="Trockenfutter\nin verschiedenen\nGeschmacksrichtungen",
    foodbag_02="Biologisches\nTrockenfutter",
    foodbag_01="Luxus-Trockenfutter",
    waterbottle_01="Wasser zum\nSparpreis",
    waterbottle_04="Wasser mit\nVitaminen\nangereichert",
    waterbottle_03="Biologisches\nWasser",
    waterbottle_02="Luxus-Wasser",
    shampoo_03="Shampoo zum\nSparpreis",
    shampoo_01="Biologisches\nShampoo",
    shampoo_02="Luxus-Shampoo",

    foodcan_04x="Tierfutter\nzum Sparpreis\n(3 Dosen)",
    foodcan_03x="Tierfutter\nin verschiedenen Geschmacksrichtungen (3 Dosen)",
    foodcan_02x="Biologisches\nTierfutter\n(3 Dosen)",

    foodbag_04x="Trockenfutter\nzum Sparpreis\n(3 Beutel)",
    foodbag_03x="Aromatisiertes\nTrockenfutter\n(3 Beutel)",
    foodbag_02x="Biologisches\nTrockenfutter\n(3 Beutel)",

    waterbottle_01x="Wasser zum\nSparpreis\n(3 Flaschen)",
    waterbottle_04x="Wasser mit Vitaminen\nangereichert\n(3 Flaschen)",
    waterbottle_03x="Biologisches\nWasser\n(3 Flaschen)",

    shampoo_03x="Shampoo\nzum Sparpreis\n(3 Flaschen)",
    shampoo_01x="Biologisches\nShampoo\n(3 Flaschen)",

    treats_03x="Leckerchen\nzum Sparpreis\n(3 Dosen)",
    treats_01x="Biologische\nLeckerchen\n(3 Dosen)",

    brush_01="Fellbürste\naus Holz",
    brush_02="Kobaltblaue\nFellbürste",
    brush_03="Fellbürste aus\nSterlingsilber",
    brush_04="Luxuriöse,\ngoldene Fellbürste",
    treats_03="Leckerchen\nzum Sparpreis",
    treats_01="Biologische\nLeckerchen ",
    treats_02="Gourmet-\nLeckerchen",

    bandanacollar_01="Leuchtend rotes\nHalstuch",
    collar_01="Braunes\nLederhalsband",
    collar_02="Schwarzes\nLederhalsband",
    collar_03="Weißes\nLederhalsband",
    collar_04="Blaues\nWildlederhalsband",
    collar_05="Grünes\nWildlederhalsband",
    collar_06="Rotes\nWildlederhalsband",
    collar_07="Krokoleder-\nhalsband",
    collar_08="Juwelenhalsband",
    floralcollar_01="Blaues\nBlumenhalsband",
    floralcollar_02="Pinkes\nBlumenhalsband",
    floralcollar_03="Dunkles\nBlumenhalsband",
    chaincollar_01="Silbernes\nKettenhalsband",
    chaincollar_02="Goldenes\nKettenhalsband",
    chaincollar_03="Stahl-\nKettenhalsband",
    gmcollar_01="Goldmedaillen-\nhalsband",

    booties_01="Athletische\nSchühchen",
    booties_03="Weiße\nLederschühchen",
    booties_02="Stahlkappen-\nschühchen",
    pombooties_01="Urlaubsschühchen\nmit Bommeln",
    pombooties_03="Ballettschühchen\nmit Bommeln",
    pombooties_02="Schühchen mit\nLeopardenmuster\nund Bommeln",
    baseballhat_01="Baseball-Kappe",
    beeniehat_01="Propeller-Kappe",
    sombrerohat_01="Sombrero",
    cowboyhat_01="Cowboy-Hut",
    jesterhat_01="Narrenkappe",
    piratehat_01="Piratenhut",
    princesshat_01="Prinzessinnen-\nhut",
    wizardhat_01="Hexenhut",
    tiarahat_01="Königliches\nDiadem",
    vikinghat_01="Wikingerhelm",
    mohawkhat_01="Grüner\nIrokesenschnitt",
    tailpom_01="Pinker\nSchwänzchenbommel",
    tailpom_02="Roter\nSchwänzchenbommel",
    tailpom_03="Blauer\nSchwänzchenbommel",
    tailpom_04="Leopardenmuster-\nSchwänzchenbommel",
    tailpom_05="Weißer\nSchwänzchenbommel",
    tailpom_06="Glitzernder\nSchwänzchenbommel",

livingroom_01="Standard-Wohnzimmer\nfür die\nErstausstattung",
livingroom_02="Modernes Wohnzimmer\nim zeitgenössischen\nStil",
livingroom_03="Rustikales\nWohnzimmer im\nLandhausstil",
livingroom_04="Luxus-Wohnzimmer\nfür den\ngehobenen Geschmack",
Bathroom_01="Standard-Badezimmer\nfür die\nErstausstattung",
Bathroom_02="Modernes Badezimmer\nim zeitgenössischen\nStil",
Bathroom_03="Rustikales\nBadezimmer\nim Landhausstil",
Bathroom_04="Luxus-Badezimmer\nfür den\ngehobenen Geschmack",
Kitchen_01="Standard-Küche\nfür die\nErstausstattung",
Kitchen_02="Moderne Küche\nim zeitgenössischen\nStil",
Kitchen_03="Rustikale\nKüche im\nLandhausstil",
Kitchen_04="Luxus-Küche für\nden gehobenen\nGeschmack",

    foodbowl_01="Kobaltblauer\nFressnapf",
    foodbowl_03="Kirschroter\nFressnapf",
    foodbowl_04="Fressnapf mit\nKeksmuster",
    foodbowl_02="Fressnapf aus\nrostfreiem Stahl",
    arearug_01="Moderner\nLäufer",
    arearug_02="Art Deco-Läufer",
    arearug_03="Gemusterter\nTeppich",
    arearug_04="Luxuriöser\nOrientteppich",
    coffeetable_01="Rustikaler\nCouchtisch",
    coffeetable_02="Moderner\nCouchtisch",
    coffeetable_03="Luxus-Couchtisch",
    easychair_04="Beigefarbener\nStoffsessel",
    easychair_03="Brauner\nLedersessel",
    easychair_02="Sessel aus\ngeknittertem\nVelours",
    easychair_01="Blauer\nSatinsessel",
    kitchenchair_01="Moderner\nKüchenstuhl",
    kitchenchair_02="Rustikaler\nKüchenstuhl",
    kitchenchair_03="Luxus-\nKüchenstuhl",
    kitchentable_01="Einfacher\nKüchentisch",
    kitchentable_02="Moderner\nKüchentisch",
    kitchentable_03="Rustikaler\nKüchentisch",
    kitchentable_04="Luxus-\nKüchentisch",
    fridge_01="Einfacher\nKühlschrank",
    fridge_02="Moderner\nKühlschrank",
    fridge_03="Rustikaler\nKühlschrank",
    fridge_04="Luxus-\nKühlschrank",
    petbed_04="Schaffell-\nDecke",
    petbed_01="Decke aus\ngeknittertem\nVelours",
    petbed_02="Handgesteppte\nDecke",
    petbed_03="Echte\nLeopardenfell-Decke",
    sofa_01="Beigefarbenes\nStoffsofa",
    sofa_03="Braunes\nLedersofa",
    sofa_04="Gestepptes\nSofa",
    sofa_02="Blaues\nSatinsofa",
    toilet_01="Beigefarbene\nPorzellantoilette",
    toilet_02="Pudrig-blaue\nToilette",
    toilet_03="Zart avocadogrüne\nToilette",
    toilet_04="Toilette aus\nrostfreiem Stahl",
    tub_01="Beigefarbene\nPorzellanbadewanne",
    tub_02="Pudrig-blaue\nPorzellanbadewanne",
    tub_03="Zart avocadogrüne\nPorzellanbadewanne",
    tub_04="Goldglänzende\nBadewanne",
    doghouse_01="Einfaches\nTierhäuschen",
    doghouse_02="Modernes\nTierhäuschen",
    doghouse_03="Rustikales\nTierhäuschen",
    doghouse_04="Luxus-\nTierhäuschen",
    ball_01="Gelber\nTennisball",
    ball_02="Blauer\nQuietschball",
    ball_03="Gummiband-Ball",
    ball_04="Baseball mit\nAutogramm",
    ball_06="Goldener\nLuxusball",
    flyingdisc_01="Frisbeescheibe\naus Plastik",
    flyingdisc_02="Frisbeescheibe\nfür Fortgeschrittene",
    flyingdisc_04="Frisbeescheibe\nfür Experten",
    flyingdisc_03="Goldene Luxus-\nFrisbeescheibe",
    stick_01="Holzstöckchen",
    newspaper_01="Aufgerollte\nZeitung",
    mocassin_01="Lederner\nMokassin",
    squeekybone_01="Gummiknochen",
    teddy_01="Stoffteddy",
    squeekyduck_01="Quakende\nEnte",

    -- catz-specific stuff

    ball_05="Rotes\nWollknäuel",
    jingleball_04="Pinker\nKlimperball",
    jingleball_02="Blauer\nKlimperball",
    jingleball_01="Klimperball in\nköniglichem\nviolett",
    jingleball_03="Goldener\nKlimperball",
    toymouse_01="Maus aus\nKatzenminze",
    litterbox_01="Grünes Klo",
    litterbox_02="Blaues Klo",
    litterbox_04="Rotes Klo",
    litterbox_03="Klo aus\nrostfreiem\nStahl",
    scratchingpost_01="Einfacher\nKratzbaum",
    scratchingpost_02="Luxus-Kratzbaum",
    perch_02="Einfacher\nKatzensitzplatz",
    perch_01="Luxus-\nKatzensitzplatz",

    Dogz_fur_01="Einfaches Fell 1",
    Dogz_fur_02="Einfaches Fell 2",
    Dogz_fur_03="Einfaches Fell 3",
    Dogz_fur_04="Timberwolffell",
    Dogz_fur_05="Dalmatinerfell",
    Dogz_fur_06="Roboterstahl",

    Catz_fur_01="Einfaches Fell 1",
    Catz_fur_02="Einfaches Fell 2",
    Catz_fur_03="Einfaches Fell 3",
    Catz_fur_04="Blassgrau",
    Catz_fur_05="Naturrot",
    Catz_fur_06="Naturblond",
    Catz_fur_07="Krasses Pink",
    Catz_fur_08="Pudriges Blau",
    Catz_fur_09="Tiger",
    Catz_fur_10="Leopard",
    Catz_fur_11="Roboterstahl",
    Catz_fur_12="Giraffe",
    Catz_fur_13="Zebra",
    Catz_fur_14="Gepard",

    Dogz_MainMenuTextNoPet="Willkommen zu Dogz.\nEs wird Zeit, dein erstes Hündchen zu adoptieren!",
    Catz_MainMenuTextNoPet="Willkommen zu Catz.\nEs wird Zeit, dein erstes Kätzchen zu adoptieren!",
    Dogz_MainMenuText="Willkommen zurück zu Dogz.\nSpiel mit diesem Hündchen oder wähle ein neues!",
    Catz_MainMenuText="Willkommen zurück zu Catz.\nSpiel mit diesem Kätzchen oder wähle ein neues!",

    Dogz_LoadMenuTitle="Lade Hund",
    Catz_LoadMenuTitle="Lade Katze",

    Dogz_KennelTitle="Hündchen adoptieren",
    Catz_KennelTitle="Kätzchen adoptieren",

    Settings="Einstellungen",
    Video="Video",
    Volume="Lautstärke",
    AntiAlias="Weichere Linien",

    AdoptCertificate="Adoptionsurkunde",

    PrintYesNo="Bist du sicher, dass du drucken willst?",
    DeletePhotoYesNo="Bist du sicher, dass du dieses Foto löschen möchtest?",
    DeletePetYesNo="Bist du sicher, das du diesen Liebling löschen willst?",

    TOD_Heading="Kunststück des Tages",
    TOD_None="Achte auf das nächste Kunststück des Tages, das bald kommt!",
    TOD_Winner="Du hast gerade $%d beim Kunststück des Tages gewonnen. Gut gemacht!",
    TOD_OneEasyTrick="Lass deinen Liebling das Kunststück %s vorführen und gewinne $%d!",
    TOD_OneHardTrick="Lass deinen Liebling das Kunststück %s vorführen und gewinne $%d!",
    TOD_TwoTricks="Lass deinen Liebling erst %s und dann %s vorführen und gewinne $%d!",
    TOD_ThreeTricks="Lass deinen Liebling drei verschiedene Kunststücke hintereinander vorführen und gewinne $%d!",
    TOD_OneFetch="Lass deinen Liebling das Spielzeug %s holen und gewinne $%d!",
    TOD_TwoFetches="Lass deinen Liebling die Spielzeuge %s und %s holen und gewinne $%d!",
    TOD_ThreeFetches="Lass deinen Liebling drei verschiedene Spielzeuge hintereinander holen und gewinne $%d!",
    TOD_Balance="Lass deinen Liebling ein Spielzeug auf der Schnauze balancieren. Alle drei Sekunden gewinnst du $%d!",
    TOD_Treat="Halte ein Leckerchen über die Schnauze deines Lieblings solange du kannst. Alle drei Sekunden gewinnst du $%d!",
    TOD_EasyTrickPhoto="Schicke ein neues Foto deines Lieblings ein, wie er das Kunststück %s macht und gewinne %&d!",
    TOD_HardTrickPhoto="Schicke ein neues Foto deines Lieblings ein, wie er das Kunststück %s macht und gewinne %&d!",
    TOD_BeautyPhoto="Wasche deinen Liebling und zieh ihn fein an. Schicke dann ein Foto ein, um einen Preis zu gewinnen!",
    TOD_CutePhoto="Wasche deinen Liebling, zieh ihn fein an und lass ihn Modell stehen. Schicke dann ein Foto ein, um einen Preis zu gewinnen!",

ToolTip_Options="Optionen",
ToolTip_Store="Einkaufen",
ToolTip_Shows="Talent-Shows",
ToolTip_Inventory="Mein Kram",
ToolTip_Camera="Foto schießen",
ToolTip_Praise="Loben",
ToolTip_Treat="Leckerchen",
ToolTip_Scold="Schimpfen",
ToolTip_Tricks="Tricks",
ToolTip_Stats="Tierstatus",


    ToolTip_CareTab="Futter und Pflegezubehör",
    ToolTip_ToysTab="Spielzeuge",
    ToolTip_ClothingTab="Kleidung und Accessoires",
    ToolTip_HouseTab="Wohnausstattung und Möbel",

ToolTip_Bathroom="Badezimmer",
ToolTip_LivingRoom="Wohnzimmer",
ToolTip_Kitchen="Küche",
ToolTip_Backyard="Draußen",

    ToolTip_Promenade="Befiehl LAUF HERUM",
    ToolTip_Sit="Befiehl SITZ!",
    ToolTip_LieDown="Befiehl PLATZ!",
    ToolTip_Speak="Befiehl GIB LAUT!",
    ToolTip_GivePaw="Befiehl GIB PFÖTCHEN!",
    ToolTip_Beg="Befiehl BETTEL!",
    ToolTip_RollOver="Befiehl ROLL DICH!",
    ToolTip_Hide="Befiehl VERSTECK DICH!",
    ToolTip_NodHead="Befiehl NICKE MIT DEM KOPF!",
    ToolTip_ShakeHead="Befiehl SCHÜTTLE DEN KOPF!",
    ToolTip_Jump="Befiehl SPRING!",
    ToolTip_StandOnHindLegs="Befiehl MACH MÄNNCHEN!",

    ToolTip_ShowerHead="Dusche",
    ToolTip_Shampoo="Shampoo",
    ToolTip_LeaveAttentionMode="Nahaufnahme verlassen",
    ToolTip_LeaveTubMode="Badewanne verlassen",

    TrickName_Promenade="LAUF HERUM",
    TrickName_Sit="SITZ",
    TrickName_LieDown="PLATZ",
    TrickName_Speak="GIB LAUT",
    TrickName_GivePaw="GIB PFÖTCHEN",
    TrickName_Beg="BETTEL",
    TrickName_RollOver="ROLL DICH",
    TrickName_Hide="VERSTECK DICH",
    TrickName_NodHead="NICKEN",
    TrickName_ShakeHead="SCHÜTTELN",
    TrickName_Jump="SPRING",
    TrickName_StandOnHindLegs="MÄNNCHEN",

    TS_WelcomeEasy="Willkommen zum Petz Talentwettbewerb, leichtes Niveau, %d. Teilnahme!",
    TS_WelcomeMedium="Willkommen zum Petz Talentwettbewerb, mittelschweres Niveau, %d. Teilnahme!",
    TS_WelcomeHard="Willkommen zum Petz Talentwettbewerb, schweres Niveau, %d. Teilnahme!",
    TS_PetID="Unser nächster Kandidat ist ein %s namens %s. ",
    TS_BreedGermanShepard="Deutscher Schäferhund-Welpe",
    TS_BreedBorderCollie="Border Collie-Welpe",
    TS_BreedGoldenRetriever="Labrador Retriever-Welpe",
    TS_BreedBeagle="Beagle-Welpe",
    TS_BreedPug="Mops-Welpe",
    TS_BreedAbyssinian="Abessinier-Kätzchen",
    TS_BreedBengal="Bengal-Kätzchen",
    TS_BreedBurmese="Burma-Kätzchen",
    TS_BreedMaineCoon="Maine Coon-Kätzchen",
    TS_BreedSiamese="Siam-Kätzchen",
    TS_PetNew="%s nimmt zum ersten Mal an diesem Wettbewerb teil. Begrüßen wir %s! ",
    TS_His="sein",
    TS_Him="ihm",
    TS_Her="ihr",
    TS_PetHistory="%s hat schon an %d %s-Wettbewerb(en) teilgenommen und dabei insgesamt $%d gewonnen!",
    TS_Easy="Leicht",
    TS_Medium="Mittelschwer",
    TS_Hard="Schwer",
    TS_ToBeat="Die Lieblinge, die heute besiegt werden müssen, sind %s an erster Stelle, %s an zweiter Stelle und %s an dritter Stelle.",
    TS_ReadyRound1="Mach dich bereit. Der 1. Durchgang beginnt gleich!",
    TS_TwoTricks="Führe %s und %s nacheinander innerhalb von %d Sekunden vor. Los!",
    TS_ThreeTricks="Führe %s, %s und %s nacheinander innerhalb von %d Sekunden vor. Los!",
    TS_ScoreRound1="Deine Punktzahl für den 1. Durchgang beträgt %d!",
    TS_ReadyRound2="Jetzt ist der Pflege- und Schönheitsdurchgang dran!",
    TS_Round2="Sag %s, dass er HERUMLAUFEN soll, damit die Richter %s ansehen können.",
    TS_ScoreRound2="%s gewinnt einen Pflege- und Schönheits-Bonus von %d Punkten.",
    TS_TotalRound2="Gesamtpunktzahl beträgt jetzt %d Punkte!",
    TS_ReadyRound3="Mach dich bereit für unseren dritten und letzten Durchgang: Freestyle!",
    TS_Round3="Lass %s so viele verschiedene Kunststücke vorführen, wie du kannst, bevor die Zeit um ist. Los!",
    TS_ScoreRound3="%s gewinnt einen Freestyle-Bonus von %d Punkten.",
    TS_RankingScore="Mit einer Gesamtpunktzahl von %d gewinnt %s %s von $%d!",
    TS_Place1="erster Preis",
    TS_Place2="zweiter Preis",
    TS_Place3="dritter Preis",
    TS_NoRankingScore="Die Endpunktzahl für diesen Wettbewerb beträgt %d. Nächstes Mal mehr Glück %s!",
    TS_Bye="Danke, dass du den Petz-Talentwettbewerb besucht hast!",

    TS_RandomName1="Spike",
    TS_RandomName2="Prinz",
    TS_RandomName3="Rex",
    TS_RandomName4="Kumpel",
    TS_RandomName5="Witzbold",
    TS_RandomName6="Fellknäuel",
    TS_RandomName7="Franz",
    TS_RandomName8="Killer",
    TS_RandomName9="Blackie",
    TS_RandomName10="Schweinchen",
    TS_RandomName11="Prinzessin",
    TS_RandomName12="Madame",
    TS_RandomName13="Lady",
    TS_RandomName14="Schleicher",
    TS_RandomName15="Schnäuzchen",
    TS_RandomName16="Stinker",
    TS_RandomName17="Sissi",
    TS_RandomName18="Winzling",
    TS_RandomName19="Fluffy",
    TS_RandomName20="Schluffi",

    GermanShepard="Deutscher Schäferhund",
    BorderCollie="Border Collie",
    GoldenRetriever="Labrador Retriever",
    Beagle="Beagle",
    Pug="Mops",
    Abyssinian="Abessinier",
    Bengal="Bengale",
    Burmese="Burmeser",
    MaineCoon="Maine Coon",
    Siamese="Siam",

    SelectFur="Wähle ein Fell",
    SelectCollar="Wähle ein Halsband",

    Yes="Ja",
    No="Nein",

    AskUseKennel="Möchtest du deinen Liebling für $20 in Pflege geben?",

    BookOfTricksAdvanced="Buch der\nKunststücke für\nFortgeschrittene",
    BookOfTricksExpert="Buch der\nKunststücke für\nExperten",
    BookOfTricksSecret="Geheimes Buch\nder Kunststücke",

 Tip_Banner="Tipps",
 Tip_62="Dein Tier hat genug Tricks gelernt, um in der Anfänger-Talentshow aufzutreten!",
 Tip_63="Dein Tier hat genug Tricks gelernt, um in der Fortgeschrittenen-Talentshow aufzutreten!",
 Tip_64="Dein Tier hat genug Tricks gelernt, um in der Experten-Talentshow aufzutreten!",
 Tip_65="Für jeden Trick, den dein Haustier vorführt, bekommst du 5$.",
 Tip_66="Du hast gerade dein Haustier gerufen. Jetzt kannst du es streicheln und mit ihm spielen.",
 Tip_67="Gib deinem Haustier ein Leckerchen als Belohnung, wenn es etwas richtig macht.",
 Tip_68="Spritze dein Haustier nass, um es auszuschimpfen, wenn es etwas falsch macht.",
 Tip_69="Dein Haustier hat eine Sauerei angerichtet! Klicke darauf, um sauber zu machen.",
 Tip_70="Benutze Leckerchen und Nassspritzen, um deinem Haustier beizubringen, wo es okay ist, sein Geschäft zu verrichten.",
 Tip_71="Benutze den Duschkopf, um dein Haustier nach dem Shampoonieren abzuspülen.",
 Tip_72="Verdiene dir etwas dazu, indem du dein Haustier Tricks vorführen lässt oder die Talentshow besuchst.",
 Tip_73="Das Buch der Tricks zeigt dir, wie du deinem Haustier Tricks beibringst.",
 Tip_74="Du hast dein ganzes Tierfutter verbraucht. Gehe in den Laden, um mehr zu kaufen.",
 Tip_75="Du hast dein ganzes Wasser verbraucht. Gehe in den Laden, um mehr zu kaufen.",
 Tip_76="Du hast dein ganzes Shampoo verbraucht. Gehe in den Laden, um mehr zu kaufen.",
 Tip_77="Klicke auf den Kreis am oberen Bildrand, um Dinge, die du geworfen hast, zurückzuholen.",
 ConfirmOverwrite="Es gibt schon ein Haustier mit diesem Namen. Bist du sicher, dass du das alte Haustier durch dieses ersetzen möchtest.",
 ReadMeLink="LiesMich",
 ManualLink="Handbuch",
 RegisterLink="Registrieren",
 QuitConfirm="Bist du sicher, dass du das Spiel beenden willst?",
 Level1="Level 1",
 Level2="Level 2",
 Level3="Level 3",
 TS_LevelEasy="Einfach",
 TS_LevelAdvanced="Fortgeschritten",
 TS_LevelExpert="Experte",
 NoBreedSelected="Keine Rasse gewählt",
 SelectBreed="Wähle eine Rasse",
 CustomizeYourPet="Passe dein Haustier an",
 NameYourPet="Gib deinem Haustier einen Namen",
 Boy="Junge",
 Girl="Mädchen",
 UninstallDelete="Möchtest du alle vom Benutzer erstellten Dateien löschen?",
 Okay="OK",
 AutorunPlay="Spielen",
 AutorunInstall="Installieren",
 AutorunUninstall="Deinstallieren",
 AutorunReadMe="LiesMich",
 AutorunManual="Handbuch",
 AutorunRegister="Registrieren",
 AutorunQuit="Beenden",
 LabelInventory="Mein Kram",
 LabelStore="Petz-Store",

TS_YourScore="Runde 1: %d     Runde 2: %d     Runde 3: %d     Gesamt: %d",
TS_WinPlace1="%s belegt den 1. Platz! Du gewinnst $%d!",
TS_WinPlace2="%s belegt den 2. Platz! Du gewinnst $%d!",
TS_WinPlace3="%s belegt den 3. Platz! Du gewinnst $%d!",
TS_WinPlace4="%s wurde Letzter. Mehr Glück beim nächsten Mal!",
TS_Award1="1. Platz",
TS_Award2="2. Platz",
TS_Award3="3. Platz",
TS_Award4="4. Platz",
TS_Score="Punkte: %d",

StatBreed="Rasse",
StatBirthday="Geburtstag",
StatIntelligence="Intelligenz",
StatAgility="Agilität",
StatStamina="Ausdauer",
StatObedience="Gehorsam",

NeedLove="Liebe",
NeedHunger="Hunger",
NeedThirst="Durst",
NeedGrooming="Bürsten",
NeedAlertness="Wachsamkeit",

BookOfTricks="Buch der Tricks für Anfänger",
ReturnHouse="Zurück zum Haus",

ToolTip_ReturnToHouse="Zurück nach Hause",
BrushPrompt="Möchtest du ins Bad gehen, um dein Haustier zu bürsten?",
remove_clothes="Gesamte Kleidung ausziehen",

NeedLoveGreen="Spiel mit deinem Tier, damit es sich geliebt fühlt.",
NeedLoveYellow="Dein Haustier wird einsam. Es ist Zeit, es zu streicheln oder mit ihm zu spielen.",
NeedLoveRed="Dein Haustier ist einsam. Du musst mit ihm spielen oder es streicheln.",
NeedHungerGreen="Füttere dein Haustier, wenn es hungrig ist.",
NeedHungerYellow="Dein Haustier wird hungrig. Höchste Zeit, es zu füttern.",
NeedHungerRed="Dein Haustier hat Hunger. Zeit zum Füttern.",
NeedThirstGreen="Gib deinem Haustier Wasser, wenn es durstig ist.",
NeedThirstYellow="Dein Haustier ist durstig. Gib ihm Wasser.",
NeedThirstRed="Dein Haustier hat Durst. Zeit für Wasser.",
NeedGroomingGreen="Bade oder bürste dein Haustier, wenn es schmutzig ist.",
NeedGroomingYellow="Dein Haustier wird schmutzig. Es ist Zeit, es zu baden oder zu bürsten.",
NeedGroomingRed="Dein Haustier ist schmutzig. Du musst es bürsten oder waschen.",
NeedAlertnessGreen="Lass dein Haustier schlafen, wenn es müde ist.",
NeedAlertnessYellow="Dein Haustier wird müde. Lass es schlafen.",
NeedAlertnessRed="Dein Haustier ist müde. Zeit zum Schlafen.",

StatIntelligenceTip="Wie schnell dein Haustier lernt.",
StatAgilityTip="Wie toll dein Haustier schwierige Tricks vorführt.",
StatStaminaTip="Wie schnell dein Haustier müde wird.",
StatObedienceTip="Wie oft dein Haustier tut, was du sagst.",

Tip_78="Dein Haustier ist sehr müde. Zeit für ein Schläfchen.",
Tip_79="Willkommen zurück! Dein Haustier hat dich vermisst.",

-- PLEASE add all new text BELOW this line, or it will not get translated! -BM

    PrinterNotFound="Drucker nicht gefunden. Vergewissere dich, dass er angeschlossen und eingeschaltet ist.",

    BrushPrompt2="Möchtest du dein Haustier jetzt bürsten?",

    Tip_80="Es braucht viel Übung, bis dein Haustier mehr als nur ein paar Tricks lernt. Trainiere weiter %s und gib ihm ein Leckerchen, wenn es gehorcht.",

    NeedsTitle="Bedürfnisse",
    StatsTitle="Statistik",

    ubisoft_copyright = "(C) Ubisoft",
}

language.Italian = {

    YouWin="Hai vinto!",
    YouLose="Hai perso!",
    Round="%d round",
    BonusUnlocked="Bonus sbloccato!",
    GotoMainMenu="Confermi di voler accedere al menu principale?",
    Paused="In pausa",
    Pause="In pausa",
    Loading="Caricamento",
    Uninstall="Disinstalla",

    SettingTitle="Impostazioni",
    SettingsVolume="Volume",
    SettingsVideo="Video",
    SettingsAntiAliasing="Linee più morbide",

    Tip_01="Clicca sullo schermo per chiamare il tuo nuovo cucciolo.",
    Tip_02="Il cucciolo ha fame. Nella valigetta troverai del cibo.",
    Tip_03="Il cucciolo ha sete. Nella valigetta troverai dell'acqua.",
    Tip_04="Il cucciolo ha bisogno di un bagno. Puoi trovare dello shampoo nel negozio di Petz.",
    Tip_05="Il cucciolo è stanco. È ora di farlo riposare.",
    Tip_06="Il cucciolo ha bisogno d'amore. Fagli un po' di coccole.",
    Tip_07="Questo è il negozio di Petz. Qui puoi comperare tutto ciò di cui il tuo cucciolo ha bisogno.",
    Tip_08="Questa è la tua valigetta: qui viene conservato quello che comperi.",
    Tip_09="Premia il cucciolo dandogli uno stuzzichino.",
    Tip_10="Sgrida il cucciolo spruzzandolo con l'acqua.",
    Tip_11="Usa questi pulsanti per dare dei comandi al cucciolo.",
    Tip_12="Questo riquadro mostra come si sente il cucciolo.",
    Tip_13="Tieni premuto il pulsante del mouse e muovi la mano per accarezzare il cucciolo. Adora le attenzioni!",
    Tip_14="Clicca col pulsante del mouse e muovi verso il basso per farlo sedere.",
    Tip_15="Hai fatto camminare in cerchio il cucciolo. Seleziona il pulsante blu per dire: CAMMINA!",
    Tip_16="Hai fatto sedere il cucciolo. Seleziona il pulsante blu per dire: A CUCCIA!",
    Tip_17="Hai fatto sdraiare il cucciolo. Seleziona il pulsante blu per dire: A TERRA!",
    Tip_18="Hai fatto parlare il cucciolo. Seleziona il pulsante blu per dire: PARLA!",
    Tip_19="Ti sei fatto dare la zampa dal cucciolo. Premi il pulsante blu per dire ZAMPA!",
    Tip_20="Hai fatto alzare il cucciolo per chiedere. Seleziona il pulsante blu per dire: CHIEDI!",
    Tip_21="Hai fatto rotolare il cucciolo. Seleziona il pulsante blu per dire: ROTOLA!",
    Tip_22="Hai fatto sì che il cucciolo nascondesse il muso. Seleziona il pulsante blu per dire: NASCONDITI!",
    Tip_23="Hai fatto annuire il cucciolo. Seleziona il pulsante blu per dire: ANNUISCI!",
    Tip_24="Hai fatto sì che il cucciolo scuotesse la testa. Seleziona il pulsante blu per dire: MUOVI LA TESTA!",
    Tip_25="Hai fatto saltare il cucciolo. Seleziona il pulsante blu per dire: SALTA!",
    Tip_26="Hai fatto alzare su due zampe il cucciolo. Seleziona il pulsante blu per dire: SU DUE ZAMPE!",
    Tip_27="Muovi il cucciolo un po' di volte verso il basso per farlo sdraiare.",
    Tip_28="Continua a mostrare al cucciolo come %s fino a quando non impara.",
    Tip_29="Uno stuzzichino aiuterà il cucciolo a imparare il significato di %s.",

    Tip_31="Prova a dire ancora: %s, e ricompensa il cucciolo quando obbedisce.",
    Tip_32="Il cucciolo obbedirà più facilmente se gli dai da mangiare.",
    Tip_33="Il cucciolo obbedirà più facilmente se gli dai da bere.",
    Tip_34="Il cucciolo obbedirà più facilmente se lo coccoli.",
    Tip_35="Il cucciolo obbedirà più facilmente se lo pulisci.",
    Tip_36="Il cucciolo obbedirà più facilmente se lo lasci riposare.",
    Tip_37="Il cucciolo obbedirà più facilmente se ci giochi.",
    Tip_38="Il cucciolo ha provato: %s. Uno stuzzichino potrebbe aiutarlo a farlo meglio la prossima volta.",
    Tip_39="Il cucciolo non capisce se parli troppo velocemente.",
    Tip_40="Il cucciolo potrebbe dimenticarsi: %s, se lo sgridi!",
    Tip_41="Il cucciolo ha dimenticato il trucco: %s.",
    Tip_42="Vuoi andare in cucina a dar da mangiare al cucciolo?",
    Tip_43="Vuoi andare in cucina a dar da bere al cucciolo?",
    Tip_44="Vuoi andare in bagno per lavare il cucciolo?",

    Tip_45="Il cucciolo ha imparato cosa significa CAMMINA!",
    Tip_46="Il cucciolo ha imparato cosa significa A CUCCIA!",
    Tip_47="Il cucciolo ha imparato cosa significa A TERRA!",
    Tip_48="Il cucciolo ha imparato cosa significa PARLA!",
    Tip_49="Il cucciolo ha imparato cosa significa ZAMPA!",
    Tip_50="Il cucciolo ha imparato cosa significa CHIEDI!",
    Tip_51="Il cucciolo ha imparato cosa significa ROTOLA!",
    Tip_52="Il cucciolo ha imparato cosa significa NASCONDITI!",
    Tip_53="Il cucciolo ha imparato cosa significa ANNUISCI!",
    Tip_54="Il cucciolo ha imparato cosa significa MUOVI LA TESTA!",
    Tip_55="Il cucciolo ha imparato cosa significa SALTA!",
    Tip_56="Il cucciolo ha imparato cosa significa SU DUE ZAMPE!",

    Tip_57="Vuoi andare in giardino a giocare con il cucciolo?",

    Tip_58="Per lanciare un giocattolo, tieni premuto il pulsante del mouse, muovi rapidamente il puntatore e poi rilascia il pulsante.",

    Tip_59="Il cucciolo deve conoscere 4 trucchi, compreso CAMMINA, per partecipare all'Esibizione di livello Facile.",
    Tip_60="Il cucciolo deve conoscere 8 trucchi per partecipare all'Esibizione di livello Medio.",
    Tip_61="Il cucciolo deve conoscere 12 trucchi per partecipare all'Esibizione di livello Difficile.",

    DogDesc_Beagle="Questi cani da caccia sono pieni di energia. I beagle sono molto affettuosi ma anche molto indipendenti, quindi ci vuole pazienza per addestrarli. Il pelo corto li rende semplici da curare. Attento! Questi piccoli mattacchioni graffiano tutto quello che trovano.",
    DogDesc_Collie="Questi cani sono intelligenti e addestrarli è un piacere. I collie sono compagni affettuosi e obbedienti. Il pelo lungo però li rende più bisognosi di cure di altre razze.",
    DogDesc_Shepherd="I cani pastore sono animali fedeli. La loro capacità di amare è quasi smisurata, inoltre apprendono facilmente. Il pelo lungo è difficile da curare, però, e abbaiano più di altre razze.",
    DogDesc_Retriever="Questi piccolini amano giocare. Sono furbi e veloci, amichevoli e affettuosi. I labrador imparano in fretta, ma possono avere problemi di attenzione. Hanno anche bisogno di più acqua rispetto alle altre razze, perché tendono a sbavare.",
    DogDesc_Pug="Questi cuccioli sono dei piccoli burloni. Amano giocare e sono molto affettuosi. Addestrare un carlino è difficile, ma amano le attenzioni, quindi sarà comunque piacevole. Mostra loro quanto li ami e ti ricambieranno. Il pelo corto rende semplice curarli.",

    CatDesc_Abyssinian="Questo gatto intelligente e indipendente ama le altezze: gli piace saltare su tutto. L'abissino inoltre ha molta più energia di altre razze: può giocare per intere ore di fila. Il suo pelo lucente non richiede molta attenzione.",
    CatDesc_Bengal="Questo gatto estremamente intelligente è facile da addestrare e non dà quasi problemi: è perfetto per i principianti. Il bengala richiede più acqua e cibo rispetto ad altre razze.",
    CatDesc_Burmese="Questi gatti intelligenti e obbedienti tendono a entrare in simbiosi coi padroni. Il birmano tende però a graffiare tutto quello che gli capita, quindi mostra un po' di polso!",
    CatDesc_MaineCoon="Questi grossi gatti sono furbi e veloci. I maine coon imparano facilmente i nuovi trucchi ma hanno bisogno di più cibo, riposo e cure di altre razze.",
    CatDesc_Siamese="Mellifluo e agile, il siamese è l'elite del mondo felino. Ama l'attenzione ma preferisce cavarsela da solo. È anche molto ciarliero: se ti piacciono i miagolii, è il gatto che fa per te!",

    foodcan_04="Cibo\neconomico",
    foodcan_03="Cibo\nsaporito",
    foodcan_02="Cibo\nbiologico",
    foodcan_01="Cibo\ndeluxe",
    foodbag_04="Alimento\neconomico",
    foodbag_03="Alimento\nsaporito",
    foodbag_02="Alimento\nbiologico",
    foodbag_01="Alimento\ndeluxe",
    waterbottle_01="Acqua\neconomica",
    waterbottle_04="Acqua\nvitaminizzata",
    waterbottle_03="Acqua\nbiologica",
    waterbottle_02="Acqua\ndeluxe",
    shampoo_03="Sciampo\neconomico",
    shampoo_01="Sciampo\nbiologico",
    shampoo_02="Sciampo\ndeluxe",

    foodcan_04x="Cibo\neconomico\n(3 scatolette)",
    foodcan_03x="Cibo\nsaporito\n(3 scatolette)",
    foodcan_02x="Cibo\nbiologico\n(3 scatolette)",

    foodbag_04x="Alimento\neconomico\n(3 sacchetti)",
    foodbag_03x="Alimento\nsaporito\n(3 sacchetti)",
    foodbag_02x="Alimento\nbiologico\n(3 sacchetti)",

    waterbottle_01x="Acqua\neconomica\n(3 bottiglie)",
    waterbottle_04x="Acqua\nvitaminizzata\n(3 bottiglie)",
    waterbottle_03x="Acqua\nbiologica\n(3 bottiglie)",

    shampoo_03x="Sciampo\neconomico\n(3 bottiglie)",
    shampoo_01x="Sciampo\nbiologico\n(3 bottiglie)",

    treats_03x="Stuzzichini\neconomici\n(3 scatolette)",
    treats_01x="Stuzzichini\norganici\n(3 scatolette)",

    brush_01="Spazzola\ndi legno",
    brush_02="Spazzola\nblu cobalto",
    brush_03="Spazzola\nd'argento",
    brush_04="Spazzola\nd'oro deluxe",
    treats_03="Stuzzichino\neconomico",
    treats_01="Stuzzichino\nbiologico",
    treats_02="Stuzzichino\nda intenditore",

    bandanacollar_01="Bandana\nrossa",
    collar_01="Collare marrone\ndi pelle",
    collar_02="Collare nero\ndi pelle",
    collar_03="Collare bianco\ndi pelle",
    collar_04="Collare\nscamosciato\nblu",
    collar_05="Collare\nscamosciato\nverde",
    collar_06="Collare\nscamosciato\nrosso",
    collar_07="Collare di\npelle di\nrettile",
    collar_08="Collare reale\ningioiellato",
    floralcollar_01="Collare a\nfiori blu",
    floralcollar_02="Collare a\nfiori rosa",
    floralcollar_03="Collare a\nfiori scuri",
    chaincollar_01="Collare di\ncatena d'argento",
    chaincollar_02="Collare di\ncatena d'oro",
    chaincollar_03="Collare di\ncatena d'acciaio",
    gmcollar_01="Collare con\nmedaglia d'oro",

    booties_01="Scarpine\nsportive",
    booties_03="Scarpine bianche\ndi pelle",
    booties_02="Scarpine\ndalla punta\nd'acciaio",
    pombooties_01="Scarpine\ndelle feste\ncoi pompon",
    pombooties_03="Scarpine\nda balletto\ncoi pompon",
    pombooties_02="Scarpine\nleopardate\ncoi pompon",
    baseballhat_01="Cappellino\nda baseball",
    beeniehat_01="Berrettino\ncon elica",
    sombrerohat_01="Sombrero",
    cowboyhat_01="Cappello\nda cowboy",
    jesterhat_01="Cappello\nda giullare",
    piratehat_01="Cappello\nda pirata",
    princesshat_01="Cappello da\nprincipessa",
    wizardhat_01="Cappello\nda mago",
    tiarahat_01="Corona\nreale",
    vikinghat_01="Elmo da\nvichingo",
    mohawkhat_01="Cresta\nverde",
    tailpom_01="Pompon coda\nrosa",
    tailpom_02="Pompon coda\nrossa",
    tailpom_03="Pompon coda\nblu",
    tailpom_04="Pompon coda\nleopardata",
    tailpom_05="Pompon coda\nbianca",
    tailpom_06="Pompon coda\nluccicante",

livingroom_01 ="Salotto standard\nper acquirenti\nalle prime armi",
livingroom_02 ="Salotto moderno\nper uno stile\ncontemporaneo",
livingroom_03 ="Salotto rustico\nadatto alla vita\nin campagna",
livingroom_04 ="Salotto di lusso\nper i gusti\npiù raffinati",
Bathroom_01 ="Bagno standard\nper acquirenti\nalle prime armi",
Bathroom_02 ="Bagno moderno\nper uno stile\ncontemporaneo",
Bathroom_03 ="Bagno rustico\nadatto alla vita\nin campagna",
Bathroom_04 ="Bagno di lusso\nper i gusti\npiù raffinati",
Kitchen_01 ="Cucina standard\nper acquirenti\nalle prime armi",
Kitchen_02 ="Cucina moderna\nper uno stile\ncontemporaneo",
Kitchen_03 ="Cucina rustica\nadatta alla vita\nin campagna",
Kitchen_04 ="Cucina di lusso\nper i gusti\npiù raffinati",


    foodbowl_01="Ciotola blu\ncobalto per\nil cibo",
    foodbowl_03="Ciotola rosso\nciliegia per\nil cibo",
    foodbowl_04="Ciotola per il\ncibo con fantasie\ndi biscotti",
    foodbowl_02="Ciotola d'acciaio\nper il cibo",
    arearug_01="Tappetino\nmoderno",
    arearug_02="Tappetino\nart deco",
    arearug_03="Tappeto\ndecorato",
    arearug_04="Tappeto lussuoso\norientale",
    coffeetable_01="Tavolo da\ncaffè rustico",
    coffeetable_02="Tavolo da\ncaffè moderno",
    coffeetable_03="Tavolo da\ncaffè di lusso",
    easychair_04="Poltrona in\ntessuto beige",
    easychair_03="Poltrona marrone\ndi pelle",
    easychair_02="Poltrona\nin feltro",
    easychair_01="Poltrona\nin seta blu",
    kitchenchair_01="Sedia da\ncucina moderna",
    kitchenchair_02="Sedia da\ncucina rustica",
    kitchenchair_03="Sedia da\ncucina di lusso",
    kitchentable_01="Tavolo da\ncucina standard",
    kitchentable_02="Tavolo da\ncucina moderna",
    kitchentable_03="Tavolo da\ncucina rustica",
    kitchentable_04="Tavolo da\ncucina di lusso",
    fridge_01="Frigorifero\nstandard",
    fridge_02="Frigorifero\nmoderno",
    fridge_03="Frigorifero\nrustico",
    fridge_04="Frigorifero\ndi lusso",
    petbed_04="Cuccia in pelle\ndi pecora",
    petbed_01="Cuccia in\nfeltro",
    petbed_02="Cuccia\ntrapuntata\na mano",
    petbed_03="Cuccia\nleopardata",
    sofa_01="Divano in\ntessuto beige",
    sofa_03="Divano marrone\ndi pelle",
    sofa_04="Divano\ntrapuntato",
    sofa_02="Divano di\nseta blu",
    toilet_01="Toletta di\nporcellana\nbeige",
    toilet_02="Toletta\nblu cobalto",
    toilet_03="Toletta\ncolor avocado",
    toilet_04="Toletta\nd'acciaio",
    tub_01="Vasca di\nporcellana beige",
    tub_02="Vasca blu\ncobalto",
    tub_03="Vasca color\navocado",
    tub_04="Vasca in\noro lucidato",
    doghouse_01="Casetta\nstandard",
    doghouse_02="Casetta\nmoderna",
    doghouse_03="Casetta\nrustica",
    doghouse_04="Casetta\ndi lusso",
    ball_01="Pallina da\ntennis gialla",
    ball_02="Pallina di\ngomma blu",
    ball_03="Palla di\nelastici",
    ball_04="Palla da baseball\nautografata",
    ball_06="Palla di lusso\ndi lamé dorato",
    flyingdisc_01="Frisbee di\nplastica",
    flyingdisc_02="Frisbee\navanzato",
    flyingdisc_04="Frisbee\nda esperti",
    flyingdisc_03="Frisbee\ndi lusso",
    stick_01="Pezzetto\ndi legno",
    newspaper_01="Giornale\narrotolato",
    mocassin_01="Mocassino\ndi pelle",
    squeekybone_01="Osso di\ngomma",
    teddy_01="Orsetto\ndi peluche",
    squeekyduck_01="Paperella\ndi gomma",

    -- catz-specific stuff

    ball_05="Palla di\nspago rosso",
    jingleball_04="Palla\ntintinnante\nrosa",
    jingleball_02="Palla\ntintinnante\nblu",
    jingleball_01="Palla\ntintinnante\nporpora",
    jingleball_03="Palla\ntintinnante\ndi lamé dorato",
    toymouse_01="Topo\nprofumato",
    litterbox_01="Lettiera\nverde",
    litterbox_02="Lettiera\nblu",
    litterbox_04="Lettiera\nrossa",
    litterbox_03="Lettiera\nd'acciaio",
    scratchingpost_01="Tiragraffi\nstandard",
    scratchingpost_02="Tiragraffi\ndi lusso",
    perch_02="Rifugio standard\nper gatti",
    perch_01="Rifugio deluxe\nper gatti",

    Dogz_fur_01="Manto\nstandard 1",
    Dogz_fur_02="Manto\nstandard 2",
    Dogz_fur_03="Manto\nstandard 3",
    Dogz_fur_04="Manto\ndi lupo",
    Dogz_fur_05="Manto\ndalmata",
    Dogz_fur_06="Acciaio\nrobotico",

    Catz_fur_01="Manto\nstandard 1",
    Catz_fur_02="Manto\nstandard 2",
    Catz_fur_03="Manto\nstandard 3",
    Catz_fur_04="Grigio\nombra",
    Catz_fur_05="Rosso\nnaturale",
    Catz_fur_06="Biondo\nnaturale",
    Catz_fur_07="Rosa\nshocking",
    Catz_fur_08="Blu\ncobalto",
    Catz_fur_09="Tigre",
    Catz_fur_10="Leopardo",
    Catz_fur_11="Acciaio\nrobotico",
    Catz_fur_12="Giraffa",
    Catz_fur_13="Zebra",
    Catz_fur_14="Ghepardo",

    Dogz_MainMenuTextNoPet="Benvenuto a Dogz.\nÈ ora di adottare il tuo primo cagnolino!",
    Catz_MainMenuTextNoPet="Benvenuto a Catz.\nÈ ora di adottare il tuo primo micio!",
    Dogz_MainMenuText="Bentornato a Dogz.\nGioca con questo cagnolino oppure scegline uno nuovo!",
    Catz_MainMenuText="Bentornato a Catz.\nGioca con questo micio oppure scegline uno nuovo!",

    Dogz_LoadMenuTitle="Carica cagnolino",
    Catz_LoadMenuTitle="Carica micio",

    Dogz_KennelTitle="Adotta cagnolino",
    Catz_KennelTitle="Adotta micio",

    Settings="Impostazioni",
    Video="Video",
    Volume="Volume",
    AntiAlias="Linee più morbide",

    AdoptCertificate="Certificato di adozione",

    PrintYesNo="Confermi di voler stampare?",
    DeletePhotoYesNo="Confermi di voler eliminare questa foto?",
    DeletePetYesNo="Confermi di voler eliminare questo cucciolo?",

    TOD_Heading="Trucco del giorno",
    TOD_None="Presta attenzione al prossimo trucco del giorno!",
    TOD_Winner="Hai appena vinto %d$ con il trucco del giorno. Bel lavoro!",
    TOD_OneEasyTrick="Fai fare al tuo cucciolo il trucco %s per vincere %d$!",
    TOD_OneHardTrick="Fai fare al tuo cucciolo il trucco %s per vincere %d$!",
    TOD_TwoTricks="Fai fare al tuo cucciolo il trucco %s e poi il trucco %s per vincere %d$!",
    TOD_ThreeTricks="Fai fare al tuo cucciolo tre trucchi diversi di fila per vincere %d$!",
    TOD_OneFetch="Guadagna %d$ facendo prendere al tuo cucciolo il seguente oggetto: %s!",
    TOD_TwoFetches="Guadagna %d$ facendo prendere al tuo cucciolo i seguenti oggetti: %s e %s!",
    TOD_ThreeFetches="Fai prendere al tuo cucciolo tre giochi diversi di fila per vincere %d$!",
    TOD_Balance="Fai tenere al tuo cucciolo un giocattolo in equilibrio sul naso. Vinci %d$ ogni 3 secondi!",
    TOD_Treat="Fai tenere uno stuzzichino sul naso del tuo cucciolo. Vinci %d$ ogni 3 secondi!",
    TOD_EasyTrickPhoto="Presenta una nuova foto del tuo cucciolo mentre fa il trucco %s per vincere %d$!",
    TOD_HardTrickPhoto="Presenta una nuova foto del tuo cucciolo mentre fa il trucco %s per vincere %d$!",
    TOD_BeautyPhoto="Pulisci il cucciolo e vestilo. Poi presenta una foto per vincere un premio!",
    TOD_CutePhoto="Pulisci il cucciolo, vestilo e mettilo in posa. Poi presenta una foto per vincere un premio!",

ToolTip_Options="Opzioni",
ToolTip_Store="Negozio",
ToolTip_Shows="Esibizioni",
ToolTip_Inventory="Le mie cose",
ToolTip_Camera="Scatta foto",
ToolTip_Praise="Loda",
ToolTip_Treat="Stuzzichino",
ToolTip_Scold="Sgrida",
ToolTip_Tricks="Trucchi",
ToolTip_Stats="Info sul cucciolo",


    ToolTip_CareTab="Oggetti per la cura e per mangiare",
    ToolTip_ToysTab="Giocattoli",
    ToolTip_ClothingTab="Vestiti e accessori",
    ToolTip_HouseTab="Mobili e accessori per la casa",

ToolTip_Bathroom="Bagno",
ToolTip_LivingRoom="Salotto",
ToolTip_Kitchen="Cucina",
ToolTip_Backyard="Esterno",


    ToolTip_Promenade="Di' CAMMINA!",
    ToolTip_Sit="Di' A CUCCIA!",
    ToolTip_LieDown="Di' A TERRA!",
    ToolTip_Speak="Di' PARLA!",
    ToolTip_GivePaw="Di' ZAMPA!",
    ToolTip_Beg="Di' CHIEDI!",
    ToolTip_RollOver="Di' ROTOLA!",
    ToolTip_Hide="Di' NASCONDITI!",
    ToolTip_NodHead="Di' ANNUISCI!",
    ToolTip_ShakeHead="Di' MUOVI LA TESTA!",
    ToolTip_Jump="Di' SALTA!",
    ToolTip_StandOnHindLegs="Di' SU DUE ZAMPE!",

ToolTip_ShowerHead="Doccia",
ToolTip_Shampoo="Sciampo",
ToolTip_LeaveAttentionMode="Esci dalla modalità Ravvicinata",
ToolTip_LeaveTubMode="Esci dalla vasca",


    TrickName_Promenade="CAMMINA",
    TrickName_Sit="A CUCCIA",
    TrickName_LieDown="A TERRA",
    TrickName_Speak="PARLA",
    TrickName_GivePaw="ZAMPA",
    TrickName_Beg="CHIEDI",
    TrickName_RollOver="ROTOLA",
    TrickName_Hide="NASCONDITI",
    TrickName_NodHead="ANNUISCI",
    TrickName_ShakeHead="MUOVI LA TESTA",
    TrickName_Jump="SALTA",
    TrickName_StandOnHindLegs="SU DUE ZAMPE",

    TS_WelcomeEasy="Benvenuto all'Esibizione di Petz, livello Facile %d!",
    TS_WelcomeMedium="Benvenuto all'Esibizione di Petz, livello Medio %d!",
    TS_WelcomeHard="Benvenuto all'Esibizione di Petz, livello Difficile %d!",
    TS_PetID="Il prossimo concorrente è un %s di nome %s.",
    TS_BreedGermanShepard="pastore tedesco",
    TS_BreedBorderCollie="collie",
    TS_BreedGoldenRetriever="labrador",
    TS_BreedBeagle="beagle",
    TS_BreedPug="carlino",
    TS_BreedAbyssinian="abissino",
    TS_BreedBengal="bengala",
    TS_BreedBurmese="birmano",
    TS_BreedMaineCoon="maine coon",
    TS_BreedSiamese="siamese",
    TS_PetNew="È la sua prima volta a questa Esibizione. Facciamo un grosso applauso a %s!",
    TS_His="suo",
    TS_Him="a lui",
    TS_Her="a lei",
    TS_PetHistory="%s ha partecipato a %d Esibizione/i di livello %s, vincendo un totale di %d$!",
    TS_Easy="Facile",
    TS_Medium="Medio",
    TS_Hard="Difficile",
    TS_ToBeat="I cuccioli da battere oggi sono %s al primo posto, %s al secondo e %s al terzo.",
    TS_ReadyRound1="Preparatevi, sta per iniziare il primo round!",
    TS_TwoTricks="Esegui in ordine i trucchi %s e %s entro %d secondi. Via!",
    TS_ThreeTricks="Esegui in ordine i trucchi %s, %s e %s entro %d secondi. Via!",
    TS_ScoreRound1="Il tuo punteggio per il primo round è di %d punti!",
    TS_ReadyRound2="Ora tocca al round di Cura e bellezza!",
    TS_Round2="Ordina CAMMINA a %s, in modo che possa farsi ammirare dai giudici.",
    TS_ScoreRound2="%s vince un bonus per Cura e bellezza di %d punti.",
    TS_TotalRound2="Il punteggio totale finora è di %d punti!",
    TS_ReadyRound3="Preparati per il terzo e ultimo round: Stile libero!",
    TS_Round3="Fai eseguire a %s più trucchi diversi prima che scada il tempo. Via!",
    TS_ScoreRound3="%s vince un bonus di %d punti per lo Stile libero.",
    TS_RankingScore="Con un punteggio finale di %d, %s vince il %s di %d$!",
    TS_Place1="primo premio",
    TS_Place2="secondo premio",
    TS_Place3="terzo premio",
    TS_NoRankingScore="Il punteggio finale per questa Esibizione è di %d. Sarà per la prossima volta, %s!",
    TS_Bye="Grazie per aver partecipato all'Esibizione di Petz!",

    TS_RandomName1="Spike",
    TS_RandomName2="Prince",
    TS_RandomName3="Duke",
    TS_RandomName4="Buddy",
    TS_RandomName5="Joker",
    TS_RandomName6="Furball",
    TS_RandomName7="King",
    TS_RandomName8="Killer",
    TS_RandomName9="Blackie",
    TS_RandomName10="Piggy",
    TS_RandomName11="Princess",
    TS_RandomName12="Duchess",
    TS_RandomName13="Lady",
    TS_RandomName14="Sneaker",
    TS_RandomName15="Snout",
    TS_RandomName16="Stinky",
    TS_RandomName17="Queen",
    TS_RandomName18="Tiny",
    TS_RandomName19="Fluffy",
    TS_RandomName20="Flopsy",

    GermanShepard="Pastore tedesco",
    BorderCollie="Collie",
    GoldenRetriever="Labrador",
    Beagle="Beagle",
    Pug="Carlino",
    Abyssinian="Abissino",
    Bengal="Bengala",
    Burmese="Birmano",
    MaineCoon="Maine coon",
    Siamese="Siamese",

    SelectFur="Scegli una livrea",
    SelectCollar="Scegli un collare",

    Yes="Sì",
    No="No",

    AskUseKennel="Vuoi mettere il tuo cucciolo al canile per 20$?",

    BookOfTricksAdvanced="Manuale di\ntrucchi\navanzato",
    BookOfTricksExpert="Manuale di\ntrucchi per\nesperti",
    BookOfTricksSecret="Manuale di\ntrucchi\nsegreti",

 Tip_Banner="Consigli",
 Tip_62="Il tuo cucciolo ha imparato abbastanza trucchi per partecipare all’Esibizione di livello Facile!",
 Tip_63="Il tuo cucciolo ha imparato abbastanza trucchi per partecipare all’Esibizione di livello Medio!",
 Tip_64="Il tuo cucciolo ha imparato abbastanza trucchi per partecipare all’Esibizione di livello Difficile!",
 Tip_65="Guadagni 5$ ogni volta che il tuo cucciolo esegue un trucco.",
 Tip_66="Hai appena chiamato il tuo cucciolo! Ora puoi coccolarlo e giocare con lui.",
 Tip_67="Quando fa qualcosa che ti piace, dai al tuo cucciolo uno stuzzichino per premiarlo.",
 Tip_68="Quando fa qualcosa che non ti piace, spruzza il tuo cucciolo per sgridarlo.",
 Tip_69="Il tuo cucciolo ha appena combinato un disastro! Cliccaci sopra per ripulire.",
 Tip_70="Usa gli stuzzichini e le spruzzate per insegnare al cucciolo dove può giocare e fare disastri.",
 Tip_71="Usa la doccia per risciacquare il cucciolo dopo lo sciampo.",
 Tip_72="Guadagna soldi extra facendo eseguire trucchi al tuo cucciolo o partecipando all'Esibizione.",
 Tip_73="Il Manuale di trucchi ti mostrerà come far eseguire i trucchi al tuo cucciolo.",
 Tip_74="Hai appena finito il cibo per il tuo cucciolo. Visita il negozio per comprarne dell'altro.",
 Tip_75="Hai appena finito l'acqua per il tuo cucciolo. Visita il negozio per comprarne dell'altra.",
 Tip_76="Hai appena finito lo sciampo per il tuo cucciolo. Visita il negozio per comprarne dell'altro.",
 Tip_77="Clicca sul cerchio a destra per riprendere le cose che hai lanciato.",
 ConfirmOverwrite="Esiste già un cucciolo con questo nome. Confermi di voler sovrascrivere il vecchio cucciolo con questo?",

 ReadMeLink="Readme",
 ManualLink="Manuale",
 RegisterLink="Registrazione",
 QuitConfirm="Confermi di voler uscire?",
 Level1="Livello 1",
 Level2="Livello 2",
 Level3="Livello 3",
 TS_LevelEasy="Facile",
 TS_LevelAdvanced="Avanzato",
 TS_LevelExpert="Esperto",
 NoBreedSelected="Nessuna razza selezionata",
 SelectBreed="Seleziona una razza",
 CustomizeYourPet="Personalizza il tuo cucciolo",
 NameYourPet="Dai un nome al tuo cucciolo",
 Boy="Maschio",
 Girl="Femmina",
 UninstallDelete ="Vuoi eliminare tutti i file creati dal giocatore?",
 Okay="OK",
 AutorunPlay="Gioca",
 AutorunInstall="Installa",
 AutorunUninstall="Rimuovi",
 AutorunReadMe="Readme",
 AutorunManual="Manuale",
 AutorunRegister="Registrazione",
 AutorunQuit="Esci",
 LabelInventory="Le mie cose",
 LabelStore="Negozio di Petz",
TS_YourScore="Round 1: %d     Round 2: %d     Round 3: %d     Totale: %d",
TS_WinPlace1="%s ha conquistato il primo posto! Il premio è di %d$!",
TS_WinPlace2="%s ha conquistato il secondo posto! Il premio è di %d$!",
TS_WinPlace3="%s ha conquistato il terzo posto! Il premio è di %d$!",
TS_WinPlace4="%s ha ottenuto l'ultimo posto. Sarà per la prossima volta!",
TS_Award1="1° posto",
TS_Award2="2° posto",
TS_Award3="3° posto",
TS_Award4="4° posto",
TS_Score="Punteggio: %d",

StatBreed="Razza",
StatBirthday="Compleanno",
StatIntelligence="Intelligenza",
StatAgility="Agilità",
StatStamina="Resistenza",
StatObedience="Obbedienza",

NeedLove="Amore",
NeedHunger="Fame",
NeedThirst="Sete",
NeedGrooming="Cure",
NeedAlertness="Prontezza",

BookOfTricks="Manuale di trucchi per principianti",
ReturnHouse="Torna a casa",

ToolTip_ReturnToHouse="Torna a casa",
BrushPrompt="Vuoi andare in bagno per spazzolare il tuo cucciolo?",
remove_clothes="Rimuovi tutti gli abiti",

NeedLoveGreen="Gioca con il tuo cucciolo per farlo sentire amato.",
NeedLoveYellow="Il tuo cucciolo si sente solo. Gioca con lui o fagli un po' di coccole.",
NeedLoveRed="Il tuo cucciolo si sente solo. È ora di coccolarlo o di giocare con lui.",
NeedHungerGreen="Dai da mangiare al tuo cucciolo non appena ha fame.",
NeedHungerYellow="Al tuo cucciolo sta venendo fame. È ora di dargli da mangiare.",
NeedHungerRed="Il tuo cucciolo ha fame. È ora di dargli da mangiare.",
NeedThirstGreen="Dai da bere al tuo cucciolo non appena ha sete.",
NeedThirstYellow="Al tuo cucciolo sta venendo sete. È ora di dargli da bere.",
NeedThirstRed="Il tuo cucciolo ha sete. È ora di dargli dell'acqua.",
NeedGroomingGreen="Lava o spazzola il tuo cucciolo quando è sporco.",
NeedGroomingYellow="Il tuo cucciolo si sta sporcando. È ora di una spazzolata o dello shampoo.",
NeedGroomingRed="Il tuo cucciolo è sporco. È ora di una spazzolata o dello sciampo.",
NeedAlertnessGreen="Fai dormire il tuo cucciolo quando si stanca.",
NeedAlertnessYellow="Il tuo cucciolo si sta stancando. È ora di farlo dormire.",
NeedAlertnessRed="Il tuo cucciolo è stanco. È ora di farlo dormire.",

StatIntelligenceTip="Il tuo cucciolo impara davvero in fretta.",
StatAgilityTip="Il tuo cucciolo è molto bravo coi trucchi difficili.",
StatStaminaTip="Il tuo cucciolo si stanca molto in fretta.",
StatObedienceTip="Il tuo cucciolo fa quasi sempre ciò che gli dici.",

Tip_78="Il tuo cucciolo è molto stanco. È ora di farlo dormire un po'.",
Tip_79="Bentornato! Il tuo cucciolo ha sentito la tua mancanza.",

-- PLEASE add all new text BELOW this line, or it will not get translated! -BM

    PrinterNotFound="Stampante non rilevata. Assicurati che la stampante sia accesa e collegata correttamente.",

    BrushPrompt2="Vuoi spazzolare adesso il tuo cucciolo?",

    Tip_80="Il tuo cucciolo deve fare un po' di esercizio per imparare ulteriori trucchi. Continua a mostrargli come eseguire il trucco %s e premialo ogni volta che obbedisce.",

    NeedsTitle="Bisogni",
    StatsTitle="Statistiche",

    ubisoft_copyright = "(C) Ubisoft",
}
