
physics = {
    gravity = 160.0,
    
    velocity_epsilon = 0.01,

    scale_initial_velocity = {
        x = 0.25,
        y = 0.05,
        z = -0.4
    },
    
    min_z_initial_velocity = 80.0,
    max_initial_velocity = 425.0,
    
    grass = {
        rolling_friction = 80.0,
        elasticity = 0.7,
        height = 2.0,
    },
    
    fence = {
        elasticity = 0.9,
    },
    
    pet = {
        elasticity = 0.3,
    },

    toy = { },

    default_toy =
        function()
            return {
                min_apex_height = 1.7,
                min_velocity = 2.0,
                elasticity = 0.2,
                rolling_friction = 1.0,
                initial_angular_velocity = 1000.0,
                radius = 4.0,
            }
        end,
    
    copy =
        function(src)
            local dst = { }
            for k, v in pairs(src) do
                dst[k] = v
            end
            return dst
        end,
}

-----------------------------------------------------
-- default toy
-----------------------------------------------------
physics.toy.Default = physics.default_toy()

-----------------------------------------------------
-- ball
-----------------------------------------------------
physics.toy.Ball = physics.default_toy()
physics.toy.Ball.elasticity = 0.5

physics.toy.ball_01 = physics.copy(physics.toy.Ball)
physics.toy.ball_02 = physics.copy(physics.toy.Ball)
physics.toy.ball_03 = physics.copy(physics.toy.Ball)
physics.toy.ball_04 = physics.copy(physics.toy.Ball)
physics.toy.ball_05 = physics.copy(physics.toy.Ball)
physics.toy.ball_06 = physics.copy(physics.toy.Ball)
physics.toy.ball_07 = physics.copy(physics.toy.Ball)
physics.toy.ball_08 = physics.copy(physics.toy.Ball)

-----------------------------------------------------
-- frisbee
-----------------------------------------------------
physics.toy.Frisbee = physics.default_toy()
physics.toy.Frisbee.elasticity = 0.05
physics.toy.Frisbee.lift = 80.0
physics.toy.Frisbee.rolling_friction = 999999.0
physics.toy.Frisbee.grab_tilt = 40.0
physics.toy.Frisbee.initial_angular_velocity = 1500.0

physics.toy.flyingdisc_01 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_02 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_03 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_04 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_05 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_06 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_07 = physics.copy(physics.toy.Frisbee)
physics.toy.flyingdisc_08 = physics.copy(physics.toy.Frisbee)


