/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

public final class TextHitInfo {
    private int charIndex;
    private boolean isLeadingEdge;

    public int getCharIndex() {
        return this.charIndex;
    }

    public int getInsertionIndex() {
        return this.isLeadingEdge ? this.charIndex : this.charIndex + 1;
    }

    public int hashCode() {
        return this.charIndex;
    }

    public boolean isLeadingEdge() {
        return this.isLeadingEdge;
    }

    private TextHitInfo(int n2, boolean bl2) {
        this.charIndex = n2;
        this.isLeadingEdge = bl2;
    }

    public TextHitInfo getOtherHit() {
        if (this.isLeadingEdge) {
            return TextHitInfo.trailing(this.charIndex - 1);
        }
        return TextHitInfo.leading(this.charIndex + 1);
    }

    public static TextHitInfo afterOffset(int n2) {
        return new TextHitInfo(n2, true);
    }

    public static TextHitInfo beforeOffset(int n2) {
        return new TextHitInfo(n2 - 1, false);
    }

    public TextHitInfo getOffsetHit(int n2) {
        return new TextHitInfo(this.charIndex + n2, this.isLeadingEdge);
    }

    public static TextHitInfo leading(int n2) {
        return new TextHitInfo(n2, true);
    }

    public static TextHitInfo trailing(int n2) {
        return new TextHitInfo(n2, false);
    }

    public boolean equals(TextHitInfo textHitInfo) {
        return textHitInfo != null && this.charIndex == textHitInfo.charIndex && this.isLeadingEdge == textHitInfo.isLeadingEdge;
    }

    public boolean equals(Object object) {
        return object instanceof TextHitInfo && this.equals((TextHitInfo)object);
    }

    public String toString() {
        return "TextHitInfo[" + this.charIndex + (this.isLeadingEdge ? "L" : "T") + "]";
    }
}

