/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.stream;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteOrder;
import java.util.Stack;
import javax.imageio.IIOException;
import javax.imageio.stream.IIOByteBuffer;
import javax.imageio.stream.ImageInputStream;

public abstract class ImageInputStreamImpl
implements ImageInputStream {
    private Stack markByteStack = new Stack();
    private Stack markBitStack = new Stack();
    private boolean isClosed = false;
    private static final int BYTE_BUF_LENGTH = 8192;
    private byte[] byteBuf = new byte[8192];
    protected ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected long streamPos;
    protected int bitOffset;
    protected long flushedPos = 0L;

    public byte readByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return (byte)n2;
    }

    public char readChar() throws IOException {
        return (char)this.readShort();
    }

    public double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public int getBitOffset() throws IOException {
        this.checkClosed();
        return this.bitOffset;
    }

    public abstract int read() throws IOException;

    public int readBit() throws IOException {
        this.checkClosed();
        int n2 = this.bitOffset + 1 & 7;
        int n3 = this.read();
        if (n3 == -1) {
            throw new EOFException();
        }
        if (n2 != 0) {
            this.seek(this.getStreamPosition() - 1L);
            n3 >>= 8 - n2;
        }
        this.bitOffset = n2;
        return n3 & 1;
    }

    public int readInt() throws IOException {
        int n2;
        int n3;
        int n4;
        int n5 = this.read();
        if ((n5 | (n4 = this.read()) | (n3 = this.read()) | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (n5 << 24) + (n4 << 16) + (n3 << 8) + (n2 << 0);
        }
        return (n2 << 24) + (n3 << 16) + (n4 << 8) + (n5 << 0);
    }

    public int readUnsignedByte() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2;
    }

    public int readUnsignedShort() throws IOException {
        return this.readShort() & 0xFFFF;
    }

    public long getFlushedPosition() {
        return this.flushedPos;
    }

    public long getStreamPosition() throws IOException {
        this.checkClosed();
        return this.streamPos;
    }

    public long length() {
        return -1L;
    }

    public long readLong() throws IOException {
        int n2 = this.readInt();
        int n3 = this.readInt();
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return ((long)n2 << 32) + ((long)n3 & 0xFFFFFFFFL);
        }
        return ((long)n3 << 32) + ((long)n2 & 0xFFFFFFFFL);
    }

    public long readUnsignedInt() throws IOException {
        return (long)this.readInt() & 0xFFFFFFFFFFFFFFFFL;
    }

    public short readShort() throws IOException {
        int n2;
        int n3 = this.read();
        if ((n3 | (n2 = this.read())) < 0) {
            throw new EOFException();
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (short)((n3 << 8) + (n2 << 0));
        }
        return (short)((n2 << 8) + (n3 << 0));
    }

    protected final void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("closed");
        }
    }

    public void close() throws IOException {
        this.checkClosed();
        this.isClosed = true;
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        super.finalize();
    }

    public void flush() throws IOException {
        this.flushBefore(this.getStreamPosition());
    }

    public void mark() {
        try {
            this.markByteStack.push(new Long(this.getStreamPosition()));
            this.markBitStack.push(new Integer(this.getBitOffset()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void reset() throws IOException {
        if (this.markByteStack.empty()) {
            return;
        }
        long l2 = (Long)this.markByteStack.pop();
        if (l2 < this.flushedPos) {
            throw new IIOException("Previous marked position has been discarded!");
        }
        this.seek(l2);
        int n2 = (Integer)this.markBitStack.pop();
        this.setBitOffset(n2);
    }

    public boolean isCached() {
        return false;
    }

    public boolean isCachedFile() {
        return false;
    }

    public boolean isCachedMemory() {
        return false;
    }

    public boolean readBoolean() throws IOException {
        int n2 = this.read();
        if (n2 < 0) {
            throw new EOFException();
        }
        return n2 != 0;
    }

    public int skipBytes(int n2) throws IOException {
        long l2 = this.getStreamPosition();
        this.seek(l2 + (long)n2);
        return (int)(this.getStreamPosition() - l2);
    }

    public long readBits(int n2) throws IOException {
        int n3;
        this.checkClosed();
        if (n2 < 0 || n2 > 64) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return 0L;
        }
        int n4 = this.bitOffset + n2 & 7;
        long l2 = 0L;
        for (n3 = n2 + this.bitOffset; n3 > 0; n3 -= 8) {
            int n5 = this.read();
            if (n5 == -1) {
                throw new EOFException();
            }
            l2 <<= 8;
            l2 |= (long)n5;
        }
        if (n4 != 0) {
            this.seek(this.getStreamPosition() - 1L);
        }
        this.bitOffset = n4;
        l2 >>>= -n3;
        return l2 &= -1L >>> 64 - n2;
    }

    public void setBitOffset(int n2) throws IOException {
        this.checkClosed();
        if (n2 < 0 || n2 > 7) {
            throw new IllegalArgumentException("bitOffset must be betwwen 0 and 7!");
        }
        this.bitOffset = n2;
    }

    public long skipBytes(long l2) throws IOException {
        long l3 = this.getStreamPosition();
        this.seek(l3 + l2);
        return this.getStreamPosition() - l3;
    }

    public void flushBefore(long l2) throws IOException {
        if (l2 < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        if (l2 > this.getStreamPosition()) {
            throw new IndexOutOfBoundsException("pos > getStreamPosition()!");
        }
        this.flushedPos = l2;
    }

    public void seek(long l2) throws IOException {
        this.checkClosed();
        if (l2 < this.flushedPos) {
            throw new IndexOutOfBoundsException("pos < flushedPos!");
        }
        this.streamPos = l2;
        this.bitOffset = 0;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public void readFully(byte[] byArray) throws IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public abstract int read(byte[] var1, int var2, int var3) throws IOException;

    public void readFully(byte[] byArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > byArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > b.length!");
        }
        while (n3 > 0) {
            int n4 = this.read(byArray, n2, n3);
            if (n4 == -1) {
                throw new EOFException();
            }
            n2 += n4;
            n3 -= n4;
        }
    }

    private void toChars(byte[] byArray, char[] cArray, int n2, int n3) {
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n4];
                int n5 = byArray[n4 + 1] & 0xFF;
                cArray[n2 + i2] = (char)(by << 8 | n5);
                n4 += 2;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte by = byArray[n4 + 1];
                int n6 = byArray[n4] & 0xFF;
                cArray[n2 + i3] = (char)(by << 8 | n6);
                n4 += 2;
            }
        }
    }

    private void toDoubles(byte[] byArray, double[] dArray, int n2, int n3) {
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n4];
                int n5 = byArray[n4 + 1] & 0xFF;
                int n6 = byArray[n4 + 2] & 0xFF;
                int n7 = byArray[n4 + 3] & 0xFF;
                byte by2 = byArray[n4 + 4];
                int n8 = byArray[n4 + 5] & 0xFF;
                int n9 = byArray[n4 + 6] & 0xFF;
                int n10 = byArray[n4 + 7] & 0xFF;
                int n11 = by << 24 | n5 << 16 | n6 << 8 | n7;
                int n12 = by2 << 24 | n8 << 16 | n9 << 8 | n10;
                long l2 = (long)n11 << 32 | (long)n12 & 0xFFFFFFFFL;
                dArray[n2 + i2] = Double.longBitsToDouble(l2);
                n4 += 8;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte by = byArray[n4 + 7];
                int n13 = byArray[n4 + 6] & 0xFF;
                int n14 = byArray[n4 + 5] & 0xFF;
                int n15 = byArray[n4 + 4] & 0xFF;
                byte by3 = byArray[n4 + 3];
                int n16 = byArray[n4 + 2] & 0xFF;
                int n17 = byArray[n4 + 1] & 0xFF;
                int n18 = byArray[n4] & 0xFF;
                int n19 = by << 24 | n13 << 16 | n14 << 8 | n15;
                int n20 = by3 << 24 | n16 << 16 | n17 << 8 | n18;
                long l3 = (long)n19 << 32 | (long)n20 & 0xFFFFFFFFL;
                dArray[n2 + i3] = Double.longBitsToDouble(l3);
                n4 += 8;
            }
        }
    }

    private void toFloats(byte[] byArray, float[] fArray, int n2, int n3) {
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n4];
                int n5 = byArray[n4 + 1] & 0xFF;
                int n6 = byArray[n4 + 2] & 0xFF;
                int n7 = byArray[n4 + 3] & 0xFF;
                int n8 = by << 24 | n5 << 16 | n6 << 8 | n7;
                fArray[n2 + i2] = Float.intBitsToFloat(n8);
                n4 += 4;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte by = byArray[n4 + 3];
                int n9 = byArray[n4 + 2] & 0xFF;
                int n10 = byArray[n4 + 1] & 0xFF;
                int n11 = byArray[n4 + 0] & 0xFF;
                int n12 = by << 24 | n9 << 16 | n10 << 8 | n11;
                fArray[n2 + i3] = Float.intBitsToFloat(n12);
                n4 += 4;
            }
        }
    }

    private void toInts(byte[] byArray, int[] nArray, int n2, int n3) {
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n4];
                int n5 = byArray[n4 + 1] & 0xFF;
                int n6 = byArray[n4 + 2] & 0xFF;
                int n7 = byArray[n4 + 3] & 0xFF;
                nArray[n2 + i2] = by << 24 | n5 << 16 | n6 << 8 | n7;
                n4 += 4;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte by = byArray[n4 + 3];
                int n8 = byArray[n4 + 2] & 0xFF;
                int n9 = byArray[n4 + 1] & 0xFF;
                int n10 = byArray[n4] & 0xFF;
                nArray[n2 + i3] = by << 24 | n8 << 16 | n9 << 8 | n10;
                n4 += 4;
            }
        }
    }

    private void toLongs(byte[] byArray, long[] lArray, int n2, int n3) {
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n4];
                int n5 = byArray[n4 + 1] & 0xFF;
                int n6 = byArray[n4 + 2] & 0xFF;
                int n7 = byArray[n4 + 3] & 0xFF;
                byte by2 = byArray[n4 + 4];
                int n8 = byArray[n4 + 5] & 0xFF;
                int n9 = byArray[n4 + 6] & 0xFF;
                int n10 = byArray[n4 + 7] & 0xFF;
                int n11 = by << 24 | n5 << 16 | n6 << 8 | n7;
                int n12 = by2 << 24 | n8 << 16 | n9 << 8 | n10;
                lArray[n2 + i2] = (long)n11 << 32 | (long)n12 & 0xFFFFFFFFL;
                n4 += 8;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte by = byArray[n4 + 7];
                int n13 = byArray[n4 + 6] & 0xFF;
                int n14 = byArray[n4 + 5] & 0xFF;
                int n15 = byArray[n4 + 4] & 0xFF;
                byte by3 = byArray[n4 + 3];
                int n16 = byArray[n4 + 2] & 0xFF;
                int n17 = byArray[n4 + 1] & 0xFF;
                int n18 = byArray[n4] & 0xFF;
                int n19 = by << 24 | n13 << 16 | n14 << 8 | n15;
                int n20 = by3 << 24 | n16 << 16 | n17 << 8 | n18;
                lArray[n2 + i3] = (long)n19 << 32 | (long)n20 & 0xFFFFFFFFL;
                n4 += 8;
            }
        }
    }

    private void toShorts(byte[] byArray, short[] sArray, int n2, int n3) {
        int n4 = 0;
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            for (int i2 = 0; i2 < n3; ++i2) {
                byte by = byArray[n4];
                int n5 = byArray[n4 + 1] & 0xFF;
                sArray[n2 + i2] = (short)(by << 8 | n5);
                n4 += 2;
            }
        } else {
            for (int i3 = 0; i3 < n3; ++i3) {
                byte by = byArray[n4 + 1];
                int n6 = byArray[n4] & 0xFF;
                sArray[n2 + i3] = (short)(by << 8 | n6);
                n4 += 2;
            }
        }
    }

    public void readFully(char[] cArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > cArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > c.length!");
        }
        while (n3 > 0) {
            int n4 = Math.min(n3, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, n4 * 2);
            this.toChars(this.byteBuf, cArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void readFully(double[] dArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > dArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > d.length!");
        }
        while (n3 > 0) {
            int n4 = Math.min(n3, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, n4 * 8);
            this.toDoubles(this.byteBuf, dArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void readFully(float[] fArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > fArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > f.length!");
        }
        while (n3 > 0) {
            int n4 = Math.min(n3, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, n4 * 4);
            this.toFloats(this.byteBuf, fArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void readFully(int[] nArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > nArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > i.length!");
        }
        while (n3 > 0) {
            int n4 = Math.min(n3, this.byteBuf.length / 4);
            this.readFully(this.byteBuf, 0, n4 * 4);
            this.toInts(this.byteBuf, nArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void readFully(long[] lArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > lArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > l.length!");
        }
        while (n3 > 0) {
            int n4 = Math.min(n3, this.byteBuf.length / 8);
            this.readFully(this.byteBuf, 0, n4 * 8);
            this.toLongs(this.byteBuf, lArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public void readFully(short[] sArray, int n2, int n3) throws IOException {
        if (n2 < 0 || n3 < 0 || n2 + n3 > sArray.length || n2 + n3 < 0) {
            throw new IndexOutOfBoundsException("off < 0 || len < 0 || off + len > s.length!");
        }
        while (n3 > 0) {
            int n4 = Math.min(n3, this.byteBuf.length / 2);
            this.readFully(this.byteBuf, 0, n4 * 2);
            this.toShorts(this.byteBuf, sArray, n2, n4);
            n2 += n4;
            n3 -= n4;
        }
    }

    public String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = -1;
        boolean bl2 = false;
        block4: while (!bl2) {
            n2 = this.read();
            switch (n2) {
                case -1: 
                case 10: {
                    bl2 = true;
                    continue block4;
                }
                case 13: {
                    bl2 = true;
                    long l2 = this.getStreamPosition();
                    if (this.read() == 10) continue block4;
                    this.seek(l2);
                    continue block4;
                }
            }
            stringBuffer.append((char)n2);
        }
        if (n2 == -1 && stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public String readUTF() throws IOException {
        String string;
        this.bitOffset = 0;
        ByteOrder byteOrder = this.getByteOrder();
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
        try {
            string = DataInputStream.readUTF(this);
        }
        catch (IOException iOException) {
            this.setByteOrder(byteOrder);
            throw iOException;
        }
        this.setByteOrder(byteOrder);
        return string;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public void readBytes(IIOByteBuffer iIOByteBuffer, int n2) throws IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("len < 0!");
        }
        if (iIOByteBuffer == null) {
            throw new NullPointerException("buf == null!");
        }
        byte[] byArray = new byte[n2];
        n2 = this.read(byArray, 0, n2);
        iIOByteBuffer.setData(byArray);
        iIOByteBuffer.setOffset(0);
        iIOByteBuffer.setLength(n2);
    }
}

