/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.IDataObject;
import org.eclipse.swt.internal.ole.win32.IEnumFORMATETC;
import org.eclipse.swt.internal.ole.win32.IUnknown;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.widgets.Display;

public class Clipboard {
    private Display display;
    private COMObject iDataObject;
    private int refCount;
    private Transfer[] transferAgents = new Transfer[0];
    private Object[] data = new Object[0];
    private int CFSTR_PREFERREDDROPEFFECT;
    static /* synthetic */ Class class$0;

    public Clipboard(Display display) {
        this.checkSubclass();
        if (display == null && (display = Display.getCurrent()) == null) {
            display = Display.getDefault();
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        this.display = display;
        TCHAR tCHAR = new TCHAR(0, "Preferred DropEffect", true);
        this.CFSTR_PREFERREDDROPEFFECT = OS.RegisterClipboardFormat(tCHAR);
        this.createCOMInterfaces();
        this.AddRef();
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.Clipboard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            DND.error(24);
        }
        if (display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (display.isDisposed()) {
            DND.error(24);
        }
    }

    public void clearContents() {
        this.clearContents(1);
    }

    public void clearContents(int n2) {
        this.checkWidget();
        if ((n2 & 1) != 0 && COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) == 0) {
            COM.OleSetClipboard(0);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (this.display.getThread() != Thread.currentThread()) {
            DND.error(22);
        }
        if (COM.OleIsCurrentClipboard(this.iDataObject.getAddress()) == 0) {
            COM.OleFlushClipboard();
        }
        this.Release();
        this.display = null;
    }

    public Object getContents(Transfer transfer) {
        return this.getContents(transfer, 1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getContents(Transfer transfer, int n2) {
        Object object;
        block12: {
            Object object2;
            block11: {
                this.checkWidget();
                if (transfer == null) {
                    DND.error(4);
                }
                if ((n2 & 1) == 0) {
                    return null;
                }
                int[] nArray = new int[1];
                int n3 = 0;
                int n4 = COM.OleGetClipboard(nArray);
                while (true) {
                    if (n4 == 0 || n3++ >= 10) {
                        if (n4 == 0) break;
                        return null;
                    }
                    try {
                        Thread.sleep(50L);
                    }
                    catch (Throwable throwable) {}
                    object = new MSG();
                    OS.PeekMessage((MSG)object, 0, 0, 0, 2);
                    n4 = COM.OleGetClipboard(nArray);
                }
                object = new IDataObject(nArray[0]);
                try {
                    TransferData[] transferDataArray = transfer.getSupportedTypes();
                    int n5 = 0;
                    while (n5 < transferDataArray.length) {
                        if (((IDataObject)object).QueryGetData(transferDataArray[n5].formatetc) == 0) {
                            TransferData transferData = transferDataArray[n5];
                            transferData.pIDataObject = nArray[0];
                            object2 = transfer.nativeToJava(transferData);
                            Object var10_11 = null;
                            break block11;
                        }
                        ++n5;
                    }
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var10_12 = null;
                    ((IUnknown)object).Release();
                    throw throwable;
                }
            }
            ((IUnknown)object).Release();
            return object2;
        }
        Object var10_13 = null;
        ((IUnknown)object).Release();
        return null;
    }

    public boolean isDisposed() {
        return this.display == null;
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray) {
        this.setContents(objectArray, transferArray, 1);
    }

    public void setContents(Object[] objectArray, Transfer[] transferArray, int n2) {
        this.checkWidget();
        if (objectArray == null || transferArray == null || objectArray.length != transferArray.length || objectArray.length == 0) {
            DND.error(5);
        }
        int n3 = 0;
        while (n3 < objectArray.length) {
            if (objectArray[n3] == null || transferArray[n3] == null || !transferArray[n3].validate(objectArray[n3])) {
                DND.error(5);
            }
            ++n3;
        }
        if ((n2 & 1) == 0) {
            return;
        }
        this.data = objectArray;
        this.transferAgents = transferArray;
        n3 = COM.OleSetClipboard(this.iDataObject.getAddress());
        int n4 = 0;
        while (n3 != 0 && n4++ < 10) {
            try {
                Thread.sleep(50L);
            }
            catch (Throwable throwable) {}
            MSG mSG = new MSG();
            OS.PeekMessage(mSG, 0, 0, 0, 2);
            n3 = COM.OleSetClipboard(this.iDataObject.getAddress());
        }
        if (n3 != 0) {
            DND.error(2002);
        }
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[12];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 2;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 3;
        nArray[8] = 2;
        nArray[9] = 4;
        nArray[10] = 1;
        nArray[11] = 1;
        this.iDataObject = new COMObject(nArray){

            public int method0(int[] nArray) {
                return Clipboard.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return Clipboard.this.AddRef();
            }

            public int method2(int[] nArray) {
                return Clipboard.this.Release();
            }

            public int method3(int[] nArray) {
                return Clipboard.this.GetData(nArray[0], nArray[1]);
            }

            public int method5(int[] nArray) {
                return Clipboard.this.QueryGetData(nArray[0]);
            }

            public int method8(int[] nArray) {
                return Clipboard.this.EnumFormatEtc(nArray[0], nArray[1]);
            }
        };
    }

    private void disposeCOMInterfaces() {
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    private int EnumFormatEtc(int n2, int n3) {
        Object[] objectArray;
        if (n2 == 2) {
            return -2147467263;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        int n4 = 0;
        while (n4 < this.transferAgents.length) {
            objectArray = this.transferAgents[n4].getSupportedTypes();
            TransferData[] transferDataArray2 = new TransferData[transferDataArray.length + objectArray.length];
            System.arraycopy(transferDataArray, 0, transferDataArray2, 0, transferDataArray.length);
            System.arraycopy(objectArray, 0, transferDataArray2, transferDataArray.length, objectArray.length);
            transferDataArray = transferDataArray2;
            ++n4;
        }
        OleEnumFORMATETC oleEnumFORMATETC = new OleEnumFORMATETC();
        oleEnumFORMATETC.AddRef();
        objectArray = new FORMATETC[transferDataArray.length + 1];
        int n5 = 0;
        while (n5 < transferDataArray.length) {
            objectArray[n5] = transferDataArray[n5].formatetc;
            ++n5;
        }
        FORMATETC fORMATETC = new FORMATETC();
        fORMATETC.cfFormat = this.CFSTR_PREFERREDDROPEFFECT;
        fORMATETC.dwAspect = 1;
        fORMATETC.lindex = -1;
        fORMATETC.tymed = 1;
        objectArray[objectArray.length - 1] = fORMATETC;
        oleEnumFORMATETC.setFormats((FORMATETC[])objectArray);
        OS.MoveMemory(n3, new int[]{oleEnumFORMATETC.getAddress()}, 4);
        return 0;
    }

    private int GetData(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(n2) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            STGMEDIUM sTGMEDIUM = new STGMEDIUM();
            sTGMEDIUM.tymed = 1;
            sTGMEDIUM.unionField = OS.GlobalAlloc(64, 4);
            OS.MoveMemory(sTGMEDIUM.unionField, new int[]{1}, 4);
            sTGMEDIUM.pUnkForRelease = 0;
            COM.MoveMemory(n3, sTGMEDIUM, STGMEDIUM.sizeof);
            return 0;
        }
        int n4 = -1;
        int n5 = 0;
        while (n5 < this.transferAgents.length) {
            if (this.transferAgents[n5].isSupportedType(transferData)) {
                n4 = n5;
                break;
            }
            ++n5;
        }
        if (n4 == -1) {
            return -2147221404;
        }
        this.transferAgents[n4].javaToNative(this.data[n4], transferData);
        COM.MoveMemory(n3, transferData.stgmedium, STGMEDIUM.sizeof);
        return transferData.result;
    }

    private int QueryGetData(int n2) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        if (transferData.type == this.CFSTR_PREFERREDDROPEFFECT) {
            return 0;
        }
        int n3 = 0;
        while (n3 < this.transferAgents.length) {
            if (this.transferAgents[n3].isSupportedType(transferData)) {
                return 0;
            }
            ++n3;
        }
        return -2147221404;
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDataObject)) {
            OS.MoveMemory(n3, new int[]{this.iDataObject.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(n3, new int[1], 4);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.data = new Object[0];
            this.transferAgents = new Transfer[0];
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    public TransferData[] getAvailableTypes() {
        return this.getAvailableTypes(1);
    }

    public TransferData[] getAvailableTypes(int n2) {
        this.checkWidget();
        if ((n2 & 1) == 0) {
            return new TransferData[0];
        }
        FORMATETC[] fORMATETCArray = this._getAvailableTypes();
        TransferData[] transferDataArray = new TransferData[fORMATETCArray.length];
        int n3 = 0;
        while (n3 < fORMATETCArray.length) {
            transferDataArray[n3] = new TransferData();
            transferDataArray[n3].type = fORMATETCArray[n3].cfFormat;
            transferDataArray[n3].formatetc = fORMATETCArray[n3];
            ++n3;
        }
        return transferDataArray;
    }

    public String[] getAvailableTypeNames() {
        this.checkWidget();
        FORMATETC[] fORMATETCArray = this._getAvailableTypes();
        String[] stringArray = new String[fORMATETCArray.length];
        int n2 = 128;
        int n3 = 0;
        while (n3 < fORMATETCArray.length) {
            TCHAR tCHAR = new TCHAR(0, n2);
            int n4 = OS.GetClipboardFormatName(fORMATETCArray[n3].cfFormat, tCHAR, n2);
            if (n4 != 0) {
                stringArray[n3] = tCHAR.toString(0, n4);
            } else {
                switch (fORMATETCArray[n3].cfFormat) {
                    case 15: {
                        stringArray[n3] = "CF_HDROP";
                        break;
                    }
                    case 1: {
                        stringArray[n3] = "CF_TEXT";
                        break;
                    }
                    case 2: {
                        stringArray[n3] = "CF_BITMAP";
                        break;
                    }
                    case 3: {
                        stringArray[n3] = "CF_METAFILEPICT";
                        break;
                    }
                    case 4: {
                        stringArray[n3] = "CF_SYLK";
                        break;
                    }
                    case 5: {
                        stringArray[n3] = "CF_DIF";
                        break;
                    }
                    case 6: {
                        stringArray[n3] = "CF_TIFF";
                        break;
                    }
                    case 7: {
                        stringArray[n3] = "CF_OEMTEXT";
                        break;
                    }
                    case 8: {
                        stringArray[n3] = "CF_DIB";
                        break;
                    }
                    case 9: {
                        stringArray[n3] = "CF_PALETTE";
                        break;
                    }
                    case 10: {
                        stringArray[n3] = "CF_PENDATA";
                        break;
                    }
                    case 11: {
                        stringArray[n3] = "CF_RIFF";
                        break;
                    }
                    case 12: {
                        stringArray[n3] = "CF_WAVE";
                        break;
                    }
                    case 13: {
                        stringArray[n3] = "CF_UNICODETEXT";
                        break;
                    }
                    case 14: {
                        stringArray[n3] = "CF_ENHMETAFILE";
                        break;
                    }
                    case 16: {
                        stringArray[n3] = "CF_LOCALE";
                        break;
                    }
                    case 17: {
                        stringArray[n3] = "CF_MAX";
                        break;
                    }
                    default: {
                        stringArray[n3] = "UNKNOWN";
                    }
                }
            }
            ++n3;
        }
        return stringArray;
    }

    private FORMATETC[] _getAvailableTypes() {
        FORMATETC[] fORMATETCArray = new FORMATETC[]{};
        int[] nArray = new int[1];
        if (COM.OleGetClipboard(nArray) != 0) {
            return fORMATETCArray;
        }
        IDataObject iDataObject = new IDataObject(nArray[0]);
        int[] nArray2 = new int[1];
        int n2 = iDataObject.EnumFormatEtc(1, nArray2);
        iDataObject.Release();
        if (n2 != 0) {
            return fORMATETCArray;
        }
        IEnumFORMATETC iEnumFORMATETC = new IEnumFORMATETC(nArray2[0]);
        int n3 = OS.GlobalAlloc(64, FORMATETC.sizeof);
        int[] nArray3 = new int[1];
        iEnumFORMATETC.Reset();
        while (iEnumFORMATETC.Next(1, n3, nArray3) == 0 && nArray3[0] == 1) {
            FORMATETC fORMATETC = new FORMATETC();
            COM.MoveMemory(fORMATETC, n3, FORMATETC.sizeof);
            FORMATETC[] fORMATETCArray2 = new FORMATETC[fORMATETCArray.length + 1];
            System.arraycopy(fORMATETCArray, 0, fORMATETCArray2, 0, fORMATETCArray.length);
            fORMATETCArray2[fORMATETCArray.length] = fORMATETC;
            fORMATETCArray = fORMATETCArray2;
        }
        OS.GlobalFree(n3);
        iEnumFORMATETC.Release();
        return fORMATETCArray;
    }
}

