/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.win32.CHOOSEFONT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    FontData fontData;
    RGB rgb;

    public FontDialog(Shell shell) {
        this(shell, 32768);
    }

    public FontDialog(Shell shell, int n2) {
        super(shell, n2);
        this.checkSubclass();
    }

    public FontData getFontData() {
        return this.fontData;
    }

    public FontData[] getFontList() {
        if (this.fontData == null) {
            return null;
        }
        FontData[] fontDataArray = new FontData[]{this.fontData};
        return fontDataArray;
    }

    public RGB getRGB() {
        return this.rgb;
    }

    public FontData open() {
        int n2;
        int n3;
        Object object;
        if (OS.IsWinCE) {
            SWT.error(20);
        }
        int n4 = 0;
        if (this.parent != null) {
            n4 = this.parent.handle;
        }
        int n5 = OS.GetProcessHeap();
        CHOOSEFONT cHOOSEFONT = new CHOOSEFONT();
        cHOOSEFONT.lStructSize = CHOOSEFONT.sizeof;
        cHOOSEFONT.hwndOwner = n4;
        cHOOSEFONT.Flags = 257;
        int n6 = OS.HeapAlloc(n5, 8, LOGFONT.sizeof);
        if (this.fontData != null && this.fontData.data != null) {
            object = this.fontData.data;
            n3 = ((LOGFONT)object).lfHeight;
            n2 = OS.GetDC(0);
            int n7 = -((int)(0.5f + this.fontData.height * (float)OS.GetDeviceCaps(n2, 90) / 72.0f));
            OS.ReleaseDC(0, n2);
            ((LOGFONT)object).lfHeight = n7;
            cHOOSEFONT.Flags |= 0x40;
            OS.MoveMemory(n6, (LOGFONT)object, LOGFONT.sizeof);
            ((LOGFONT)object).lfHeight = n3;
        }
        cHOOSEFONT.lpLogFont = n6;
        if (this.rgb != null) {
            int n8 = this.rgb.red & 0xFF;
            n3 = this.rgb.green << 8 & 0xFF00;
            n2 = this.rgb.blue << 16 & 0xFF0000;
            cHOOSEFONT.rgbColors = n8 | n3 | n2;
        }
        object = null;
        Display display = null;
        if ((this.style & 0x30000) != 0) {
            display = this.parent.getDisplay();
            object = display.getModalDialogShell();
            display.setModalDialogShell(this.parent);
        }
        n2 = OS.ChooseFont(cHOOSEFONT) ? 1 : 0;
        if ((this.style & 0x30000) != 0) {
            display.setModalDialogShell((Shell)object);
        }
        if (n2 != 0) {
            int n9;
            LOGFONT lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            OS.MoveMemory(lOGFONT, n6, LOGFONT.sizeof);
            int n10 = OS.GetDC(0);
            int n11 = OS.GetDeviceCaps(n10, 90);
            int n12 = 0;
            if (lOGFONT.lfHeight > 0) {
                int n13 = OS.CreateFontIndirect(lOGFONT);
                n9 = OS.SelectObject(n10, n13);
                TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                OS.GetTextMetrics(n10, tEXTMETRIC);
                OS.SelectObject(n10, n9);
                OS.DeleteObject(n13);
                n12 = lOGFONT.lfHeight - tEXTMETRIC.tmInternalLeading;
            } else {
                n12 = -lOGFONT.lfHeight;
            }
            OS.ReleaseDC(0, n10);
            float f2 = (float)n12 * 72.0f / (float)n11;
            this.fontData = FontData.win32_new(lOGFONT, f2);
            n9 = cHOOSEFONT.rgbColors & 0xFF;
            int n14 = cHOOSEFONT.rgbColors >> 8 & 0xFF;
            int n15 = cHOOSEFONT.rgbColors >> 16 & 0xFF;
            this.rgb = new RGB(n9, n14, n15);
        }
        if (n6 != 0) {
            OS.HeapFree(n5, 0, n6);
        }
        if (n2 == 0) {
            return null;
        }
        return this.fontData;
    }

    public void setFontData(FontData fontData) {
        this.fontData = fontData;
    }

    public void setFontList(FontData[] fontDataArray) {
        this.fontData = fontDataArray != null && fontDataArray.length > 0 ? fontDataArray[0] : null;
    }

    public void setRGB(RGB rGB) {
        this.rgb = rGB;
    }
}

